/*
 * $Id: table.h,v 0.77 2002/01/14 11:06:55 dankogai Exp $
 * (c) 1999 Dan Kogai <dankogai@dan.co.jp>
 */

typedef unsigned char Octet;
typedef unsigned long Quad;

typedef struct {
  Quad ucs2, euc;
} Table_t;

#define TABLE_SIZE 13012

Table_t E2U[TABLE_SIZE];

/* this guy is pedantic */

Table_t U2E[] = {
	{0x5c, 0xa1c0},   /* \ */
	{0x7e, 0x8fa2b7}, /* ~ */
	{0xa1, 0x8fa2c2}, 
	{0xa2, 0xa1f1}, 
	{0xa3, 0xa1f2}, 
	{0xa4, 0x8fa2f0}, 
	{0xa5, 0x5c}, 
	{0xa6, 0x8fa2c3}, 
	{0xa7, 0xa1f8}, 
	{0xa8, 0xa1af}, 
	{0xa9, 0x8fa2ed}, 
	{0xaa, 0x8fa2ec}, 
	{0xac, 0xa2cc}, 
	{0xae, 0x8fa2ee}, 
	{0xaf, 0x8fa2b4}, 
	{0xb0, 0xa1eb}, 
	{0xb1, 0xa1de}, 
	{0xb4, 0xa1ad}, 
	{0xb6, 0xa2f9}, 
	{0xb8, 0x8fa2b1}, 
	{0xba, 0x8fa2eb}, 
	{0xbf, 0x8fa2c4}, 
	{0xc0, 0x8faaa2}, 
	{0xc1, 0x8faaa1}, 
	{0xc2, 0x8faaa4}, 
	{0xc3, 0x8faaaa}, 
	{0xc4, 0x8faaa3}, 
	{0xc5, 0x8faaa9}, 
	{0xc6, 0x8fa9a1}, 
	{0xc7, 0x8faaae}, 
	{0xc8, 0x8faab2}, 
	{0xc9, 0x8faab1}, 
	{0xca, 0x8faab4}, 
	{0xcb, 0x8faab3}, 
	{0xcc, 0x8faac0}, 
	{0xcd, 0x8faabf}, 
	{0xce, 0x8faac2}, 
	{0xcf, 0x8faac1}, 
	{0xd1, 0x8faad0}, 
	{0xd2, 0x8faad2}, 
	{0xd3, 0x8faad1}, 
	{0xd4, 0x8faad4}, 
	{0xd5, 0x8faad8}, 
	{0xd6, 0x8faad3}, 
	{0xd7, 0xa1df}, 
	{0xd8, 0x8fa9ac}, 
	{0xd9, 0x8faae3}, 
	{0xda, 0x8faae2}, 
	{0xdb, 0x8faae5}, 
	{0xdc, 0x8faae4}, 
	{0xdd, 0x8faaf2}, 
	{0xde, 0x8fa9b0}, 
	{0xdf, 0x8fa9ce}, 
	{0xe0, 0x8faba2}, 
	{0xe1, 0x8faba1}, 
	{0xe2, 0x8faba4}, 
	{0xe3, 0x8fabaa}, 
	{0xe4, 0x8faba3}, 
	{0xe5, 0x8faba9}, 
	{0xe6, 0x8fa9c1}, 
	{0xe7, 0x8fabae}, 
	{0xe8, 0x8fabb2}, 
	{0xe9, 0x8fabb1}, 
	{0xea, 0x8fabb4}, 
	{0xeb, 0x8fabb3}, 
	{0xec, 0x8fabc0}, 
	{0xed, 0x8fabbf}, 
	{0xee, 0x8fabc2}, 
	{0xef, 0x8fabc1}, 
	{0xf0, 0x8fa9c3}, 
	{0xf1, 0x8fabd0}, 
	{0xf2, 0x8fabd2}, 
	{0xf3, 0x8fabd1}, 
	{0xf4, 0x8fabd4}, 
	{0xf5, 0x8fabd8}, 
	{0xf6, 0x8fabd3}, 
	{0xf7, 0xa1e0}, 
	{0xf8, 0x8fa9cc}, 
	{0xf9, 0x8fabe3}, 
	{0xfa, 0x8fabe2}, 
	{0xfb, 0x8fabe5}, 
	{0xfc, 0x8fabe4}, 
	{0xfd, 0x8fabf2}, 
	{0xfe, 0x8fa9d0}, 
	{0xff, 0x8fabf3}, 
	{0x100, 0x8faaa7}, 
	{0x101, 0x8faba7}, 
	{0x102, 0x8faaa5}, 
	{0x103, 0x8faba5}, 
	{0x104, 0x8faaa8}, 
	{0x105, 0x8faba8}, 
	{0x106, 0x8faaab}, 
	{0x107, 0x8fabab}, 
	{0x108, 0x8faaac}, 
	{0x109, 0x8fabac}, 
	{0x10a, 0x8faaaf}, 
	{0x10b, 0x8fabaf}, 
	{0x10c, 0x8faaad}, 
	{0x10d, 0x8fabad}, 
	{0x10e, 0x8faab0}, 
	{0x10f, 0x8fabb0}, 
	{0x110, 0x8fa9a2}, 
	{0x111, 0x8fa9c2}, 
	{0x112, 0x8faab7}, 
	{0x113, 0x8fabb7}, 
	{0x116, 0x8faab6}, 
	{0x117, 0x8fabb6}, 
	{0x118, 0x8faab8}, 
	{0x119, 0x8fabb8}, 
	{0x11a, 0x8faab5}, 
	{0x11b, 0x8fabb5}, 
	{0x11c, 0x8faaba}, 
	{0x11d, 0x8fabba}, 
	{0x11e, 0x8faabb}, 
	{0x11f, 0x8fabbb}, 
	{0x120, 0x8faabd}, 
	{0x121, 0x8fabbd}, 
	{0x122, 0x8faabc}, 
	{0x124, 0x8faabe}, 
	{0x125, 0x8fabbe}, 
	{0x126, 0x8fa9a4}, 
	{0x127, 0x8fa9c4}, 
	{0x128, 0x8faac7}, 
	{0x129, 0x8fabc7}, 
	{0x12a, 0x8faac5}, 
	{0x12b, 0x8fabc5}, 
	{0x12e, 0x8faac6}, 
	{0x12f, 0x8fabc6}, 
	{0x130, 0x8faac4}, 
	{0x131, 0x8fa9c5}, 
	{0x132, 0x8fa9a6}, 
	{0x133, 0x8fa9c6}, 
	{0x134, 0x8faac8}, 
	{0x135, 0x8fabc8}, 
	{0x136, 0x8faac9}, 
	{0x137, 0x8fabc9}, 
	{0x138, 0x8fa9c7}, 
	{0x139, 0x8faaca}, 
	{0x13a, 0x8fabca}, 
	{0x13b, 0x8faacc}, 
	{0x13c, 0x8fabcc}, 
	{0x13d, 0x8faacb}, 
	{0x13e, 0x8fabcb}, 
	{0x13f, 0x8fa9a9}, 
	{0x140, 0x8fa9c9}, 
	{0x141, 0x8fa9a8}, 
	{0x142, 0x8fa9c8}, 
	{0x143, 0x8faacd}, 
	{0x144, 0x8fabcd}, 
	{0x145, 0x8faacf}, 
	{0x146, 0x8fabcf}, 
	{0x147, 0x8faace}, 
	{0x148, 0x8fabce}, 
	{0x149, 0x8fa9ca}, 
	{0x14a, 0x8fa9ab}, 
	{0x14b, 0x8fa9cb}, 
	{0x14c, 0x8faad7}, 
	{0x14d, 0x8fabd7}, 
	{0x150, 0x8faad6}, 
	{0x151, 0x8fabd6}, 
	{0x152, 0x8fa9ad}, 
	{0x153, 0x8fa9cd}, 
	{0x154, 0x8faad9}, 
	{0x155, 0x8fabd9}, 
	{0x156, 0x8faadb}, 
	{0x157, 0x8fabdb}, 
	{0x158, 0x8faada}, 
	{0x159, 0x8fabda}, 
	{0x15a, 0x8faadc}, 
	{0x15b, 0x8fabdc}, 
	{0x15c, 0x8faadd}, 
	{0x15d, 0x8fabdd}, 
	{0x15e, 0x8faadf}, 
	{0x15f, 0x8fabdf}, 
	{0x160, 0x8faade}, 
	{0x161, 0x8fabde}, 
	{0x162, 0x8faae1}, 
	{0x163, 0x8fabe1}, 
	{0x164, 0x8faae0}, 
	{0x165, 0x8fabe0}, 
	{0x166, 0x8fa9af}, 
	{0x167, 0x8fa9cf}, 
	{0x168, 0x8faaec}, 
	{0x169, 0x8fabec}, 
	{0x16a, 0x8faae9}, 
	{0x16b, 0x8fabe9}, 
	{0x16c, 0x8faae6}, 
	{0x16d, 0x8fabe6}, 
	{0x16e, 0x8faaeb}, 
	{0x16f, 0x8fabeb}, 
	{0x170, 0x8faae8}, 
	{0x171, 0x8fabe8}, 
	{0x172, 0x8faaea}, 
	{0x173, 0x8fabea}, 
	{0x174, 0x8faaf1}, 
	{0x175, 0x8fabf1}, 
	{0x176, 0x8faaf4}, 
	{0x177, 0x8fabf4}, 
	{0x178, 0x8faaf3}, 
	{0x179, 0x8faaf5}, 
	{0x17a, 0x8fabf5}, 
	{0x17b, 0x8faaf7}, 
	{0x17c, 0x8fabf7}, 
	{0x17d, 0x8faaf6}, 
	{0x17e, 0x8fabf6}, 
	{0x1cd, 0x8faaa6}, 
	{0x1ce, 0x8faba6}, 
	{0x1cf, 0x8faac3}, 
	{0x1d0, 0x8fabc3}, 
	{0x1d1, 0x8faad5}, 
	{0x1d2, 0x8fabd5}, 
	{0x1d3, 0x8faae7}, 
	{0x1d4, 0x8fabe7}, 
	{0x1d5, 0x8faaf0}, 
	{0x1d6, 0x8fabf0}, 
	{0x1d7, 0x8faaed}, 
	{0x1d8, 0x8fabed}, 
	{0x1d9, 0x8faaef}, 
	{0x1da, 0x8fabef}, 
	{0x1db, 0x8faaee}, 
	{0x1dc, 0x8fabee}, 
	{0x1f5, 0x8fabb9}, 
	{0x2c7, 0x8fa2b0}, 
	{0x2d8, 0x8fa2af}, 
	{0x2d9, 0x8fa2b2}, 
	{0x2da, 0x8fa2b6}, 
	{0x2db, 0x8fa2b5}, 
	{0x2dd, 0x8fa2b3}, 
	{0x384, 0x8fa2b8}, 
	{0x385, 0x8fa2b9}, 
	{0x386, 0x8fa6e1}, 
	{0x388, 0x8fa6e2}, 
	{0x389, 0x8fa6e3}, 
	{0x38a, 0x8fa6e4}, 
	{0x38c, 0x8fa6e7}, 
	{0x38e, 0x8fa6e9}, 
	{0x38f, 0x8fa6ec}, 
	{0x390, 0x8fa6f6}, 
	{0x391, 0xa6a1}, 
	{0x392, 0xa6a2}, 
	{0x393, 0xa6a3}, 
	{0x394, 0xa6a4}, 
	{0x395, 0xa6a5}, 
	{0x396, 0xa6a6}, 
	{0x397, 0xa6a7}, 
	{0x398, 0xa6a8}, 
	{0x399, 0xa6a9}, 
	{0x39a, 0xa6aa}, 
	{0x39b, 0xa6ab}, 
	{0x39c, 0xa6ac}, 
	{0x39d, 0xa6ad}, 
	{0x39e, 0xa6ae}, 
	{0x39f, 0xa6af}, 
	{0x3a0, 0xa6b0}, 
	{0x3a1, 0xa6b1}, 
	{0x3a3, 0xa6b2}, 
	{0x3a4, 0xa6b3}, 
	{0x3a5, 0xa6b4}, 
	{0x3a6, 0xa6b5}, 
	{0x3a7, 0xa6b6}, 
	{0x3a8, 0xa6b7}, 
	{0x3a9, 0xa6b8}, 
	{0x3aa, 0x8fa6e5}, 
	{0x3ab, 0x8fa6ea}, 
	{0x3ac, 0x8fa6f1}, 
	{0x3ad, 0x8fa6f2}, 
	{0x3ae, 0x8fa6f3}, 
	{0x3af, 0x8fa6f4}, 
	{0x3b0, 0x8fa6fb}, 
	{0x3b1, 0xa6c1}, 
	{0x3b2, 0xa6c2}, 
	{0x3b3, 0xa6c3}, 
	{0x3b4, 0xa6c4}, 
	{0x3b5, 0xa6c5}, 
	{0x3b6, 0xa6c6}, 
	{0x3b7, 0xa6c7}, 
	{0x3b8, 0xa6c8}, 
	{0x3b9, 0xa6c9}, 
	{0x3ba, 0xa6ca}, 
	{0x3bb, 0xa6cb}, 
	{0x3bc, 0xa6cc}, 
	{0x3bd, 0xa6cd}, 
	{0x3be, 0xa6ce}, 
	{0x3bf, 0xa6cf}, 
	{0x3c0, 0xa6d0}, 
	{0x3c1, 0xa6d1}, 
	{0x3c2, 0x8fa6f8}, 
	{0x3c3, 0xa6d2}, 
	{0x3c4, 0xa6d3}, 
	{0x3c5, 0xa6d4}, 
	{0x3c6, 0xa6d5}, 
	{0x3c7, 0xa6d6}, 
	{0x3c8, 0xa6d7}, 
	{0x3c9, 0xa6d8}, 
	{0x3ca, 0x8fa6f5}, 
	{0x3cb, 0x8fa6fa}, 
	{0x3cc, 0x8fa6f7}, 
	{0x3cd, 0x8fa6f9}, 
	{0x3ce, 0x8fa6fc}, 
	{0x401, 0xa7a7}, 
	{0x402, 0x8fa7c2}, 
	{0x403, 0x8fa7c3}, 
	{0x404, 0x8fa7c4}, 
	{0x405, 0x8fa7c5}, 
	{0x406, 0x8fa7c6}, 
	{0x407, 0x8fa7c7}, 
	{0x408, 0x8fa7c8}, 
	{0x409, 0x8fa7c9}, 
	{0x40a, 0x8fa7ca}, 
	{0x40b, 0x8fa7cb}, 
	{0x40c, 0x8fa7cc}, 
	{0x40e, 0x8fa7cd}, 
	{0x40f, 0x8fa7ce}, 
	{0x410, 0xa7a1}, 
	{0x411, 0xa7a2}, 
	{0x412, 0xa7a3}, 
	{0x413, 0xa7a4}, 
	{0x414, 0xa7a5}, 
	{0x415, 0xa7a6}, 
	{0x416, 0xa7a8}, 
	{0x417, 0xa7a9}, 
	{0x418, 0xa7aa}, 
	{0x419, 0xa7ab}, 
	{0x41a, 0xa7ac}, 
	{0x41b, 0xa7ad}, 
	{0x41c, 0xa7ae}, 
	{0x41d, 0xa7af}, 
	{0x41e, 0xa7b0}, 
	{0x41f, 0xa7b1}, 
	{0x420, 0xa7b2}, 
	{0x421, 0xa7b3}, 
	{0x422, 0xa7b4}, 
	{0x423, 0xa7b5}, 
	{0x424, 0xa7b6}, 
	{0x425, 0xa7b7}, 
	{0x426, 0xa7b8}, 
	{0x427, 0xa7b9}, 
	{0x428, 0xa7ba}, 
	{0x429, 0xa7bb}, 
	{0x42a, 0xa7bc}, 
	{0x42b, 0xa7bd}, 
	{0x42c, 0xa7be}, 
	{0x42d, 0xa7bf}, 
	{0x42e, 0xa7c0}, 
	{0x42f, 0xa7c1}, 
	{0x430, 0xa7d1}, 
	{0x431, 0xa7d2}, 
	{0x432, 0xa7d3}, 
	{0x433, 0xa7d4}, 
	{0x434, 0xa7d5}, 
	{0x435, 0xa7d6}, 
	{0x436, 0xa7d8}, 
	{0x437, 0xa7d9}, 
	{0x438, 0xa7da}, 
	{0x439, 0xa7db}, 
	{0x43a, 0xa7dc}, 
	{0x43b, 0xa7dd}, 
	{0x43c, 0xa7de}, 
	{0x43d, 0xa7df}, 
	{0x43e, 0xa7e0}, 
	{0x43f, 0xa7e1}, 
	{0x440, 0xa7e2}, 
	{0x441, 0xa7e3}, 
	{0x442, 0xa7e4}, 
	{0x443, 0xa7e5}, 
	{0x444, 0xa7e6}, 
	{0x445, 0xa7e7}, 
	{0x446, 0xa7e8}, 
	{0x447, 0xa7e9}, 
	{0x448, 0xa7ea}, 
	{0x449, 0xa7eb}, 
	{0x44a, 0xa7ec}, 
	{0x44b, 0xa7ed}, 
	{0x44c, 0xa7ee}, 
	{0x44d, 0xa7ef}, 
	{0x44e, 0xa7f0}, 
	{0x44f, 0xa7f1}, 
	{0x451, 0xa7d7}, 
	{0x452, 0x8fa7f2}, 
	{0x453, 0x8fa7f3}, 
	{0x454, 0x8fa7f4}, 
	{0x455, 0x8fa7f5}, 
	{0x456, 0x8fa7f6}, 
	{0x457, 0x8fa7f7}, 
	{0x458, 0x8fa7f8}, 
	{0x459, 0x8fa7f9}, 
	{0x45a, 0x8fa7fa}, 
	{0x45b, 0x8fa7fb}, 
	{0x45c, 0x8fa7fc}, 
	{0x45e, 0x8fa7fd}, 
	{0x45f, 0x8fa7fe}, 
	{0x2010, 0xa1be}, 
	{0x2015, 0xa1bd}, 
	{0x2016, 0xa1c2}, 
	{0x2018, 0xa1c6}, 
	{0x2019, 0xa1c7}, 
	{0x201c, 0xa1c8}, 
	{0x201d, 0xa1c9}, 
	{0x2020, 0xa2f7}, 
	{0x2021, 0xa2f8}, 
	{0x2025, 0xa1c5}, 
	{0x2026, 0xa1c4}, 
	{0x2030, 0xa2f3}, 
	{0x2032, 0xa1ec}, 
	{0x2033, 0xa1ed}, 
	{0x203b, 0xa2a8}, 
	{0x203e, 0x7e}, 
	{0x2103, 0xa1ee}, 
	{0x2116, 0x8fa2f1}, 
	{0x2122, 0x8fa2ef}, 
	{0x212b, 0xa2f2}, 
	{0x2190, 0xa2ab}, 
	{0x2191, 0xa2ac}, 
	{0x2192, 0xa2aa}, 
	{0x2193, 0xa2ad}, 
	{0x21d2, 0xa2cd}, 
	{0x21d4, 0xa2ce}, 
	{0x2200, 0xa2cf}, 
	{0x2202, 0xa2df}, 
	{0x2203, 0xa2d0}, 
	{0x2207, 0xa2e0}, 
	{0x2208, 0xa2ba}, 
	{0x220b, 0xa2bb}, 
	{0x2212, 0xa1dd}, 
	{0x221a, 0xa2e5}, 
	{0x221d, 0xa2e7}, 
	{0x221e, 0xa1e7}, 
	{0x2220, 0xa2dc}, 
	{0x2227, 0xa2ca}, 
	{0x2228, 0xa2cb}, 
	{0x2229, 0xa2c1}, 
	{0x222a, 0xa2c0}, 
	{0x222b, 0xa2e9}, 
	{0x222c, 0xa2ea}, 
	{0x2234, 0xa1e8}, 
	{0x2235, 0xa2e8}, 
	{0x223d, 0xa2e6}, 
	{0x2252, 0xa2e2}, 
	{0x2260, 0xa1e2}, 
	{0x2261, 0xa2e1}, 
	{0x2266, 0xa1e5}, 
	{0x2267, 0xa1e6}, 
	{0x226a, 0xa2e3}, 
	{0x226b, 0xa2e4}, 
	{0x2282, 0xa2be}, 
	{0x2283, 0xa2bf}, 
	{0x2286, 0xa2bc}, 
	{0x2287, 0xa2bd}, 
	{0x22a5, 0xa2dd}, 
	{0x2312, 0xa2de}, 
	{0x2500, 0xa8a1}, 
	{0x2501, 0xa8ac}, 
	{0x2502, 0xa8a2}, 
	{0x2503, 0xa8ad}, 
	{0x250c, 0xa8a3}, 
	{0x250f, 0xa8ae}, 
	{0x2510, 0xa8a4}, 
	{0x2513, 0xa8af}, 
	{0x2514, 0xa8a6}, 
	{0x2517, 0xa8b1}, 
	{0x2518, 0xa8a5}, 
	{0x251b, 0xa8b0}, 
	{0x251c, 0xa8a7}, 
	{0x251d, 0xa8bc}, 
	{0x2520, 0xa8b7}, 
	{0x2523, 0xa8b2}, 
	{0x2524, 0xa8a9}, 
	{0x2525, 0xa8be}, 
	{0x2528, 0xa8b9}, 
	{0x252b, 0xa8b4}, 
	{0x252c, 0xa8a8}, 
	{0x252f, 0xa8b8}, 
	{0x2530, 0xa8bd}, 
	{0x2533, 0xa8b3}, 
	{0x2534, 0xa8aa}, 
	{0x2537, 0xa8ba}, 
	{0x2538, 0xa8bf}, 
	{0x253b, 0xa8b5}, 
	{0x253c, 0xa8ab}, 
	{0x253f, 0xa8bb}, 
	{0x2542, 0xa8c0}, 
	{0x254b, 0xa8b6}, 
	{0x25a0, 0xa2a3}, 
	{0x25a1, 0xa2a2}, 
	{0x25b2, 0xa2a5}, 
	{0x25b3, 0xa2a4}, 
	{0x25bc, 0xa2a7}, 
	{0x25bd, 0xa2a6}, 
	{0x25c6, 0xa2a1}, 
	{0x25c7, 0xa1fe}, 
	{0x25cb, 0xa1fb}, 
	{0x25ce, 0xa1fd}, 
	{0x25cf, 0xa1fc}, 
	{0x25ef, 0xa2fe}, 
	{0x2605, 0xa1fa}, 
	{0x2606, 0xa1f9}, 
	{0x2640, 0xa1ea}, 
	{0x2642, 0xa1e9}, 
	{0x266a, 0xa2f6}, 
	{0x266d, 0xa2f5}, 
	{0x266f, 0xa2f4}, 
	{0x3000, 0xa1a1}, 
	{0x3001, 0xa1a2}, 
	{0x3002, 0xa1a3}, 
	{0x3003, 0xa1b7}, 
	{0x3005, 0xa1b9}, 
	{0x3006, 0xa1ba}, 
	{0x3007, 0xa1bb}, 
	{0x3008, 0xa1d2}, 
	{0x3009, 0xa1d3}, 
	{0x300a, 0xa1d4}, 
	{0x300b, 0xa1d5}, 
	{0x300c, 0xa1d6}, 
	{0x300d, 0xa1d7}, 
	{0x300e, 0xa1d8}, 
	{0x300f, 0xa1d9}, 
	{0x3010, 0xa1da}, 
	{0x3011, 0xa1db}, 
	{0x3012, 0xa2a9}, 
	{0x3013, 0xa2ae}, 
	{0x3014, 0xa1cc}, 
	{0x3015, 0xa1cd}, 
	{0x301c, 0xa1c1}, 
	{0x3041, 0xa4a1}, 
	{0x3042, 0xa4a2}, 
	{0x3043, 0xa4a3}, 
	{0x3044, 0xa4a4}, 
	{0x3045, 0xa4a5}, 
	{0x3046, 0xa4a6}, 
	{0x3047, 0xa4a7}, 
	{0x3048, 0xa4a8}, 
	{0x3049, 0xa4a9}, 
	{0x304a, 0xa4aa}, 
	{0x304b, 0xa4ab}, 
	{0x304c, 0xa4ac}, 
	{0x304d, 0xa4ad}, 
	{0x304e, 0xa4ae}, 
	{0x304f, 0xa4af}, 
	{0x3050, 0xa4b0}, 
	{0x3051, 0xa4b1}, 
	{0x3052, 0xa4b2}, 
	{0x3053, 0xa4b3}, 
	{0x3054, 0xa4b4}, 
	{0x3055, 0xa4b5}, 
	{0x3056, 0xa4b6}, 
	{0x3057, 0xa4b7}, 
	{0x3058, 0xa4b8}, 
	{0x3059, 0xa4b9}, 
	{0x305a, 0xa4ba}, 
	{0x305b, 0xa4bb}, 
	{0x305c, 0xa4bc}, 
	{0x305d, 0xa4bd}, 
	{0x305e, 0xa4be}, 
	{0x305f, 0xa4bf}, 
	{0x3060, 0xa4c0}, 
	{0x3061, 0xa4c1}, 
	{0x3062, 0xa4c2}, 
	{0x3063, 0xa4c3}, 
	{0x3064, 0xa4c4}, 
	{0x3065, 0xa4c5}, 
	{0x3066, 0xa4c6}, 
	{0x3067, 0xa4c7}, 
	{0x3068, 0xa4c8}, 
	{0x3069, 0xa4c9}, 
	{0x306a, 0xa4ca}, 
	{0x306b, 0xa4cb}, 
	{0x306c, 0xa4cc}, 
	{0x306d, 0xa4cd}, 
	{0x306e, 0xa4ce}, 
	{0x306f, 0xa4cf}, 
	{0x3070, 0xa4d0}, 
	{0x3071, 0xa4d1}, 
	{0x3072, 0xa4d2}, 
	{0x3073, 0xa4d3}, 
	{0x3074, 0xa4d4}, 
	{0x3075, 0xa4d5}, 
	{0x3076, 0xa4d6}, 
	{0x3077, 0xa4d7}, 
	{0x3078, 0xa4d8}, 
	{0x3079, 0xa4d9}, 
	{0x307a, 0xa4da}, 
	{0x307b, 0xa4db}, 
	{0x307c, 0xa4dc}, 
	{0x307d, 0xa4dd}, 
	{0x307e, 0xa4de}, 
	{0x307f, 0xa4df}, 
	{0x3080, 0xa4e0}, 
	{0x3081, 0xa4e1}, 
	{0x3082, 0xa4e2}, 
	{0x3083, 0xa4e3}, 
	{0x3084, 0xa4e4}, 
	{0x3085, 0xa4e5}, 
	{0x3086, 0xa4e6}, 
	{0x3087, 0xa4e7}, 
	{0x3088, 0xa4e8}, 
	{0x3089, 0xa4e9}, 
	{0x308a, 0xa4ea}, 
	{0x308b, 0xa4eb}, 
	{0x308c, 0xa4ec}, 
	{0x308d, 0xa4ed}, 
	{0x308e, 0xa4ee}, 
	{0x308f, 0xa4ef}, 
	{0x3090, 0xa4f0}, 
	{0x3091, 0xa4f1}, 
	{0x3092, 0xa4f2}, 
	{0x3093, 0xa4f3}, 
	{0x309b, 0xa1ab}, 
	{0x309c, 0xa1ac}, 
	{0x309d, 0xa1b5}, 
	{0x309e, 0xa1b6}, 
	{0x30a1, 0xa5a1}, 
	{0x30a2, 0xa5a2}, 
	{0x30a3, 0xa5a3}, 
	{0x30a4, 0xa5a4}, 
	{0x30a5, 0xa5a5}, 
	{0x30a6, 0xa5a6}, 
	{0x30a7, 0xa5a7}, 
	{0x30a8, 0xa5a8}, 
	{0x30a9, 0xa5a9}, 
	{0x30aa, 0xa5aa}, 
	{0x30ab, 0xa5ab}, 
	{0x30ac, 0xa5ac}, 
	{0x30ad, 0xa5ad}, 
	{0x30ae, 0xa5ae}, 
	{0x30af, 0xa5af}, 
	{0x30b0, 0xa5b0}, 
	{0x30b1, 0xa5b1}, 
	{0x30b2, 0xa5b2}, 
	{0x30b3, 0xa5b3}, 
	{0x30b4, 0xa5b4}, 
	{0x30b5, 0xa5b5}, 
	{0x30b6, 0xa5b6}, 
	{0x30b7, 0xa5b7}, 
	{0x30b8, 0xa5b8}, 
	{0x30b9, 0xa5b9}, 
	{0x30ba, 0xa5ba}, 
	{0x30bb, 0xa5bb}, 
	{0x30bc, 0xa5bc}, 
	{0x30bd, 0xa5bd}, 
	{0x30be, 0xa5be}, 
	{0x30bf, 0xa5bf}, 
	{0x30c0, 0xa5c0}, 
	{0x30c1, 0xa5c1}, 
	{0x30c2, 0xa5c2}, 
	{0x30c3, 0xa5c3}, 
	{0x30c4, 0xa5c4}, 
	{0x30c5, 0xa5c5}, 
	{0x30c6, 0xa5c6}, 
	{0x30c7, 0xa5c7}, 
	{0x30c8, 0xa5c8}, 
	{0x30c9, 0xa5c9}, 
	{0x30ca, 0xa5ca}, 
	{0x30cb, 0xa5cb}, 
	{0x30cc, 0xa5cc}, 
	{0x30cd, 0xa5cd}, 
	{0x30ce, 0xa5ce}, 
	{0x30cf, 0xa5cf}, 
	{0x30d0, 0xa5d0}, 
	{0x30d1, 0xa5d1}, 
	{0x30d2, 0xa5d2}, 
	{0x30d3, 0xa5d3}, 
	{0x30d4, 0xa5d4}, 
	{0x30d5, 0xa5d5}, 
	{0x30d6, 0xa5d6}, 
	{0x30d7, 0xa5d7}, 
	{0x30d8, 0xa5d8}, 
	{0x30d9, 0xa5d9}, 
	{0x30da, 0xa5da}, 
	{0x30db, 0xa5db}, 
	{0x30dc, 0xa5dc}, 
	{0x30dd, 0xa5dd}, 
	{0x30de, 0xa5de}, 
	{0x30df, 0xa5df}, 
	{0x30e0, 0xa5e0}, 
	{0x30e1, 0xa5e1}, 
	{0x30e2, 0xa5e2}, 
	{0x30e3, 0xa5e3}, 
	{0x30e4, 0xa5e4}, 
	{0x30e5, 0xa5e5}, 
	{0x30e6, 0xa5e6}, 
	{0x30e7, 0xa5e7}, 
	{0x30e8, 0xa5e8}, 
	{0x30e9, 0xa5e9}, 
	{0x30ea, 0xa5ea}, 
	{0x30eb, 0xa5eb}, 
	{0x30ec, 0xa5ec}, 
	{0x30ed, 0xa5ed}, 
	{0x30ee, 0xa5ee}, 
	{0x30ef, 0xa5ef}, 
	{0x30f0, 0xa5f0}, 
	{0x30f1, 0xa5f1}, 
	{0x30f2, 0xa5f2}, 
	{0x30f3, 0xa5f3}, 
	{0x30f4, 0xa5f4}, 
	{0x30f5, 0xa5f5}, 
	{0x30f6, 0xa5f6}, 
	{0x30fb, 0xa1a6}, 
	{0x30fc, 0xa1bc}, 
	{0x30fd, 0xa1b3}, 
	{0x30fe, 0xa1b4}, 
	{0x4e00, 0xb0ec}, 
	{0x4e01, 0xc3fa}, 
	{0x4e02, 0x8fb0a1}, 
	{0x4e03, 0xbcb7}, 
	{0x4e04, 0x8fb0a2}, 
	{0x4e05, 0x8fb0a3}, 
	{0x4e07, 0xcbfc}, 
	{0x4e08, 0xbee6}, 
	{0x4e09, 0xbbb0}, 
	{0x4e0a, 0xbee5}, 
	{0x4e0b, 0xb2bc}, 
	{0x4e0c, 0x8fb0a4}, 
	{0x4e0d, 0xc9d4}, 
	{0x4e0e, 0xcdbf}, 
	{0x4e10, 0xd0a2}, 
	{0x4e11, 0xb1af}, 
	{0x4e12, 0x8fb0a5}, 
	{0x4e14, 0xb3ee}, 
	{0x4e15, 0xd0a3}, 
	{0x4e16, 0xc0a4}, 
	{0x4e17, 0xd2c2}, 
	{0x4e18, 0xb5d6}, 
	{0x4e19, 0xcaba}, 
	{0x4e1e, 0xbee7}, 
	{0x4e1f, 0x8fb0a6}, 
	{0x4e21, 0xcebe}, 
	{0x4e23, 0x8fb0a7}, 
	{0x4e24, 0x8fb0a8}, 
	{0x4e26, 0xcac2}, 
	{0x4e28, 0x8fb0a9}, 
	{0x4e2a, 0xd0a4}, 
	{0x4e2b, 0x8fb0aa}, 
	{0x4e2d, 0xc3e6}, 
	{0x4e2e, 0x8fb0ab}, 
	{0x4e2f, 0x8fb0ac}, 
	{0x4e30, 0x8fb0ad}, 
	{0x4e31, 0xd0a5}, 
	{0x4e32, 0xb6fa}, 
	{0x4e35, 0x8fb0ae}, 
	{0x4e36, 0xd0a6}, 
	{0x4e38, 0xb4dd}, 
	{0x4e39, 0xc3b0}, 
	{0x4e3b, 0xbce7}, 
	{0x4e3c, 0xd0a7}, 
	{0x4e3f, 0xd0a8}, 
	{0x4e40, 0x8fb0af}, 
	{0x4e41, 0x8fb0b0}, 
	{0x4e42, 0xd0a9}, 
	{0x4e43, 0xc7b5}, 
	{0x4e44, 0x8fb0b1}, 
	{0x4e45, 0xb5d7}, 
	{0x4e47, 0x8fb0b2}, 
	{0x4e4b, 0xc7b7}, 
	{0x4e4d, 0xc6e3}, 
	{0x4e4e, 0xb8c3}, 
	{0x4e4f, 0xcbb3}, 
	{0x4e51, 0x8fb0b3}, 
	{0x4e55, 0xe9c9}, 
	{0x4e56, 0xd0aa}, 
	{0x4e57, 0xbee8}, 
	{0x4e58, 0xd0ab}, 
	{0x4e59, 0xb2b5}, 
	{0x4e5a, 0x8fb0b4}, 
	{0x4e5c, 0x8fb0b5}, 
	{0x4e5d, 0xb6e5}, 
	{0x4e5e, 0xb8f0}, 
	{0x4e5f, 0xcce9}, 
	{0x4e62, 0xd6a6}, 
	{0x4e63, 0x8fb0b6}, 
	{0x4e68, 0x8fb0b7}, 
	{0x4e69, 0x8fb0b8}, 
	{0x4e71, 0xcdf0}, 
	{0x4e73, 0xc6fd}, 
	{0x4e74, 0x8fb0b9}, 
	{0x4e75, 0x8fb0ba}, 
	{0x4e79, 0x8fb0bb}, 
	{0x4e7e, 0xb4a5}, 
	{0x4e7f, 0x8fb0bc}, 
	{0x4e80, 0xb5b5}, 
	{0x4e82, 0xd0ac}, 
	{0x4e85, 0xd0ad}, 
	{0x4e86, 0xcebb}, 
	{0x4e88, 0xcdbd}, 
	{0x4e89, 0xc1e8}, 
	{0x4e8a, 0xd0af}, 
	{0x4e8b, 0xbbf6}, 
	{0x4e8c, 0xc6f3}, 
	{0x4e8d, 0x8fb0bd}, 
	{0x4e8e, 0xd0b2}, 
	{0x4e91, 0xb1be}, 
	{0x4e92, 0xb8df}, 
	{0x4e94, 0xb8de}, 
	{0x4e95, 0xb0e6}, 
	{0x4e96, 0x8fb0be}, 
	{0x4e97, 0x8fb0bf}, 
	{0x4e98, 0xcfcb}, 
	{0x4e99, 0xcfca}, 
	{0x4e9b, 0xbab3}, 
	{0x4e9c, 0xb0a1}, 
	{0x4e9d, 0x8fb0c0}, 
	{0x4e9e, 0xd0b3}, 
	{0x4e9f, 0xd0b4}, 
	{0x4ea0, 0xd0b5}, 
	{0x4ea1, 0xcbb4}, 
	{0x4ea2, 0xd0b6}, 
	{0x4ea4, 0xb8f2}, 
	{0x4ea5, 0xb0e7}, 
	{0x4ea6, 0xcbf2}, 
	{0x4ea8, 0xb5fc}, 
	{0x4eab, 0xb5fd}, 
	{0x4eac, 0xb5fe}, 
	{0x4ead, 0xc4e2}, 
	{0x4eae, 0xcebc}, 
	{0x4eaf, 0x8fb0c1}, 
	{0x4eb0, 0xd0b7}, 
	{0x4eb3, 0xd0b8}, 
	{0x4eb6, 0xd0b9}, 
	{0x4eb9, 0x8fb0c2}, 
	{0x4eba, 0xbfcd}, 
	{0x4ec0, 0xbdba}, 
	{0x4ec1, 0xbfce}, 
	{0x4ec2, 0xd0be}, 
	{0x4ec3, 0x8fb0c3}, 
	{0x4ec4, 0xd0bc}, 
	{0x4ec6, 0xd0bd}, 
	{0x4ec7, 0xb5d8}, 
	{0x4eca, 0xbaa3}, 
	{0x4ecb, 0xb2f0}, 
	{0x4ecd, 0xd0bb}, 
	{0x4ece, 0xd0ba}, 
	{0x4ecf, 0xcaa9}, 
	{0x4ed0, 0x8fb0c4}, 
	{0x4ed4, 0xbbc6}, 
	{0x4ed5, 0xbbc5}, 
	{0x4ed6, 0xc2be}, 
	{0x4ed7, 0xd0bf}, 
	{0x4ed8, 0xc9d5}, 
	{0x4ed9, 0xc0e7}, 
	{0x4eda, 0x8fb0c5}, 
	{0x4edb, 0x8fb0c6}, 
	{0x4edd, 0xa1b8}, 
	{0x4ede, 0xd0c0}, 
	{0x4edf, 0xd0c2}, 
	{0x4ee0, 0x8fb0c7}, 
	{0x4ee1, 0x8fb0c8}, 
	{0x4ee2, 0x8fb0c9}, 
	{0x4ee3, 0xc2e5}, 
	{0x4ee4, 0xcee1}, 
	{0x4ee5, 0xb0ca}, 
	{0x4ee8, 0x8fb0ca}, 
	{0x4eed, 0xd0c1}, 
	{0x4eee, 0xb2be}, 
	{0x4eef, 0x8fb0cb}, 
	{0x4ef0, 0xb6c4}, 
	{0x4ef1, 0x8fb0cc}, 
	{0x4ef2, 0xc3e7}, 
	{0x4ef3, 0x8fb0cd}, 
	{0x4ef5, 0x8fb0ce}, 
	{0x4ef6, 0xb7ef}, 
	{0x4ef7, 0xd0c3}, 
	{0x4efb, 0xc7a4}, 
	{0x4efd, 0x8fb0cf}, 
	{0x4efe, 0x8fb0d0}, 
	{0x4eff, 0x8fb0d1}, 
	{0x4f00, 0x8fb0d2}, 
	{0x4f01, 0xb4eb}, 
	{0x4f02, 0x8fb0d3}, 
	{0x4f03, 0x8fb0d4}, 
	{0x4f08, 0x8fb0d5}, 
	{0x4f09, 0xd0c4}, 
	{0x4f0a, 0xb0cb}, 
	{0x4f0b, 0x8fb0d6}, 
	{0x4f0c, 0x8fb0d7}, 
	{0x4f0d, 0xb8e0}, 
	{0x4f0e, 0xb4ec}, 
	{0x4f0f, 0xc9fa}, 
	{0x4f10, 0xc8b2}, 
	{0x4f11, 0xb5d9}, 
	{0x4f12, 0x8fb0d8}, 
	{0x4f15, 0x8fb0d9}, 
	{0x4f16, 0x8fb0da}, 
	{0x4f17, 0x8fb0db}, 
	{0x4f19, 0x8fb0dc}, 
	{0x4f1a, 0xb2f1}, 
	{0x4f1c, 0xd0e7}, 
	{0x4f1d, 0xc5c1}, 
	{0x4f2e, 0x8fb0dd}, 
	{0x4f2f, 0xc7ec}, 
	{0x4f30, 0xd0c6}, 
	{0x4f31, 0x8fb0de}, 
	{0x4f33, 0x8fb0e0}, 
	{0x4f34, 0xc8bc}, 
	{0x4f35, 0x8fb0e1}, 
	{0x4f36, 0xcee2}, 
	{0x4f37, 0x8fb0e2}, 
	{0x4f38, 0xbfad}, 
	{0x4f39, 0x8fb0e3}, 
	{0x4f3a, 0xbbc7}, 
	{0x4f3b, 0x8fb0e4}, 
	{0x4f3c, 0xbbf7}, 
	{0x4f3d, 0xb2c0}, 
	{0x4f3e, 0x8fb0e5}, 
	{0x4f40, 0x8fb0e6}, 
	{0x4f42, 0x8fb0e7}, 
	{0x4f43, 0xc4d1}, 
	{0x4f46, 0xc3a2}, 
	{0x4f47, 0xd0ca}, 
	{0x4f48, 0x8fb0e8}, 
	{0x4f49, 0x8fb0e9}, 
	{0x4f4b, 0x8fb0ea}, 
	{0x4f4c, 0x8fb0eb}, 
	{0x4f4d, 0xb0cc}, 
	{0x4f4e, 0xc4e3}, 
	{0x4f4f, 0xbdbb}, 
	{0x4f50, 0xbab4}, 
	{0x4f51, 0xcda4}, 
	{0x4f52, 0x8fb0ec}, 
	{0x4f53, 0xc2ce}, 
	{0x4f54, 0x8fb0ed}, 
	{0x4f55, 0xb2bf}, 
	{0x4f56, 0x8fb0ee}, 
	{0x4f57, 0xd0c9}, 
	{0x4f58, 0x8fb0ef}, 
	{0x4f59, 0xcdbe}, 
	{0x4f5a, 0xd0c5}, 
	{0x4f5b, 0xd0c7}, 
	{0x4f5c, 0xbaee}, 
	{0x4f5d, 0xd0c8}, 
	{0x4f5e, 0xd5a4}, 
	{0x4f5f, 0x8fb0f0}, 
	{0x4f60, 0x8fb0df}, 
	{0x4f63, 0x8fb0f1}, 
	{0x4f69, 0xd0d0}, 
	{0x4f6a, 0x8fb0f2}, 
	{0x4f6c, 0x8fb0f3}, 
	{0x4f6e, 0x8fb0f4}, 
	{0x4f6f, 0xd0d3}, 
	{0x4f70, 0xd0d1}, 
	{0x4f71, 0x8fb0f5}, 
	{0x4f73, 0xb2c2}, 
	{0x4f75, 0xcabb}, 
	{0x4f76, 0xd0cb}, 
	{0x4f77, 0x8fb0f6}, 
	{0x4f78, 0x8fb0f7}, 
	{0x4f79, 0x8fb0f8}, 
	{0x4f7a, 0x8fb0f9}, 
	{0x4f7b, 0xd0cf}, 
	{0x4f7c, 0xb8f3}, 
	{0x4f7d, 0x8fb0fa}, 
	{0x4f7e, 0x8fb0fb}, 
	{0x4f7f, 0xbbc8}, 
	{0x4f81, 0x8fb0fc}, 
	{0x4f82, 0x8fb0fd}, 
	{0x4f83, 0xb4a6}, 
	{0x4f84, 0x8fb0fe}, 
	{0x4f85, 0x8fb1a1}, 
	{0x4f86, 0xd0d4}, 
	{0x4f88, 0xd0cc}, 
	{0x4f89, 0x8fb1a2}, 
	{0x4f8a, 0x8fb1a3}, 
	{0x4f8b, 0xcee3}, 
	{0x4f8c, 0x8fb1a4}, 
	{0x4f8d, 0xbbf8}, 
	{0x4f8e, 0x8fb1a5}, 
	{0x4f8f, 0xd0cd}, 
	{0x4f90, 0x8fb1a6}, 
	{0x4f91, 0xd0d2}, 
	{0x4f92, 0x8fb1a7}, 
	{0x4f93, 0x8fb1a8}, 
	{0x4f94, 0x8fb1a9}, 
	{0x4f96, 0xd0d5}, 
	{0x4f97, 0x8fb1aa}, 
	{0x4f98, 0xd0ce}, 
	{0x4f99, 0x8fb1ab}, 
	{0x4f9a, 0x8fb1ac}, 
	{0x4f9b, 0xb6a1}, 
	{0x4f9d, 0xb0cd}, 
	{0x4f9e, 0x8fb1ad}, 
	{0x4f9f, 0x8fb1ae}, 
	{0x4fa0, 0xb6a2}, 
	{0x4fa1, 0xb2c1}, 
	{0x4fab, 0xd5a5}, 
	{0x4fad, 0xcbf9}, 
	{0x4fae, 0xc9ee}, 
	{0x4faf, 0xb8f4}, 
	{0x4fb2, 0x8fb1af}, 
	{0x4fb5, 0xbfaf}, 
	{0x4fb6, 0xceb7}, 
	{0x4fb7, 0x8fb1b0}, 
	{0x4fb9, 0x8fb1b1}, 
	{0x4fbb, 0x8fb1b2}, 
	{0x4fbc, 0x8fb1b3}, 
	{0x4fbd, 0x8fb1b4}, 
	{0x4fbe, 0x8fb1b5}, 
	{0x4fbf, 0xcad8}, 
	{0x4fc0, 0x8fb1b6}, 
	{0x4fc1, 0x8fb1b7}, 
	{0x4fc2, 0xb7b8}, 
	{0x4fc3, 0xc2a5}, 
	{0x4fc4, 0xb2e4}, 
	{0x4fc5, 0x8fb1b8}, 
	{0x4fc6, 0x8fb1b9}, 
	{0x4fc8, 0x8fb1ba}, 
	{0x4fc9, 0x8fb1bb}, 
	{0x4fca, 0xbdd3}, 
	{0x4fcb, 0x8fb1bc}, 
	{0x4fcc, 0x8fb1bd}, 
	{0x4fcd, 0x8fb1be}, 
	{0x4fce, 0xd0d9}, 
	{0x4fcf, 0x8fb1bf}, 
	{0x4fd0, 0xd0de}, 
	{0x4fd1, 0xd0dc}, 
	{0x4fd2, 0x8fb1c0}, 
	{0x4fd4, 0xd0d7}, 
	{0x4fd7, 0xc2af}, 
	{0x4fd8, 0xd0da}, 
	{0x4fda, 0xd0dd}, 
	{0x4fdb, 0xd0db}, 
	{0x4fdc, 0x8fb1c1}, 
	{0x4fdd, 0xcadd}, 
	{0x4fdf, 0xd0d8}, 
	{0x4fe0, 0x8fb1c2}, 
	{0x4fe1, 0xbfae}, 
	{0x4fe2, 0x8fb1c3}, 
	{0x4fe3, 0xcbf3}, 
	{0x4fe4, 0xd0df}, 
	{0x4fe5, 0xd0e0}, 
	{0x4fee, 0xbda4}, 
	{0x4fef, 0xd0ed}, 
	{0x4ff0, 0x8fb1c4}, 
	{0x4ff2, 0x8fb1c5}, 
	{0x4ff3, 0xc7d0}, 
	{0x4ff5, 0xc9b6}, 
	{0x4ff6, 0xd0e8}, 
	{0x4ff8, 0xcaf0}, 
	{0x4ffa, 0xb2b6}, 
	{0x4ffc, 0x8fb1c6}, 
	{0x4ffd, 0x8fb1c7}, 
	{0x4ffe, 0xd0ec}, 
	{0x4fff, 0x8fb1c8}, 
	{0x5000, 0x8fb1c9}, 
	{0x5001, 0x8fb1ca}, 
	{0x5004, 0x8fb1cb}, 
	{0x5005, 0xd0e6}, 
	{0x5006, 0xd0ef}, 
	{0x5007, 0x8fb1cc}, 
	{0x5009, 0xc1d2}, 
	{0x500a, 0x8fb1cd}, 
	{0x500b, 0xb8c4}, 
	{0x500c, 0x8fb1ce}, 
	{0x500d, 0xc7dc}, 
	{0x500e, 0x8fb1cf}, 
	{0x500f, 0xe0c7}, 
	{0x5010, 0x8fb1d0}, 
	{0x5011, 0xd0ee}, 
	{0x5012, 0xc5dd}, 
	{0x5013, 0x8fb1d1}, 
	{0x5014, 0xd0e3}, 
	{0x5016, 0xb8f6}, 
	{0x5017, 0x8fb1d2}, 
	{0x5018, 0x8fb1d3}, 
	{0x5019, 0xb8f5}, 
	{0x501a, 0xd0e1}, 
	{0x501b, 0x8fb1d4}, 
	{0x501c, 0x8fb1d5}, 
	{0x501d, 0x8fb1d6}, 
	{0x501e, 0x8fb1d7}, 
	{0x501f, 0xbcda}, 
	{0x5021, 0xd0e9}, 
	{0x5022, 0x8fb1d8}, 
	{0x5023, 0xcaef}, 
	{0x5024, 0xc3cd}, 
	{0x5025, 0xd0e5}, 
	{0x5026, 0xb7f1}, 
	{0x5027, 0x8fb1d9}, 
	{0x5028, 0xd0e2}, 
	{0x5029, 0xd0ea}, 
	{0x502a, 0xd0e4}, 
	{0x502b, 0xced1}, 
	{0x502c, 0xd0eb}, 
	{0x502d, 0xcfc1}, 
	{0x502e, 0x8fb1da}, 
	{0x5030, 0x8fb1db}, 
	{0x5032, 0x8fb1dc}, 
	{0x5033, 0x8fb1dd}, 
	{0x5035, 0x8fb1de}, 
	{0x5036, 0xb6e6}, 
	{0x5039, 0xb7f0}, 
	{0x503b, 0x8fb1f6}, 
	{0x5040, 0x8fb1df}, 
	{0x5041, 0x8fb1e0}, 
	{0x5042, 0x8fb1e1}, 
	{0x5043, 0xd0f0}, 
	{0x5045, 0x8fb1e2}, 
	{0x5046, 0x8fb1e3}, 
	{0x5047, 0xd0f1}, 
	{0x5048, 0xd0f5}, 
	{0x5049, 0xb0ce}, 
	{0x504a, 0x8fb1e4}, 
	{0x504c, 0x8fb1e5}, 
	{0x504e, 0x8fb1e6}, 
	{0x504f, 0xcad0}, 
	{0x5050, 0xd0f4}, 
	{0x5051, 0x8fb1e7}, 
	{0x5052, 0x8fb1e8}, 
	{0x5053, 0x8fb1e9}, 
	{0x5055, 0xd0f3}, 
	{0x5056, 0xd0f7}, 
	{0x5057, 0x8fb1ea}, 
	{0x5059, 0x8fb1eb}, 
	{0x505a, 0xd0f6}, 
	{0x505c, 0xc4e4}, 
	{0x505f, 0x8fb1ec}, 
	{0x5060, 0x8fb1ed}, 
	{0x5062, 0x8fb1ee}, 
	{0x5063, 0x8fb1ef}, 
	{0x5065, 0xb7f2}, 
	{0x5066, 0x8fb1f0}, 
	{0x5067, 0x8fb1f1}, 
	{0x506a, 0x8fb1f2}, 
	{0x506c, 0xd0f8}, 
	{0x506d, 0x8fb1f3}, 
	{0x5070, 0x8fb1f4}, 
	{0x5071, 0x8fb1f5}, 
	{0x5072, 0xbcc5}, 
	{0x5074, 0xc2a6}, 
	{0x5075, 0xc4e5}, 
	{0x5076, 0xb6f6}, 
	{0x5078, 0xd0f9}, 
	{0x507d, 0xb5b6}, 
	{0x5080, 0xd0fa}, 
	{0x5081, 0x8fb1f7}, 
	{0x5083, 0x8fb1f8}, 
	{0x5084, 0x8fb1f9}, 
	{0x5085, 0xd0fc}, 
	{0x5086, 0x8fb1fa}, 
	{0x508a, 0x8fb1fb}, 
	{0x508d, 0xcbb5}, 
	{0x508e, 0x8fb1fc}, 
	{0x508f, 0x8fb1fd}, 
	{0x5090, 0x8fb1fe}, 
	{0x5091, 0xb7e6}, 
	{0x5092, 0x8fb2a1}, 
	{0x5093, 0x8fb2a2}, 
	{0x5094, 0x8fb2a3}, 
	{0x5096, 0x8fb2a4}, 
	{0x5098, 0xbbb1}, 
	{0x5099, 0xc8f7}, 
	{0x509a, 0xd0fb}, 
	{0x509b, 0x8fb2a5}, 
	{0x509c, 0x8fb2a6}, 
	{0x509e, 0x8fb2a7}, 
	{0x509f, 0x8fb2a8}, 
	{0x50a0, 0x8fb2a9}, 
	{0x50a1, 0x8fb2aa}, 
	{0x50a2, 0x8fb2ab}, 
	{0x50aa, 0x8fb2ac}, 
	{0x50ac, 0xbac5}, 
	{0x50ad, 0xcdc3}, 
	{0x50af, 0x8fb2ad}, 
	{0x50b0, 0x8fb2ae}, 
	{0x50b2, 0xd0fe}, 
	{0x50b3, 0xd1a3}, 
	{0x50b4, 0xd0fd}, 
	{0x50b5, 0xbac4}, 
	{0x50b7, 0xbdfd}, 
	{0x50b9, 0x8fb2af}, 
	{0x50ba, 0x8fb2b0}, 
	{0x50bd, 0x8fb2b1}, 
	{0x50be, 0xb7b9}, 
	{0x50c0, 0x8fb2b2}, 
	{0x50c2, 0xd1a4}, 
	{0x50c3, 0x8fb2b3}, 
	{0x50c4, 0x8fb2b4}, 
	{0x50c5, 0xb6cf}, 
	{0x50c7, 0x8fb2b5}, 
	{0x50c9, 0xd1a1}, 
	{0x50ca, 0xd1a2}, 
	{0x50cc, 0x8fb2b6}, 
	{0x50cd, 0xc6af}, 
	{0x50ce, 0x8fb2b7}, 
	{0x50cf, 0xc1fc}, 
	{0x50d0, 0x8fb2b8}, 
	{0x50d1, 0xb6a3}, 
	{0x50d3, 0x8fb2b9}, 
	{0x50d4, 0x8fb2ba}, 
	{0x50d5, 0xcbcd}, 
	{0x50d6, 0xd1a5}, 
	{0x50d8, 0x8fb2bb}, 
	{0x50da, 0xcebd}, 
	{0x50dc, 0x8fb2bc}, 
	{0x50dd, 0x8fb2bd}, 
	{0x50de, 0xd1a6}, 
	{0x50df, 0x8fb2be}, 
	{0x50e2, 0x8fb2bf}, 
	{0x50e3, 0xd1a9}, 
	{0x50e4, 0x8fb2c0}, 
	{0x50e5, 0xd1a7}, 
	{0x50e6, 0x8fb2c1}, 
	{0x50e7, 0xc1ce}, 
	{0x50e8, 0x8fb2c2}, 
	{0x50e9, 0x8fb2c3}, 
	{0x50ed, 0xd1a8}, 
	{0x50ee, 0xd1aa}, 
	{0x50ef, 0x8fb2c4}, 
	{0x50f1, 0x8fb2c5}, 
	{0x50f2, 0x8fb2d1}, 
	{0x50f5, 0xd1ac}, 
	{0x50f6, 0x8fb2c6}, 
	{0x50f9, 0xd1ab}, 
	{0x50fa, 0x8fb2c7}, 
	{0x50fb, 0xcac8}, 
	{0x50fe, 0x8fb2c8}, 
	{0x5100, 0xb5b7}, 
	{0x5101, 0xd1ae}, 
	{0x5102, 0xd1af}, 
	{0x5103, 0x8fb2c9}, 
	{0x5104, 0xb2af}, 
	{0x5106, 0x8fb2ca}, 
	{0x5107, 0x8fb2cb}, 
	{0x5108, 0x8fb2cc}, 
	{0x5109, 0xd1ad}, 
	{0x510b, 0x8fb2cd}, 
	{0x510c, 0x8fb2ce}, 
	{0x510d, 0x8fb2cf}, 
	{0x510e, 0x8fb2d0}, 
	{0x5110, 0x8fb2d2}, 
	{0x5112, 0xbcf4}, 
	{0x5114, 0xd1b2}, 
	{0x5115, 0xd1b1}, 
	{0x5116, 0xd1b0}, 
	{0x5117, 0x8fb2d3}, 
	{0x5118, 0xd0d6}, 
	{0x5119, 0x8fb2d4}, 
	{0x511a, 0xd1b3}, 
	{0x511b, 0x8fb2d5}, 
	{0x511c, 0x8fb2d6}, 
	{0x511d, 0x8fb2d7}, 
	{0x511e, 0x8fb2d8}, 
	{0x511f, 0xbdfe}, 
	{0x5121, 0xd1b4}, 
	{0x5123, 0x8fb2d9}, 
	{0x5127, 0x8fb2da}, 
	{0x5128, 0x8fb2db}, 
	{0x512a, 0xcda5}, 
	{0x512c, 0x8fb2dc}, 
	{0x512d, 0x8fb2dd}, 
	{0x512f, 0x8fb2de}, 
	{0x5131, 0x8fb2df}, 
	{0x5132, 0xccd9}, 
	{0x5133, 0x8fb2e0}, 
	{0x5134, 0x8fb2e1}, 
	{0x5135, 0x8fb2e2}, 
	{0x5137, 0xd1b6}, 
	{0x5138, 0x8fb2e3}, 
	{0x5139, 0x8fb2e4}, 
	{0x513a, 0xd1b5}, 
	{0x513b, 0xd1b8}, 
	{0x513c, 0xd1b7}, 
	{0x513f, 0xd1b9}, 
	{0x5140, 0xd1ba}, 
	{0x5141, 0xb0f4}, 
	{0x5142, 0x8fb2e5}, 
	{0x5143, 0xb8b5}, 
	{0x5144, 0xb7bb}, 
	{0x5145, 0xbdbc}, 
	{0x5146, 0xc3fb}, 
	{0x5147, 0xb6a4}, 
	{0x5148, 0xc0e8}, 
	{0x5149, 0xb8f7}, 
	{0x514a, 0x8fb2e6}, 
	{0x514b, 0xb9ee}, 
	{0x514c, 0xd1bc}, 
	{0x514d, 0xccc8}, 
	{0x514e, 0xc5c6}, 
	{0x514f, 0x8fb2e7}, 
	{0x5150, 0xbbf9}, 
	{0x5152, 0xd1bb}, 
	{0x5153, 0x8fb2e8}, 
	{0x5154, 0xd1bd}, 
	{0x5155, 0x8fb2e9}, 
	{0x5157, 0x8fb2ea}, 
	{0x5158, 0x8fb2eb}, 
	{0x515a, 0xc5de}, 
	{0x515c, 0xb3f5}, 
	{0x515f, 0x8fb2ec}, 
	{0x5162, 0xd1be}, 
	{0x5164, 0x8fb2ed}, 
	{0x5165, 0xc6fe}, 
	{0x5166, 0x8fb2ee}, 
	{0x5168, 0xc1b4}, 
	{0x5169, 0xd1c0}, 
	{0x516a, 0xd1c1}, 
	{0x516b, 0xc8ac}, 
	{0x516c, 0xb8f8}, 
	{0x516d, 0xcfbb}, 
	{0x516e, 0xd1c2}, 
	{0x5171, 0xb6a6}, 
	{0x5175, 0xcabc}, 
	{0x5176, 0xc2b6}, 
	{0x5177, 0xb6f1}, 
	{0x5178, 0xc5b5}, 
	{0x517c, 0xb7f3}, 
	{0x517e, 0x8fb2ef}, 
	{0x5180, 0xd1c3}, 
	{0x5182, 0xd1c4}, 
	{0x5183, 0x8fb2f0}, 
	{0x5184, 0x8fb2f1}, 
	{0x5185, 0xc6e2}, 
	{0x5186, 0xb1df}, 
	{0x5189, 0xd1c7}, 
	{0x518a, 0xbafd}, 
	{0x518b, 0x8fb2f2}, 
	{0x518c, 0xd1c6}, 
	{0x518d, 0xbac6}, 
	{0x518e, 0x8fb2f3}, 
	{0x518f, 0xd1c8}, 
	{0x5190, 0xe6ee}, 
	{0x5191, 0xd1c9}, 
	{0x5192, 0xcbc1}, 
	{0x5193, 0xd1ca}, 
	{0x5195, 0xd1cb}, 
	{0x5196, 0xd1cc}, 
	{0x5197, 0xbee9}, 
	{0x5198, 0x8fb2f4}, 
	{0x5199, 0xbccc}, 
	{0x519d, 0x8fb2f5}, 
	{0x51a0, 0xb4a7}, 
	{0x51a1, 0x8fb2f6}, 
	{0x51a2, 0xd1cf}, 
	{0x51a3, 0x8fb2f7}, 
	{0x51a4, 0xd1cd}, 
	{0x51a5, 0xccbd}, 
	{0x51a6, 0xd1ce}, 
	{0x51a8, 0xc9da}, 
	{0x51a9, 0xd1d0}, 
	{0x51aa, 0xd1d1}, 
	{0x51ab, 0xd1d2}, 
	{0x51ac, 0xc5df}, 
	{0x51ad, 0x8fb2f8}, 
	{0x51b0, 0xd1d6}, 
	{0x51b1, 0xd1d4}, 
	{0x51b2, 0xd1d5}, 
	{0x51b3, 0xd1d3}, 
	{0x51b4, 0xbae3}, 
	{0x51b5, 0xd1d7}, 
	{0x51b6, 0xccea}, 
	{0x51b7, 0xcee4}, 
	{0x51b8, 0x8fb2f9}, 
	{0x51ba, 0x8fb2fa}, 
	{0x51bc, 0x8fb2fb}, 
	{0x51bd, 0xd1d8}, 
	{0x51be, 0x8fb2fc}, 
	{0x51bf, 0x8fb2fd}, 
	{0x51c2, 0x8fb2fe}, 
	{0x51c4, 0xc0a8}, 
	{0x51c5, 0xd1d9}, 
	{0x51c6, 0xbdda}, 
	{0x51c8, 0x8fb3a1}, 
	{0x51c9, 0xd1da}, 
	{0x51cb, 0xc3fc}, 
	{0x51cc, 0xcebf}, 
	{0x51cd, 0xc5e0}, 
	{0x51cf, 0x8fb3a2}, 
	{0x51d1, 0x8fb3a3}, 
	{0x51d2, 0x8fb3a4}, 
	{0x51d3, 0x8fb3a5}, 
	{0x51d5, 0x8fb3a6}, 
	{0x51d6, 0xd2c5}, 
	{0x51d8, 0x8fb3a7}, 
	{0x51db, 0xd1db}, 
	{0x51dc, 0xf4a5}, 
	{0x51dd, 0xb6c5}, 
	{0x51de, 0x8fb3a8}, 
	{0x51e0, 0xd1dc}, 
	{0x51e1, 0xcbde}, 
	{0x51e2, 0x8fb3a9}, 
	{0x51e5, 0x8fb3aa}, 
	{0x51e6, 0xbde8}, 
	{0x51e7, 0xc2fc}, 
	{0x51e9, 0xd1de}, 
	{0x51ea, 0xc6e4}, 
	{0x51ed, 0xd1df}, 
	{0x51ee, 0x8fb3ab}, 
	{0x51f0, 0xd1e0}, 
	{0x51f1, 0xb3ae}, 
	{0x51f2, 0x8fb3ac}, 
	{0x51f3, 0x8fb3ad}, 
	{0x51f4, 0x8fb3ae}, 
	{0x51f5, 0xd1e1}, 
	{0x51f6, 0xb6a7}, 
	{0x51f7, 0x8fb3af}, 
	{0x51f8, 0xc6cc}, 
	{0x51f9, 0xb1fa}, 
	{0x51fa, 0xbdd0}, 
	{0x51fd, 0xc8a1}, 
	{0x51fe, 0xd1e2}, 
	{0x5200, 0xc5e1}, 
	{0x5201, 0x8fb3b0}, 
	{0x5202, 0x8fb3b1}, 
	{0x5203, 0xbfcf}, 
	{0x5204, 0xd1e3}, 
	{0x5205, 0x8fb3b2}, 
	{0x5206, 0xcaac}, 
	{0x5207, 0xc0da}, 
	{0x5208, 0xb4a2}, 
	{0x520a, 0xb4a9}, 
	{0x520b, 0xd1e4}, 
	{0x520e, 0xd1e6}, 
	{0x5211, 0xb7ba}, 
	{0x5212, 0x8fb3b3}, 
	{0x5213, 0x8fb3b4}, 
	{0x5214, 0xd1e5}, 
	{0x5215, 0x8fb3b5}, 
	{0x5216, 0x8fb3b6}, 
	{0x5217, 0xcef3}, 
	{0x5218, 0x8fb3b7}, 
	{0x521d, 0xbde9}, 
	{0x5222, 0x8fb3b8}, 
	{0x5224, 0xc8bd}, 
	{0x5225, 0xcacc}, 
	{0x5227, 0xd1e7}, 
	{0x5228, 0x8fb3b9}, 
	{0x5229, 0xcdf8}, 
	{0x522a, 0xd1e8}, 
	{0x522e, 0xd1e9}, 
	{0x5230, 0xc5fe}, 
	{0x5231, 0x8fb3ba}, 
	{0x5232, 0x8fb3bb}, 
	{0x5233, 0xd1ea}, 
	{0x5235, 0x8fb3bc}, 
	{0x5236, 0xc0a9}, 
	{0x5237, 0xbafe}, 
	{0x5238, 0xb7f4}, 
	{0x5239, 0xd1eb}, 
	{0x523a, 0xbbc9}, 
	{0x523b, 0xb9ef}, 
	{0x523c, 0x8fb3bd}, 
	{0x5243, 0xc4e6}, 
	{0x5244, 0xd1ed}, 
	{0x5245, 0x8fb3be}, 
	{0x5247, 0xc2a7}, 
	{0x5249, 0x8fb3bf}, 
	{0x524a, 0xbaef}, 
	{0x524b, 0xd1ee}, 
	{0x524c, 0xd1ef}, 
	{0x524d, 0xc1b0}, 
	{0x524f, 0xd1ec}, 
	{0x5254, 0xd1f1}, 
	{0x5255, 0x8fb3c0}, 
	{0x5256, 0xcbb6}, 
	{0x5257, 0x8fb3c1}, 
	{0x5258, 0x8fb3c2}, 
	{0x525a, 0x8fb3c3}, 
	{0x525b, 0xb9e4}, 
	{0x525c, 0x8fb3c4}, 
	{0x525e, 0xd1f0}, 
	{0x525f, 0x8fb3c5}, 
	{0x5260, 0x8fb3c6}, 
	{0x5261, 0x8fb3c7}, 
	{0x5263, 0xb7f5}, 
	{0x5264, 0xbade}, 
	{0x5265, 0xc7ed}, 
	{0x5266, 0x8fb3c8}, 
	{0x5269, 0xd1f4}, 
	{0x526a, 0xd1f2}, 
	{0x526e, 0x8fb3c9}, 
	{0x526f, 0xc9fb}, 
	{0x5270, 0xbeea}, 
	{0x5271, 0xd1fb}, 
	{0x5272, 0xb3e4}, 
	{0x5273, 0xd1f5}, 
	{0x5274, 0xd1f3}, 
	{0x5275, 0xc1cf}, 
	{0x5277, 0x8fb3ca}, 
	{0x5278, 0x8fb3cb}, 
	{0x5279, 0x8fb3cc}, 
	{0x527d, 0xd1f7}, 
	{0x527f, 0xd1f6}, 
	{0x5280, 0x8fb3cd}, 
	{0x5282, 0x8fb3ce}, 
	{0x5283, 0xb3c4}, 
	{0x5285, 0x8fb3cf}, 
	{0x5287, 0xb7e0}, 
	{0x5288, 0xd1fc}, 
	{0x5289, 0xcead}, 
	{0x528a, 0x8fb3d0}, 
	{0x528c, 0x8fb3d1}, 
	{0x528d, 0xd1f8}, 
	{0x5291, 0xd1fd}, 
	{0x5292, 0xd1fa}, 
	{0x5293, 0x8fb3d2}, 
	{0x5294, 0xd1f9}, 
	{0x5295, 0x8fb3d3}, 
	{0x5296, 0x8fb3d4}, 
	{0x5297, 0x8fb3d5}, 
	{0x5298, 0x8fb3d6}, 
	{0x529a, 0x8fb3d7}, 
	{0x529b, 0xcecf}, 
	{0x529c, 0x8fb3d8}, 
	{0x529f, 0xb8f9}, 
	{0x52a0, 0xb2c3}, 
	{0x52a3, 0xcef4}, 
	{0x52a4, 0x8fb3d9}, 
	{0x52a5, 0x8fb3da}, 
	{0x52a6, 0x8fb3db}, 
	{0x52a7, 0x8fb3dc}, 
	{0x52a9, 0xbdf5}, 
	{0x52aa, 0xc5d8}, 
	{0x52ab, 0xb9e5}, 
	{0x52ac, 0xd2a2}, 
	{0x52ad, 0xd2a3}, 
	{0x52af, 0x8fb3dd}, 
	{0x52b0, 0x8fb3de}, 
	{0x52b1, 0xcee5}, 
	{0x52b4, 0xcfab}, 
	{0x52b5, 0xd2a5}, 
	{0x52b6, 0x8fb3df}, 
	{0x52b7, 0x8fb3e0}, 
	{0x52b8, 0x8fb3e1}, 
	{0x52b9, 0xb8fa}, 
	{0x52ba, 0x8fb3e2}, 
	{0x52bb, 0x8fb3e3}, 
	{0x52bc, 0xd2a4}, 
	{0x52bd, 0x8fb3e4}, 
	{0x52be, 0xb3af}, 
	{0x52c0, 0x8fb3e5}, 
	{0x52c1, 0xd2a6}, 
	{0x52c3, 0xcbd6}, 
	{0x52c4, 0x8fb3e6}, 
	{0x52c5, 0xc4bc}, 
	{0x52c6, 0x8fb3e7}, 
	{0x52c7, 0xcda6}, 
	{0x52c8, 0x8fb3e8}, 
	{0x52c9, 0xcad9}, 
	{0x52cc, 0x8fb3e9}, 
	{0x52cd, 0xd2a7}, 
	{0x52cf, 0x8fb3ea}, 
	{0x52d1, 0x8fb3eb}, 
	{0x52d2, 0xf0d5}, 
	{0x52d4, 0x8fb3ec}, 
	{0x52d5, 0xc6b0}, 
	{0x52d6, 0x8fb3ed}, 
	{0x52d7, 0xd2a8}, 
	{0x52d8, 0xb4aa}, 
	{0x52d9, 0xccb3}, 
	{0x52db, 0x8fb3ee}, 
	{0x52dc, 0x8fb3ef}, 
	{0x52dd, 0xbea1}, 
	{0x52de, 0xd2a9}, 
	{0x52df, 0xcae7}, 
	{0x52e0, 0xd2ad}, 
	{0x52e1, 0x8fb3f0}, 
	{0x52e2, 0xc0aa}, 
	{0x52e3, 0xd2aa}, 
	{0x52e4, 0xb6d0}, 
	{0x52e5, 0x8fb3f1}, 
	{0x52e6, 0xd2ab}, 
	{0x52e7, 0xb4ab}, 
	{0x52e8, 0x8fb3f2}, 
	{0x52e9, 0x8fb3f3}, 
	{0x52ea, 0x8fb3f4}, 
	{0x52ec, 0x8fb3f5}, 
	{0x52f0, 0x8fb3f6}, 
	{0x52f1, 0x8fb3f7}, 
	{0x52f2, 0xb7ae}, 
	{0x52f3, 0xd2ae}, 
	{0x52f4, 0x8fb3f8}, 
	{0x52f5, 0xd2af}, 
	{0x52f6, 0x8fb3f9}, 
	{0x52f7, 0x8fb3fa}, 
	{0x52f8, 0xd2b0}, 
	{0x52f9, 0xd2b1}, 
	{0x52fa, 0xbcdb}, 
	{0x52fe, 0xb8fb}, 
	{0x52ff, 0xccde}, 
	{0x5300, 0x8fb3fb}, 
	{0x5301, 0xcce8}, 
	{0x5302, 0xc6f7}, 
	{0x5303, 0x8fb3fc}, 
	{0x5305, 0xcaf1}, 
	{0x5306, 0xd2b2}, 
	{0x5308, 0xd2b3}, 
	{0x530a, 0x8fb3fd}, 
	{0x530b, 0x8fb3fe}, 
	{0x530c, 0x8fb4a1}, 
	{0x530d, 0xd2b5}, 
	{0x530f, 0xd2b7}, 
	{0x5310, 0xd2b6}, 
	{0x5311, 0x8fb4a2}, 
	{0x5313, 0x8fb4a3}, 
	{0x5315, 0xd2b8}, 
	{0x5316, 0xb2bd}, 
	{0x5317, 0xcbcc}, 
	{0x5318, 0x8fb4a4}, 
	{0x5319, 0xbafc}, 
	{0x531a, 0xd2b9}, 
	{0x531b, 0x8fb4a5}, 
	{0x531c, 0x8fb4a6}, 
	{0x531d, 0xc1d9}, 
	{0x531e, 0x8fb4a7}, 
	{0x531f, 0x8fb4a8}, 
	{0x5320, 0xbea2}, 
	{0x5321, 0xb6a9}, 
	{0x5323, 0xd2ba}, 
	{0x5325, 0x8fb4a9}, 
	{0x5327, 0x8fb4aa}, 
	{0x5328, 0x8fb4ab}, 
	{0x5329, 0x8fb4ac}, 
	{0x532a, 0xc8db}, 
	{0x532b, 0x8fb4ad}, 
	{0x532c, 0x8fb4ae}, 
	{0x532d, 0x8fb4af}, 
	{0x532f, 0xd2bb}, 
	{0x5330, 0x8fb4b0}, 
	{0x5331, 0xd2bc}, 
	{0x5332, 0x8fb4b1}, 
	{0x5333, 0xd2bd}, 
	{0x5335, 0x8fb4b2}, 
	{0x5338, 0xd2be}, 
	{0x5339, 0xc9a4}, 
	{0x533a, 0xb6e8}, 
	{0x533b, 0xb0e5}, 
	{0x533c, 0x8fb4b3}, 
	{0x533d, 0x8fb4b4}, 
	{0x533e, 0x8fb4b5}, 
	{0x533f, 0xc6bf}, 
	{0x5340, 0xd2bf}, 
	{0x5341, 0xbdbd}, 
	{0x5342, 0x8fb4b6}, 
	{0x5343, 0xc0e9}, 
	{0x5345, 0xd2c1}, 
	{0x5346, 0xd2c0}, 
	{0x5347, 0xbea3}, 
	{0x5348, 0xb8e1}, 
	{0x5349, 0xd2c3}, 
	{0x534a, 0xc8be}, 
	{0x534b, 0x8fb4b8}, 
	{0x534c, 0x8fb4b7}, 
	{0x534d, 0xd2c4}, 
	{0x5351, 0xc8dc}, 
	{0x5352, 0xc2b4}, 
	{0x5353, 0xc2ee}, 
	{0x5354, 0xb6a8}, 
	{0x5357, 0xc6ee}, 
	{0x5358, 0xc3b1}, 
	{0x5359, 0x8fb4b9}, 
	{0x535a, 0xc7ee}, 
	{0x535b, 0x8fb4ba}, 
	{0x535c, 0xcbce}, 
	{0x535e, 0xd2c6}, 
	{0x5360, 0xc0ea}, 
	{0x5361, 0x8fb4bb}, 
	{0x5363, 0x8fb4bc}, 
	{0x5365, 0x8fb4bd}, 
	{0x5366, 0xb7b5}, 
	{0x5369, 0xd2c7}, 
	{0x536c, 0x8fb4be}, 
	{0x536d, 0x8fb4bf}, 
	{0x536e, 0xd2c8}, 
	{0x536f, 0xb1ac}, 
	{0x5370, 0xb0f5}, 
	{0x5371, 0xb4ed}, 
	{0x5372, 0x8fb4c0}, 
	{0x5373, 0xc2a8}, 
	{0x5374, 0xb5d1}, 
	{0x5375, 0xcdf1}, 
	{0x5377, 0xd2cb}, 
	{0x5378, 0xb2b7}, 
	{0x5379, 0x8fb4c1}, 
	{0x537b, 0xd2ca}, 
	{0x537e, 0x8fb4c2}, 
	{0x537f, 0xb6aa}, 
	{0x5382, 0xd2cc}, 
	{0x5383, 0x8fb4c3}, 
	{0x5384, 0xccf1}, 
	{0x5387, 0x8fb4c4}, 
	{0x5388, 0x8fb4c5}, 
	{0x538e, 0x8fb4c6}, 
	{0x5393, 0x8fb4c7}, 
	{0x5394, 0x8fb4c8}, 
	{0x5396, 0xd2cd}, 
	{0x5398, 0xced2}, 
	{0x5399, 0x8fb4c9}, 
	{0x539a, 0xb8fc}, 
	{0x539d, 0x8fb4ca}, 
	{0x539f, 0xb8b6}, 
	{0x53a0, 0xd2ce}, 
	{0x53a1, 0x8fb4cb}, 
	{0x53a4, 0x8fb4cc}, 
	{0x53a5, 0xd2d0}, 
	{0x53a6, 0xd2cf}, 
	{0x53a8, 0xbfdf}, 
	{0x53a9, 0xb1b9}, 
	{0x53aa, 0x8fb4cd}, 
	{0x53ab, 0x8fb4ce}, 
	{0x53ad, 0xb1de}, 
	{0x53ae, 0xd2d1}, 
	{0x53af, 0x8fb4cf}, 
	{0x53b0, 0xd2d2}, 
	{0x53b2, 0x8fb4d0}, 
	{0x53b3, 0xb8b7}, 
	{0x53b4, 0x8fb4d1}, 
	{0x53b5, 0x8fb4d2}, 
	{0x53b6, 0xd2d3}, 
	{0x53b7, 0x8fb4d3}, 
	{0x53b8, 0x8fb4d4}, 
	{0x53ba, 0x8fb4d5}, 
	{0x53bb, 0xb5ee}, 
	{0x53bd, 0x8fb4d6}, 
	{0x53c0, 0x8fb4d7}, 
	{0x53c2, 0xbbb2}, 
	{0x53c3, 0xd2d4}, 
	{0x53c5, 0x8fb4d8}, 
	{0x53c8, 0xcbf4}, 
	{0x53c9, 0xbab5}, 
	{0x53ca, 0xb5da}, 
	{0x53cb, 0xcda7}, 
	{0x53cc, 0xc1d0}, 
	{0x53cd, 0xc8bf}, 
	{0x53ce, 0xbcfd}, 
	{0x53cf, 0x8fb4d9}, 
	{0x53d2, 0x8fb4da}, 
	{0x53d3, 0x8fb4db}, 
	{0x53d4, 0xbdc7}, 
	{0x53d5, 0x8fb4dc}, 
	{0x53d6, 0xbce8}, 
	{0x53d7, 0xbcf5}, 
	{0x53d9, 0xbdf6}, 
	{0x53da, 0x8fb4dd}, 
	{0x53db, 0xc8c0}, 
	{0x53dd, 0x8fb4de}, 
	{0x53de, 0x8fb4df}, 
	{0x53df, 0xd2d7}, 
	{0x53e0, 0x8fb4e0}, 
	{0x53e1, 0xb1c3}, 
	{0x53e2, 0xc1d1}, 
	{0x53e3, 0xb8fd}, 
	{0x53e4, 0xb8c5}, 
	{0x53e5, 0xb6e7}, 
	{0x53e6, 0x8fb4e1}, 
	{0x53e7, 0x8fb4e2}, 
	{0x53e8, 0xd2db}, 
	{0x53e9, 0xc3a1}, 
	{0x53ea, 0xc2fe}, 
	{0x53eb, 0xb6ab}, 
	{0x53ec, 0xbea4}, 
	{0x53ed, 0xd2dc}, 
	{0x53ee, 0xd2da}, 
	{0x53ef, 0xb2c4}, 
	{0x53f0, 0xc2e6}, 
	{0x53f1, 0xbcb8}, 
	{0x53f2, 0xbbcb}, 
	{0x53f3, 0xb1a6}, 
	{0x53f5, 0x8fb4e3}, 
	{0x53f6, 0xb3f0}, 
	{0x53f7, 0xb9e6}, 
	{0x53f8, 0xbbca}, 
	{0x53fa, 0xd2dd}, 
	{0x5401, 0xd2de}, 
	{0x5402, 0x8fb4e4}, 
	{0x5403, 0xb5c9}, 
	{0x5404, 0xb3c6}, 
	{0x5408, 0xb9e7}, 
	{0x5409, 0xb5c8}, 
	{0x540a, 0xc4df}, 
	{0x540b, 0xb1a5}, 
	{0x540c, 0xc6b1}, 
	{0x540d, 0xccbe}, 
	{0x540e, 0xb9a1}, 
	{0x540f, 0xcdf9}, 
	{0x5410, 0xc5c7}, 
	{0x5411, 0xb8fe}, 
	{0x5413, 0x8fb4e5}, 
	{0x541a, 0x8fb4e6}, 
	{0x541b, 0xb7af}, 
	{0x541d, 0xd2e7}, 
	{0x541f, 0xb6e3}, 
	{0x5420, 0xcbca}, 
	{0x5421, 0x8fb4e7}, 
	{0x5426, 0xc8dd}, 
	{0x5427, 0x8fb4e8}, 
	{0x5428, 0x8fb4e9}, 
	{0x5429, 0xd2e6}, 
	{0x542a, 0x8fb4ea}, 
	{0x542b, 0xb4de}, 
	{0x542c, 0xd2e1}, 
	{0x542d, 0xd2e2}, 
	{0x542e, 0xd2e4}, 
	{0x542f, 0x8fb4eb}, 
	{0x5431, 0x8fb4ec}, 
	{0x5434, 0x8fb4ed}, 
	{0x5435, 0x8fb4ee}, 
	{0x5436, 0xd2e5}, 
	{0x5438, 0xb5db}, 
	{0x5439, 0xbfe1}, 
	{0x543b, 0xcaad}, 
	{0x543c, 0xd2e3}, 
	{0x543d, 0xd2df}, 
	{0x543e, 0xb8e3}, 
	{0x5440, 0xd2e0}, 
	{0x5442, 0xcfa4}, 
	{0x5443, 0x8fb4ef}, 
	{0x5444, 0x8fb4f0}, 
	{0x5446, 0xcaf2}, 
	{0x5447, 0x8fb4f1}, 
	{0x5448, 0xc4e8}, 
	{0x5449, 0xb8e2}, 
	{0x544a, 0xb9f0}, 
	{0x544d, 0x8fb4f2}, 
	{0x544e, 0xd2e8}, 
	{0x544f, 0x8fb4f3}, 
	{0x5451, 0xc6dd}, 
	{0x545e, 0x8fb4f4}, 
	{0x545f, 0xd2ec}, 
	{0x5462, 0x8fb4f5}, 
	{0x5464, 0x8fb4f6}, 
	{0x5466, 0x8fb4f7}, 
	{0x5467, 0x8fb4f8}, 
	{0x5468, 0xbcfe}, 
	{0x5469, 0x8fb4f9}, 
	{0x546a, 0xbcf6}, 
	{0x546b, 0x8fb4fa}, 
	{0x546d, 0x8fb4fb}, 
	{0x546e, 0x8fb4fc}, 
	{0x5470, 0xd2ef}, 
	{0x5471, 0xd2ed}, 
	{0x5473, 0xcca3}, 
	{0x5474, 0x8fb4fd}, 
	{0x5475, 0xd2ea}, 
	{0x5476, 0xd2f3}, 
	{0x5477, 0xd2ee}, 
	{0x547b, 0xd2f1}, 
	{0x547c, 0xb8c6}, 
	{0x547d, 0xccbf}, 
	{0x547f, 0x8fb4fe}, 
	{0x5480, 0xd2f2}, 
	{0x5481, 0x8fb5a1}, 
	{0x5483, 0x8fb5a2}, 
	{0x5484, 0xd2f4}, 
	{0x5485, 0x8fb5a3}, 
	{0x5486, 0xd2f6}, 
	{0x5488, 0x8fb5a4}, 
	{0x5489, 0x8fb5a5}, 
	{0x548b, 0xbaf0}, 
	{0x548c, 0xcfc2}, 
	{0x548d, 0x8fb5a6}, 
	{0x548e, 0xd2eb}, 
	{0x548f, 0xd2e9}, 
	{0x5490, 0xd2f5}, 
	{0x5491, 0x8fb5a7}, 
	{0x5492, 0xd2f0}, 
	{0x5495, 0x8fb5a8}, 
	{0x5496, 0x8fb5a9}, 
	{0x549c, 0x8fb5aa}, 
	{0x549f, 0x8fb5ab}, 
	{0x54a1, 0x8fb5ac}, 
	{0x54a2, 0xd2f8}, 
	{0x54a4, 0xd3a3}, 
	{0x54a5, 0xd2fa}, 
	{0x54a6, 0x8fb5ad}, 
	{0x54a7, 0x8fb5ae}, 
	{0x54a8, 0xd2fe}, 
	{0x54a9, 0x8fb5af}, 
	{0x54aa, 0x8fb5b0}, 
	{0x54ab, 0xd3a1}, 
	{0x54ac, 0xd2fb}, 
	{0x54ad, 0x8fb5b1}, 
	{0x54ae, 0x8fb5b2}, 
	{0x54af, 0xd3be}, 
	{0x54b1, 0x8fb5b3}, 
	{0x54b2, 0xbae9}, 
	{0x54b3, 0xb3b1}, 
	{0x54b7, 0x8fb5b4}, 
	{0x54b8, 0xd2f9}, 
	{0x54b9, 0x8fb5b5}, 
	{0x54ba, 0x8fb5b6}, 
	{0x54bb, 0x8fb5b7}, 
	{0x54bc, 0xd3a5}, 
	{0x54bd, 0xb0f6}, 
	{0x54be, 0xd3a4}, 
	{0x54bf, 0x8fb5b8}, 
	{0x54c0, 0xb0a5}, 
	{0x54c1, 0xc9ca}, 
	{0x54c2, 0xd3a2}, 
	{0x54c4, 0xd2fc}, 
	{0x54c6, 0x8fb5b9}, 
	{0x54c7, 0xd2f7}, 
	{0x54c8, 0xd2fd}, 
	{0x54c9, 0xbac8}, 
	{0x54ca, 0x8fb5ba}, 
	{0x54cd, 0x8fb5bb}, 
	{0x54ce, 0x8fb5bc}, 
	{0x54d8, 0xd3a6}, 
	{0x54e0, 0x8fb5bd}, 
	{0x54e1, 0xb0f7}, 
	{0x54e2, 0xd3af}, 
	{0x54e5, 0xd3a7}, 
	{0x54e6, 0xd3a8}, 
	{0x54e8, 0xbea5}, 
	{0x54e9, 0xcbe9}, 
	{0x54ea, 0x8fb5be}, 
	{0x54ec, 0x8fb5bf}, 
	{0x54ed, 0xd3ad}, 
	{0x54ee, 0xd3ac}, 
	{0x54ef, 0x8fb5c0}, 
	{0x54f2, 0xc5af}, 
	{0x54f6, 0x8fb5c1}, 
	{0x54fa, 0xd3ae}, 
	{0x54fc, 0x8fb5c2}, 
	{0x54fd, 0xd3ab}, 
	{0x54fe, 0x8fb5c3}, 
	{0x54ff, 0x8fb5c4}, 
	{0x5500, 0x8fb5c5}, 
	{0x5501, 0x8fb5c6}, 
	{0x5504, 0xb1b4}, 
	{0x5505, 0x8fb5c7}, 
	{0x5506, 0xbab6}, 
	{0x5507, 0xbfb0}, 
	{0x5508, 0x8fb5c8}, 
	{0x5509, 0x8fb5c9}, 
	{0x550c, 0x8fb5ca}, 
	{0x550d, 0x8fb5cb}, 
	{0x550e, 0x8fb5cc}, 
	{0x550f, 0xd3a9}, 
	{0x5510, 0xc5e2}, 
	{0x5514, 0xd3aa}, 
	{0x5515, 0x8fb5cd}, 
	{0x5516, 0xb0a2}, 
	{0x552a, 0x8fb5ce}, 
	{0x552b, 0x8fb5cf}, 
	{0x552e, 0xd3b4}, 
	{0x552f, 0xcda3}, 
	{0x5531, 0xbea7}, 
	{0x5532, 0x8fb5d0}, 
	{0x5533, 0xd3ba}, 
	{0x5535, 0x8fb5d1}, 
	{0x5536, 0x8fb5d2}, 
	{0x5538, 0xd3b9}, 
	{0x5539, 0xd3b0}, 
	{0x553b, 0x8fb5d3}, 
	{0x553c, 0x8fb5d4}, 
	{0x553d, 0x8fb5d5}, 
	{0x553e, 0xc2c3}, 
	{0x5540, 0xd3b1}, 
	{0x5541, 0x8fb5d6}, 
	{0x5544, 0xc2ef}, 
	{0x5545, 0xd3b6}, 
	{0x5546, 0xbea6}, 
	{0x5547, 0x8fb5d7}, 
	{0x5549, 0x8fb5d8}, 
	{0x554a, 0x8fb5d9}, 
	{0x554c, 0xd3b3}, 
	{0x554d, 0x8fb5da}, 
	{0x554f, 0xcce4}, 
	{0x5550, 0x8fb5db}, 
	{0x5551, 0x8fb5dc}, 
	{0x5553, 0xb7bc}, 
	{0x5556, 0xd3b7}, 
	{0x5557, 0xd3b8}, 
	{0x5558, 0x8fb5dd}, 
	{0x555a, 0x8fb5de}, 
	{0x555b, 0x8fb5df}, 
	{0x555c, 0xd3b5}, 
	{0x555d, 0xd3bb}, 
	{0x555e, 0x8fb5e0}, 
	{0x5560, 0x8fb5e1}, 
	{0x5561, 0x8fb5e2}, 
	{0x5563, 0xd3b2}, 
	{0x5564, 0x8fb5e3}, 
	{0x5566, 0x8fb5e4}, 
	{0x557b, 0xd3c1}, 
	{0x557c, 0xd3c6}, 
	{0x557e, 0xd3c2}, 
	{0x557f, 0x8fb5e5}, 
	{0x5580, 0xd3bd}, 
	{0x5581, 0x8fb5e6}, 
	{0x5582, 0x8fb5e7}, 
	{0x5583, 0xd3c7}, 
	{0x5584, 0xc1b1}, 
	{0x5586, 0x8fb5e8}, 
	{0x5587, 0xd3c9}, 
	{0x5588, 0x8fb5e9}, 
	{0x5589, 0xb9a2}, 
	{0x558a, 0xd3bf}, 
	{0x558b, 0xc3fd}, 
	{0x558e, 0x8fb5ea}, 
	{0x558f, 0x8fb5eb}, 
	{0x5591, 0x8fb5ec}, 
	{0x5592, 0x8fb5ed}, 
	{0x5593, 0x8fb5ee}, 
	{0x5594, 0x8fb5ef}, 
	{0x5597, 0x8fb5f0}, 
	{0x5598, 0xd3c3}, 
	{0x5599, 0xd3bc}, 
	{0x559a, 0xb4ad}, 
	{0x559c, 0xb4ee}, 
	{0x559d, 0xb3e5}, 
	{0x559e, 0xd3c4}, 
	{0x559f, 0xd3c0}, 
	{0x55a3, 0x8fb5f1}, 
	{0x55a4, 0x8fb5f2}, 
	{0x55a7, 0xb7f6}, 
	{0x55a8, 0xd3ca}, 
	{0x55a9, 0xd3c8}, 
	{0x55aa, 0xc1d3}, 
	{0x55ab, 0xb5ca}, 
	{0x55ac, 0xb6ac}, 
	{0x55ad, 0x8fb5f3}, 
	{0x55ae, 0xd3c5}, 
	{0x55b0, 0xb6f4}, 
	{0x55b2, 0x8fb5f4}, 
	{0x55b6, 0xb1c4}, 
	{0x55bf, 0x8fb5f5}, 
	{0x55c1, 0x8fb5f6}, 
	{0x55c3, 0x8fb5f7}, 
	{0x55c4, 0xd3ce}, 
	{0x55c5, 0xd3cc}, 
	{0x55c6, 0x8fb5f8}, 
	{0x55c7, 0xd4a7}, 
	{0x55c9, 0x8fb5f9}, 
	{0x55cb, 0x8fb5fa}, 
	{0x55cc, 0x8fb5fb}, 
	{0x55ce, 0x8fb5fc}, 
	{0x55d1, 0x8fb5fd}, 
	{0x55d2, 0x8fb5fe}, 
	{0x55d3, 0x8fb6a1}, 
	{0x55d4, 0xd3d1}, 
	{0x55d7, 0x8fb6a2}, 
	{0x55d8, 0x8fb6a3}, 
	{0x55da, 0xd3cb}, 
	{0x55db, 0x8fb6a4}, 
	{0x55dc, 0xd3cf}, 
	{0x55de, 0x8fb6a5}, 
	{0x55df, 0xd3cd}, 
	{0x55e2, 0x8fb6a6}, 
	{0x55e3, 0xbbcc}, 
	{0x55e4, 0xd3d0}, 
	{0x55e9, 0x8fb6a7}, 
	{0x55f6, 0x8fb6a8}, 
	{0x55f7, 0xd3d3}, 
	{0x55f9, 0xd3d8}, 
	{0x55fd, 0xd3d6}, 
	{0x55fe, 0xd3d5}, 
	{0x55ff, 0x8fb6a9}, 
	{0x5605, 0x8fb6aa}, 
	{0x5606, 0xc3b2}, 
	{0x5608, 0x8fb6ab}, 
	{0x5609, 0xb2c5}, 
	{0x560a, 0x8fb6ac}, 
	{0x560d, 0x8fb6ad}, 
	{0x560e, 0x8fb6ae}, 
	{0x560f, 0x8fb6af}, 
	{0x5610, 0x8fb6b0}, 
	{0x5611, 0x8fb6b1}, 
	{0x5612, 0x8fb6b2}, 
	{0x5614, 0xd3d2}, 
	{0x5616, 0xd3d4}, 
	{0x5617, 0xbea8}, 
	{0x5618, 0xb1b3}, 
	{0x5619, 0x8fb6b3}, 
	{0x561b, 0xd3d7}, 
	{0x5629, 0xb2de}, 
	{0x562c, 0x8fb6b4}, 
	{0x562f, 0xd3e2}, 
	{0x5630, 0x8fb6b5}, 
	{0x5631, 0xbefc}, 
	{0x5632, 0xd3de}, 
	{0x5633, 0x8fb6b6}, 
	{0x5634, 0xd3dc}, 
	{0x5635, 0x8fb6b7}, 
	{0x5636, 0xd3dd}, 
	{0x5637, 0x8fb6b8}, 
	{0x5638, 0xd3df}, 
	{0x5639, 0x8fb6b9}, 
	{0x563b, 0x8fb6ba}, 
	{0x563c, 0x8fb6bb}, 
	{0x563d, 0x8fb6bc}, 
	{0x563f, 0x8fb6bd}, 
	{0x5640, 0x8fb6be}, 
	{0x5641, 0x8fb6bf}, 
	{0x5642, 0xb1bd}, 
	{0x5643, 0x8fb6c0}, 
	{0x5644, 0x8fb6c1}, 
	{0x5646, 0x8fb6c2}, 
	{0x5649, 0x8fb6c3}, 
	{0x564b, 0x8fb6c4}, 
	{0x564c, 0xc1b9}, 
	{0x564d, 0x8fb6c5}, 
	{0x564e, 0xd3d9}, 
	{0x564f, 0x8fb6c6}, 
	{0x5650, 0xd3da}, 
	{0x5654, 0x8fb6c7}, 
	{0x565b, 0xb3fa}, 
	{0x565e, 0x8fb6c8}, 
	{0x5660, 0x8fb6c9}, 
	{0x5661, 0x8fb6ca}, 
	{0x5662, 0x8fb6cb}, 
	{0x5663, 0x8fb6cc}, 
	{0x5664, 0xd3e1}, 
	{0x5666, 0x8fb6cd}, 
	{0x5668, 0xb4ef}, 
	{0x5669, 0x8fb6ce}, 
	{0x566a, 0xd3e4}, 
	{0x566b, 0xd3e0}, 
	{0x566c, 0xd3e3}, 
	{0x566d, 0x8fb6cf}, 
	{0x566f, 0x8fb6d0}, 
	{0x5671, 0x8fb6d1}, 
	{0x5672, 0x8fb6d2}, 
	{0x5674, 0xcaae}, 
	{0x5675, 0x8fb6d3}, 
	{0x5678, 0xc6d5}, 
	{0x567a, 0xc8b8}, 
	{0x5680, 0xd3e6}, 
	{0x5684, 0x8fb6d4}, 
	{0x5685, 0x8fb6d5}, 
	{0x5686, 0xd3e5}, 
	{0x5687, 0xb3c5}, 
	{0x5688, 0x8fb6d6}, 
	{0x568a, 0xd3e7}, 
	{0x568b, 0x8fb6d7}, 
	{0x568c, 0x8fb6d8}, 
	{0x568f, 0xd3ea}, 
	{0x5694, 0xd3e9}, 
	{0x5695, 0x8fb6d9}, 
	{0x5699, 0x8fb6da}, 
	{0x569a, 0x8fb6db}, 
	{0x569d, 0x8fb6dc}, 
	{0x569e, 0x8fb6dd}, 
	{0x569f, 0x8fb6de}, 
	{0x56a0, 0xd3e8}, 
	{0x56a2, 0xc7b9}, 
	{0x56a5, 0xd3eb}, 
	{0x56a6, 0x8fb6df}, 
	{0x56a7, 0x8fb6e0}, 
	{0x56a8, 0x8fb6e1}, 
	{0x56a9, 0x8fb6e2}, 
	{0x56ab, 0x8fb6e3}, 
	{0x56ac, 0x8fb6e4}, 
	{0x56ad, 0x8fb6e5}, 
	{0x56ae, 0xd3ec}, 
	{0x56b1, 0x8fb6e6}, 
	{0x56b3, 0x8fb6e7}, 
	{0x56b4, 0xd3ee}, 
	{0x56b6, 0xd3ed}, 
	{0x56b7, 0x8fb6e8}, 
	{0x56bc, 0xd3f0}, 
	{0x56be, 0x8fb6e9}, 
	{0x56c0, 0xd3f3}, 
	{0x56c1, 0xd3f1}, 
	{0x56c2, 0xd3ef}, 
	{0x56c3, 0xd3f2}, 
	{0x56c5, 0x8fb6ea}, 
	{0x56c8, 0xd3f4}, 
	{0x56c9, 0x8fb6eb}, 
	{0x56ca, 0x8fb6ec}, 
	{0x56cb, 0x8fb6ed}, 
	{0x56cc, 0x8fb6f0}, 
	{0x56cd, 0x8fb6f1}, 
	{0x56ce, 0xd3f5}, 
	{0x56cf, 0x8fb6ee}, 
	{0x56d0, 0x8fb6ef}, 
	{0x56d1, 0xd3f6}, 
	{0x56d3, 0xd3f7}, 
	{0x56d7, 0xd3f8}, 
	{0x56d8, 0xd1c5}, 
	{0x56d9, 0x8fb6f2}, 
	{0x56da, 0xbcfc}, 
	{0x56db, 0xbbcd}, 
	{0x56dc, 0x8fb6f3}, 
	{0x56dd, 0x8fb6f4}, 
	{0x56de, 0xb2f3}, 
	{0x56df, 0x8fb6f5}, 
	{0x56e0, 0xb0f8}, 
	{0x56e1, 0x8fb6f6}, 
	{0x56e3, 0xc3c4}, 
	{0x56e4, 0x8fb6f7}, 
	{0x56e5, 0x8fb6f8}, 
	{0x56e6, 0x8fb6f9}, 
	{0x56e7, 0x8fb6fa}, 
	{0x56e8, 0x8fb6fb}, 
	{0x56eb, 0x8fb6fd}, 
	{0x56ed, 0x8fb6fe}, 
	{0x56ee, 0xd3f9}, 
	{0x56f0, 0xbaa4}, 
	{0x56f1, 0x8fb6fc}, 
	{0x56f2, 0xb0cf}, 
	{0x56f3, 0xbfde}, 
	{0x56f6, 0x8fb7a1}, 
	{0x56f7, 0x8fb7a2}, 
	{0x56f9, 0xd3fa}, 
	{0x56fa, 0xb8c7}, 
	{0x56fd, 0xb9f1}, 
	{0x56ff, 0xd3fc}, 
	{0x5700, 0xd3fb}, 
	{0x5701, 0x8fb7a3}, 
	{0x5702, 0x8fb7a4}, 
	{0x5703, 0xcae0}, 
	{0x5704, 0xd3fd}, 
	{0x5707, 0x8fb7a5}, 
	{0x5708, 0xd4a1}, 
	{0x5709, 0xd3fe}, 
	{0x570a, 0x8fb7a6}, 
	{0x570b, 0xd4a2}, 
	{0x570c, 0x8fb7a7}, 
	{0x570d, 0xd4a3}, 
	{0x570f, 0xb7f7}, 
	{0x5711, 0x8fb7a8}, 
	{0x5712, 0xb1e0}, 
	{0x5713, 0xd4a4}, 
	{0x5715, 0x8fb7a9}, 
	{0x5716, 0xd4a6}, 
	{0x5718, 0xd4a5}, 
	{0x571a, 0x8fb7aa}, 
	{0x571b, 0x8fb7ab}, 
	{0x571c, 0xd4a8}, 
	{0x571d, 0x8fb7ac}, 
	{0x571f, 0xc5da}, 
	{0x5720, 0x8fb7ad}, 
	{0x5722, 0x8fb7ae}, 
	{0x5723, 0x8fb7af}, 
	{0x5724, 0x8fb7b0}, 
	{0x5725, 0x8fb7b1}, 
	{0x5726, 0xd4a9}, 
	{0x5727, 0xb0b5}, 
	{0x5728, 0xbadf}, 
	{0x5729, 0x8fb7b2}, 
	{0x572a, 0x8fb7b3}, 
	{0x572c, 0x8fb7b4}, 
	{0x572d, 0xb7bd}, 
	{0x572e, 0x8fb7b5}, 
	{0x572f, 0x8fb7b6}, 
	{0x5730, 0xc3cf}, 
	{0x5733, 0x8fb7b7}, 
	{0x5734, 0x8fb7b8}, 
	{0x5737, 0xd4aa}, 
	{0x5738, 0xd4ab}, 
	{0x573b, 0xd4ad}, 
	{0x573d, 0x8fb7b9}, 
	{0x573e, 0x8fb7ba}, 
	{0x573f, 0x8fb7bb}, 
	{0x5740, 0xd4ae}, 
	{0x5742, 0xbae4}, 
	{0x5745, 0x8fb7bc}, 
	{0x5746, 0x8fb7bd}, 
	{0x5747, 0xb6d1}, 
	{0x574a, 0xcbb7}, 
	{0x574c, 0x8fb7be}, 
	{0x574d, 0x8fb7bf}, 
	{0x574e, 0xd4ac}, 
	{0x574f, 0xd4af}, 
	{0x5750, 0xbac1}, 
	{0x5751, 0xb9a3}, 
	{0x5752, 0x8fb7c0}, 
	{0x5761, 0xd4b3}, 
	{0x5762, 0x8fb7c1}, 
	{0x5764, 0xbaa5}, 
	{0x5765, 0x8fb7c2}, 
	{0x5766, 0xc3b3}, 
	{0x5767, 0x8fb7c3}, 
	{0x5768, 0x8fb7c4}, 
	{0x5769, 0xd4b0}, 
	{0x576a, 0xc4da}, 
	{0x576b, 0x8fb7c5}, 
	{0x576d, 0x8fb7c6}, 
	{0x576e, 0x8fb7c7}, 
	{0x576f, 0x8fb7c8}, 
	{0x5770, 0x8fb7c9}, 
	{0x5771, 0x8fb7ca}, 
	{0x5773, 0x8fb7cb}, 
	{0x5774, 0x8fb7cc}, 
	{0x5775, 0x8fb7cd}, 
	{0x5777, 0x8fb7ce}, 
	{0x5779, 0x8fb7cf}, 
	{0x577a, 0x8fb7d0}, 
	{0x577b, 0x8fb7d1}, 
	{0x577c, 0x8fb7d2}, 
	{0x577e, 0x8fb7d3}, 
	{0x577f, 0xd4b4}, 
	{0x5781, 0x8fb7d4}, 
	{0x5782, 0xbfe2}, 
	{0x5783, 0x8fb7d5}, 
	{0x5788, 0xd4b2}, 
	{0x5789, 0xd4b5}, 
	{0x578b, 0xb7bf}, 
	{0x578c, 0x8fb7d6}, 
	{0x5793, 0xd4b6}, 
	{0x5794, 0x8fb7d7}, 
	{0x5795, 0x8fb7e0}, 
	{0x5797, 0x8fb7d8}, 
	{0x5799, 0x8fb7d9}, 
	{0x579a, 0x8fb7da}, 
	{0x579c, 0x8fb7db}, 
	{0x579d, 0x8fb7dc}, 
	{0x579e, 0x8fb7dd}, 
	{0x579f, 0x8fb7de}, 
	{0x57a0, 0xd4b7}, 
	{0x57a1, 0x8fb7df}, 
	{0x57a2, 0xb9a4}, 
	{0x57a3, 0xb3c0}, 
	{0x57a4, 0xd4b9}, 
	{0x57a7, 0x8fb7e1}, 
	{0x57a8, 0x8fb7e2}, 
	{0x57a9, 0x8fb7e3}, 
	{0x57aa, 0xd4ba}, 
	{0x57ac, 0x8fb7e4}, 
	{0x57b0, 0xd4bb}, 
	{0x57b3, 0xd4b8}, 
	{0x57b8, 0x8fb7e5}, 
	{0x57bd, 0x8fb7e6}, 
	{0x57c0, 0xd4b1}, 
	{0x57c3, 0xd4bc}, 
	{0x57c6, 0xd4bd}, 
	{0x57c7, 0x8fb7e7}, 
	{0x57c8, 0x8fb7e8}, 
	{0x57cb, 0xcbe4}, 
	{0x57cc, 0x8fb7e9}, 
	{0x57ce, 0xbeeb}, 
	{0x57cf, 0x8fb7ea}, 
	{0x57d2, 0xd4bf}, 
	{0x57d3, 0xd4c0}, 
	{0x57d4, 0xd4be}, 
	{0x57d5, 0x8fb7eb}, 
	{0x57d6, 0xd4c2}, 
	{0x57dc, 0xc7b8}, 
	{0x57dd, 0x8fb7ec}, 
	{0x57de, 0x8fb7ed}, 
	{0x57df, 0xb0e8}, 
	{0x57e0, 0xc9d6}, 
	{0x57e1, 0x8fb7fe}, 
	{0x57e3, 0xd4c3}, 
	{0x57e4, 0x8fb7ee}, 
	{0x57e6, 0x8fb7ef}, 
	{0x57e7, 0x8fb7f0}, 
	{0x57e9, 0x8fb7f1}, 
	{0x57ed, 0x8fb7f2}, 
	{0x57f0, 0x8fb7f3}, 
	{0x57f4, 0xbefd}, 
	{0x57f5, 0x8fb7f4}, 
	{0x57f6, 0x8fb7f5}, 
	{0x57f7, 0xbcb9}, 
	{0x57f8, 0x8fb7f6}, 
	{0x57f9, 0xc7dd}, 
	{0x57fa, 0xb4f0}, 
	{0x57fc, 0xbaeb}, 
	{0x57fd, 0x8fb7f7}, 
	{0x57fe, 0x8fb7f8}, 
	{0x57ff, 0x8fb7f9}, 
	{0x5800, 0xcbd9}, 
	{0x5802, 0xc6b2}, 
	{0x5803, 0x8fb7fa}, 
	{0x5804, 0x8fb7fb}, 
	{0x5805, 0xb7f8}, 
	{0x5806, 0xc2cf}, 
	{0x5808, 0x8fb7fc}, 
	{0x5809, 0x8fb7fd}, 
	{0x580a, 0xd4c1}, 
	{0x580b, 0xd4c4}, 
	{0x580c, 0x8fb8a1}, 
	{0x580d, 0x8fb8a2}, 
	{0x5815, 0xc2c4}, 
	{0x5819, 0xd4c5}, 
	{0x581b, 0x8fb8a3}, 
	{0x581d, 0xd4c6}, 
	{0x581e, 0x8fb8a4}, 
	{0x581f, 0x8fb8a5}, 
	{0x5820, 0x8fb8a6}, 
	{0x5821, 0xd4c8}, 
	{0x5824, 0xc4e9}, 
	{0x5826, 0x8fb8a7}, 
	{0x5827, 0x8fb8a8}, 
	{0x582a, 0xb4ae}, 
	{0x582d, 0x8fb8a9}, 
	{0x582f, 0xf4a1}, 
	{0x5830, 0xb1e1}, 
	{0x5831, 0xcaf3}, 
	{0x5832, 0x8fb8aa}, 
	{0x5834, 0xbeec}, 
	{0x5835, 0xc5c8}, 
	{0x5839, 0x8fb8ab}, 
	{0x583a, 0xbae6}, 
	{0x583d, 0xd4ce}, 
	{0x583f, 0x8fb8ac}, 
	{0x5840, 0xcabd}, 
	{0x5841, 0xcedd}, 
	{0x5849, 0x8fb8ad}, 
	{0x584a, 0xb2f4}, 
	{0x584b, 0xd4ca}, 
	{0x584c, 0x8fb8ae}, 
	{0x584d, 0x8fb8af}, 
	{0x584f, 0x8fb8b0}, 
	{0x5850, 0x8fb8b1}, 
	{0x5851, 0xc1ba}, 
	{0x5852, 0xd4cd}, 
	{0x5854, 0xc5e3}, 
	{0x5855, 0x8fb8b2}, 
	{0x5857, 0xc5c9}, 
	{0x5858, 0xc5e4}, 
	{0x5859, 0xc8b9}, 
	{0x585a, 0xc4cd}, 
	{0x585e, 0xbac9}, 
	{0x585f, 0x8fb8b3}, 
	{0x5861, 0x8fb8b4}, 
	{0x5862, 0xd4c9}, 
	{0x5864, 0x8fb8b5}, 
	{0x5867, 0x8fb8b6}, 
	{0x5868, 0x8fb8b7}, 
	{0x5869, 0xb1f6}, 
	{0x586b, 0xc5b6}, 
	{0x5870, 0xd4cb}, 
	{0x5872, 0xd4c7}, 
	{0x5875, 0xbfd0}, 
	{0x5878, 0x8fb8b8}, 
	{0x5879, 0xd4cf}, 
	{0x587c, 0x8fb8b9}, 
	{0x587e, 0xbdce}, 
	{0x587f, 0x8fb8ba}, 
	{0x5880, 0x8fb8bb}, 
	{0x5881, 0x8fb8bc}, 
	{0x5883, 0xb6ad}, 
	{0x5885, 0xd4d0}, 
	{0x5887, 0x8fb8bd}, 
	{0x5888, 0x8fb8be}, 
	{0x5889, 0x8fb8bf}, 
	{0x588a, 0x8fb8c0}, 
	{0x588c, 0x8fb8c1}, 
	{0x588d, 0x8fb8c2}, 
	{0x588f, 0x8fb8c3}, 
	{0x5890, 0x8fb8c4}, 
	{0x5893, 0xcae8}, 
	{0x5894, 0x8fb8c5}, 
	{0x5896, 0x8fb8c6}, 
	{0x5897, 0xc1fd}, 
	{0x589c, 0xc4c6}, 
	{0x589d, 0x8fb8c7}, 
	{0x589f, 0xd4d2}, 
	{0x58a0, 0x8fb8c8}, 
	{0x58a1, 0x8fb8c9}, 
	{0x58a2, 0x8fb8ca}, 
	{0x58a6, 0x8fb8cb}, 
	{0x58a8, 0xcbcf}, 
	{0x58a9, 0x8fb8cc}, 
	{0x58ab, 0xd4d3}, 
	{0x58ae, 0xd4d8}, 
	{0x58b1, 0x8fb8cd}, 
	{0x58b2, 0x8fb8ce}, 
	{0x58b3, 0xcaaf}, 
	{0x58b8, 0xd4d7}, 
	{0x58b9, 0xd4d1}, 
	{0x58ba, 0xd4d4}, 
	{0x58bb, 0xd4d6}, 
	{0x58bc, 0x8fb8d0}, 
	{0x58be, 0xbaa6}, 
	{0x58c1, 0xcac9}, 
	{0x58c2, 0x8fb8d1}, 
	{0x58c4, 0x8fb8cf}, 
	{0x58c5, 0xd4d9}, 
	{0x58c7, 0xc3c5}, 
	{0x58c8, 0x8fb8d2}, 
	{0x58ca, 0xb2f5}, 
	{0x58cc, 0xbeed}, 
	{0x58cd, 0x8fb8d3}, 
	{0x58ce, 0x8fb8d4}, 
	{0x58d0, 0x8fb8d5}, 
	{0x58d1, 0xd4db}, 
	{0x58d2, 0x8fb8d6}, 
	{0x58d3, 0xd4da}, 
	{0x58d4, 0x8fb8d7}, 
	{0x58d5, 0xb9e8}, 
	{0x58d6, 0x8fb8d8}, 
	{0x58d7, 0xd4dc}, 
	{0x58d8, 0xd4de}, 
	{0x58d9, 0xd4dd}, 
	{0x58da, 0x8fb8d9}, 
	{0x58dc, 0xd4e0}, 
	{0x58dd, 0x8fb8da}, 
	{0x58de, 0xd4d5}, 
	{0x58df, 0xd4e2}, 
	{0x58e1, 0x8fb8db}, 
	{0x58e2, 0x8fb8dc}, 
	{0x58e4, 0xd4e1}, 
	{0x58e5, 0xd4df}, 
	{0x58e9, 0x8fb8dd}, 
	{0x58eb, 0xbbce}, 
	{0x58ec, 0xbfd1}, 
	{0x58ee, 0xc1d4}, 
	{0x58ef, 0xd4e3}, 
	{0x58f0, 0xc0bc}, 
	{0x58f1, 0xb0ed}, 
	{0x58f2, 0xc7e4}, 
	{0x58f3, 0x8fb8de}, 
	{0x58f7, 0xc4db}, 
	{0x58f9, 0xd4e5}, 
	{0x58fa, 0xd4e4}, 
	{0x58fb, 0xd4e6}, 
	{0x58fc, 0xd4e7}, 
	{0x58fd, 0xd4e8}, 
	{0x5902, 0xd4e9}, 
	{0x5905, 0x8fb8df}, 
	{0x5906, 0x8fb8e0}, 
	{0x5909, 0xcad1}, 
	{0x590a, 0xd4ea}, 
	{0x590b, 0x8fb8e1}, 
	{0x590c, 0x8fb8e2}, 
	{0x590f, 0xb2c6}, 
	{0x5910, 0xd4eb}, 
	{0x5912, 0x8fb8e3}, 
	{0x5913, 0x8fb8e4}, 
	{0x5914, 0x8fb8e5}, 
	{0x5915, 0xcdbc}, 
	{0x5916, 0xb3b0}, 
	{0x5918, 0xd2c9}, 
	{0x5919, 0xbdc8}, 
	{0x591a, 0xc2bf}, 
	{0x591b, 0xd4ec}, 
	{0x591c, 0xcceb}, 
	{0x591d, 0x8fb8e7}, 
	{0x5921, 0x8fb8e8}, 
	{0x5922, 0xccb4}, 
	{0x5923, 0x8fb8e9}, 
	{0x5924, 0x8fb8ea}, 
	{0x5925, 0xd4ee}, 
	{0x5927, 0xc2e7}, 
	{0x5928, 0x8fb8eb}, 
	{0x5929, 0xc5b7}, 
	{0x592a, 0xc2c0}, 
	{0x592b, 0xc9d7}, 
	{0x592c, 0xd4ef}, 
	{0x592d, 0xd4f0}, 
	{0x592e, 0xb1fb}, 
	{0x592f, 0x8fb8ec}, 
	{0x5930, 0x8fb8ed}, 
	{0x5931, 0xbcba}, 
	{0x5932, 0xd4f1}, 
	{0x5933, 0x8fb8ee}, 
	{0x5935, 0x8fb8ef}, 
	{0x5936, 0x8fb8f0}, 
	{0x5937, 0xb0d0}, 
	{0x5938, 0xd4f2}, 
	{0x593e, 0xd4f3}, 
	{0x593f, 0x8fb8f1}, 
	{0x5943, 0x8fb8f2}, 
	{0x5944, 0xb1e2}, 
	{0x5946, 0x8fb8f3}, 
	{0x5947, 0xb4f1}, 
	{0x5948, 0xc6e0}, 
	{0x5949, 0xcaf4}, 
	{0x594e, 0xd4f7}, 
	{0x594f, 0xc1d5}, 
	{0x5950, 0xd4f6}, 
	{0x5951, 0xb7c0}, 
	{0x5952, 0x8fb8f4}, 
	{0x5953, 0x8fb8f5}, 
	{0x5954, 0xcbdb}, 
	{0x5955, 0xd4f5}, 
	{0x5957, 0xc5e5}, 
	{0x5958, 0xd4f9}, 
	{0x5959, 0x8fb8f6}, 
	{0x595a, 0xd4f8}, 
	{0x595b, 0x8fb8f7}, 
	{0x595d, 0x8fb8f8}, 
	{0x595e, 0x8fb8f9}, 
	{0x595f, 0x8fb8fa}, 
	{0x5960, 0xd4fb}, 
	{0x5961, 0x8fb8fb}, 
	{0x5962, 0xd4fa}, 
	{0x5963, 0x8fb8fc}, 
	{0x5965, 0xb1fc}, 
	{0x5967, 0xd4fc}, 
	{0x5968, 0xbea9}, 
	{0x5969, 0xd4fe}, 
	{0x596a, 0xc3a5}, 
	{0x596b, 0x8fb8fd}, 
	{0x596c, 0xd4fd}, 
	{0x596d, 0x8fb8fe}, 
	{0x596e, 0xcab3}, 
	{0x596f, 0x8fb9a1}, 
	{0x5972, 0x8fb9a2}, 
	{0x5973, 0xbdf7}, 
	{0x5974, 0xc5db}, 
	{0x5975, 0x8fb9a3}, 
	{0x5976, 0x8fb9a4}, 
	{0x5978, 0xd5a1}, 
	{0x5979, 0x8fb9a5}, 
	{0x597b, 0x8fb9a6}, 
	{0x597c, 0x8fb9a7}, 
	{0x597d, 0xb9a5}, 
	{0x5981, 0xd5a2}, 
	{0x5982, 0xc7a1}, 
	{0x5983, 0xc8de}, 
	{0x5984, 0xccd1}, 
	{0x598a, 0xc7a5}, 
	{0x598b, 0x8fb9a8}, 
	{0x598c, 0x8fb9a9}, 
	{0x598d, 0xd5ab}, 
	{0x598e, 0x8fb9aa}, 
	{0x5992, 0x8fb9ab}, 
	{0x5993, 0xb5b8}, 
	{0x5995, 0x8fb9ac}, 
	{0x5996, 0xcdc5}, 
	{0x5997, 0x8fb9ad}, 
	{0x5999, 0xccaf}, 
	{0x599b, 0xd6ac}, 
	{0x599d, 0xd5a3}, 
	{0x599f, 0x8fb9ae}, 
	{0x59a3, 0xd5a6}, 
	{0x59a4, 0x8fb9af}, 
	{0x59a5, 0xc2c5}, 
	{0x59a7, 0x8fb9b0}, 
	{0x59a8, 0xcbb8}, 
	{0x59ac, 0xc5ca}, 
	{0x59ad, 0x8fb9b1}, 
	{0x59ae, 0x8fb9b2}, 
	{0x59af, 0x8fb9b3}, 
	{0x59b0, 0x8fb9b4}, 
	{0x59b2, 0xd5a7}, 
	{0x59b3, 0x8fb9b5}, 
	{0x59b7, 0x8fb9b6}, 
	{0x59b9, 0xcbe5}, 
	{0x59ba, 0x8fb9b7}, 
	{0x59bb, 0xbaca}, 
	{0x59bc, 0x8fb9b8}, 
	{0x59be, 0xbeaa}, 
	{0x59c1, 0x8fb9b9}, 
	{0x59c3, 0x8fb9ba}, 
	{0x59c4, 0x8fb9bb}, 
	{0x59c6, 0xd5a8}, 
	{0x59c8, 0x8fb9bc}, 
	{0x59c9, 0xbbd0}, 
	{0x59ca, 0x8fb9bd}, 
	{0x59cb, 0xbbcf}, 
	{0x59cd, 0x8fb9be}, 
	{0x59d0, 0xb0b9}, 
	{0x59d1, 0xb8c8}, 
	{0x59d2, 0x8fb9bf}, 
	{0x59d3, 0xc0ab}, 
	{0x59d4, 0xb0d1}, 
	{0x59d9, 0xd5ac}, 
	{0x59da, 0xd5ad}, 
	{0x59dc, 0xd5aa}, 
	{0x59dd, 0x8fb9c0}, 
	{0x59de, 0x8fb9c1}, 
	{0x59df, 0x8fb9c2}, 
	{0x59e3, 0x8fb9c3}, 
	{0x59e4, 0x8fb9c4}, 
	{0x59e5, 0xb1b8}, 
	{0x59e6, 0xb4af}, 
	{0x59e7, 0x8fb9c5}, 
	{0x59e8, 0xd5a9}, 
	{0x59ea, 0xccc5}, 
	{0x59eb, 0xc9b1}, 
	{0x59ee, 0x8fb9c6}, 
	{0x59ef, 0x8fb9c7}, 
	{0x59f1, 0x8fb9c8}, 
	{0x59f2, 0x8fb9c9}, 
	{0x59f4, 0x8fb9ca}, 
	{0x59f6, 0xb0a8}, 
	{0x59f7, 0x8fb9cb}, 
	{0x59fb, 0xb0f9}, 
	{0x59ff, 0xbbd1}, 
	{0x5a00, 0x8fb9cc}, 
	{0x5a01, 0xb0d2}, 
	{0x5a03, 0xb0a3}, 
	{0x5a04, 0x8fb9cd}, 
	{0x5a09, 0xd5b2}, 
	{0x5a0c, 0x8fb9ce}, 
	{0x5a0d, 0x8fb9cf}, 
	{0x5a0e, 0x8fb9d0}, 
	{0x5a11, 0xd5b0}, 
	{0x5a12, 0x8fb9d1}, 
	{0x5a13, 0x8fb9d2}, 
	{0x5a18, 0xccbc}, 
	{0x5a1a, 0xd5b3}, 
	{0x5a1c, 0xd5b1}, 
	{0x5a1e, 0x8fb9d3}, 
	{0x5a1f, 0xd5af}, 
	{0x5a20, 0xbfb1}, 
	{0x5a23, 0x8fb9d4}, 
	{0x5a24, 0x8fb9d5}, 
	{0x5a25, 0xd5ae}, 
	{0x5a27, 0x8fb9d6}, 
	{0x5a28, 0x8fb9d7}, 
	{0x5a29, 0xcada}, 
	{0x5a2a, 0x8fb9d8}, 
	{0x5a2d, 0x8fb9d9}, 
	{0x5a2f, 0xb8e4}, 
	{0x5a30, 0x8fb9da}, 
	{0x5a35, 0xd5b7}, 
	{0x5a36, 0xd5b8}, 
	{0x5a3c, 0xbeab}, 
	{0x5a40, 0xd5b4}, 
	{0x5a41, 0xcfac}, 
	{0x5a44, 0x8fb9db}, 
	{0x5a45, 0x8fb9dc}, 
	{0x5a46, 0xc7cc}, 
	{0x5a47, 0x8fb9dd}, 
	{0x5a48, 0x8fb9de}, 
	{0x5a49, 0xd5b6}, 
	{0x5a4c, 0x8fb9df}, 
	{0x5a50, 0x8fb9e0}, 
	{0x5a55, 0x8fb9e1}, 
	{0x5a5a, 0xbaa7}, 
	{0x5a5e, 0x8fb9e2}, 
	{0x5a62, 0xd5b9}, 
	{0x5a63, 0x8fb9e3}, 
	{0x5a65, 0x8fb9e4}, 
	{0x5a66, 0xc9d8}, 
	{0x5a67, 0x8fb9e5}, 
	{0x5a6a, 0xd5ba}, 
	{0x5a6c, 0xd5b5}, 
	{0x5a6d, 0x8fb9e6}, 
	{0x5a77, 0x8fb9e7}, 
	{0x5a7a, 0x8fb9e8}, 
	{0x5a7b, 0x8fb9e9}, 
	{0x5a7e, 0x8fb9ea}, 
	{0x5a7f, 0xccbb}, 
	{0x5a8b, 0x8fb9eb}, 
	{0x5a90, 0x8fb9ec}, 
	{0x5a92, 0xc7de}, 
	{0x5a93, 0x8fb9ed}, 
	{0x5a96, 0x8fb9ee}, 
	{0x5a99, 0x8fb9ef}, 
	{0x5a9a, 0xd5bb}, 
	{0x5a9b, 0xc9b2}, 
	{0x5a9c, 0x8fb9f0}, 
	{0x5a9e, 0x8fb9f1}, 
	{0x5a9f, 0x8fb9f2}, 
	{0x5aa0, 0x8fb9f3}, 
	{0x5aa2, 0x8fb9f4}, 
	{0x5aa7, 0x8fb9f5}, 
	{0x5aac, 0x8fb9f6}, 
	{0x5ab1, 0x8fb9f7}, 
	{0x5ab2, 0x8fb9f8}, 
	{0x5ab3, 0x8fb9f9}, 
	{0x5ab5, 0x8fb9fa}, 
	{0x5ab8, 0x8fb9fb}, 
	{0x5aba, 0x8fb9fc}, 
	{0x5abb, 0x8fb9fd}, 
	{0x5abc, 0xd5bc}, 
	{0x5abd, 0xd5c0}, 
	{0x5abe, 0xd5bd}, 
	{0x5abf, 0x8fb9fe}, 
	{0x5ac1, 0xb2c7}, 
	{0x5ac2, 0xd5bf}, 
	{0x5ac4, 0x8fbaa1}, 
	{0x5ac6, 0x8fbaa2}, 
	{0x5ac8, 0x8fbaa3}, 
	{0x5ac9, 0xbcbb}, 
	{0x5acb, 0xd5be}, 
	{0x5acc, 0xb7f9}, 
	{0x5acf, 0x8fbaa4}, 
	{0x5ad0, 0xd5cc}, 
	{0x5ad6, 0xd5c5}, 
	{0x5ad7, 0xd5c2}, 
	{0x5ada, 0x8fbaa5}, 
	{0x5adc, 0x8fbaa6}, 
	{0x5ae0, 0x8fbaa7}, 
	{0x5ae1, 0xc3e4}, 
	{0x5ae3, 0xd5c1}, 
	{0x5ae5, 0x8fbaa8}, 
	{0x5ae6, 0xd5c3}, 
	{0x5ae9, 0xd5c4}, 
	{0x5aea, 0x8fbaa9}, 
	{0x5aee, 0x8fbaaa}, 
	{0x5af5, 0x8fbaab}, 
	{0x5af6, 0x8fbaac}, 
	{0x5afa, 0xd5c6}, 
	{0x5afb, 0xd5c7}, 
	{0x5afd, 0x8fbaad}, 
	{0x5b00, 0x8fbaae}, 
	{0x5b01, 0x8fbaaf}, 
	{0x5b08, 0x8fbab0}, 
	{0x5b09, 0xb4f2}, 
	{0x5b0b, 0xd5c9}, 
	{0x5b0c, 0xd5c8}, 
	{0x5b16, 0xd5ca}, 
	{0x5b17, 0x8fbab1}, 
	{0x5b19, 0x8fbab3}, 
	{0x5b1b, 0x8fbab4}, 
	{0x5b1d, 0x8fbab5}, 
	{0x5b21, 0x8fbab6}, 
	{0x5b22, 0xbeee}, 
	{0x5b25, 0x8fbab7}, 
	{0x5b2a, 0xd5cd}, 
	{0x5b2c, 0xc4dc}, 
	{0x5b2d, 0x8fbab8}, 
	{0x5b30, 0xb1c5}, 
	{0x5b32, 0xd5cb}, 
	{0x5b34, 0x8fbab2}, 
	{0x5b36, 0xd5ce}, 
	{0x5b38, 0x8fbab9}, 
	{0x5b3e, 0xd5cf}, 
	{0x5b40, 0xd5d2}, 
	{0x5b41, 0x8fbaba}, 
	{0x5b43, 0xd5d0}, 
	{0x5b45, 0xd5d1}, 
	{0x5b4b, 0x8fbabb}, 
	{0x5b4c, 0x8fbabc}, 
	{0x5b50, 0xbbd2}, 
	{0x5b51, 0xd5d3}, 
	{0x5b52, 0x8fbabd}, 
	{0x5b54, 0xb9a6}, 
	{0x5b55, 0xd5d4}, 
	{0x5b56, 0x8fbabe}, 
	{0x5b57, 0xbbfa}, 
	{0x5b58, 0xc2b8}, 
	{0x5b5a, 0xd5d5}, 
	{0x5b5b, 0xd5d6}, 
	{0x5b5c, 0xbbda}, 
	{0x5b5d, 0xb9a7}, 
	{0x5b5e, 0x8fbabf}, 
	{0x5b5f, 0xccd2}, 
	{0x5b63, 0xb5a8}, 
	{0x5b64, 0xb8c9}, 
	{0x5b65, 0xd5d7}, 
	{0x5b66, 0xb3d8}, 
	{0x5b68, 0x8fbac0}, 
	{0x5b69, 0xd5d8}, 
	{0x5b6b, 0xc2b9}, 
	{0x5b6e, 0x8fbac1}, 
	{0x5b6f, 0x8fbac2}, 
	{0x5b70, 0xd5d9}, 
	{0x5b71, 0xd6a3}, 
	{0x5b73, 0xd5da}, 
	{0x5b75, 0xd5db}, 
	{0x5b78, 0xd5dc}, 
	{0x5b7a, 0xd5de}, 
	{0x5b7c, 0x8fbac3}, 
	{0x5b7d, 0x8fbac4}, 
	{0x5b7e, 0x8fbac5}, 
	{0x5b7f, 0x8fbac6}, 
	{0x5b80, 0xd5df}, 
	{0x5b81, 0x8fbac7}, 
	{0x5b83, 0xd5e0}, 
	{0x5b84, 0x8fbac8}, 
	{0x5b85, 0xc2f0}, 
	{0x5b86, 0x8fbac9}, 
	{0x5b87, 0xb1a7}, 
	{0x5b88, 0xbce9}, 
	{0x5b89, 0xb0c2}, 
	{0x5b8a, 0x8fbaca}, 
	{0x5b8b, 0xc1d7}, 
	{0x5b8c, 0xb4b0}, 
	{0x5b8d, 0xbcb5}, 
	{0x5b8e, 0x8fbacb}, 
	{0x5b8f, 0xb9a8}, 
	{0x5b90, 0x8fbacc}, 
	{0x5b91, 0x8fbacd}, 
	{0x5b93, 0x8fbace}, 
	{0x5b94, 0x8fbacf}, 
	{0x5b95, 0xc5e6}, 
	{0x5b96, 0x8fbad0}, 
	{0x5b97, 0xbda1}, 
	{0x5b98, 0xb4b1}, 
	{0x5b99, 0xc3e8}, 
	{0x5b9a, 0xc4ea}, 
	{0x5b9b, 0xb0b8}, 
	{0x5b9c, 0xb5b9}, 
	{0x5b9d, 0xcaf5}, 
	{0x5b9f, 0xbcc2}, 
	{0x5ba2, 0xb5d2}, 
	{0x5ba3, 0xc0eb}, 
	{0x5ba4, 0xbcbc}, 
	{0x5ba5, 0xcda8}, 
	{0x5ba6, 0xd5e1}, 
	{0x5ba8, 0x8fbad1}, 
	{0x5ba9, 0x8fbad2}, 
	{0x5bac, 0x8fbad3}, 
	{0x5bad, 0x8fbad4}, 
	{0x5bae, 0xb5dc}, 
	{0x5baf, 0x8fbad5}, 
	{0x5bb0, 0xbacb}, 
	{0x5bb1, 0x8fbad6}, 
	{0x5bb2, 0x8fbad7}, 
	{0x5bb3, 0xb3b2}, 
	{0x5bb4, 0xb1e3}, 
	{0x5bb5, 0xbeac}, 
	{0x5bb6, 0xb2c8}, 
	{0x5bb7, 0x8fbad8}, 
	{0x5bb8, 0xd5e2}, 
	{0x5bb9, 0xcdc6}, 
	{0x5bba, 0x8fbad9}, 
	{0x5bbc, 0x8fbada}, 
	{0x5bbf, 0xbdc9}, 
	{0x5bc0, 0x8fbadb}, 
	{0x5bc1, 0x8fbadc}, 
	{0x5bc2, 0xbce4}, 
	{0x5bc3, 0xd5e3}, 
	{0x5bc4, 0xb4f3}, 
	{0x5bc5, 0xc6d2}, 
	{0x5bc6, 0xcca9}, 
	{0x5bc7, 0xd5e4}, 
	{0x5bc9, 0xd5e5}, 
	{0x5bcc, 0xc9d9}, 
	{0x5bcd, 0x8fbadd}, 
	{0x5bcf, 0x8fbade}, 
	{0x5bd0, 0xd5e7}, 
	{0x5bd2, 0xb4a8}, 
	{0x5bd3, 0xb6f7}, 
	{0x5bd4, 0xd5e6}, 
	{0x5bd6, 0x8fbadf}, 
	{0x5bd7, 0x8fbae0}, 
	{0x5bd8, 0x8fbae1}, 
	{0x5bd9, 0x8fbae2}, 
	{0x5bda, 0x8fbae3}, 
	{0x5bdb, 0xb4b2}, 
	{0x5bdd, 0xbfb2}, 
	{0x5bde, 0xd5eb}, 
	{0x5bdf, 0xbba1}, 
	{0x5be0, 0x8fbae4}, 
	{0x5be1, 0xb2c9}, 
	{0x5be2, 0xd5ea}, 
	{0x5be4, 0xd5e8}, 
	{0x5be5, 0xd5ec}, 
	{0x5be6, 0xd5e9}, 
	{0x5be7, 0xc7ab}, 
	{0x5be8, 0xdccd}, 
	{0x5be9, 0xbfb3}, 
	{0x5beb, 0xd5ed}, 
	{0x5bee, 0xcec0}, 
	{0x5bef, 0x8fbae5}, 
	{0x5bf0, 0xd5ee}, 
	{0x5bf1, 0x8fbae6}, 
	{0x5bf3, 0xd5f0}, 
	{0x5bf4, 0x8fbae7}, 
	{0x5bf5, 0xc3fe}, 
	{0x5bf6, 0xd5ef}, 
	{0x5bf8, 0xc0a3}, 
	{0x5bfa, 0xbbfb}, 
	{0x5bfd, 0x8fbae8}, 
	{0x5bfe, 0xc2d0}, 
	{0x5bff, 0xbcf7}, 
	{0x5c01, 0xc9f5}, 
	{0x5c02, 0xc0ec}, 
	{0x5c04, 0xbccd}, 
	{0x5c05, 0xd5f1}, 
	{0x5c06, 0xbead}, 
	{0x5c07, 0xd5f2}, 
	{0x5c08, 0xd5f3}, 
	{0x5c09, 0xb0d3}, 
	{0x5c0a, 0xc2ba}, 
	{0x5c0b, 0xbfd2}, 
	{0x5c0c, 0x8fbae9}, 
	{0x5c0d, 0xd5f4}, 
	{0x5c0e, 0xc6b3}, 
	{0x5c0f, 0xbeae}, 
	{0x5c11, 0xbeaf}, 
	{0x5c13, 0xd5f5}, 
	{0x5c16, 0xc0ed}, 
	{0x5c17, 0x8fbaea}, 
	{0x5c1a, 0xbeb0}, 
	{0x5c1e, 0x8fbaeb}, 
	{0x5c1f, 0x8fbaec}, 
	{0x5c20, 0xd5f6}, 
	{0x5c22, 0xd5f7}, 
	{0x5c23, 0x8fbaed}, 
	{0x5c24, 0xcce0}, 
	{0x5c26, 0x8fbaee}, 
	{0x5c28, 0xd5f8}, 
	{0x5c29, 0x8fbaef}, 
	{0x5c2b, 0x8fbaf0}, 
	{0x5c2c, 0x8fbaf1}, 
	{0x5c2d, 0xb6c6}, 
	{0x5c2e, 0x8fbaf2}, 
	{0x5c30, 0x8fbaf3}, 
	{0x5c31, 0xbda2}, 
	{0x5c32, 0x8fbaf4}, 
	{0x5c35, 0x8fbaf5}, 
	{0x5c36, 0x8fbaf6}, 
	{0x5c38, 0xd5f9}, 
	{0x5c39, 0xd5fa}, 
	{0x5c3a, 0xbcdc}, 
	{0x5c3b, 0xbfac}, 
	{0x5c3c, 0xc6f4}, 
	{0x5c3d, 0xbfd4}, 
	{0x5c3e, 0xc8f8}, 
	{0x5c3f, 0xc7a2}, 
	{0x5c40, 0xb6c9}, 
	{0x5c41, 0xd5fb}, 
	{0x5c45, 0xb5ef}, 
	{0x5c46, 0xd5fc}, 
	{0x5c48, 0xb6fe}, 
	{0x5c4a, 0xc6cf}, 
	{0x5c4b, 0xb2b0}, 
	{0x5c4d, 0xbbd3}, 
	{0x5c4e, 0xd5fd}, 
	{0x5c4f, 0xd6a2}, 
	{0x5c50, 0xd6a1}, 
	{0x5c51, 0xb6fd}, 
	{0x5c53, 0xd5fe}, 
	{0x5c55, 0xc5b8}, 
	{0x5c59, 0x8fbaf7}, 
	{0x5c5a, 0x8fbaf8}, 
	{0x5c5c, 0x8fbaf9}, 
	{0x5c5e, 0xc2b0}, 
	{0x5c60, 0xc5cb}, 
	{0x5c61, 0xbcc8}, 
	{0x5c62, 0x8fbafa}, 
	{0x5c63, 0x8fbafb}, 
	{0x5c64, 0xc1d8}, 
	{0x5c65, 0xcdfa}, 
	{0x5c67, 0x8fbafc}, 
	{0x5c68, 0x8fbafd}, 
	{0x5c69, 0x8fbafe}, 
	{0x5c6c, 0xd6a4}, 
	{0x5c6d, 0x8fbba1}, 
	{0x5c6e, 0xd6a5}, 
	{0x5c6f, 0xc6d6}, 
	{0x5c70, 0x8fbba2}, 
	{0x5c71, 0xbbb3}, 
	{0x5c74, 0x8fbba3}, 
	{0x5c75, 0x8fbba4}, 
	{0x5c76, 0xd6a7}, 
	{0x5c79, 0xd6a8}, 
	{0x5c7a, 0x8fbba5}, 
	{0x5c7b, 0x8fbba6}, 
	{0x5c7c, 0x8fbba7}, 
	{0x5c7d, 0x8fbba8}, 
	{0x5c87, 0x8fbba9}, 
	{0x5c88, 0x8fbbaa}, 
	{0x5c8a, 0x8fbbab}, 
	{0x5c8c, 0xd6a9}, 
	{0x5c8f, 0x8fbbac}, 
	{0x5c90, 0xb4f4}, 
	{0x5c91, 0xd6aa}, 
	{0x5c92, 0x8fbbad}, 
	{0x5c94, 0xd6ab}, 
	{0x5c9d, 0x8fbbae}, 
	{0x5c9f, 0x8fbbaf}, 
	{0x5ca0, 0x8fbbb0}, 
	{0x5ca1, 0xb2ac}, 
	{0x5ca2, 0x8fbbb1}, 
	{0x5ca3, 0x8fbbb2}, 
	{0x5ca6, 0x8fbbb3}, 
	{0x5ca8, 0xc1bb}, 
	{0x5ca9, 0xb4e4}, 
	{0x5caa, 0x8fbbb4}, 
	{0x5cab, 0xd6ad}, 
	{0x5cac, 0xcca8}, 
	{0x5cb1, 0xc2d2}, 
	{0x5cb2, 0x8fbbb5}, 
	{0x5cb3, 0xb3d9}, 
	{0x5cb4, 0x8fbbb6}, 
	{0x5cb5, 0x8fbbb7}, 
	{0x5cb6, 0xd6af}, 
	{0x5cb7, 0xd6b1}, 
	{0x5cb8, 0xb4df}, 
	{0x5cba, 0x8fbbb8}, 
	{0x5cbb, 0xd6ae}, 
	{0x5cbc, 0xd6b0}, 
	{0x5cbe, 0xd6b3}, 
	{0x5cc5, 0xd6b2}, 
	{0x5cc7, 0xd6b4}, 
	{0x5cc9, 0x8fbbb9}, 
	{0x5ccb, 0x8fbbba}, 
	{0x5cd2, 0x8fbbbb}, 
	{0x5cd7, 0x8fbbbd}, 
	{0x5cd9, 0xd6b5}, 
	{0x5cdd, 0x8fbbbc}, 
	{0x5ce0, 0xc6bd}, 
	{0x5ce1, 0xb6ae}, 
	{0x5ce8, 0xb2e5}, 
	{0x5ce9, 0xd6b6}, 
	{0x5cea, 0xd6bb}, 
	{0x5ced, 0xd6b9}, 
	{0x5cee, 0x8fbbbe}, 
	{0x5cef, 0xcaf7}, 
	{0x5cf0, 0xcaf6}, 
	{0x5cf1, 0x8fbbbf}, 
	{0x5cf2, 0x8fbbc0}, 
	{0x5cf4, 0x8fbbc1}, 
	{0x5cf6, 0xc5e7}, 
	{0x5cfa, 0xd6b8}, 
	{0x5cfb, 0xbdd4}, 
	{0x5cfd, 0xd6b7}, 
	{0x5d01, 0x8fbbc2}, 
	{0x5d06, 0x8fbbc3}, 
	{0x5d07, 0xbff2}, 
	{0x5d0b, 0xd6bc}, 
	{0x5d0d, 0x8fbbc4}, 
	{0x5d0e, 0xbaea}, 
	{0x5d11, 0xd6c2}, 
	{0x5d12, 0x8fbbc5}, 
	{0x5d14, 0xd6c3}, 
	{0x5d15, 0xd6bd}, 
	{0x5d16, 0xb3b3}, 
	{0x5d17, 0xd6be}, 
	{0x5d18, 0xd6c7}, 
	{0x5d19, 0xd6c6}, 
	{0x5d1a, 0xd6c5}, 
	{0x5d1b, 0xd6c1}, 
	{0x5d1f, 0xd6c0}, 
	{0x5d22, 0xd6c4}, 
	{0x5d23, 0x8fbbc7}, 
	{0x5d24, 0x8fbbc8}, 
	{0x5d26, 0x8fbbc9}, 
	{0x5d27, 0x8fbbca}, 
	{0x5d29, 0xcaf8}, 
	{0x5d2b, 0x8fbbc6}, 
	{0x5d31, 0x8fbbcb}, 
	{0x5d34, 0x8fbbcc}, 
	{0x5d39, 0x8fbbcd}, 
	{0x5d3d, 0x8fbbce}, 
	{0x5d3f, 0x8fbbcf}, 
	{0x5d42, 0x8fbbd0}, 
	{0x5d43, 0x8fbbd1}, 
	{0x5d46, 0x8fbbd2}, 
	{0x5d48, 0x8fbbd3}, 
	{0x5d4a, 0x8fbbd7}, 
	{0x5d4b, 0xd6cb}, 
	{0x5d4c, 0xd6c8}, 
	{0x5d4e, 0xd6ca}, 
	{0x5d50, 0xcdf2}, 
	{0x5d51, 0x8fbbd5}, 
	{0x5d52, 0xd6c9}, 
	{0x5d55, 0x8fbbd4}, 
	{0x5d59, 0x8fbbd6}, 
	{0x5d5c, 0xd6bf}, 
	{0x5d5f, 0x8fbbd8}, 
	{0x5d60, 0x8fbbd9}, 
	{0x5d61, 0x8fbbda}, 
	{0x5d62, 0x8fbbdb}, 
	{0x5d64, 0x8fbbdc}, 
	{0x5d69, 0xbff3}, 
	{0x5d6a, 0x8fbbdd}, 
	{0x5d6c, 0xd6cc}, 
	{0x5d6d, 0x8fbbde}, 
	{0x5d6f, 0xbab7}, 
	{0x5d70, 0x8fbbdf}, 
	{0x5d73, 0xd6cd}, 
	{0x5d76, 0xd6ce}, 
	{0x5d79, 0x8fbbe0}, 
	{0x5d7a, 0x8fbbe1}, 
	{0x5d7e, 0x8fbbe2}, 
	{0x5d7f, 0x8fbbe3}, 
	{0x5d81, 0x8fbbe4}, 
	{0x5d82, 0xd6d1}, 
	{0x5d83, 0x8fbbe5}, 
	{0x5d84, 0xd6d0}, 
	{0x5d87, 0xd6cf}, 
	{0x5d88, 0x8fbbe6}, 
	{0x5d8a, 0x8fbbe7}, 
	{0x5d8b, 0xc5e8}, 
	{0x5d8c, 0xd6ba}, 
	{0x5d90, 0xd6d7}, 
	{0x5d92, 0x8fbbe8}, 
	{0x5d93, 0x8fbbe9}, 
	{0x5d94, 0x8fbbea}, 
	{0x5d95, 0x8fbbeb}, 
	{0x5d99, 0x8fbbec}, 
	{0x5d9b, 0x8fbbed}, 
	{0x5d9d, 0xd6d3}, 
	{0x5d9f, 0x8fbbee}, 
	{0x5da0, 0x8fbbef}, 
	{0x5da2, 0xd6d2}, 
	{0x5da7, 0x8fbbf0}, 
	{0x5dab, 0x8fbbf1}, 
	{0x5dac, 0xd6d4}, 
	{0x5dae, 0xd6d5}, 
	{0x5db0, 0x8fbbf2}, 
	{0x5db2, 0x8fe6f4}, 
	{0x5db4, 0x8fbbf3}, 
	{0x5db7, 0xd6d8}, 
	{0x5db8, 0x8fbbf4}, 
	{0x5db9, 0x8fbbf5}, 
	{0x5dba, 0xcee6}, 
	{0x5dbc, 0xd6d9}, 
	{0x5dbd, 0xd6d6}, 
	{0x5dc3, 0x8fbbf6}, 
	{0x5dc7, 0x8fbbf7}, 
	{0x5dc9, 0xd6da}, 
	{0x5dcb, 0x8fbbf8}, 
	{0x5dcc, 0xb4e0}, 
	{0x5dcd, 0xd6db}, 
	{0x5dce, 0x8fbbfa}, 
	{0x5dd0, 0x8fbbf9}, 
	{0x5dd2, 0xd6dd}, 
	{0x5dd3, 0xd6dc}, 
	{0x5dd6, 0xd6de}, 
	{0x5dd8, 0x8fbbfb}, 
	{0x5dd9, 0x8fbbfc}, 
	{0x5ddb, 0xd6df}, 
	{0x5ddd, 0xc0ee}, 
	{0x5dde, 0xbda3}, 
	{0x5de0, 0x8fbbfd}, 
	{0x5de1, 0xbde4}, 
	{0x5de3, 0xc1e3}, 
	{0x5de4, 0x8fbbfe}, 
	{0x5de5, 0xb9a9}, 
	{0x5de6, 0xbab8}, 
	{0x5de7, 0xb9aa}, 
	{0x5de8, 0xb5f0}, 
	{0x5de9, 0x8fbca1}, 
	{0x5deb, 0xd6e0}, 
	{0x5dee, 0xbab9}, 
	{0x5df1, 0xb8ca}, 
	{0x5df2, 0xd6e1}, 
	{0x5df3, 0xcca6}, 
	{0x5df4, 0xc7c3}, 
	{0x5df5, 0xd6e2}, 
	{0x5df7, 0xb9ab}, 
	{0x5df8, 0x8fbca2}, 
	{0x5df9, 0x8fbca3}, 
	{0x5dfb, 0xb4ac}, 
	{0x5dfd, 0xc3a7}, 
	{0x5dfe, 0xb6d2}, 
	{0x5e00, 0x8fbca4}, 
	{0x5e02, 0xbbd4}, 
	{0x5e03, 0xc9db}, 
	{0x5e06, 0xc8c1}, 
	{0x5e07, 0x8fbca5}, 
	{0x5e0b, 0xd6e3}, 
	{0x5e0c, 0xb4f5}, 
	{0x5e0d, 0x8fbca6}, 
	{0x5e11, 0xd6e6}, 
	{0x5e12, 0x8fbca7}, 
	{0x5e14, 0x8fbca8}, 
	{0x5e15, 0x8fbca9}, 
	{0x5e16, 0xc4a1}, 
	{0x5e18, 0x8fbcaa}, 
	{0x5e19, 0xd6e5}, 
	{0x5e1a, 0xd6e4}, 
	{0x5e1b, 0xd6e7}, 
	{0x5e1d, 0xc4eb}, 
	{0x5e1f, 0x8fbcab}, 
	{0x5e20, 0x8fbcac}, 
	{0x5e25, 0xbfe3}, 
	{0x5e28, 0x8fbcae}, 
	{0x5e2b, 0xbbd5}, 
	{0x5e2d, 0xc0ca}, 
	{0x5e2e, 0x8fbcad}, 
	{0x5e2f, 0xc2d3}, 
	{0x5e30, 0xb5a2}, 
	{0x5e32, 0x8fbcaf}, 
	{0x5e33, 0xc4a2}, 
	{0x5e35, 0x8fbcb0}, 
	{0x5e36, 0xd6e8}, 
	{0x5e37, 0xd6e9}, 
	{0x5e38, 0xbeef}, 
	{0x5e3d, 0xcbb9}, 
	{0x5e3e, 0x8fbcb1}, 
	{0x5e40, 0xd6ec}, 
	{0x5e43, 0xd6eb}, 
	{0x5e44, 0xd6ea}, 
	{0x5e45, 0xc9fd}, 
	{0x5e47, 0xd6f3}, 
	{0x5e49, 0x8fbcb4}, 
	{0x5e4b, 0x8fbcb2}, 
	{0x5e4c, 0xcbda}, 
	{0x5e4e, 0xd6ed}, 
	{0x5e50, 0x8fbcb3}, 
	{0x5e51, 0x8fbcb5}, 
	{0x5e54, 0xd6ef}, 
	{0x5e55, 0xcbeb}, 
	{0x5e56, 0x8fbcb6}, 
	{0x5e57, 0xd6ee}, 
	{0x5e58, 0x8fbcb7}, 
	{0x5e5b, 0x8fbcb8}, 
	{0x5e5c, 0x8fbcb9}, 
	{0x5e5e, 0x8fbcba}, 
	{0x5e5f, 0xd6f0}, 
	{0x5e61, 0xc8a8}, 
	{0x5e62, 0xd6f1}, 
	{0x5e63, 0xcabe}, 
	{0x5e64, 0xd6f2}, 
	{0x5e68, 0x8fbcbb}, 
	{0x5e6a, 0x8fbcbc}, 
	{0x5e6b, 0x8fbcbd}, 
	{0x5e6c, 0x8fbcbe}, 
	{0x5e6d, 0x8fbcbf}, 
	{0x5e6e, 0x8fbcc0}, 
	{0x5e70, 0x8fbcc1}, 
	{0x5e72, 0xb4b3}, 
	{0x5e73, 0xcabf}, 
	{0x5e74, 0xc7af}, 
	{0x5e75, 0xd6f4}, 
	{0x5e76, 0xd6f5}, 
	{0x5e78, 0xb9ac}, 
	{0x5e79, 0xb4b4}, 
	{0x5e7a, 0xd6f6}, 
	{0x5e7b, 0xb8b8}, 
	{0x5e7c, 0xcdc4}, 
	{0x5e7d, 0xcda9}, 
	{0x5e7e, 0xb4f6}, 
	{0x5e7f, 0xd6f8}, 
	{0x5e80, 0x8fbcc2}, 
	{0x5e81, 0xc4a3}, 
	{0x5e83, 0xb9ad}, 
	{0x5e84, 0xbeb1}, 
	{0x5e87, 0xc8df}, 
	{0x5e8a, 0xbeb2}, 
	{0x5e8b, 0x8fbcc3}, 
	{0x5e8e, 0x8fbcc4}, 
	{0x5e8f, 0xbdf8}, 
	{0x5e95, 0xc4ec}, 
	{0x5e96, 0xcaf9}, 
	{0x5e97, 0xc5b9}, 
	{0x5e9a, 0xb9ae}, 
	{0x5e9c, 0xc9dc}, 
	{0x5ea0, 0xd6f9}, 
	{0x5ea2, 0x8fbcc5}, 
	{0x5ea4, 0x8fbcc6}, 
	{0x5ea5, 0x8fbcc7}, 
	{0x5ea6, 0xc5d9}, 
	{0x5ea7, 0xbac2}, 
	{0x5ea8, 0x8fbcc8}, 
	{0x5eaa, 0x8fbcc9}, 
	{0x5eab, 0xb8cb}, 
	{0x5eac, 0x8fbcca}, 
	{0x5ead, 0xc4ed}, 
	{0x5eb1, 0x8fbccb}, 
	{0x5eb3, 0x8fbccc}, 
	{0x5eb5, 0xb0c3}, 
	{0x5eb6, 0xbdee}, 
	{0x5eb7, 0xb9af}, 
	{0x5eb8, 0xcdc7}, 
	{0x5ebd, 0x8fbccd}, 
	{0x5ebe, 0x8fbcce}, 
	{0x5ebf, 0x8fbccf}, 
	{0x5ec1, 0xd6fa}, 
	{0x5ec2, 0xd6fb}, 
	{0x5ec3, 0xc7d1}, 
	{0x5ec6, 0x8fbcd0}, 
	{0x5ec8, 0xd6fc}, 
	{0x5ec9, 0xcef7}, 
	{0x5eca, 0xcfad}, 
	{0x5ecb, 0x8fbcd2}, 
	{0x5ecc, 0x8fbcd1}, 
	{0x5ece, 0x8fbcd3}, 
	{0x5ecf, 0xd6fe}, 
	{0x5ed0, 0xd6fd}, 
	{0x5ed1, 0x8fbcd4}, 
	{0x5ed2, 0x8fbcd5}, 
	{0x5ed3, 0xb3c7}, 
	{0x5ed4, 0x8fbcd6}, 
	{0x5ed5, 0x8fbcd7}, 
	{0x5ed6, 0xd7a1}, 
	{0x5eda, 0xd7a4}, 
	{0x5edb, 0xd7a5}, 
	{0x5edc, 0x8fbcd8}, 
	{0x5edd, 0xd7a3}, 
	{0x5ede, 0x8fbcd9}, 
	{0x5edf, 0xc9c0}, 
	{0x5ee0, 0xbeb3}, 
	{0x5ee1, 0xd7a7}, 
	{0x5ee2, 0xd7a6}, 
	{0x5ee3, 0xd7a2}, 
	{0x5ee5, 0x8fbcda}, 
	{0x5ee8, 0xd7a8}, 
	{0x5ee9, 0xd7a9}, 
	{0x5eeb, 0x8fbcdb}, 
	{0x5eec, 0xd7aa}, 
	{0x5ef0, 0xd7ad}, 
	{0x5ef1, 0xd7ab}, 
	{0x5ef3, 0xd7ac}, 
	{0x5ef4, 0xd7ae}, 
	{0x5ef6, 0xb1e4}, 
	{0x5ef7, 0xc4ee}, 
	{0x5ef8, 0xd7af}, 
	{0x5efa, 0xb7fa}, 
	{0x5efb, 0xb2f6}, 
	{0x5efc, 0xc7b6}, 
	{0x5efe, 0xd7b0}, 
	{0x5eff, 0xc6fb}, 
	{0x5f01, 0xcadb}, 
	{0x5f02, 0x8fbcdc}, 
	{0x5f03, 0xd7b1}, 
	{0x5f04, 0xcfae}, 
	{0x5f06, 0x8fbcdd}, 
	{0x5f07, 0x8fbcde}, 
	{0x5f08, 0x8fbcdf}, 
	{0x5f09, 0xd7b2}, 
	{0x5f0a, 0xcac0}, 
	{0x5f0b, 0xd7b5}, 
	{0x5f0c, 0xd0a1}, 
	{0x5f0d, 0xd0b1}, 
	{0x5f0e, 0x8fbce0}, 
	{0x5f0f, 0xbcb0}, 
	{0x5f10, 0xc6f5}, 
	{0x5f11, 0xd7b6}, 
	{0x5f13, 0xb5dd}, 
	{0x5f14, 0xc4a4}, 
	{0x5f15, 0xb0fa}, 
	{0x5f16, 0xd7b7}, 
	{0x5f17, 0xcaa6}, 
	{0x5f18, 0xb9b0}, 
	{0x5f19, 0x8fbce1}, 
	{0x5f1b, 0xc3d0}, 
	{0x5f1c, 0x8fbce2}, 
	{0x5f1d, 0x8fbce3}, 
	{0x5f1f, 0xc4ef}, 
	{0x5f21, 0x8fbce4}, 
	{0x5f22, 0x8fbce5}, 
	{0x5f23, 0x8fbce6}, 
	{0x5f24, 0x8fbce7}, 
	{0x5f25, 0xccef}, 
	{0x5f26, 0xb8b9}, 
	{0x5f27, 0xb8cc}, 
	{0x5f28, 0x8fbce8}, 
	{0x5f29, 0xd7b8}, 
	{0x5f2b, 0x8fbce9}, 
	{0x5f2c, 0x8fbcea}, 
	{0x5f2d, 0xd7b9}, 
	{0x5f2e, 0x8fbceb}, 
	{0x5f2f, 0xd7bf}, 
	{0x5f30, 0x8fbcec}, 
	{0x5f31, 0xbce5}, 
	{0x5f34, 0x8fbced}, 
	{0x5f35, 0xc4a5}, 
	{0x5f36, 0x8fbcee}, 
	{0x5f37, 0xb6af}, 
	{0x5f38, 0xd7ba}, 
	{0x5f3b, 0x8fbcef}, 
	{0x5f3c, 0xc9ab}, 
	{0x5f3d, 0x8fbcf0}, 
	{0x5f3e, 0xc3c6}, 
	{0x5f3f, 0x8fbcf1}, 
	{0x5f40, 0x8fbcf2}, 
	{0x5f41, 0xd7bb}, 
	{0x5f44, 0x8fbcf3}, 
	{0x5f45, 0x8fbcf4}, 
	{0x5f47, 0x8fbcf5}, 
	{0x5f48, 0xd7bc}, 
	{0x5f4a, 0xb6b0}, 
	{0x5f4c, 0xd7bd}, 
	{0x5f4d, 0x8fbcf6}, 
	{0x5f4e, 0xd7be}, 
	{0x5f50, 0x8fbcf7}, 
	{0x5f51, 0xd7c0}, 
	{0x5f53, 0xc5f6}, 
	{0x5f54, 0x8fbcf8}, 
	{0x5f56, 0xd7c1}, 
	{0x5f57, 0xd7c2}, 
	{0x5f58, 0x8fbcf9}, 
	{0x5f59, 0xd7c3}, 
	{0x5f5b, 0x8fbcfa}, 
	{0x5f5c, 0xd7b4}, 
	{0x5f5d, 0xd7b3}, 
	{0x5f60, 0x8fbcfb}, 
	{0x5f61, 0xd7c4}, 
	{0x5f62, 0xb7c1}, 
	{0x5f63, 0x8fbcfc}, 
	{0x5f64, 0x8fbcfd}, 
	{0x5f66, 0xc9a7}, 
	{0x5f67, 0x8fbcfe}, 
	{0x5f69, 0xbacc}, 
	{0x5f6a, 0xc9b7}, 
	{0x5f6b, 0xc4a6}, 
	{0x5f6c, 0xc9cb}, 
	{0x5f6d, 0xd7c5}, 
	{0x5f6f, 0x8fbda1}, 
	{0x5f70, 0xbeb4}, 
	{0x5f71, 0xb1c6}, 
	{0x5f72, 0x8fbda2}, 
	{0x5f73, 0xd7c6}, 
	{0x5f74, 0x8fbda3}, 
	{0x5f75, 0x8fbda4}, 
	{0x5f77, 0xd7c7}, 
	{0x5f78, 0x8fbda5}, 
	{0x5f79, 0xccf2}, 
	{0x5f7a, 0x8fbda6}, 
	{0x5f7c, 0xc8e0}, 
	{0x5f7d, 0x8fbda7}, 
	{0x5f7e, 0x8fbda8}, 
	{0x5f7f, 0xd7ca}, 
	{0x5f80, 0xb1fd}, 
	{0x5f81, 0xc0ac}, 
	{0x5f82, 0xd7c9}, 
	{0x5f83, 0xd7c8}, 
	{0x5f84, 0xb7c2}, 
	{0x5f85, 0xc2d4}, 
	{0x5f87, 0xd7ce}, 
	{0x5f88, 0xd7cc}, 
	{0x5f89, 0x8fbda9}, 
	{0x5f8a, 0xd7cb}, 
	{0x5f8b, 0xcea7}, 
	{0x5f8c, 0xb8e5}, 
	{0x5f8d, 0x8fbdaa}, 
	{0x5f8f, 0x8fbdab}, 
	{0x5f90, 0xbdf9}, 
	{0x5f91, 0xd7cd}, 
	{0x5f92, 0xc5cc}, 
	{0x5f93, 0xbdbe}, 
	{0x5f96, 0x8fbdac}, 
	{0x5f97, 0xc6c0}, 
	{0x5f98, 0xd7d1}, 
	{0x5f99, 0xd7d0}, 
	{0x5f9c, 0x8fbdad}, 
	{0x5f9d, 0x8fbdae}, 
	{0x5f9e, 0xd7cf}, 
	{0x5fa0, 0xd7d2}, 
	{0x5fa1, 0xb8e6}, 
	{0x5fa2, 0x8fbdaf}, 
	{0x5fa4, 0x8fbdb2}, 
	{0x5fa7, 0x8fbdb0}, 
	{0x5fa8, 0xd7d3}, 
	{0x5fa9, 0xc9fc}, 
	{0x5faa, 0xbddb}, 
	{0x5fab, 0x8fbdb1}, 
	{0x5fac, 0x8fbdb3}, 
	{0x5fad, 0xd7d4}, 
	{0x5fae, 0xc8f9}, 
	{0x5faf, 0x8fbdb4}, 
	{0x5fb0, 0x8fbdb5}, 
	{0x5fb1, 0x8fbdb6}, 
	{0x5fb3, 0xc6c1}, 
	{0x5fb4, 0xc4a7}, 
	{0x5fb8, 0x8fbdb7}, 
	{0x5fb9, 0xc5b0}, 
	{0x5fbc, 0xd7d5}, 
	{0x5fbd, 0xb5ab}, 
	{0x5fc3, 0xbfb4}, 
	{0x5fc4, 0x8fbdb8}, 
	{0x5fc5, 0xc9ac}, 
	{0x5fc7, 0x8fbdb9}, 
	{0x5fc8, 0x8fbdba}, 
	{0x5fc9, 0x8fbdbb}, 
	{0x5fcb, 0x8fbdbc}, 
	{0x5fcc, 0xb4f7}, 
	{0x5fcd, 0xc7a6}, 
	{0x5fd0, 0x8fbdbd}, 
	{0x5fd1, 0x8fbdbe}, 
	{0x5fd2, 0x8fbdbf}, 
	{0x5fd3, 0x8fbdc0}, 
	{0x5fd4, 0x8fbdc1}, 
	{0x5fd6, 0xd7d6}, 
	{0x5fd7, 0xbbd6}, 
	{0x5fd8, 0xcbba}, 
	{0x5fd9, 0xcbbb}, 
	{0x5fdc, 0xb1fe}, 
	{0x5fdd, 0xd7db}, 
	{0x5fde, 0x8fbdc2}, 
	{0x5fe0, 0xc3e9}, 
	{0x5fe1, 0x8fbdc3}, 
	{0x5fe2, 0x8fbdc4}, 
	{0x5fe4, 0xd7d8}, 
	{0x5fe8, 0x8fbdc5}, 
	{0x5fe9, 0x8fbdc6}, 
	{0x5fea, 0x8fbdc7}, 
	{0x5feb, 0xb2f7}, 
	{0x5fec, 0x8fbdc8}, 
	{0x5fed, 0x8fbdc9}, 
	{0x5fee, 0x8fbdca}, 
	{0x5fef, 0x8fbdcb}, 
	{0x5ff0, 0xd8ad}, 
	{0x5ff1, 0xd7da}, 
	{0x5ff2, 0x8fbdcc}, 
	{0x5ff3, 0x8fbdcd}, 
	{0x5ff5, 0xc7b0}, 
	{0x5ff6, 0x8fbdce}, 
	{0x5ff8, 0xd7d9}, 
	{0x5ffa, 0x8fbdcf}, 
	{0x5ffb, 0xd7d7}, 
	{0x5ffc, 0x8fbdd0}, 
	{0x5ffd, 0xb9fa}, 
	{0x5fff, 0xd7dd}, 
	{0x6007, 0x8fbdd1}, 
	{0x600a, 0x8fbdd2}, 
	{0x600d, 0x8fbdd3}, 
	{0x600e, 0xd7e3}, 
	{0x600f, 0xd7e9}, 
	{0x6010, 0xd7e1}, 
	{0x6012, 0xc5dc}, 
	{0x6013, 0x8fbdd4}, 
	{0x6014, 0x8fbdd5}, 
	{0x6015, 0xd7e6}, 
	{0x6016, 0xc9dd}, 
	{0x6017, 0x8fbdd6}, 
	{0x6018, 0x8fbdd7}, 
	{0x6019, 0xd7e0}, 
	{0x601a, 0x8fbdd8}, 
	{0x601b, 0xd7e5}, 
	{0x601c, 0xcee7}, 
	{0x601d, 0xbbd7}, 
	{0x601f, 0x8fbdd9}, 
	{0x6020, 0xc2d5}, 
	{0x6021, 0xd7de}, 
	{0x6024, 0x8fbdda}, 
	{0x6025, 0xb5de}, 
	{0x6026, 0xd7e8}, 
	{0x6027, 0xc0ad}, 
	{0x6028, 0xb1e5}, 
	{0x6029, 0xd7e2}, 
	{0x602a, 0xb2f8}, 
	{0x602b, 0xd7e7}, 
	{0x602d, 0x8fbddb}, 
	{0x602f, 0xb6b1}, 
	{0x6031, 0xd7e4}, 
	{0x6033, 0x8fbddc}, 
	{0x6035, 0x8fbddd}, 
	{0x603a, 0xd7ea}, 
	{0x6040, 0x8fbdde}, 
	{0x6041, 0xd7ec}, 
	{0x6042, 0xd7f6}, 
	{0x6043, 0xd7f4}, 
	{0x6046, 0xd7f1}, 
	{0x6047, 0x8fbddf}, 
	{0x6048, 0x8fbde0}, 
	{0x6049, 0x8fbde1}, 
	{0x604a, 0xd7f0}, 
	{0x604b, 0xcef8}, 
	{0x604c, 0x8fbde2}, 
	{0x604d, 0xd7f2}, 
	{0x6050, 0xb6b2}, 
	{0x6051, 0x8fbde3}, 
	{0x6052, 0xb9b1}, 
	{0x6054, 0x8fbde4}, 
	{0x6055, 0xbdfa}, 
	{0x6056, 0x8fbde5}, 
	{0x6057, 0x8fbde6}, 
	{0x6059, 0xd7f9}, 
	{0x605a, 0xd7eb}, 
	{0x605d, 0x8fbde7}, 
	{0x605f, 0xd7ef}, 
	{0x6060, 0xd7df}, 
	{0x6061, 0x8fbde8}, 
	{0x6062, 0xb2fa}, 
	{0x6063, 0xd7f3}, 
	{0x6064, 0xd7f5}, 
	{0x6065, 0xc3d1}, 
	{0x6067, 0x8fbde9}, 
	{0x6068, 0xbaa8}, 
	{0x6069, 0xb2b8}, 
	{0x606a, 0xd7ed}, 
	{0x606b, 0xd7f8}, 
	{0x606c, 0xd7f7}, 
	{0x606d, 0xb6b3}, 
	{0x606f, 0xc2a9}, 
	{0x6070, 0xb3e6}, 
	{0x6071, 0x8fbdea}, 
	{0x6075, 0xb7c3}, 
	{0x6077, 0xd7ee}, 
	{0x607e, 0x8fbdeb}, 
	{0x607f, 0x8fbdec}, 
	{0x6081, 0xd7fa}, 
	{0x6082, 0x8fbded}, 
	{0x6083, 0xd7fd}, 
	{0x6084, 0xd8a1}, 
	{0x6086, 0x8fbdee}, 
	{0x6088, 0x8fbdef}, 
	{0x6089, 0xbcbd}, 
	{0x608a, 0x8fbdf0}, 
	{0x608b, 0xd8a7}, 
	{0x608c, 0xc4f0}, 
	{0x608d, 0xd7fb}, 
	{0x608e, 0x8fbdf1}, 
	{0x6091, 0x8fbdf2}, 
	{0x6092, 0xd8a5}, 
	{0x6093, 0x8fbdf3}, 
	{0x6094, 0xb2f9}, 
	{0x6095, 0x8fbdf4}, 
	{0x6096, 0xd8a3}, 
	{0x6097, 0xd8a4}, 
	{0x6098, 0x8fbdf5}, 
	{0x609a, 0xd7fe}, 
	{0x609b, 0xd8a2}, 
	{0x609d, 0x8fbdf6}, 
	{0x609e, 0x8fbdf7}, 
	{0x609f, 0xb8e7}, 
	{0x60a0, 0xcdaa}, 
	{0x60a2, 0x8fbdf8}, 
	{0x60a3, 0xb4b5}, 
	{0x60a4, 0x8fbdf9}, 
	{0x60a5, 0x8fbdfa}, 
	{0x60a6, 0xb1d9}, 
	{0x60a7, 0xd8a6}, 
	{0x60a8, 0x8fbdfb}, 
	{0x60a9, 0xc7ba}, 
	{0x60aa, 0xb0ad}, 
	{0x60b0, 0x8fbdfc}, 
	{0x60b1, 0x8fbdfd}, 
	{0x60b2, 0xc8e1}, 
	{0x60b3, 0xd7dc}, 
	{0x60b4, 0xd8ac}, 
	{0x60b5, 0xd8b0}, 
	{0x60b6, 0xcce5}, 
	{0x60b7, 0x8fbdfe}, 
	{0x60b8, 0xd8a9}, 
	{0x60bb, 0x8fbea1}, 
	{0x60bc, 0xc5e9}, 
	{0x60bd, 0xd8ae}, 
	{0x60be, 0x8fbea2}, 
	{0x60c2, 0x8fbea3}, 
	{0x60c4, 0x8fbea4}, 
	{0x60c5, 0xbef0}, 
	{0x60c6, 0xd8af}, 
	{0x60c7, 0xc6d7}, 
	{0x60c8, 0x8fbea5}, 
	{0x60c9, 0x8fbea6}, 
	{0x60ca, 0x8fbea7}, 
	{0x60cb, 0x8fbea8}, 
	{0x60ce, 0x8fbea9}, 
	{0x60cf, 0x8fbeaa}, 
	{0x60d1, 0xcfc7}, 
	{0x60d3, 0xd8ab}, 
	{0x60d4, 0x8fbeab}, 
	{0x60d5, 0x8fbeac}, 
	{0x60d8, 0xd8b1}, 
	{0x60d9, 0x8fbead}, 
	{0x60da, 0xb9fb}, 
	{0x60db, 0x8fbeae}, 
	{0x60dc, 0xc0cb}, 
	{0x60dd, 0x8fbeaf}, 
	{0x60de, 0x8fbeb0}, 
	{0x60df, 0xb0d4}, 
	{0x60e0, 0xd8aa}, 
	{0x60e1, 0xd8a8}, 
	{0x60e2, 0x8fbeb1}, 
	{0x60e3, 0xc1da}, 
	{0x60e5, 0x8fbeb2}, 
	{0x60e7, 0xd7fc}, 
	{0x60e8, 0xbbb4}, 
	{0x60f0, 0xc2c6}, 
	{0x60f1, 0xd8bd}, 
	{0x60f2, 0x8fbeb3}, 
	{0x60f3, 0xc1db}, 
	{0x60f4, 0xd8b8}, 
	{0x60f5, 0x8fbeb4}, 
	{0x60f6, 0xd8b5}, 
	{0x60f7, 0xd8b6}, 
	{0x60f8, 0x8fbeb5}, 
	{0x60f9, 0xbce6}, 
	{0x60fa, 0xd8b9}, 
	{0x60fb, 0xd8bc}, 
	{0x60fc, 0x8fbeb6}, 
	{0x60fd, 0x8fbeb7}, 
	{0x6100, 0xd8b7}, 
	{0x6101, 0xbda5}, 
	{0x6102, 0x8fbeb8}, 
	{0x6103, 0xd8ba}, 
	{0x6106, 0xd8b4}, 
	{0x6107, 0x8fbeb9}, 
	{0x6108, 0xccfc}, 
	{0x6109, 0xccfb}, 
	{0x610a, 0x8fbeba}, 
	{0x610c, 0x8fbebb}, 
	{0x610d, 0xd8be}, 
	{0x610e, 0xd8bf}, 
	{0x610f, 0xb0d5}, 
	{0x6110, 0x8fbebc}, 
	{0x6111, 0x8fbebd}, 
	{0x6112, 0x8fbebe}, 
	{0x6113, 0x8fbebf}, 
	{0x6114, 0x8fbec0}, 
	{0x6115, 0xd8b3}, 
	{0x6116, 0x8fbec1}, 
	{0x6117, 0x8fbec2}, 
	{0x6119, 0x8fbec3}, 
	{0x611a, 0xb6f2}, 
	{0x611b, 0xb0a6}, 
	{0x611c, 0x8fbec4}, 
	{0x611e, 0x8fbec5}, 
	{0x611f, 0xb4b6}, 
	{0x6121, 0xd8bb}, 
	{0x6122, 0x8fbec6}, 
	{0x6127, 0xd8c3}, 
	{0x6128, 0xd8c2}, 
	{0x612a, 0x8fbec7}, 
	{0x612b, 0x8fbec8}, 
	{0x612c, 0xd8c7}, 
	{0x6130, 0x8fbec9}, 
	{0x6131, 0x8fbeca}, 
	{0x6134, 0xd8c8}, 
	{0x6135, 0x8fbecb}, 
	{0x6136, 0x8fbecc}, 
	{0x6137, 0x8fbecd}, 
	{0x6139, 0x8fbece}, 
	{0x613c, 0xd8c6}, 
	{0x613d, 0xd8c9}, 
	{0x613e, 0xd8c1}, 
	{0x613f, 0xd8c5}, 
	{0x6141, 0x8fbecf}, 
	{0x6142, 0xd8ca}, 
	{0x6144, 0xd8cb}, 
	{0x6145, 0x8fbed0}, 
	{0x6146, 0x8fbed1}, 
	{0x6147, 0xd8c0}, 
	{0x6148, 0xbbfc}, 
	{0x6149, 0x8fbed2}, 
	{0x614a, 0xd8c4}, 
	{0x614b, 0xc2d6}, 
	{0x614c, 0xb9b2}, 
	{0x614d, 0xd8b2}, 
	{0x614e, 0xbfb5}, 
	{0x6153, 0xd8d8}, 
	{0x6155, 0xcae9}, 
	{0x6158, 0xd8ce}, 
	{0x6159, 0xd8cf}, 
	{0x615a, 0xd8d0}, 
	{0x615d, 0xd8d7}, 
	{0x615e, 0x8fbed3}, 
	{0x615f, 0xd8d6}, 
	{0x6160, 0x8fbed4}, 
	{0x6162, 0xcbfd}, 
	{0x6163, 0xb4b7}, 
	{0x6165, 0xd8d4}, 
	{0x6167, 0xb7c5}, 
	{0x6168, 0xb3b4}, 
	{0x616b, 0xd8d1}, 
	{0x616c, 0x8fbed5}, 
	{0x616e, 0xceb8}, 
	{0x616f, 0xd8d3}, 
	{0x6170, 0xb0d6}, 
	{0x6171, 0xd8d5}, 
	{0x6172, 0x8fbed6}, 
	{0x6173, 0xd8cc}, 
	{0x6174, 0xd8d2}, 
	{0x6175, 0xd8d9}, 
	{0x6176, 0xb7c4}, 
	{0x6177, 0xd8cd}, 
	{0x6178, 0x8fbed7}, 
	{0x617b, 0x8fbed8}, 
	{0x617c, 0x8fbed9}, 
	{0x617e, 0xcddd}, 
	{0x617f, 0x8fbeda}, 
	{0x6180, 0x8fbedb}, 
	{0x6181, 0x8fbedc}, 
	{0x6182, 0xcdab}, 
	{0x6183, 0x8fbedd}, 
	{0x6184, 0x8fbede}, 
	{0x6187, 0xd8dc}, 
	{0x618a, 0xd8e0}, 
	{0x618b, 0x8fbedf}, 
	{0x618d, 0x8fbee0}, 
	{0x618e, 0xc1fe}, 
	{0x6190, 0xcef9}, 
	{0x6191, 0xd8e1}, 
	{0x6192, 0x8fbee1}, 
	{0x6193, 0x8fbee2}, 
	{0x6194, 0xd8de}, 
	{0x6196, 0xd8db}, 
	{0x6197, 0x8fbee3}, 
	{0x6198, 0x8fbee4}, 
	{0x6199, 0xd8da}, 
	{0x619a, 0xd8df}, 
	{0x619c, 0x8fbee5}, 
	{0x619d, 0x8fbee6}, 
	{0x619f, 0x8fbee7}, 
	{0x61a0, 0x8fbee8}, 
	{0x61a4, 0xcab0}, 
	{0x61a5, 0x8fbee9}, 
	{0x61a7, 0xc6b4}, 
	{0x61a8, 0x8fbeea}, 
	{0x61a9, 0xb7c6}, 
	{0x61aa, 0x8fbeeb}, 
	{0x61ab, 0xd8e2}, 
	{0x61ac, 0xd8dd}, 
	{0x61ad, 0x8fbeec}, 
	{0x61ae, 0xd8e3}, 
	{0x61b2, 0xb7fb}, 
	{0x61b6, 0xb2b1}, 
	{0x61b8, 0x8fbeed}, 
	{0x61b9, 0x8fbeee}, 
	{0x61ba, 0xd8eb}, 
	{0x61bc, 0x8fbeef}, 
	{0x61be, 0xb4b8}, 
	{0x61c0, 0x8fbef0}, 
	{0x61c1, 0x8fbef1}, 
	{0x61c2, 0x8fbef2}, 
	{0x61c3, 0xd8e9}, 
	{0x61c6, 0xd8ea}, 
	{0x61c7, 0xbaa9}, 
	{0x61c8, 0xd8e8}, 
	{0x61c9, 0xd8e6}, 
	{0x61ca, 0xd8e5}, 
	{0x61cb, 0xd8ec}, 
	{0x61cc, 0xd8e4}, 
	{0x61cd, 0xd8ee}, 
	{0x61ce, 0x8fbef3}, 
	{0x61cf, 0x8fbef4}, 
	{0x61d0, 0xb2fb}, 
	{0x61d5, 0x8fbef5}, 
	{0x61dc, 0x8fbef6}, 
	{0x61dd, 0x8fbef7}, 
	{0x61de, 0x8fbef8}, 
	{0x61df, 0x8fbef9}, 
	{0x61e1, 0x8fbefa}, 
	{0x61e2, 0x8fbefb}, 
	{0x61e3, 0xd8f0}, 
	{0x61e5, 0x8fbefe}, 
	{0x61e6, 0xd8ef}, 
	{0x61e7, 0x8fbefc}, 
	{0x61e9, 0x8fbefd}, 
	{0x61ec, 0x8fbfa1}, 
	{0x61ed, 0x8fbfa2}, 
	{0x61ef, 0x8fbfa3}, 
	{0x61f2, 0xc4a8}, 
	{0x61f4, 0xd8f3}, 
	{0x61f6, 0xd8f1}, 
	{0x61f7, 0xd8e7}, 
	{0x61f8, 0xb7fc}, 
	{0x61fa, 0xd8f2}, 
	{0x61fc, 0xd8f6}, 
	{0x61fd, 0xd8f5}, 
	{0x61fe, 0xd8f7}, 
	{0x61ff, 0xd8f4}, 
	{0x6200, 0xd8f8}, 
	{0x6201, 0x8fbfa4}, 
	{0x6203, 0x8fbfa5}, 
	{0x6204, 0x8fbfa6}, 
	{0x6207, 0x8fbfa7}, 
	{0x6208, 0xd8f9}, 
	{0x6209, 0xd8fa}, 
	{0x620a, 0xcaea}, 
	{0x620c, 0xd8fc}, 
	{0x620d, 0xd8fb}, 
	{0x620e, 0xbdbf}, 
	{0x6210, 0xc0ae}, 
	{0x6211, 0xb2e6}, 
	{0x6212, 0xb2fc}, 
	{0x6213, 0x8fbfa8}, 
	{0x6214, 0xd8fd}, 
	{0x6215, 0x8fbfa9}, 
	{0x6216, 0xb0bf}, 
	{0x621a, 0xc0cc}, 
	{0x621b, 0xd8fe}, 
	{0x621c, 0x8fbfaa}, 
	{0x621d, 0xecc3}, 
	{0x621e, 0xd9a1}, 
	{0x621f, 0xb7e1}, 
	{0x6220, 0x8fbfab}, 
	{0x6221, 0xd9a2}, 
	{0x6222, 0x8fbfac}, 
	{0x6223, 0x8fbfad}, 
	{0x6226, 0xc0ef}, 
	{0x6227, 0x8fbfae}, 
	{0x6229, 0x8fbfaf}, 
	{0x622a, 0xd9a3}, 
	{0x622b, 0x8fbfb0}, 
	{0x622e, 0xd9a4}, 
	{0x622f, 0xb5ba}, 
	{0x6230, 0xd9a5}, 
	{0x6232, 0xd9a6}, 
	{0x6233, 0xd9a7}, 
	{0x6234, 0xc2d7}, 
	{0x6238, 0xb8cd}, 
	{0x6239, 0x8fbfb1}, 
	{0x623b, 0xcce1}, 
	{0x623d, 0x8fbfb2}, 
	{0x623f, 0xcbbc}, 
	{0x6240, 0xbdea}, 
	{0x6241, 0xd9a8}, 
	{0x6242, 0x8fbfb3}, 
	{0x6243, 0x8fbfb4}, 
	{0x6244, 0x8fbfb5}, 
	{0x6246, 0x8fbfb6}, 
	{0x6247, 0xc0f0}, 
	{0x6248, 0xeebd}, 
	{0x6249, 0xc8e2}, 
	{0x624b, 0xbcea}, 
	{0x624c, 0x8fbfb7}, 
	{0x624d, 0xbacd}, 
	{0x624e, 0xd9a9}, 
	{0x6250, 0x8fbfb8}, 
	{0x6251, 0x8fbfb9}, 
	{0x6252, 0x8fbfba}, 
	{0x6253, 0xc2c7}, 
	{0x6254, 0x8fbfbb}, 
	{0x6255, 0xcaa7}, 
	{0x6256, 0x8fbfbc}, 
	{0x6258, 0xc2f1}, 
	{0x625a, 0x8fbfbd}, 
	{0x625b, 0xd9ac}, 
	{0x625c, 0x8fbfbe}, 
	{0x625e, 0xd9aa}, 
	{0x6260, 0xd9ad}, 
	{0x6263, 0xd9ab}, 
	{0x6264, 0x8fbfbf}, 
	{0x6268, 0xd9ae}, 
	{0x626d, 0x8fbfc0}, 
	{0x626e, 0xcab1}, 
	{0x626f, 0x8fbfc1}, 
	{0x6271, 0xb0b7}, 
	{0x6273, 0x8fbfc2}, 
	{0x6276, 0xc9de}, 
	{0x6279, 0xc8e3}, 
	{0x627a, 0x8fbfc3}, 
	{0x627c, 0xd9af}, 
	{0x627d, 0x8fbfc4}, 
	{0x627e, 0xd9b2}, 
	{0x627f, 0xbeb5}, 
	{0x6280, 0xb5bb}, 
	{0x6282, 0xd9b0}, 
	{0x6283, 0xd9b7}, 
	{0x6284, 0xbeb6}, 
	{0x6289, 0xd9b1}, 
	{0x628a, 0xc7c4}, 
	{0x628d, 0x8fbfc5}, 
	{0x628e, 0x8fbfc6}, 
	{0x628f, 0x8fbfc7}, 
	{0x6290, 0x8fbfc8}, 
	{0x6291, 0xcdde}, 
	{0x6292, 0xd9b3}, 
	{0x6293, 0xd9b4}, 
	{0x6294, 0xd9b8}, 
	{0x6295, 0xc5ea}, 
	{0x6296, 0xd9b5}, 
	{0x6297, 0xb9b3}, 
	{0x6298, 0xc0de}, 
	{0x629b, 0xd9c6}, 
	{0x629c, 0xc8b4}, 
	{0x629e, 0xc2f2}, 
	{0x62a6, 0x8fbfc9}, 
	{0x62a8, 0x8fbfca}, 
	{0x62ab, 0xc8e4}, 
	{0x62ac, 0xdaad}, 
	{0x62b1, 0xcafa}, 
	{0x62b3, 0x8fbfcb}, 
	{0x62b5, 0xc4f1}, 
	{0x62b6, 0x8fbfcc}, 
	{0x62b7, 0x8fbfcd}, 
	{0x62b9, 0xcbf5}, 
	{0x62ba, 0x8fbfce}, 
	{0x62bb, 0xd9bb}, 
	{0x62bc, 0xb2a1}, 
	{0x62bd, 0xc3ea}, 
	{0x62be, 0x8fbfcf}, 
	{0x62bf, 0x8fbfd0}, 
	{0x62c2, 0xd9c4}, 
	{0x62c4, 0x8fbfd1}, 
	{0x62c5, 0xc3b4}, 
	{0x62c6, 0xd9be}, 
	{0x62c7, 0xd9c5}, 
	{0x62c8, 0xd9c0}, 
	{0x62c9, 0xd9c7}, 
	{0x62ca, 0xd9c3}, 
	{0x62cc, 0xd9c2}, 
	{0x62cd, 0xc7ef}, 
	{0x62ce, 0x8fbfd2}, 
	{0x62cf, 0xd9bc}, 
	{0x62d0, 0xb2fd}, 
	{0x62d1, 0xd9ba}, 
	{0x62d2, 0xb5f1}, 
	{0x62d3, 0xc2f3}, 
	{0x62d4, 0xd9b6}, 
	{0x62d5, 0x8fbfd3}, 
	{0x62d6, 0x8fbfd4}, 
	{0x62d7, 0xd9b9}, 
	{0x62d8, 0xb9b4}, 
	{0x62d9, 0xc0db}, 
	{0x62da, 0x8fbfd5}, 
	{0x62db, 0xbeb7}, 
	{0x62dc, 0xd9c1}, 
	{0x62dd, 0xc7d2}, 
	{0x62e0, 0xb5f2}, 
	{0x62e1, 0xb3c8}, 
	{0x62ea, 0x8fbfd6}, 
	{0x62ec, 0xb3e7}, 
	{0x62ed, 0xbfa1}, 
	{0x62ee, 0xd9c9}, 
	{0x62ef, 0xd9ce}, 
	{0x62f1, 0xd9ca}, 
	{0x62f2, 0x8fbfd7}, 
	{0x62f3, 0xb7fd}, 
	{0x62f4, 0x8fbfd8}, 
	{0x62f5, 0xd9cf}, 
	{0x62f6, 0xbba2}, 
	{0x62f7, 0xb9e9}, 
	{0x62fc, 0x8fbfd9}, 
	{0x62fd, 0x8fbfda}, 
	{0x62fe, 0xbda6}, 
	{0x62ff, 0xd9bd}, 
	{0x6301, 0xbbfd}, 
	{0x6302, 0xd9cc}, 
	{0x6303, 0x8fbfdb}, 
	{0x6304, 0x8fbfdc}, 
	{0x6307, 0xbbd8}, 
	{0x6308, 0xd9cd}, 
	{0x6309, 0xb0c4}, 
	{0x630a, 0x8fbfdd}, 
	{0x630b, 0x8fbfde}, 
	{0x630c, 0xd9c8}, 
	{0x630d, 0x8fbfdf}, 
	{0x6310, 0x8fbfe0}, 
	{0x6311, 0xc4a9}, 
	{0x6313, 0x8fbfe1}, 
	{0x6316, 0x8fbfe2}, 
	{0x6318, 0x8fbfe3}, 
	{0x6319, 0xb5f3}, 
	{0x631f, 0xb6b4}, 
	{0x6327, 0xd9cb}, 
	{0x6328, 0xb0a7}, 
	{0x6329, 0x8fbfe4}, 
	{0x632a, 0x8fbfe5}, 
	{0x632b, 0xbac3}, 
	{0x632d, 0x8fbfe6}, 
	{0x632f, 0xbfb6}, 
	{0x6335, 0x8fbfe7}, 
	{0x6336, 0x8fbfe8}, 
	{0x6339, 0x8fbfe9}, 
	{0x633a, 0xc4f2}, 
	{0x633c, 0x8fbfea}, 
	{0x633d, 0xc8d4}, 
	{0x633e, 0xd9d1}, 
	{0x633f, 0xc1de}, 
	{0x6341, 0x8fbfeb}, 
	{0x6342, 0x8fbfec}, 
	{0x6343, 0x8fbfed}, 
	{0x6344, 0x8fbfee}, 
	{0x6346, 0x8fbfef}, 
	{0x6349, 0xc2aa}, 
	{0x634a, 0x8fbff0}, 
	{0x634b, 0x8fbff1}, 
	{0x634c, 0xbbab}, 
	{0x634d, 0xd9d2}, 
	{0x634e, 0x8fbff2}, 
	{0x634f, 0xd9d4}, 
	{0x6350, 0xd9d0}, 
	{0x6352, 0x8fbff3}, 
	{0x6353, 0x8fbff4}, 
	{0x6354, 0x8fbff5}, 
	{0x6355, 0xcae1}, 
	{0x6357, 0xc4bd}, 
	{0x6358, 0x8fbff6}, 
	{0x635b, 0x8fbff7}, 
	{0x635c, 0xc1dc}, 
	{0x6365, 0x8fbff8}, 
	{0x6366, 0x8fbff9}, 
	{0x6367, 0xcafb}, 
	{0x6368, 0xbcce}, 
	{0x6369, 0xd9e0}, 
	{0x636b, 0xd9df}, 
	{0x636c, 0x8fbffa}, 
	{0x636d, 0x8fbffb}, 
	{0x636e, 0xbff8}, 
	{0x6371, 0x8fbffc}, 
	{0x6372, 0xb7fe}, 
	{0x6374, 0x8fbffd}, 
	{0x6375, 0x8fbffe}, 
	{0x6376, 0xd9d9}, 
	{0x6377, 0xbeb9}, 
	{0x6378, 0x8fc0a1}, 
	{0x637a, 0xc6e8}, 
	{0x637b, 0xc7b1}, 
	{0x637c, 0x8fc0a2}, 
	{0x637d, 0x8fc0a3}, 
	{0x637f, 0x8fc0a4}, 
	{0x6380, 0xd9d7}, 
	{0x6382, 0x8fc0a5}, 
	{0x6383, 0xc1dd}, 
	{0x6384, 0x8fc0a6}, 
	{0x6387, 0x8fc0a7}, 
	{0x6388, 0xbcf8}, 
	{0x6389, 0xd9dc}, 
	{0x638a, 0x8fc0a8}, 
	{0x638c, 0xbeb8}, 
	{0x638e, 0xd9d6}, 
	{0x638f, 0xd9db}, 
	{0x6390, 0x8fc0a9}, 
	{0x6392, 0xc7d3}, 
	{0x6394, 0x8fc0aa}, 
	{0x6395, 0x8fc0ab}, 
	{0x6396, 0xd9d5}, 
	{0x6398, 0xb7a1}, 
	{0x6399, 0x8fc0ac}, 
	{0x639a, 0x8fc0ad}, 
	{0x639b, 0xb3dd}, 
	{0x639e, 0x8fc0ae}, 
	{0x639f, 0xd9dd}, 
	{0x63a0, 0xceab}, 
	{0x63a1, 0xbace}, 
	{0x63a2, 0xc3b5}, 
	{0x63a3, 0xd9da}, 
	{0x63a4, 0x8fc0af}, 
	{0x63a5, 0xc0dc}, 
	{0x63a6, 0x8fc0b0}, 
	{0x63a7, 0xb9b5}, 
	{0x63a8, 0xbfe4}, 
	{0x63a9, 0xb1e6}, 
	{0x63aa, 0xc1bc}, 
	{0x63ab, 0xd9d8}, 
	{0x63ac, 0xb5c5}, 
	{0x63ad, 0x8fc0b1}, 
	{0x63ae, 0x8fc0b2}, 
	{0x63af, 0x8fc0b3}, 
	{0x63b2, 0xb7c7}, 
	{0x63b4, 0xc4cf}, 
	{0x63b5, 0xd9de}, 
	{0x63bb, 0xc1df}, 
	{0x63bd, 0x8fc0b4}, 
	{0x63be, 0xd9e1}, 
	{0x63c0, 0xd9e3}, 
	{0x63c1, 0x8fc0b5}, 
	{0x63c3, 0xc2b7}, 
	{0x63c4, 0xd9e9}, 
	{0x63c5, 0x8fc0b6}, 
	{0x63c6, 0xd9e4}, 
	{0x63c8, 0x8fc0b7}, 
	{0x63c9, 0xd9e6}, 
	{0x63ce, 0x8fc0b8}, 
	{0x63cf, 0xc9c1}, 
	{0x63d0, 0xc4f3}, 
	{0x63d1, 0x8fc0b9}, 
	{0x63d2, 0xd9e7}, 
	{0x63d3, 0x8fc0ba}, 
	{0x63d4, 0x8fc0bb}, 
	{0x63d5, 0x8fc0bc}, 
	{0x63d6, 0xcdac}, 
	{0x63da, 0xcdc8}, 
	{0x63db, 0xb4b9}, 
	{0x63dc, 0x8fc0bd}, 
	{0x63e0, 0x8fc0be}, 
	{0x63e1, 0xb0ae}, 
	{0x63e3, 0xd9e5}, 
	{0x63e5, 0x8fc0bf}, 
	{0x63e9, 0xd9e2}, 
	{0x63ea, 0x8fc0c0}, 
	{0x63ec, 0x8fc0c1}, 
	{0x63ee, 0xb4f8}, 
	{0x63f2, 0x8fc0c2}, 
	{0x63f3, 0x8fc0c3}, 
	{0x63f4, 0xb1e7}, 
	{0x63f5, 0x8fc0c4}, 
	{0x63f6, 0xd9e8}, 
	{0x63f8, 0x8fc0c5}, 
	{0x63f9, 0x8fc0c6}, 
	{0x63fa, 0xcdc9}, 
	{0x6406, 0xd9ec}, 
	{0x6409, 0x8fc0c7}, 
	{0x640a, 0x8fc0c8}, 
	{0x640d, 0xc2bb}, 
	{0x640f, 0xd9f3}, 
	{0x6410, 0x8fc0c9}, 
	{0x6412, 0x8fc0ca}, 
	{0x6413, 0xd9ed}, 
	{0x6414, 0x8fc0cb}, 
	{0x6416, 0xd9ea}, 
	{0x6417, 0xd9f1}, 
	{0x6418, 0x8fc0cc}, 
	{0x641c, 0xd9d3}, 
	{0x641e, 0x8fc0cd}, 
	{0x6420, 0x8fc0ce}, 
	{0x6422, 0x8fc0cf}, 
	{0x6424, 0x8fc0d0}, 
	{0x6425, 0x8fc0d1}, 
	{0x6426, 0xd9ee}, 
	{0x6428, 0xd9f2}, 
	{0x6429, 0x8fc0d2}, 
	{0x642a, 0x8fc0d3}, 
	{0x642c, 0xc8c2}, 
	{0x642d, 0xc5eb}, 
	{0x642f, 0x8fc0d4}, 
	{0x6430, 0x8fc0d5}, 
	{0x6434, 0xd9eb}, 
	{0x6435, 0x8fc0d6}, 
	{0x6436, 0xd9ef}, 
	{0x643a, 0xb7c8}, 
	{0x643d, 0x8fc0d7}, 
	{0x643e, 0xbaf1}, 
	{0x643f, 0x8fc0d8}, 
	{0x6442, 0xc0dd}, 
	{0x644b, 0x8fc0d9}, 
	{0x644e, 0xd9f7}, 
	{0x644f, 0x8fc0da}, 
	{0x6451, 0x8fc0db}, 
	{0x6452, 0x8fc0dc}, 
	{0x6453, 0x8fc0dd}, 
	{0x6454, 0x8fc0de}, 
	{0x6458, 0xc5a6}, 
	{0x645a, 0x8fc0df}, 
	{0x645b, 0x8fc0e0}, 
	{0x645c, 0x8fc0e1}, 
	{0x645d, 0x8fc0e2}, 
	{0x645f, 0x8fc0e3}, 
	{0x6460, 0x8fc0e4}, 
	{0x6461, 0x8fc0e5}, 
	{0x6463, 0x8fc0e6}, 
	{0x6467, 0xd9f4}, 
	{0x6469, 0xcbe0}, 
	{0x646d, 0x8fc0e7}, 
	{0x646f, 0xd9f5}, 
	{0x6473, 0x8fc0e8}, 
	{0x6474, 0x8fc0e9}, 
	{0x6476, 0xd9f6}, 
	{0x6478, 0xccce}, 
	{0x647a, 0xc0a2}, 
	{0x647b, 0x8fc0ea}, 
	{0x647d, 0x8fc0eb}, 
	{0x6483, 0xb7e2}, 
	{0x6485, 0x8fc0ec}, 
	{0x6487, 0x8fc0ed}, 
	{0x6488, 0xd9fd}, 
	{0x648f, 0x8fc0ee}, 
	{0x6490, 0x8fc0ef}, 
	{0x6491, 0x8fc0f0}, 
	{0x6492, 0xbbb5}, 
	{0x6493, 0xd9fa}, 
	{0x6495, 0xd9f9}, 
	{0x6498, 0x8fc0f1}, 
	{0x6499, 0x8fc0f2}, 
	{0x649a, 0xc7b2}, 
	{0x649b, 0x8fc0f3}, 
	{0x649d, 0x8fc0f4}, 
	{0x649e, 0xc6b5}, 
	{0x649f, 0x8fc0f5}, 
	{0x64a1, 0x8fc0f6}, 
	{0x64a3, 0x8fc0f7}, 
	{0x64a4, 0xc5b1}, 
	{0x64a5, 0xd9fb}, 
	{0x64a6, 0x8fc0f8}, 
	{0x64a8, 0x8fc0f9}, 
	{0x64a9, 0xd9fc}, 
	{0x64ab, 0xc9ef}, 
	{0x64ac, 0x8fc0fa}, 
	{0x64ad, 0xc7c5}, 
	{0x64ae, 0xbba3}, 
	{0x64b0, 0xc0f1}, 
	{0x64b2, 0xcbd0}, 
	{0x64b3, 0x8fc0fb}, 
	{0x64b9, 0xb3c9}, 
	{0x64bb, 0xdaa5}, 
	{0x64bc, 0xd9fe}, 
	{0x64bd, 0x8fc0fc}, 
	{0x64be, 0x8fc0fd}, 
	{0x64bf, 0x8fc0fe}, 
	{0x64c1, 0xcdca}, 
	{0x64c2, 0xdaa7}, 
	{0x64c4, 0x8fc1a1}, 
	{0x64c5, 0xdaa3}, 
	{0x64c7, 0xdaa4}, 
	{0x64c9, 0x8fc1a2}, 
	{0x64ca, 0x8fc1a3}, 
	{0x64cb, 0x8fc1a4}, 
	{0x64cc, 0x8fc1a5}, 
	{0x64cd, 0xc1e0}, 
	{0x64ce, 0x8fc1a6}, 
	{0x64d0, 0x8fc1a7}, 
	{0x64d1, 0x8fc1a8}, 
	{0x64d2, 0xdaa2}, 
	{0x64d4, 0xd9bf}, 
	{0x64d5, 0x8fc1a9}, 
	{0x64d7, 0x8fc1aa}, 
	{0x64d8, 0xdaa6}, 
	{0x64da, 0xdaa1}, 
	{0x64e0, 0xdaab}, 
	{0x64e1, 0xdaac}, 
	{0x64e2, 0xc5a7}, 
	{0x64e3, 0xdaae}, 
	{0x64e4, 0x8fc1ab}, 
	{0x64e5, 0x8fc1ac}, 
	{0x64e6, 0xbba4}, 
	{0x64e7, 0xdaa9}, 
	{0x64e9, 0x8fc1ad}, 
	{0x64ea, 0x8fc1ae}, 
	{0x64ec, 0xb5bc}, 
	{0x64ed, 0x8fc1af}, 
	{0x64ef, 0xdaaf}, 
	{0x64f0, 0x8fc1b0}, 
	{0x64f1, 0xdaa8}, 
	{0x64f2, 0xdab3}, 
	{0x64f4, 0xdab2}, 
	{0x64f5, 0x8fc1b1}, 
	{0x64f6, 0xdab1}, 
	{0x64f7, 0x8fc1b2}, 
	{0x64fa, 0xdab4}, 
	{0x64fb, 0x8fc1b3}, 
	{0x64fd, 0xdab6}, 
	{0x64fe, 0xbef1}, 
	{0x64ff, 0x8fc1b4}, 
	{0x6500, 0xdab5}, 
	{0x6501, 0x8fc1b5}, 
	{0x6504, 0x8fc1b6}, 
	{0x6505, 0xdab9}, 
	{0x6508, 0x8fc1b7}, 
	{0x6509, 0x8fc1b8}, 
	{0x650a, 0x8fc1b9}, 
	{0x650f, 0x8fc1ba}, 
	{0x6513, 0x8fc1bb}, 
	{0x6514, 0x8fc1bc}, 
	{0x6516, 0x8fc1bd}, 
	{0x6518, 0xdab7}, 
	{0x6519, 0x8fc1be}, 
	{0x651b, 0x8fc1bf}, 
	{0x651c, 0xdab8}, 
	{0x651d, 0xd9f0}, 
	{0x651e, 0x8fc1c0}, 
	{0x651f, 0x8fc1c1}, 
	{0x6522, 0x8fc1c2}, 
	{0x6523, 0xdabb}, 
	{0x6524, 0xdaba}, 
	{0x6526, 0x8fc1c3}, 
	{0x6529, 0x8fc1c4}, 
	{0x652a, 0xd9f8}, 
	{0x652b, 0xdabc}, 
	{0x652c, 0xdab0}, 
	{0x652e, 0x8fc1c5}, 
	{0x652f, 0xbbd9}, 
	{0x6531, 0x8fc1c6}, 
	{0x6534, 0xdabd}, 
	{0x6535, 0xdabe}, 
	{0x6536, 0xdac0}, 
	{0x6537, 0xdabf}, 
	{0x6538, 0xdac1}, 
	{0x6539, 0xb2fe}, 
	{0x653a, 0x8fc1c7}, 
	{0x653b, 0xb9b6}, 
	{0x653c, 0x8fc1c8}, 
	{0x653d, 0x8fc1c9}, 
	{0x653e, 0xcafc}, 
	{0x653f, 0xc0af}, 
	{0x6543, 0x8fc1ca}, 
	{0x6545, 0xb8ce}, 
	{0x6547, 0x8fc1cb}, 
	{0x6548, 0xdac3}, 
	{0x6549, 0x8fc1cc}, 
	{0x654d, 0xdac6}, 
	{0x654f, 0xc9d2}, 
	{0x6550, 0x8fc1cd}, 
	{0x6551, 0xb5df}, 
	{0x6552, 0x8fc1ce}, 
	{0x6554, 0x8fc1cf}, 
	{0x6555, 0xdac5}, 
	{0x6556, 0xdac4}, 
	{0x6557, 0xc7d4}, 
	{0x6558, 0xdac7}, 
	{0x6559, 0xb6b5}, 
	{0x655d, 0xdac9}, 
	{0x655e, 0xdac8}, 
	{0x655f, 0x8fc1d0}, 
	{0x6560, 0x8fc1d1}, 
	{0x6562, 0xb4ba}, 
	{0x6563, 0xbbb6}, 
	{0x6566, 0xc6d8}, 
	{0x6567, 0x8fc1d2}, 
	{0x656b, 0x8fc1d3}, 
	{0x656c, 0xb7c9}, 
	{0x6570, 0xbff4}, 
	{0x6572, 0xdaca}, 
	{0x6574, 0xc0b0}, 
	{0x6575, 0xc5a8}, 
	{0x6577, 0xc9df}, 
	{0x6578, 0xdacb}, 
	{0x657a, 0x8fc1d4}, 
	{0x657d, 0x8fc1d5}, 
	{0x6581, 0x8fc1d6}, 
	{0x6582, 0xdacc}, 
	{0x6583, 0xdacd}, 
	{0x6585, 0x8fc1d7}, 
	{0x6587, 0xcab8}, 
	{0x6588, 0xd5dd}, 
	{0x6589, 0xc0c6}, 
	{0x658a, 0x8fc1d8}, 
	{0x658c, 0xc9cc}, 
	{0x658e, 0xbad8}, 
	{0x6590, 0xc8e5}, 
	{0x6591, 0xc8c3}, 
	{0x6592, 0x8fc1d9}, 
	{0x6595, 0x8fc1da}, 
	{0x6597, 0xc5cd}, 
	{0x6598, 0x8fc1db}, 
	{0x6599, 0xcec1}, 
	{0x659b, 0xdacf}, 
	{0x659c, 0xbcd0}, 
	{0x659d, 0x8fc1dc}, 
	{0x659f, 0xdad0}, 
	{0x65a0, 0x8fc1dd}, 
	{0x65a1, 0xb0b6}, 
	{0x65a3, 0x8fc1de}, 
	{0x65a4, 0xb6d4}, 
	{0x65a5, 0xc0cd}, 
	{0x65a6, 0x8fc1df}, 
	{0x65a7, 0xc9e0}, 
	{0x65ab, 0xdad1}, 
	{0x65ac, 0xbbc2}, 
	{0x65ad, 0xc3c7}, 
	{0x65ae, 0x8fc1e0}, 
	{0x65af, 0xbbdb}, 
	{0x65b0, 0xbfb7}, 
	{0x65b2, 0x8fc1e1}, 
	{0x65b3, 0x8fc1e2}, 
	{0x65b4, 0x8fc1e3}, 
	{0x65b7, 0xdad2}, 
	{0x65b9, 0xcafd}, 
	{0x65bc, 0xb1f7}, 
	{0x65bd, 0xbbdc}, 
	{0x65bf, 0x8fc1e4}, 
	{0x65c1, 0xdad5}, 
	{0x65c2, 0x8fc1e5}, 
	{0x65c3, 0xdad3}, 
	{0x65c4, 0xdad6}, 
	{0x65c5, 0xceb9}, 
	{0x65c6, 0xdad4}, 
	{0x65c8, 0x8fc1e6}, 
	{0x65c9, 0x8fc1e7}, 
	{0x65cb, 0xc0fb}, 
	{0x65cc, 0xdad7}, 
	{0x65ce, 0x8fc1e8}, 
	{0x65cf, 0xc2b2}, 
	{0x65d0, 0x8fc1e9}, 
	{0x65d2, 0xdad8}, 
	{0x65d4, 0x8fc1ea}, 
	{0x65d6, 0x8fc1eb}, 
	{0x65d7, 0xb4fa}, 
	{0x65d8, 0x8fc1ec}, 
	{0x65d9, 0xdada}, 
	{0x65db, 0xdad9}, 
	{0x65df, 0x8fc1ed}, 
	{0x65e0, 0xdadb}, 
	{0x65e1, 0xdadc}, 
	{0x65e2, 0xb4fb}, 
	{0x65e5, 0xc6fc}, 
	{0x65e6, 0xc3b6}, 
	{0x65e7, 0xb5ec}, 
	{0x65e8, 0xbbdd}, 
	{0x65e9, 0xc1e1}, 
	{0x65ec, 0xbddc}, 
	{0x65ed, 0xb0b0}, 
	{0x65f0, 0x8fc1ee}, 
	{0x65f1, 0xdadd}, 
	{0x65f2, 0x8fc1ef}, 
	{0x65f4, 0x8fc1f0}, 
	{0x65f5, 0x8fc1f1}, 
	{0x65f9, 0x8fc1f2}, 
	{0x65fa, 0xb2a2}, 
	{0x65fb, 0xdae1}, 
	{0x65fe, 0x8fc1f3}, 
	{0x65ff, 0x8fc1f4}, 
	{0x6600, 0x8fc1f5}, 
	{0x6602, 0xb9b7}, 
	{0x6603, 0xdae0}, 
	{0x6604, 0x8fc1f6}, 
	{0x6606, 0xbaab}, 
	{0x6607, 0xbeba}, 
	{0x6608, 0x8fc1f7}, 
	{0x6609, 0x8fc1f8}, 
	{0x660a, 0xdadf}, 
	{0x660c, 0xbebb}, 
	{0x660d, 0x8fc1f9}, 
	{0x660e, 0xccc0}, 
	{0x660f, 0xbaaa}, 
	{0x6611, 0x8fc1fa}, 
	{0x6612, 0x8fc1fb}, 
	{0x6613, 0xb0d7}, 
	{0x6614, 0xc0ce}, 
	{0x6615, 0x8fc1fc}, 
	{0x6616, 0x8fc1fd}, 
	{0x661c, 0xdae6}, 
	{0x661d, 0x8fc1fe}, 
	{0x661e, 0x8fc2a1}, 
	{0x661f, 0xc0b1}, 
	{0x6620, 0xb1c7}, 
	{0x6621, 0x8fc2a2}, 
	{0x6622, 0x8fc2a3}, 
	{0x6623, 0x8fc2a4}, 
	{0x6624, 0x8fc2a5}, 
	{0x6625, 0xbdd5}, 
	{0x6626, 0x8fc2a6}, 
	{0x6627, 0xcbe6}, 
	{0x6628, 0xbaf2}, 
	{0x6629, 0x8fc2a7}, 
	{0x662a, 0x8fc2a8}, 
	{0x662b, 0x8fc2a9}, 
	{0x662c, 0x8fc2aa}, 
	{0x662d, 0xbebc}, 
	{0x662e, 0x8fc2ab}, 
	{0x662f, 0xc0a7}, 
	{0x6630, 0x8fc2ac}, 
	{0x6631, 0x8fc2ad}, 
	{0x6633, 0x8fc2ae}, 
	{0x6634, 0xdae5}, 
	{0x6635, 0xdae3}, 
	{0x6636, 0xdae4}, 
	{0x6637, 0x8fc2b0}, 
	{0x6639, 0x8fc2af}, 
	{0x663c, 0xc3eb}, 
	{0x663f, 0xdba6}, 
	{0x6640, 0x8fc2b1}, 
	{0x6641, 0xdaea}, 
	{0x6642, 0xbbfe}, 
	{0x6643, 0xb9b8}, 
	{0x6644, 0xdae8}, 
	{0x6645, 0x8fc2b2}, 
	{0x6646, 0x8fc2b3}, 
	{0x6649, 0xdae9}, 
	{0x664a, 0x8fc2b4}, 
	{0x664b, 0xbfb8}, 
	{0x664c, 0x8fc2b5}, 
	{0x664e, 0x8fc2b7}, 
	{0x664f, 0xdae7}, 
	{0x6651, 0x8fc2b6}, 
	{0x6652, 0xbbaf}, 
	{0x6657, 0x8fc2b8}, 
	{0x6658, 0x8fc2b9}, 
	{0x6659, 0x8fc2ba}, 
	{0x665b, 0x8fc2bb}, 
	{0x665c, 0x8fc2bc}, 
	{0x665d, 0xdaec}, 
	{0x665e, 0xdaeb}, 
	{0x665f, 0xdaf0}, 
	{0x6660, 0x8fc2bd}, 
	{0x6661, 0x8fc2be}, 
	{0x6662, 0xdaf1}, 
	{0x6664, 0xdaed}, 
	{0x6666, 0xb3a2}, 
	{0x6667, 0xdaee}, 
	{0x6668, 0xdaef}, 
	{0x6669, 0xc8d5}, 
	{0x666a, 0x8fc2c0}, 
	{0x666b, 0x8fc2c1}, 
	{0x666c, 0x8fc2c2}, 
	{0x666e, 0xc9e1}, 
	{0x666f, 0xb7ca}, 
	{0x6670, 0xdaf2}, 
	{0x6673, 0x8fc2c4}, 
	{0x6674, 0xc0b2}, 
	{0x6675, 0x8fc2c5}, 
	{0x6676, 0xbebd}, 
	{0x6677, 0x8fc2c7}, 
	{0x6678, 0x8fc2c8}, 
	{0x6679, 0x8fc2c9}, 
	{0x667a, 0xc3d2}, 
	{0x667b, 0x8fc2ca}, 
	{0x667c, 0x8fc2cc}, 
	{0x667e, 0x8fc2c3}, 
	{0x667f, 0x8fc2c6}, 
	{0x6680, 0x8fc2cb}, 
	{0x6681, 0xb6c7}, 
	{0x6683, 0xdaf3}, 
	{0x6684, 0xdaf7}, 
	{0x6687, 0xb2cb}, 
	{0x6688, 0xdaf4}, 
	{0x6689, 0xdaf6}, 
	{0x668b, 0x8fc2cd}, 
	{0x668c, 0x8fc2ce}, 
	{0x668d, 0x8fc2cf}, 
	{0x668e, 0xdaf5}, 
	{0x6690, 0x8fc2d0}, 
	{0x6691, 0xbdeb}, 
	{0x6692, 0x8fc2d1}, 
	{0x6696, 0xc3c8}, 
	{0x6697, 0xb0c5}, 
	{0x6698, 0xdaf8}, 
	{0x6699, 0x8fc2d2}, 
	{0x669a, 0x8fc2d3}, 
	{0x669b, 0x8fc2d4}, 
	{0x669c, 0x8fc2d5}, 
	{0x669d, 0xdaf9}, 
	{0x669f, 0x8fc2d6}, 
	{0x66a0, 0x8fc2d7}, 
	{0x66a2, 0xc4aa}, 
	{0x66a4, 0x8fc2d8}, 
	{0x66a6, 0xcef1}, 
	{0x66ab, 0xbbc3}, 
	{0x66ad, 0x8fc2d9}, 
	{0x66ae, 0xcaeb}, 
	{0x66b1, 0x8fc2da}, 
	{0x66b2, 0x8fc2db}, 
	{0x66b4, 0xcbbd}, 
	{0x66b5, 0x8fc2dc}, 
	{0x66b8, 0xdba2}, 
	{0x66b9, 0xdafb}, 
	{0x66bb, 0x8fc2dd}, 
	{0x66bc, 0xdafe}, 
	{0x66be, 0xdafd}, 
	{0x66bf, 0x8fc2de}, 
	{0x66c0, 0x8fc2df}, 
	{0x66c1, 0xdafa}, 
	{0x66c2, 0x8fc2e0}, 
	{0x66c3, 0x8fc2e1}, 
	{0x66c4, 0xdba1}, 
	{0x66c7, 0xc6de}, 
	{0x66c8, 0x8fc2e2}, 
	{0x66c9, 0xdafc}, 
	{0x66cc, 0x8fc2e3}, 
	{0x66ce, 0x8fc2e4}, 
	{0x66cf, 0x8fc2e5}, 
	{0x66d4, 0x8fc2e6}, 
	{0x66d6, 0xdba3}, 
	{0x66d9, 0xbdec}, 
	{0x66da, 0xdba4}, 
	{0x66db, 0x8fc2e7}, 
	{0x66dc, 0xcdcb}, 
	{0x66dd, 0xc7f8}, 
	{0x66df, 0x8fc2e8}, 
	{0x66e0, 0xdba5}, 
	{0x66e6, 0xdba7}, 
	{0x66e8, 0x8fc2e9}, 
	{0x66e9, 0xdba8}, 
	{0x66eb, 0x8fc2ea}, 
	{0x66ec, 0x8fc2eb}, 
	{0x66ee, 0x8fc2ec}, 
	{0x66f0, 0xdba9}, 
	{0x66f2, 0xb6ca}, 
	{0x66f3, 0xb1c8}, 
	{0x66f4, 0xb9b9}, 
	{0x66f5, 0xdbaa}, 
	{0x66f7, 0xdbab}, 
	{0x66f8, 0xbdf1}, 
	{0x66f9, 0xc1e2}, 
	{0x66fa, 0x8fc2ed}, 
	{0x66fb, 0x8fc2bf}, 
	{0x66fc, 0xd2d8}, 
	{0x66fd, 0xc1be}, 
	{0x66fe, 0xc1bd}, 
	{0x66ff, 0xc2d8}, 
	{0x6700, 0xbac7}, 
	{0x6703, 0xd0f2}, 
	{0x6705, 0x8fc2ee}, 
	{0x6707, 0x8fc2ef}, 
	{0x6708, 0xb7ee}, 
	{0x6709, 0xcdad}, 
	{0x670b, 0xcafe}, 
	{0x670d, 0xc9fe}, 
	{0x670e, 0x8fc2f0}, 
	{0x670f, 0xdbac}, 
	{0x6713, 0x8fc2f1}, 
	{0x6714, 0xbaf3}, 
	{0x6715, 0xc4bf}, 
	{0x6716, 0xdbad}, 
	{0x6717, 0xcfaf}, 
	{0x6719, 0x8fc2f2}, 
	{0x671b, 0xcbbe}, 
	{0x671c, 0x8fc2f3}, 
	{0x671d, 0xc4ab}, 
	{0x671e, 0xdbae}, 
	{0x671f, 0xb4fc}, 
	{0x6720, 0x8fc2f4}, 
	{0x6722, 0x8fc2f5}, 
	{0x6726, 0xdbaf}, 
	{0x6727, 0xdbb0}, 
	{0x6728, 0xccda}, 
	{0x672a, 0xcca4}, 
	{0x672b, 0xcbf6}, 
	{0x672c, 0xcbdc}, 
	{0x672d, 0xbba5}, 
	{0x672e, 0xdbb2}, 
	{0x6731, 0xbceb}, 
	{0x6733, 0x8fc2f6}, 
	{0x6734, 0xcbd1}, 
	{0x6736, 0xdbb4}, 
	{0x6737, 0xdbb7}, 
	{0x6738, 0xdbb6}, 
	{0x673a, 0xb4f9}, 
	{0x673d, 0xb5e0}, 
	{0x673e, 0x8fc2f7}, 
	{0x673f, 0xdbb3}, 
	{0x6741, 0xdbb5}, 
	{0x6745, 0x8fc2f8}, 
	{0x6746, 0xdbb8}, 
	{0x6747, 0x8fc2f9}, 
	{0x6748, 0x8fc2fa}, 
	{0x6749, 0xbff9}, 
	{0x674c, 0x8fc2fb}, 
	{0x674e, 0xcdfb}, 
	{0x674f, 0xb0c9}, 
	{0x6750, 0xbae0}, 
	{0x6751, 0xc2bc}, 
	{0x6753, 0xbcdd}, 
	{0x6754, 0x8fc2fc}, 
	{0x6755, 0x8fc2fd}, 
	{0x6756, 0xbef3}, 
	{0x6759, 0xdbbb}, 
	{0x675c, 0xc5ce}, 
	{0x675d, 0x8fc2fe}, 
	{0x675e, 0xdbb9}, 
	{0x675f, 0xc2ab}, 
	{0x6760, 0xdbba}, 
	{0x6761, 0xbef2}, 
	{0x6762, 0xccdd}, 
	{0x6763, 0xdbbc}, 
	{0x6764, 0xdbbd}, 
	{0x6765, 0xcde8}, 
	{0x6766, 0x8fc3a1}, 
	{0x676a, 0xdbc2}, 
	{0x676c, 0x8fc3a2}, 
	{0x676d, 0xb9ba}, 
	{0x676e, 0x8fc3a3}, 
	{0x676f, 0xc7d5}, 
	{0x6770, 0xdbbf}, 
	{0x6771, 0xc5ec}, 
	{0x6772, 0xdade}, 
	{0x6773, 0xdae2}, 
	{0x6774, 0x8fc3a4}, 
	{0x6775, 0xb5cf}, 
	{0x6776, 0x8fc3a5}, 
	{0x6777, 0xc7c7}, 
	{0x677b, 0x8fc3a6}, 
	{0x677c, 0xdbc1}, 
	{0x677e, 0xbebe}, 
	{0x677f, 0xc8c4}, 
	{0x6781, 0x8fc3a7}, 
	{0x6784, 0x8fc3a8}, 
	{0x6785, 0xdbc7}, 
	{0x6787, 0xc8fa}, 
	{0x6789, 0xdbbe}, 
	{0x678b, 0xdbc4}, 
	{0x678c, 0xdbc3}, 
	{0x678e, 0x8fc3a9}, 
	{0x678f, 0x8fc3aa}, 
	{0x6790, 0xc0cf}, 
	{0x6791, 0x8fc3ab}, 
	{0x6793, 0x8fc3ac}, 
	{0x6795, 0xcbed}, 
	{0x6796, 0x8fc3ad}, 
	{0x6797, 0xced3}, 
	{0x6798, 0x8fc3ae}, 
	{0x6799, 0x8fc3af}, 
	{0x679a, 0xcbe7}, 
	{0x679b, 0x8fc3b0}, 
	{0x679c, 0xb2cc}, 
	{0x679d, 0xbbde}, 
	{0x67a0, 0xcfc8}, 
	{0x67a1, 0xdbc6}, 
	{0x67a2, 0xbff5}, 
	{0x67a6, 0xdbc5}, 
	{0x67a9, 0xdbc0}, 
	{0x67af, 0xb8cf}, 
	{0x67b0, 0x8fc3b1}, 
	{0x67b1, 0x8fc3b2}, 
	{0x67b2, 0x8fc3b3}, 
	{0x67b3, 0xdbcc}, 
	{0x67b4, 0xdbca}, 
	{0x67b5, 0x8fc3b4}, 
	{0x67b6, 0xb2cd}, 
	{0x67b7, 0xdbc8}, 
	{0x67b8, 0xdbce}, 
	{0x67b9, 0xdbd4}, 
	{0x67bb, 0x8fc3b5}, 
	{0x67bc, 0x8fc3b6}, 
	{0x67bd, 0x8fc3b7}, 
	{0x67c0, 0x8fc3b9}, 
	{0x67c1, 0xc2c8}, 
	{0x67c2, 0x8fc3ba}, 
	{0x67c3, 0x8fc3bb}, 
	{0x67c4, 0xcac1}, 
	{0x67c5, 0x8fc3bc}, 
	{0x67c6, 0xdbd6}, 
	{0x67c8, 0x8fc3bd}, 
	{0x67c9, 0x8fc3be}, 
	{0x67ca, 0xc9a2}, 
	{0x67ce, 0xdbd5}, 
	{0x67cf, 0xc7f0}, 
	{0x67d0, 0xcbbf}, 
	{0x67d1, 0xb4bb}, 
	{0x67d2, 0x8fc3bf}, 
	{0x67d3, 0xc0f7}, 
	{0x67d4, 0xbdc0}, 
	{0x67d7, 0x8fc3c0}, 
	{0x67d8, 0xc4d3}, 
	{0x67d9, 0x8fc3c1}, 
	{0x67da, 0xcdae}, 
	{0x67dc, 0x8fc3c2}, 
	{0x67dd, 0xdbd1}, 
	{0x67de, 0xdbd0}, 
	{0x67e1, 0x8fc3c3}, 
	{0x67e2, 0xdbd2}, 
	{0x67e4, 0xdbcf}, 
	{0x67e6, 0x8fc3c4}, 
	{0x67e7, 0xdbd7}, 
	{0x67e9, 0xdbcd}, 
	{0x67ec, 0xdbcb}, 
	{0x67ee, 0xdbd3}, 
	{0x67ef, 0xdbc9}, 
	{0x67f0, 0x8fc3c5}, 
	{0x67f1, 0xc3ec}, 
	{0x67f2, 0x8fc3c6}, 
	{0x67f3, 0xccf8}, 
	{0x67f4, 0xbcc6}, 
	{0x67f5, 0xbaf4}, 
	{0x67f6, 0x8fc3c7}, 
	{0x67f7, 0x8fc3c8}, 
	{0x67f9, 0x8fc3b8}, 
	{0x67fb, 0xbaba}, 
	{0x67fe, 0xcbef}, 
	{0x67ff, 0xb3c1}, 
	{0x6802, 0xc4ce}, 
	{0x6803, 0xc6ca}, 
	{0x6804, 0xb1c9}, 
	{0x6813, 0xc0f2}, 
	{0x6814, 0x8fc3ca}, 
	{0x6816, 0xc0b4}, 
	{0x6817, 0xb7aa}, 
	{0x6819, 0x8fc3cb}, 
	{0x681d, 0x8fc3cc}, 
	{0x681e, 0xdbd9}, 
	{0x681f, 0x8fc3cd}, 
	{0x6821, 0xb9bb}, 
	{0x6822, 0xb3fc}, 
	{0x6827, 0x8fc3cf}, 
	{0x6828, 0x8fc3ce}, 
	{0x6829, 0xdbdb}, 
	{0x682a, 0xb3f4}, 
	{0x682b, 0xdbe1}, 
	{0x682c, 0x8fc3d0}, 
	{0x682d, 0x8fc3d1}, 
	{0x682f, 0x8fc3d2}, 
	{0x6830, 0x8fc3d3}, 
	{0x6831, 0x8fc3d4}, 
	{0x6832, 0xdbde}, 
	{0x6833, 0x8fc3d5}, 
	{0x6834, 0xc0f3}, 
	{0x6838, 0xb3cb}, 
	{0x6839, 0xbaac}, 
	{0x683b, 0x8fc3d6}, 
	{0x683c, 0xb3ca}, 
	{0x683d, 0xbacf}, 
	{0x683f, 0x8fc3d7}, 
	{0x6840, 0xdbdc}, 
	{0x6841, 0xb7e5}, 
	{0x6842, 0xb7cb}, 
	{0x6843, 0xc5ed}, 
	{0x6844, 0x8fc3d8}, 
	{0x6845, 0x8fc3d9}, 
	{0x6846, 0xdbda}, 
	{0x6848, 0xb0c6}, 
	{0x684a, 0x8fc3da}, 
	{0x684c, 0x8fc3db}, 
	{0x684d, 0xdbdd}, 
	{0x684e, 0xdbdf}, 
	{0x6850, 0xb6cd}, 
	{0x6851, 0xb7ac}, 
	{0x6852, 0x8fc3c9}, 
	{0x6853, 0xb4bc}, 
	{0x6854, 0xb5cb}, 
	{0x6855, 0x8fc3dc}, 
	{0x6857, 0x8fc3dd}, 
	{0x6858, 0x8fc3de}, 
	{0x6859, 0xdbe2}, 
	{0x685b, 0x8fc3df}, 
	{0x685c, 0xbaf9}, 
	{0x685d, 0xcbf1}, 
	{0x685f, 0xbbb7}, 
	{0x6863, 0xdbe3}, 
	{0x6867, 0xc9b0}, 
	{0x686b, 0x8fc3e0}, 
	{0x686e, 0x8fc3e1}, 
	{0x686f, 0x8fc3e2}, 
	{0x6870, 0x8fc3e3}, 
	{0x6871, 0x8fc3e4}, 
	{0x6872, 0x8fc3e5}, 
	{0x6874, 0xdbef}, 
	{0x6875, 0x8fc3e6}, 
	{0x6876, 0xb2b3}, 
	{0x6877, 0xdbe4}, 
	{0x6879, 0x8fc3e7}, 
	{0x687a, 0x8fc3e8}, 
	{0x687b, 0x8fc3e9}, 
	{0x687c, 0x8fc3ea}, 
	{0x687e, 0xdbf5}, 
	{0x687f, 0xdbe5}, 
	{0x6881, 0xcec2}, 
	{0x6882, 0x8fc3eb}, 
	{0x6883, 0xdbec}, 
	{0x6884, 0x8fc3ec}, 
	{0x6885, 0xc7df}, 
	{0x6886, 0x8fc3ed}, 
	{0x6888, 0x8fc3ee}, 
	{0x688d, 0xdbf4}, 
	{0x688f, 0xdbe7}, 
	{0x6893, 0xb0b4}, 
	{0x6894, 0xdbe9}, 
	{0x6896, 0x8fc3ef}, 
	{0x6897, 0xb9bc}, 
	{0x6898, 0x8fc3f0}, 
	{0x689a, 0x8fc3f1}, 
	{0x689b, 0xdbeb}, 
	{0x689c, 0x8fc3f2}, 
	{0x689d, 0xdbea}, 
	{0x689f, 0xdbe6}, 
	{0x68a0, 0xdbf1}, 
	{0x68a1, 0x8fc3f3}, 
	{0x68a2, 0xbebf}, 
	{0x68a3, 0x8fc3f4}, 
	{0x68a5, 0x8fc3f5}, 
	{0x68a6, 0xd4ed}, 
	{0x68a7, 0xb8e8}, 
	{0x68a8, 0xcdfc}, 
	{0x68a9, 0x8fc3f6}, 
	{0x68aa, 0x8fc3f7}, 
	{0x68ad, 0xdbe8}, 
	{0x68ae, 0x8fc3f8}, 
	{0x68af, 0xc4f4}, 
	{0x68b0, 0xb3a3}, 
	{0x68b1, 0xbaad}, 
	{0x68b2, 0x8fc3f9}, 
	{0x68b3, 0xdbe0}, 
	{0x68b5, 0xdbf0}, 
	{0x68b6, 0xb3e1}, 
	{0x68b9, 0xdbee}, 
	{0x68ba, 0xdbf2}, 
	{0x68bb, 0x8fc3fa}, 
	{0x68bc, 0xc5ee}, 
	{0x68c4, 0xb4fe}, 
	{0x68c5, 0x8fc3fb}, 
	{0x68c6, 0xdcb2}, 
	{0x68c8, 0x8fc3fc}, 
	{0x68c9, 0xccc9}, 
	{0x68ca, 0xdbf7}, 
	{0x68cb, 0xb4fd}, 
	{0x68cc, 0x8fc3fd}, 
	{0x68cd, 0xdbfe}, 
	{0x68cf, 0x8fc3fe}, 
	{0x68d0, 0x8fc4a1}, 
	{0x68d1, 0x8fc4a2}, 
	{0x68d2, 0xcbc0}, 
	{0x68d3, 0x8fc4a3}, 
	{0x68d4, 0xdca1}, 
	{0x68d5, 0xdca3}, 
	{0x68d6, 0x8fc4a4}, 
	{0x68d7, 0xdca7}, 
	{0x68d8, 0xdbf9}, 
	{0x68d9, 0x8fc4a5}, 
	{0x68da, 0xc3aa}, 
	{0x68dc, 0x8fc4a6}, 
	{0x68dd, 0x8fc4a7}, 
	{0x68df, 0xc5ef}, 
	{0x68e0, 0xdcab}, 
	{0x68e1, 0xdbfc}, 
	{0x68e3, 0xdca8}, 
	{0x68e5, 0x8fc4a8}, 
	{0x68e7, 0xdca2}, 
	{0x68e8, 0x8fc4a9}, 
	{0x68ea, 0x8fc4aa}, 
	{0x68eb, 0x8fc4ab}, 
	{0x68ec, 0x8fc4ac}, 
	{0x68ed, 0x8fc4ad}, 
	{0x68ee, 0xbfb9}, 
	{0x68ef, 0xdcac}, 
	{0x68f0, 0x8fc4ae}, 
	{0x68f1, 0x8fc4af}, 
	{0x68f2, 0xc0b3}, 
	{0x68f5, 0x8fc4b0}, 
	{0x68f6, 0x8fc4b1}, 
	{0x68f9, 0xdcaa}, 
	{0x68fa, 0xb4bd}, 
	{0x68fb, 0x8fc4b2}, 
	{0x68fc, 0x8fc4b3}, 
	{0x68fd, 0x8fc4b4}, 
	{0x6900, 0xcfd0}, 
	{0x6901, 0xdbf6}, 
	{0x6904, 0xdca6}, 
	{0x6905, 0xb0d8}, 
	{0x6906, 0x8fc4b5}, 
	{0x6908, 0xdbf8}, 
	{0x6909, 0x8fc4b6}, 
	{0x690a, 0x8fc4b7}, 
	{0x690b, 0xccba}, 
	{0x690c, 0xdbfd}, 
	{0x690d, 0xbfa2}, 
	{0x690e, 0xc4c7}, 
	{0x690f, 0xdbf3}, 
	{0x6910, 0x8fc4b8}, 
	{0x6911, 0x8fc4b9}, 
	{0x6912, 0xdca5}, 
	{0x6913, 0x8fc4ba}, 
	{0x6916, 0x8fc4bb}, 
	{0x6917, 0x8fc4bc}, 
	{0x6919, 0xbffa}, 
	{0x691a, 0xdcaf}, 
	{0x691b, 0xb3f1}, 
	{0x691c, 0xb8a1}, 
	{0x6921, 0xdcb1}, 
	{0x6922, 0xdbfa}, 
	{0x6923, 0xdcb0}, 
	{0x6925, 0xdca9}, 
	{0x6926, 0xdbfb}, 
	{0x6928, 0xdcad}, 
	{0x692a, 0xdcae}, 
	{0x6930, 0xdcbf}, 
	{0x6931, 0x8fc4bd}, 
	{0x6933, 0x8fc4be}, 
	{0x6934, 0xc6ce}, 
	{0x6935, 0x8fc4bf}, 
	{0x6936, 0xdca4}, 
	{0x6938, 0x8fc4c0}, 
	{0x6939, 0xdcbb}, 
	{0x693b, 0x8fc4c1}, 
	{0x693d, 0xdcbd}, 
	{0x693f, 0xc4d8}, 
	{0x6942, 0x8fc4c2}, 
	{0x6945, 0x8fc4c3}, 
	{0x6949, 0x8fc4c4}, 
	{0x694a, 0xcdcc}, 
	{0x694e, 0x8fc4c5}, 
	{0x6953, 0xc9f6}, 
	{0x6954, 0xdcb8}, 
	{0x6955, 0xc2ca}, 
	{0x6957, 0x8fc4c6}, 
	{0x6959, 0xdcbe}, 
	{0x695a, 0xc1bf}, 
	{0x695b, 0x8fc4c7}, 
	{0x695c, 0xdcb5}, 
	{0x695d, 0xdcc2}, 
	{0x695e, 0xdcc1}, 
	{0x6960, 0xc6ef}, 
	{0x6961, 0xdcc0}, 
	{0x6962, 0xc6ea}, 
	{0x6963, 0x8fc4c8}, 
	{0x6964, 0x8fc4c9}, 
	{0x6965, 0x8fc4ca}, 
	{0x6966, 0x8fc4cb}, 
	{0x6968, 0x8fc4cc}, 
	{0x6969, 0x8fc4cd}, 
	{0x696a, 0xdcc4}, 
	{0x696b, 0xdcb7}, 
	{0x696c, 0x8fc4ce}, 
	{0x696d, 0xb6c8}, 
	{0x696e, 0xdcba}, 
	{0x696f, 0xbddd}, 
	{0x6970, 0x8fc4cf}, 
	{0x6971, 0x8fc4d0}, 
	{0x6972, 0x8fc4d1}, 
	{0x6973, 0xc7e0}, 
	{0x6974, 0xdcbc}, 
	{0x6975, 0xb6cb}, 
	{0x6977, 0xdcb4}, 
	{0x6978, 0xdcb6}, 
	{0x6979, 0xdcb3}, 
	{0x697a, 0x8fc4d2}, 
	{0x697b, 0x8fc4d3}, 
	{0x697c, 0xcfb0}, 
	{0x697d, 0xb3da}, 
	{0x697e, 0xdcb9}, 
	{0x697f, 0x8fc4d4}, 
	{0x6980, 0x8fc4d5}, 
	{0x6981, 0xdcc3}, 
	{0x6982, 0xb3b5}, 
	{0x698a, 0xbae7}, 
	{0x698d, 0x8fc4d6}, 
	{0x698e, 0xb1dd}, 
	{0x6991, 0xdcd4}, 
	{0x6992, 0x8fc4d7}, 
	{0x6994, 0xcfb1}, 
	{0x6995, 0xdcd7}, 
	{0x6996, 0x8fc4d8}, 
	{0x6998, 0x8fc4d9}, 
	{0x699b, 0xbfba}, 
	{0x699c, 0xdcd6}, 
	{0x69a0, 0xdcd5}, 
	{0x69a1, 0x8fc4da}, 
	{0x69a5, 0x8fc4db}, 
	{0x69a6, 0x8fc4dc}, 
	{0x69a7, 0xdcd2}, 
	{0x69a8, 0x8fc4dd}, 
	{0x69ab, 0x8fc4de}, 
	{0x69ad, 0x8fc4df}, 
	{0x69ae, 0xdcc6}, 
	{0x69af, 0x8fc4e0}, 
	{0x69b1, 0xdce3}, 
	{0x69b2, 0xdcc5}, 
	{0x69b4, 0xdcd8}, 
	{0x69b7, 0x8fc4e1}, 
	{0x69b8, 0x8fc4e2}, 
	{0x69ba, 0x8fc4e3}, 
	{0x69bb, 0xdcd0}, 
	{0x69bc, 0x8fc4e4}, 
	{0x69be, 0xdccb}, 
	{0x69bf, 0xdcc8}, 
	{0x69c1, 0xdcc9}, 
	{0x69c3, 0xdcd1}, 
	{0x69c5, 0x8fc4e5}, 
	{0x69c7, 0xf4a2}, 
	{0x69c8, 0x8fc4e6}, 
	{0x69ca, 0xdcce}, 
	{0x69cb, 0xb9bd}, 
	{0x69cc, 0xc4c8}, 
	{0x69cd, 0xc1e4}, 
	{0x69ce, 0xdccc}, 
	{0x69d0, 0xdcc7}, 
	{0x69d1, 0x8fc4e7}, 
	{0x69d3, 0xdcca}, 
	{0x69d6, 0x8fc4e8}, 
	{0x69d7, 0x8fc4e9}, 
	{0x69d8, 0xcdcd}, 
	{0x69d9, 0xcbea}, 
	{0x69dd, 0xdccf}, 
	{0x69de, 0xdcd9}, 
	{0x69e2, 0x8fc4ea}, 
	{0x69e5, 0x8fc4eb}, 
	{0x69e7, 0xdce1}, 
	{0x69e8, 0xdcda}, 
	{0x69eb, 0xdce7}, 
	{0x69ed, 0xdce5}, 
	{0x69ee, 0x8fc4ec}, 
	{0x69ef, 0x8fc4ed}, 
	{0x69f1, 0x8fc4ee}, 
	{0x69f2, 0xdce0}, 
	{0x69f3, 0x8fc4ef}, 
	{0x69f5, 0x8fc4f0}, 
	{0x69f9, 0xdcdf}, 
	{0x69fb, 0xc4d0}, 
	{0x69fd, 0xc1e5}, 
	{0x69fe, 0x8fc4f1}, 
	{0x69ff, 0xdcdd}, 
	{0x6a00, 0x8fc4f2}, 
	{0x6a01, 0x8fc4f3}, 
	{0x6a02, 0xdcdb}, 
	{0x6a03, 0x8fc4f4}, 
	{0x6a05, 0xdce2}, 
	{0x6a0a, 0xdce8}, 
	{0x6a0b, 0xc8f5}, 
	{0x6a0c, 0xdcee}, 
	{0x6a0f, 0x8fc4f5}, 
	{0x6a11, 0x8fc4f6}, 
	{0x6a12, 0xdce9}, 
	{0x6a13, 0xdcec}, 
	{0x6a14, 0xdce6}, 
	{0x6a15, 0x8fc4f7}, 
	{0x6a17, 0xc3f4}, 
	{0x6a19, 0xc9b8}, 
	{0x6a1a, 0x8fc4f8}, 
	{0x6a1b, 0xdcdc}, 
	{0x6a1d, 0x8fc4f9}, 
	{0x6a1e, 0xdce4}, 
	{0x6a1f, 0xbec0}, 
	{0x6a20, 0x8fc4fa}, 
	{0x6a21, 0xcccf}, 
	{0x6a22, 0xdcf8}, 
	{0x6a23, 0xdceb}, 
	{0x6a24, 0x8fc4fb}, 
	{0x6a28, 0x8fc4fc}, 
	{0x6a29, 0xb8a2}, 
	{0x6a2a, 0xb2a3}, 
	{0x6a2b, 0xb3df}, 
	{0x6a2e, 0xdcd3}, 
	{0x6a30, 0x8fc4fd}, 
	{0x6a32, 0x8fc4fe}, 
	{0x6a34, 0x8fc5a1}, 
	{0x6a35, 0xbec1}, 
	{0x6a36, 0xdcf0}, 
	{0x6a37, 0x8fc5a2}, 
	{0x6a38, 0xdcf7}, 
	{0x6a39, 0xbcf9}, 
	{0x6a3a, 0xb3f2}, 
	{0x6a3b, 0x8fc5a3}, 
	{0x6a3d, 0xc3ae}, 
	{0x6a3e, 0x8fc5a4}, 
	{0x6a3f, 0x8fc5a5}, 
	{0x6a44, 0xdced}, 
	{0x6a45, 0x8fc5a6}, 
	{0x6a46, 0x8fc5a7}, 
	{0x6a47, 0xdcf2}, 
	{0x6a48, 0xdcf6}, 
	{0x6a49, 0x8fc5a8}, 
	{0x6a4a, 0x8fc5a9}, 
	{0x6a4b, 0xb6b6}, 
	{0x6a4e, 0x8fc5aa}, 
	{0x6a50, 0x8fc5ab}, 
	{0x6a51, 0x8fc5ac}, 
	{0x6a52, 0x8fc5ad}, 
	{0x6a55, 0x8fc5ae}, 
	{0x6a56, 0x8fc5af}, 
	{0x6a58, 0xb5cc}, 
	{0x6a59, 0xdcf4}, 
	{0x6a5b, 0x8fc5b0}, 
	{0x6a5f, 0xb5a1}, 
	{0x6a61, 0xc6cb}, 
	{0x6a62, 0xdcf3}, 
	{0x6a64, 0x8fc5b1}, 
	{0x6a66, 0xdcf5}, 
	{0x6a67, 0x8fc5b2}, 
	{0x6a6a, 0x8fc5b3}, 
	{0x6a71, 0x8fc5b4}, 
	{0x6a72, 0xdcef}, 
	{0x6a73, 0x8fc5b5}, 
	{0x6a78, 0xdcf1}, 
	{0x6a7e, 0x8fc5b6}, 
	{0x6a7f, 0xb3e0}, 
	{0x6a80, 0xc3c9}, 
	{0x6a81, 0x8fc5b7}, 
	{0x6a83, 0x8fc5b8}, 
	{0x6a84, 0xdcfc}, 
	{0x6a86, 0x8fc5b9}, 
	{0x6a87, 0x8fc5ba}, 
	{0x6a89, 0x8fc5bb}, 
	{0x6a8b, 0x8fc5bc}, 
	{0x6a8d, 0xdcfa}, 
	{0x6a8e, 0xb8e9}, 
	{0x6a90, 0xdcf9}, 
	{0x6a91, 0x8fc5bd}, 
	{0x6a97, 0xdda1}, 
	{0x6a9b, 0x8fc5be}, 
	{0x6a9c, 0xdbd8}, 
	{0x6a9d, 0x8fc5bf}, 
	{0x6a9e, 0x8fc5c0}, 
	{0x6a9f, 0x8fc5c1}, 
	{0x6aa0, 0xdcfb}, 
	{0x6aa2, 0xdcfd}, 
	{0x6aa3, 0xdcfe}, 
	{0x6aa5, 0x8fc5c2}, 
	{0x6aaa, 0xddac}, 
	{0x6aab, 0x8fc5c3}, 
	{0x6aac, 0xdda8}, 
	{0x6aae, 0xdbed}, 
	{0x6aaf, 0x8fc5c4}, 
	{0x6ab0, 0x8fc5c5}, 
	{0x6ab1, 0x8fc5c6}, 
	{0x6ab3, 0xdda7}, 
	{0x6ab4, 0x8fc5c7}, 
	{0x6ab8, 0xdda6}, 
	{0x6abb, 0xdda3}, 
	{0x6abd, 0x8fc5c8}, 
	{0x6abe, 0x8fc5c9}, 
	{0x6abf, 0x8fc5ca}, 
	{0x6ac1, 0xdcea}, 
	{0x6ac2, 0xdda5}, 
	{0x6ac3, 0xdda4}, 
	{0x6ac6, 0x8fc5cb}, 
	{0x6ac8, 0x8fc5cd}, 
	{0x6ac9, 0x8fc5cc}, 
	{0x6acc, 0x8fc5ce}, 
	{0x6ad0, 0x8fc5cf}, 
	{0x6ad1, 0xddaa}, 
	{0x6ad3, 0xcfa6}, 
	{0x6ad4, 0x8fc5d0}, 
	{0x6ad5, 0x8fc5d1}, 
	{0x6ad6, 0x8fc5d2}, 
	{0x6ada, 0xddad}, 
	{0x6adb, 0xb6fb}, 
	{0x6adc, 0x8fc5d3}, 
	{0x6add, 0x8fc5d4}, 
	{0x6ade, 0xdda9}, 
	{0x6adf, 0xddab}, 
	{0x6ae4, 0x8fc5d5}, 
	{0x6ae7, 0x8fc5d6}, 
	{0x6ae8, 0xc8a7}, 
	{0x6aea, 0xddae}, 
	{0x6aec, 0x8fc5d7}, 
	{0x6af0, 0x8fc5d8}, 
	{0x6af1, 0x8fc5d9}, 
	{0x6af2, 0x8fc5da}, 
	{0x6afa, 0xddb2}, 
	{0x6afb, 0xddaf}, 
	{0x6afc, 0x8fc5db}, 
	{0x6afd, 0x8fc5dc}, 
	{0x6b02, 0x8fc5dd}, 
	{0x6b03, 0x8fc5de}, 
	{0x6b04, 0xcdf3}, 
	{0x6b05, 0xddb0}, 
	{0x6b06, 0x8fc5df}, 
	{0x6b07, 0x8fc5e0}, 
	{0x6b09, 0x8fc5e1}, 
	{0x6b0a, 0xdcde}, 
	{0x6b0f, 0x8fc5e2}, 
	{0x6b10, 0x8fc5e3}, 
	{0x6b11, 0x8fc5e4}, 
	{0x6b12, 0xddb3}, 
	{0x6b16, 0xddb4}, 
	{0x6b17, 0x8fc5e5}, 
	{0x6b1b, 0x8fc5e6}, 
	{0x6b1d, 0xb1b5}, 
	{0x6b1e, 0x8fc5e7}, 
	{0x6b1f, 0xddb6}, 
	{0x6b20, 0xb7e7}, 
	{0x6b21, 0xbca1}, 
	{0x6b23, 0xb6d5}, 
	{0x6b24, 0x8fc5e8}, 
	{0x6b27, 0xb2a4}, 
	{0x6b28, 0x8fc5e9}, 
	{0x6b2b, 0x8fc5ea}, 
	{0x6b2c, 0x8fc5eb}, 
	{0x6b2f, 0x8fc5ec}, 
	{0x6b32, 0xcddf}, 
	{0x6b35, 0x8fc5ed}, 
	{0x6b36, 0x8fc5ee}, 
	{0x6b37, 0xddb8}, 
	{0x6b38, 0xddb7}, 
	{0x6b39, 0xddba}, 
	{0x6b3a, 0xb5bd}, 
	{0x6b3b, 0x8fc5ef}, 
	{0x6b3d, 0xb6d6}, 
	{0x6b3e, 0xb4be}, 
	{0x6b3f, 0x8fc5f0}, 
	{0x6b43, 0xddbd}, 
	{0x6b46, 0x8fc5f1}, 
	{0x6b47, 0xddbc}, 
	{0x6b49, 0xddbe}, 
	{0x6b4a, 0x8fc5f2}, 
	{0x6b4c, 0xb2ce}, 
	{0x6b4d, 0x8fc5f3}, 
	{0x6b4e, 0xc3b7}, 
	{0x6b50, 0xddbf}, 
	{0x6b52, 0x8fc5f4}, 
	{0x6b53, 0xb4bf}, 
	{0x6b54, 0xddc1}, 
	{0x6b56, 0x8fc5f5}, 
	{0x6b58, 0x8fc5f6}, 
	{0x6b59, 0xddc0}, 
	{0x6b5b, 0xddc2}, 
	{0x6b5d, 0x8fc5f7}, 
	{0x6b5f, 0xddc3}, 
	{0x6b60, 0x8fc5f8}, 
	{0x6b61, 0xddc4}, 
	{0x6b62, 0xbbdf}, 
	{0x6b63, 0xc0b5}, 
	{0x6b64, 0xbaa1}, 
	{0x6b66, 0xc9f0}, 
	{0x6b67, 0x8fc5f9}, 
	{0x6b69, 0xcae2}, 
	{0x6b6a, 0xcfc4}, 
	{0x6b6b, 0x8fc5fa}, 
	{0x6b6e, 0x8fc5fb}, 
	{0x6b6f, 0xbbf5}, 
	{0x6b70, 0x8fc5fc}, 
	{0x6b73, 0xbad0}, 
	{0x6b74, 0xcef2}, 
	{0x6b75, 0x8fc5fd}, 
	{0x6b78, 0xddc5}, 
	{0x6b79, 0xddc6}, 
	{0x6b7b, 0xbbe0}, 
	{0x6b7d, 0x8fc5fe}, 
	{0x6b7e, 0x8fc6a1}, 
	{0x6b7f, 0xddc7}, 
	{0x6b80, 0xddc8}, 
	{0x6b82, 0x8fc6a2}, 
	{0x6b83, 0xddca}, 
	{0x6b84, 0xddc9}, 
	{0x6b85, 0x8fc6a3}, 
	{0x6b86, 0xcbd8}, 
	{0x6b89, 0xbdde}, 
	{0x6b8a, 0xbcec}, 
	{0x6b8b, 0xbbc4}, 
	{0x6b8d, 0xddcb}, 
	{0x6b95, 0xddcd}, 
	{0x6b96, 0xbfa3}, 
	{0x6b97, 0x8fc6a4}, 
	{0x6b98, 0xddcc}, 
	{0x6b9b, 0x8fc6a5}, 
	{0x6b9e, 0xddce}, 
	{0x6b9f, 0x8fc6a6}, 
	{0x6ba0, 0x8fc6a7}, 
	{0x6ba2, 0x8fc6a8}, 
	{0x6ba3, 0x8fc6a9}, 
	{0x6ba4, 0xddcf}, 
	{0x6ba8, 0x8fc6aa}, 
	{0x6ba9, 0x8fc6ab}, 
	{0x6baa, 0xddd0}, 
	{0x6bab, 0xddd1}, 
	{0x6bac, 0x8fc6ac}, 
	{0x6bad, 0x8fc6ad}, 
	{0x6bae, 0x8fc6ae}, 
	{0x6baf, 0xddd2}, 
	{0x6bb0, 0x8fc6af}, 
	{0x6bb1, 0xddd4}, 
	{0x6bb2, 0xddd3}, 
	{0x6bb3, 0xddd5}, 
	{0x6bb4, 0xb2a5}, 
	{0x6bb5, 0xc3ca}, 
	{0x6bb7, 0xddd6}, 
	{0x6bb8, 0x8fc6b0}, 
	{0x6bb9, 0x8fc6b1}, 
	{0x6bba, 0xbba6}, 
	{0x6bbb, 0xb3cc}, 
	{0x6bbc, 0xddd7}, 
	{0x6bbd, 0x8fc6b2}, 
	{0x6bbe, 0x8fc6b3}, 
	{0x6bbf, 0xc5c2}, 
	{0x6bc0, 0xd4cc}, 
	{0x6bc3, 0x8fc6b4}, 
	{0x6bc4, 0x8fc6b5}, 
	{0x6bc5, 0xb5a3}, 
	{0x6bc6, 0xddd8}, 
	{0x6bc9, 0x8fc6b6}, 
	{0x6bcb, 0xddd9}, 
	{0x6bcc, 0x8fc6b7}, 
	{0x6bcd, 0xcaec}, 
	{0x6bce, 0xcbe8}, 
	{0x6bd2, 0xc6c7}, 
	{0x6bd3, 0xddda}, 
	{0x6bd4, 0xc8e6}, 
	{0x6bd6, 0x8fc6b8}, 
	{0x6bd8, 0xc8fb}, 
	{0x6bda, 0x8fc6b9}, 
	{0x6bdb, 0xccd3}, 
	{0x6bdf, 0xdddb}, 
	{0x6be1, 0x8fc6ba}, 
	{0x6be3, 0x8fc6bb}, 
	{0x6be6, 0x8fc6bc}, 
	{0x6be7, 0x8fc6bd}, 
	{0x6beb, 0xdddd}, 
	{0x6bec, 0xdddc}, 
	{0x6bee, 0x8fc6be}, 
	{0x6bef, 0xdddf}, 
	{0x6bf1, 0x8fc6bf}, 
	{0x6bf3, 0xddde}, 
	{0x6bf7, 0x8fc6c0}, 
	{0x6bf9, 0x8fc6c1}, 
	{0x6bff, 0x8fc6c2}, 
	{0x6c02, 0x8fc6c3}, 
	{0x6c04, 0x8fc6c4}, 
	{0x6c05, 0x8fc6c5}, 
	{0x6c08, 0xdde1}, 
	{0x6c09, 0x8fc6c6}, 
	{0x6c0d, 0x8fc6c7}, 
	{0x6c0e, 0x8fc6c8}, 
	{0x6c0f, 0xbbe1}, 
	{0x6c10, 0x8fc6c9}, 
	{0x6c11, 0xccb1}, 
	{0x6c12, 0x8fc6ca}, 
	{0x6c13, 0xdde2}, 
	{0x6c14, 0xdde3}, 
	{0x6c17, 0xb5a4}, 
	{0x6c19, 0x8fc6cb}, 
	{0x6c1b, 0xdde4}, 
	{0x6c1f, 0x8fc6cc}, 
	{0x6c23, 0xdde6}, 
	{0x6c24, 0xdde5}, 
	{0x6c26, 0x8fc6cd}, 
	{0x6c27, 0x8fc6ce}, 
	{0x6c28, 0x8fc6cf}, 
	{0x6c2c, 0x8fc6d0}, 
	{0x6c2e, 0x8fc6d1}, 
	{0x6c33, 0x8fc6d2}, 
	{0x6c34, 0xbfe5}, 
	{0x6c35, 0x8fc6d3}, 
	{0x6c36, 0x8fc6d4}, 
	{0x6c37, 0xc9b9}, 
	{0x6c38, 0xb1ca}, 
	{0x6c3a, 0x8fc6d5}, 
	{0x6c3b, 0x8fc6d6}, 
	{0x6c3e, 0xc8c5}, 
	{0x6c3f, 0x8fc6d7}, 
	{0x6c40, 0xc4f5}, 
	{0x6c41, 0xbdc1}, 
	{0x6c42, 0xb5e1}, 
	{0x6c4a, 0x8fc6d8}, 
	{0x6c4b, 0x8fc6d9}, 
	{0x6c4d, 0x8fc6da}, 
	{0x6c4e, 0xc8c6}, 
	{0x6c4f, 0x8fc6db}, 
	{0x6c50, 0xbcae}, 
	{0x6c52, 0x8fc6dc}, 
	{0x6c54, 0x8fc6dd}, 
	{0x6c55, 0xdde8}, 
	{0x6c57, 0xb4c0}, 
	{0x6c59, 0x8fc6de}, 
	{0x6c5a, 0xb1f8}, 
	{0x6c5b, 0x8fc6df}, 
	{0x6c5c, 0x8fc6e0}, 
	{0x6c5d, 0xc6f2}, 
	{0x6c5e, 0xdde7}, 
	{0x6c5f, 0xb9be}, 
	{0x6c60, 0xc3d3}, 
	{0x6c62, 0xdde9}, 
	{0x6c67, 0x8fc7b6}, 
	{0x6c68, 0xddf1}, 
	{0x6c6a, 0xddea}, 
	{0x6c6b, 0x8fc6e1}, 
	{0x6c6d, 0x8fc6e2}, 
	{0x6c6f, 0x8fc6e3}, 
	{0x6c70, 0xc2c1}, 
	{0x6c72, 0xb5e2}, 
	{0x6c73, 0xddf2}, 
	{0x6c74, 0x8fc6e4}, 
	{0x6c76, 0x8fc6e5}, 
	{0x6c78, 0x8fc6e6}, 
	{0x6c79, 0x8fc6e7}, 
	{0x6c7a, 0xb7e8}, 
	{0x6c7b, 0x8fc6e8}, 
	{0x6c7d, 0xb5a5}, 
	{0x6c7e, 0xddf0}, 
	{0x6c81, 0xddee}, 
	{0x6c82, 0xddeb}, 
	{0x6c83, 0xcde0}, 
	{0x6c85, 0x8fc6e9}, 
	{0x6c86, 0x8fc6ea}, 
	{0x6c87, 0x8fc6eb}, 
	{0x6c88, 0xc4c0}, 
	{0x6c89, 0x8fc6ec}, 
	{0x6c8c, 0xc6d9}, 
	{0x6c8d, 0xddec}, 
	{0x6c90, 0xddf4}, 
	{0x6c92, 0xddf3}, 
	{0x6c93, 0xb7a3}, 
	{0x6c94, 0x8fc6ed}, 
	{0x6c95, 0x8fc6ee}, 
	{0x6c96, 0xb2ad}, 
	{0x6c97, 0x8fc6ef}, 
	{0x6c98, 0x8fc6f0}, 
	{0x6c99, 0xbabb}, 
	{0x6c9a, 0xdded}, 
	{0x6c9b, 0xddef}, 
	{0x6c9c, 0x8fc6f1}, 
	{0x6c9f, 0x8fc6f2}, 
	{0x6ca1, 0xcbd7}, 
	{0x6ca2, 0xc2f4}, 
	{0x6cab, 0xcbf7}, 
	{0x6cae, 0xddfc}, 
	{0x6cb0, 0x8fc6f3}, 
	{0x6cb1, 0xddfd}, 
	{0x6cb2, 0x8fc6f4}, 
	{0x6cb3, 0xb2cf}, 
	{0x6cb4, 0x8fc6f5}, 
	{0x6cb8, 0xcaa8}, 
	{0x6cb9, 0xccfd}, 
	{0x6cba, 0xdea1}, 
	{0x6cbb, 0xbca3}, 
	{0x6cbc, 0xbec2}, 
	{0x6cbd, 0xddf8}, 
	{0x6cbe, 0xddfe}, 
	{0x6cbf, 0xb1e8}, 
	{0x6cc1, 0xb6b7}, 
	{0x6cc2, 0x8fc6f6}, 
	{0x6cc4, 0xddf5}, 
	{0x6cc5, 0xddfa}, 
	{0x6cc6, 0x8fc6f7}, 
	{0x6cc9, 0xc0f4}, 
	{0x6cca, 0xc7f1}, 
	{0x6ccc, 0xc8e7}, 
	{0x6ccd, 0x8fc6f8}, 
	{0x6ccf, 0x8fc6f9}, 
	{0x6cd0, 0x8fc6fa}, 
	{0x6cd1, 0x8fc6fb}, 
	{0x6cd2, 0x8fc6fc}, 
	{0x6cd3, 0xddf7}, 
	{0x6cd4, 0x8fc6fd}, 
	{0x6cd5, 0xcba1}, 
	{0x6cd6, 0x8fc6fe}, 
	{0x6cd7, 0xddf9}, 
	{0x6cd9, 0xdea4}, 
	{0x6cda, 0x8fc7a1}, 
	{0x6cdb, 0xdea2}, 
	{0x6cdc, 0x8fc7a2}, 
	{0x6cdd, 0xddfb}, 
	{0x6ce0, 0x8fc7a3}, 
	{0x6ce1, 0xcba2}, 
	{0x6ce2, 0xc7c8}, 
	{0x6ce3, 0xb5e3}, 
	{0x6ce5, 0xc5a5}, 
	{0x6ce7, 0x8fc7a4}, 
	{0x6ce8, 0xc3ed}, 
	{0x6ce9, 0x8fc7a5}, 
	{0x6cea, 0xdea5}, 
	{0x6ceb, 0x8fc7a6}, 
	{0x6cec, 0x8fc7a7}, 
	{0x6cee, 0x8fc7a8}, 
	{0x6cef, 0xdea3}, 
	{0x6cf0, 0xc2d9}, 
	{0x6cf1, 0xddf6}, 
	{0x6cf2, 0x8fc7a9}, 
	{0x6cf3, 0xb1cb}, 
	{0x6cf4, 0x8fc7aa}, 
	{0x6d04, 0x8fc7ab}, 
	{0x6d07, 0x8fc7ac}, 
	{0x6d0a, 0x8fc7ad}, 
	{0x6d0b, 0xcdce}, 
	{0x6d0c, 0xdeb0}, 
	{0x6d0e, 0x8fc7ae}, 
	{0x6d0f, 0x8fc7af}, 
	{0x6d11, 0x8fc7b0}, 
	{0x6d12, 0xdeaf}, 
	{0x6d13, 0x8fc7b1}, 
	{0x6d17, 0xc0f6}, 
	{0x6d19, 0xdeac}, 
	{0x6d1a, 0x8fc7b2}, 
	{0x6d1b, 0xcdec}, 
	{0x6d1e, 0xc6b6}, 
	{0x6d1f, 0xdea6}, 
	{0x6d25, 0xc4c5}, 
	{0x6d26, 0x8fc7b3}, 
	{0x6d27, 0x8fc7b4}, 
	{0x6d28, 0x8fc7b5}, 
	{0x6d29, 0xb1cc}, 
	{0x6d2a, 0xb9bf}, 
	{0x6d2b, 0xdea9}, 
	{0x6d2e, 0x8fc7b7}, 
	{0x6d2f, 0x8fc7b8}, 
	{0x6d31, 0x8fc7b9}, 
	{0x6d32, 0xbda7}, 
	{0x6d33, 0xdeae}, 
	{0x6d35, 0xdead}, 
	{0x6d36, 0xdea8}, 
	{0x6d38, 0xdeab}, 
	{0x6d39, 0x8fc7ba}, 
	{0x6d3b, 0xb3e8}, 
	{0x6d3c, 0x8fc7bb}, 
	{0x6d3d, 0xdeaa}, 
	{0x6d3e, 0xc7c9}, 
	{0x6d3f, 0x8fc7bc}, 
	{0x6d41, 0xceae}, 
	{0x6d44, 0xbef4}, 
	{0x6d45, 0xc0f5}, 
	{0x6d57, 0x8fc7bd}, 
	{0x6d59, 0xdeb6}, 
	{0x6d5a, 0xdeb4}, 
	{0x6d5c, 0xc9cd}, 
	{0x6d5e, 0x8fc7be}, 
	{0x6d5f, 0x8fc7bf}, 
	{0x6d61, 0x8fc7c0}, 
	{0x6d63, 0xdeb1}, 
	{0x6d64, 0xdeb3}, 
	{0x6d65, 0x8fc7c1}, 
	{0x6d66, 0xb1ba}, 
	{0x6d67, 0x8fc7c2}, 
	{0x6d69, 0xb9c0}, 
	{0x6d6a, 0xcfb2}, 
	{0x6d6c, 0xb3bd}, 
	{0x6d6e, 0xc9e2}, 
	{0x6d6f, 0x8fc7c3}, 
	{0x6d70, 0x8fc7c4}, 
	{0x6d74, 0xcde1}, 
	{0x6d77, 0xb3a4}, 
	{0x6d78, 0xbfbb}, 
	{0x6d79, 0xdeb5}, 
	{0x6d7c, 0x8fc7c5}, 
	{0x6d82, 0x8fc7c6}, 
	{0x6d85, 0xdeba}, 
	{0x6d87, 0x8fc7c7}, 
	{0x6d88, 0xbec3}, 
	{0x6d8c, 0xcdb0}, 
	{0x6d8e, 0xdeb7}, 
	{0x6d91, 0x8fc7c8}, 
	{0x6d92, 0x8fc7c9}, 
	{0x6d93, 0xdeb2}, 
	{0x6d94, 0x8fc7ca}, 
	{0x6d95, 0xdeb8}, 
	{0x6d96, 0x8fc7cb}, 
	{0x6d97, 0x8fc7cc}, 
	{0x6d98, 0x8fc7cd}, 
	{0x6d99, 0xcede}, 
	{0x6d9b, 0xc5f3}, 
	{0x6d9c, 0xc6c2}, 
	{0x6daa, 0x8fc7ce}, 
	{0x6dac, 0x8fc7cf}, 
	{0x6daf, 0xb3b6}, 
	{0x6db2, 0xb1d5}, 
	{0x6db4, 0x8fc7d0}, 
	{0x6db5, 0xdebe}, 
	{0x6db7, 0x8fc7d1}, 
	{0x6db8, 0xdec1}, 
	{0x6db9, 0x8fc7d2}, 
	{0x6dbc, 0xcec3}, 
	{0x6dbd, 0x8fc7d3}, 
	{0x6dbf, 0x8fc7d4}, 
	{0x6dc0, 0xcde4}, 
	{0x6dc4, 0x8fc7d5}, 
	{0x6dc5, 0xdec8}, 
	{0x6dc6, 0xdec2}, 
	{0x6dc7, 0xdebf}, 
	{0x6dc8, 0x8fc7d6}, 
	{0x6dca, 0x8fc7d7}, 
	{0x6dcb, 0xced4}, 
	{0x6dcc, 0xdec5}, 
	{0x6dce, 0x8fc7d8}, 
	{0x6dcf, 0x8fc7d9}, 
	{0x6dd1, 0xbdca}, 
	{0x6dd2, 0xdec7}, 
	{0x6dd5, 0xdecc}, 
	{0x6dd6, 0x8fc7da}, 
	{0x6dd8, 0xc5f1}, 
	{0x6dd9, 0xdeca}, 
	{0x6ddb, 0x8fc7db}, 
	{0x6ddd, 0x8fc7dc}, 
	{0x6dde, 0xdec4}, 
	{0x6ddf, 0x8fc7dd}, 
	{0x6de0, 0x8fc7de}, 
	{0x6de1, 0xc3b8}, 
	{0x6de2, 0x8fc7df}, 
	{0x6de4, 0xdecb}, 
	{0x6de5, 0x8fc7e0}, 
	{0x6de6, 0xdec0}, 
	{0x6de8, 0xdec6}, 
	{0x6de9, 0x8fc7e1}, 
	{0x6dea, 0xdecd}, 
	{0x6deb, 0xb0fc}, 
	{0x6dec, 0xdec3}, 
	{0x6dee, 0xdece}, 
	{0x6def, 0x8fc7e2}, 
	{0x6df0, 0x8fc7e3}, 
	{0x6df1, 0xbfbc}, 
	{0x6df3, 0xbddf}, 
	{0x6df4, 0x8fc7e4}, 
	{0x6df5, 0xcaa5}, 
	{0x6df6, 0x8fc7e5}, 
	{0x6df7, 0xbaae}, 
	{0x6df9, 0xdebb}, 
	{0x6dfa, 0xdec9}, 
	{0x6dfb, 0xc5ba}, 
	{0x6dfc, 0x8fc7e6}, 
	{0x6e00, 0x8fc7e7}, 
	{0x6e04, 0x8fc7e8}, 
	{0x6e05, 0xc0b6}, 
	{0x6e07, 0xb3e9}, 
	{0x6e08, 0xbad1}, 
	{0x6e09, 0xbec4}, 
	{0x6e0a, 0xdebd}, 
	{0x6e0b, 0xbdc2}, 
	{0x6e13, 0xb7cc}, 
	{0x6e15, 0xdebc}, 
	{0x6e19, 0xded2}, 
	{0x6e1a, 0xbded}, 
	{0x6e1b, 0xb8ba}, 
	{0x6e1d, 0xdee1}, 
	{0x6e1e, 0x8fc7e9}, 
	{0x6e1f, 0xdedb}, 
	{0x6e20, 0xb5f4}, 
	{0x6e21, 0xc5cf}, 
	{0x6e22, 0x8fc7ea}, 
	{0x6e23, 0xded6}, 
	{0x6e24, 0xdedf}, 
	{0x6e25, 0xb0af}, 
	{0x6e26, 0xb1b2}, 
	{0x6e27, 0x8fc7eb}, 
	{0x6e29, 0xb2b9}, 
	{0x6e2b, 0xded8}, 
	{0x6e2c, 0xc2ac}, 
	{0x6e2d, 0xdecf}, 
	{0x6e2e, 0xded1}, 
	{0x6e2f, 0xb9c1}, 
	{0x6e32, 0x8fc7ec}, 
	{0x6e36, 0x8fc7ed}, 
	{0x6e38, 0xdee2}, 
	{0x6e39, 0x8fc7ee}, 
	{0x6e3a, 0xdedd}, 
	{0x6e3b, 0x8fc7ef}, 
	{0x6e3c, 0x8fc7f0}, 
	{0x6e3e, 0xded5}, 
	{0x6e43, 0xdedc}, 
	{0x6e44, 0x8fc7f1}, 
	{0x6e45, 0x8fc7f2}, 
	{0x6e48, 0x8fc7f3}, 
	{0x6e49, 0x8fc7f4}, 
	{0x6e4a, 0xccab}, 
	{0x6e4b, 0x8fc7f5}, 
	{0x6e4d, 0xdeda}, 
	{0x6e4e, 0xdede}, 
	{0x6e4f, 0x8fc7f6}, 
	{0x6e51, 0x8fc7f7}, 
	{0x6e52, 0x8fc7f8}, 
	{0x6e53, 0x8fc7f9}, 
	{0x6e54, 0x8fc7fa}, 
	{0x6e56, 0xb8d0}, 
	{0x6e57, 0x8fc7fb}, 
	{0x6e58, 0xbec5}, 
	{0x6e5b, 0xc3b9}, 
	{0x6e5c, 0x8fc7fc}, 
	{0x6e5d, 0x8fc7fd}, 
	{0x6e5e, 0x8fc7fe}, 
	{0x6e5f, 0xded4}, 
	{0x6e62, 0x8fc8a1}, 
	{0x6e63, 0x8fc8a2}, 
	{0x6e67, 0xcdaf}, 
	{0x6e68, 0x8fc8a3}, 
	{0x6e6b, 0xded7}, 
	{0x6e6e, 0xded0}, 
	{0x6e6f, 0xc5f2}, 
	{0x6e72, 0xded3}, 
	{0x6e73, 0x8fc8a4}, 
	{0x6e76, 0xded9}, 
	{0x6e7b, 0x8fc8a5}, 
	{0x6e7d, 0x8fc8a6}, 
	{0x6e7e, 0xcfd1}, 
	{0x6e7f, 0xbcbe}, 
	{0x6e80, 0xcbfe}, 
	{0x6e82, 0xdee3}, 
	{0x6e8c, 0xc8ae}, 
	{0x6e8d, 0x8fc8a7}, 
	{0x6e8f, 0xdeef}, 
	{0x6e90, 0xb8bb}, 
	{0x6e93, 0x8fc8a8}, 
	{0x6e96, 0xbde0}, 
	{0x6e98, 0xdee5}, 
	{0x6e99, 0x8fc8a9}, 
	{0x6e9c, 0xceaf}, 
	{0x6e9d, 0xb9c2}, 
	{0x6e9f, 0xdef2}, 
	{0x6ea0, 0x8fc8aa}, 
	{0x6ea2, 0xb0ee}, 
	{0x6ea5, 0xdef0}, 
	{0x6ea7, 0x8fc8ab}, 
	{0x6eaa, 0xdee4}, 
	{0x6ead, 0x8fc8ac}, 
	{0x6eae, 0x8fc8ad}, 
	{0x6eaf, 0xdeea}, 
	{0x6eb1, 0x8fc8ae}, 
	{0x6eb2, 0xdeec}, 
	{0x6eb3, 0x8fc8af}, 
	{0x6eb6, 0xcdcf}, 
	{0x6eb7, 0xdee7}, 
	{0x6eba, 0xc5ae}, 
	{0x6ebb, 0x8fc8b0}, 
	{0x6ebd, 0xdee9}, 
	{0x6ebf, 0x8fc8b1}, 
	{0x6ec0, 0x8fc8b2}, 
	{0x6ec1, 0x8fc8b3}, 
	{0x6ec2, 0xdef1}, 
	{0x6ec3, 0x8fc8b4}, 
	{0x6ec4, 0xdeeb}, 
	{0x6ec5, 0xccc7}, 
	{0x6ec7, 0x8fc8b5}, 
	{0x6ec8, 0x8fc8b6}, 
	{0x6ec9, 0xdee6}, 
	{0x6eca, 0x8fc8b7}, 
	{0x6ecb, 0xbca2}, 
	{0x6ecc, 0xdefe}, 
	{0x6ecd, 0x8fc8b8}, 
	{0x6ece, 0x8fc8b9}, 
	{0x6ecf, 0x8fc8ba}, 
	{0x6ed1, 0xb3ea}, 
	{0x6ed3, 0xdee8}, 
	{0x6ed4, 0xdeed}, 
	{0x6ed5, 0xdeee}, 
	{0x6edd, 0xc2ec}, 
	{0x6ede, 0xc2da}, 
	{0x6eeb, 0x8fc8bb}, 
	{0x6eec, 0xdef6}, 
	{0x6eed, 0x8fc8bc}, 
	{0x6eee, 0x8fc8bd}, 
	{0x6eef, 0xdefc}, 
	{0x6ef2, 0xdefa}, 
	{0x6ef4, 0xc5a9}, 
	{0x6ef7, 0xdfa3}, 
	{0x6ef8, 0xdef7}, 
	{0x6ef9, 0x8fc8be}, 
	{0x6efb, 0x8fc8bf}, 
	{0x6efd, 0x8fc8c0}, 
	{0x6efe, 0xdef8}, 
	{0x6eff, 0xdee0}, 
	{0x6f01, 0xb5f9}, 
	{0x6f02, 0xc9ba}, 
	{0x6f04, 0x8fc8c1}, 
	{0x6f06, 0xbcbf}, 
	{0x6f08, 0x8fc8c2}, 
	{0x6f09, 0xb9f7}, 
	{0x6f0a, 0x8fc8c3}, 
	{0x6f0c, 0x8fc8c4}, 
	{0x6f0d, 0x8fc8c5}, 
	{0x6f0f, 0xcfb3}, 
	{0x6f11, 0xdef4}, 
	{0x6f13, 0xdfa2}, 
	{0x6f14, 0xb1e9}, 
	{0x6f15, 0xc1e6}, 
	{0x6f16, 0x8fc8c6}, 
	{0x6f18, 0x8fc8c7}, 
	{0x6f1a, 0x8fc8c8}, 
	{0x6f1b, 0x8fc8c9}, 
	{0x6f20, 0xc7f9}, 
	{0x6f22, 0xb4c1}, 
	{0x6f23, 0xcefa}, 
	{0x6f26, 0x8fc8ca}, 
	{0x6f29, 0x8fc8cb}, 
	{0x6f2a, 0x8fc8cc}, 
	{0x6f2b, 0xcca1}, 
	{0x6f2c, 0xc4d2}, 
	{0x6f2d, 0x8fc8d3}, 
	{0x6f2f, 0x8fc8cd}, 
	{0x6f30, 0x8fc8ce}, 
	{0x6f31, 0xdefb}, 
	{0x6f32, 0xdefd}, 
	{0x6f33, 0x8fc8cf}, 
	{0x6f36, 0x8fc8d0}, 
	{0x6f38, 0xc1b2}, 
	{0x6f3b, 0x8fc8d1}, 
	{0x6f3c, 0x8fc8d2}, 
	{0x6f3e, 0xdfa1}, 
	{0x6f3f, 0xdef9}, 
	{0x6f41, 0xdef3}, 
	{0x6f45, 0xb4c3}, 
	{0x6f4f, 0x8fc8d4}, 
	{0x6f51, 0x8fc8d5}, 
	{0x6f52, 0x8fc8d6}, 
	{0x6f53, 0x8fc8d7}, 
	{0x6f54, 0xb7e9}, 
	{0x6f57, 0x8fc8d8}, 
	{0x6f58, 0xdfaf}, 
	{0x6f59, 0x8fc8d9}, 
	{0x6f5a, 0x8fc8da}, 
	{0x6f5b, 0xdfaa}, 
	{0x6f5c, 0xc0f8}, 
	{0x6f5d, 0x8fc8db}, 
	{0x6f5e, 0x8fc8dc}, 
	{0x6f5f, 0xb3e3}, 
	{0x6f61, 0x8fc8dd}, 
	{0x6f62, 0x8fc8de}, 
	{0x6f64, 0xbde1}, 
	{0x6f66, 0xdfb3}, 
	{0x6f68, 0x8fc8df}, 
	{0x6f6c, 0x8fc8e0}, 
	{0x6f6d, 0xdfac}, 
	{0x6f6e, 0xc4ac}, 
	{0x6f6f, 0xdfa9}, 
	{0x6f70, 0xc4d9}, 
	{0x6f74, 0xdfcc}, 
	{0x6f78, 0xdfa6}, 
	{0x6f7a, 0xdfa5}, 
	{0x6f7c, 0xdfae}, 
	{0x6f7d, 0x8fc8e1}, 
	{0x6f7e, 0x8fc8e2}, 
	{0x6f80, 0xdfa8}, 
	{0x6f81, 0xdfa7}, 
	{0x6f82, 0xdfad}, 
	{0x6f83, 0x8fc8e3}, 
	{0x6f84, 0xc0a1}, 
	{0x6f86, 0xdfa4}, 
	{0x6f87, 0x8fc8e4}, 
	{0x6f88, 0x8fc8e5}, 
	{0x6f8b, 0x8fc8e6}, 
	{0x6f8c, 0x8fc8e7}, 
	{0x6f8d, 0x8fc8e8}, 
	{0x6f8e, 0xdfb0}, 
	{0x6f90, 0x8fc8e9}, 
	{0x6f91, 0xdfb1}, 
	{0x6f92, 0x8fc8ea}, 
	{0x6f93, 0x8fc8eb}, 
	{0x6f94, 0x8fc8ec}, 
	{0x6f96, 0x8fc8ed}, 
	{0x6f97, 0xb4c2}, 
	{0x6f9a, 0x8fc8ee}, 
	{0x6f9f, 0x8fc8ef}, 
	{0x6fa0, 0x8fc8f0}, 
	{0x6fa1, 0xdfb6}, 
	{0x6fa3, 0xdfb5}, 
	{0x6fa4, 0xdfb7}, 
	{0x6fa5, 0x8fc8f1}, 
	{0x6fa6, 0x8fc8f2}, 
	{0x6fa7, 0x8fc8f3}, 
	{0x6fa8, 0x8fc8f4}, 
	{0x6faa, 0xdfba}, 
	{0x6fae, 0x8fc8f5}, 
	{0x6faf, 0x8fc8f6}, 
	{0x6fb0, 0x8fc8f7}, 
	{0x6fb1, 0xc5c3}, 
	{0x6fb3, 0xdfb4}, 
	{0x6fb5, 0x8fc8f8}, 
	{0x6fb6, 0x8fc8f9}, 
	{0x6fb9, 0xdfb8}, 
	{0x6fbc, 0x8fc8fa}, 
	{0x6fc0, 0xb7e3}, 
	{0x6fc1, 0xc2f9}, 
	{0x6fc2, 0xdfb2}, 
	{0x6fc3, 0xc7bb}, 
	{0x6fc5, 0x8fc8fb}, 
	{0x6fc6, 0xdfb9}, 
	{0x6fc7, 0x8fc8fc}, 
	{0x6fc8, 0x8fc8fd}, 
	{0x6fca, 0x8fc8fe}, 
	{0x6fd4, 0xdfbe}, 
	{0x6fd5, 0xdfbc}, 
	{0x6fd8, 0xdfbf}, 
	{0x6fda, 0x8fc9a1}, 
	{0x6fdb, 0xdfc2}, 
	{0x6fde, 0x8fc9a2}, 
	{0x6fdf, 0xdfbb}, 
	{0x6fe0, 0xb9ea}, 
	{0x6fe1, 0xc7a8}, 
	{0x6fe4, 0xdeb9}, 
	{0x6fe8, 0x8fc9a3}, 
	{0x6fe9, 0x8fc9a4}, 
	{0x6feb, 0xcdf4}, 
	{0x6fec, 0xdfbd}, 
	{0x6fee, 0xdfc1}, 
	{0x6fef, 0xc2f5}, 
	{0x6ff0, 0x8fc9a5}, 
	{0x6ff1, 0xdfc0}, 
	{0x6ff3, 0xdfab}, 
	{0x6ff5, 0x8fc9a6}, 
	{0x6ff6, 0xefe9}, 
	{0x6ff9, 0x8fc9a7}, 
	{0x6ffa, 0xdfc5}, 
	{0x6ffc, 0x8fc9a8}, 
	{0x6ffd, 0x8fc9a9}, 
	{0x6ffe, 0xdfc9}, 
	{0x7000, 0x8fc9aa}, 
	{0x7001, 0xdfc7}, 
	{0x7005, 0x8fc9ab}, 
	{0x7006, 0x8fc9ac}, 
	{0x7007, 0x8fc9ad}, 
	{0x7009, 0xdfc3}, 
	{0x700b, 0xdfc4}, 
	{0x700d, 0x8fc9ae}, 
	{0x700f, 0xdfc8}, 
	{0x7011, 0xdfc6}, 
	{0x7015, 0xc9ce}, 
	{0x7017, 0x8fc9af}, 
	{0x7018, 0xdfce}, 
	{0x701a, 0xdfcb}, 
	{0x701b, 0xdfca}, 
	{0x701d, 0xdfcd}, 
	{0x701e, 0xc6d4}, 
	{0x701f, 0xdfcf}, 
	{0x7020, 0x8fc9b0}, 
	{0x7023, 0x8fc9b1}, 
	{0x7026, 0xc3f5}, 
	{0x7027, 0xc2ed}, 
	{0x702c, 0xc0a5}, 
	{0x702f, 0x8fc9b2}, 
	{0x7030, 0xdfd0}, 
	{0x7032, 0xdfd2}, 
	{0x7034, 0x8fc9b3}, 
	{0x7037, 0x8fc9b4}, 
	{0x7039, 0x8fc9b5}, 
	{0x703c, 0x8fc9b6}, 
	{0x703e, 0xdfd1}, 
	{0x7043, 0x8fc9b7}, 
	{0x7044, 0x8fc9b8}, 
	{0x7048, 0x8fc9b9}, 
	{0x7049, 0x8fc9ba}, 
	{0x704a, 0x8fc9bb}, 
	{0x704b, 0x8fc9bc}, 
	{0x704c, 0xdef5}, 
	{0x704e, 0x8fc9c1}, 
	{0x7051, 0xdfd3}, 
	{0x7054, 0x8fc9bd}, 
	{0x7055, 0x8fc9be}, 
	{0x7058, 0xc6e7}, 
	{0x705d, 0x8fc9bf}, 
	{0x705e, 0x8fc9c0}, 
	{0x7063, 0xdfd4}, 
	{0x7064, 0x8fc9c2}, 
	{0x7065, 0x8fc9c3}, 
	{0x706b, 0xb2d0}, 
	{0x706c, 0x8fc9c4}, 
	{0x706e, 0x8fc9c5}, 
	{0x706f, 0xc5f4}, 
	{0x7070, 0xb3a5}, 
	{0x7075, 0x8fc9c6}, 
	{0x7076, 0x8fc9c7}, 
	{0x7078, 0xb5e4}, 
	{0x707c, 0xbcde}, 
	{0x707d, 0xbad2}, 
	{0x707e, 0x8fc9c8}, 
	{0x7081, 0x8fc9c9}, 
	{0x7085, 0x8fc9ca}, 
	{0x7086, 0x8fc9cb}, 
	{0x7089, 0xcfa7}, 
	{0x708a, 0xbfe6}, 
	{0x708e, 0xb1ea}, 
	{0x7092, 0xdfd6}, 
	{0x7094, 0x8fc9cc}, 
	{0x7095, 0x8fc9cd}, 
	{0x7096, 0x8fc9ce}, 
	{0x7097, 0x8fc9cf}, 
	{0x7098, 0x8fc9d0}, 
	{0x7099, 0xdfd5}, 
	{0x709b, 0x8fc9d1}, 
	{0x70a4, 0x8fc9d2}, 
	{0x70ab, 0x8fc9d3}, 
	{0x70ac, 0xdfd9}, 
	{0x70ad, 0xc3ba}, 
	{0x70ae, 0xdfdc}, 
	{0x70af, 0xdfd7}, 
	{0x70b0, 0x8fc9d4}, 
	{0x70b1, 0x8fc9d5}, 
	{0x70b3, 0xdfdb}, 
	{0x70b4, 0x8fc9d6}, 
	{0x70b7, 0x8fc9d7}, 
	{0x70b8, 0xdfda}, 
	{0x70b9, 0xc5c0}, 
	{0x70ba, 0xb0d9}, 
	{0x70c8, 0xcef5}, 
	{0x70ca, 0x8fc9d8}, 
	{0x70cb, 0xdfde}, 
	{0x70cf, 0xb1a8}, 
	{0x70d1, 0x8fc9d9}, 
	{0x70d3, 0x8fc9da}, 
	{0x70d4, 0x8fc9db}, 
	{0x70d5, 0x8fc9dc}, 
	{0x70d6, 0x8fc9dd}, 
	{0x70d8, 0x8fc9de}, 
	{0x70d9, 0xdfe0}, 
	{0x70dc, 0x8fc9df}, 
	{0x70dd, 0xdfdf}, 
	{0x70df, 0xdfdd}, 
	{0x70e4, 0x8fc9e0}, 
	{0x70f1, 0xdfd8}, 
	{0x70f9, 0xcba3}, 
	{0x70fa, 0x8fc9e1}, 
	{0x70fd, 0xdfe2}, 
	{0x7103, 0x8fc9e2}, 
	{0x7104, 0x8fc9e3}, 
	{0x7105, 0x8fc9e4}, 
	{0x7106, 0x8fc9e5}, 
	{0x7107, 0x8fc9e6}, 
	{0x7109, 0xdfe1}, 
	{0x710b, 0x8fc9e7}, 
	{0x710c, 0x8fc9e8}, 
	{0x710f, 0x8fc9e9}, 
	{0x7114, 0xb1eb}, 
	{0x7119, 0xdfe4}, 
	{0x711a, 0xcab2}, 
	{0x711c, 0xdfe3}, 
	{0x711e, 0x8fc9ea}, 
	{0x7120, 0x8fc9eb}, 
	{0x7121, 0xccb5}, 
	{0x7126, 0xbec7}, 
	{0x712b, 0x8fc9ec}, 
	{0x712d, 0x8fc9ed}, 
	{0x712f, 0x8fc9ee}, 
	{0x7130, 0x8fc9ef}, 
	{0x7131, 0x8fc9f0}, 
	{0x7136, 0xc1b3}, 
	{0x7138, 0x8fc9f1}, 
	{0x713c, 0xbec6}, 
	{0x7141, 0x8fc9f2}, 
	{0x7145, 0x8fc9f3}, 
	{0x7146, 0x8fc9f4}, 
	{0x7147, 0x8fc9f5}, 
	{0x7149, 0xcefb}, 
	{0x714a, 0x8fc9f6}, 
	{0x714b, 0x8fc9f7}, 
	{0x714c, 0xdfea}, 
	{0x714e, 0xc0f9}, 
	{0x7150, 0x8fc9f8}, 
	{0x7152, 0x8fc9f9}, 
	{0x7155, 0xdfe6}, 
	{0x7156, 0xdfeb}, 
	{0x7157, 0x8fc9fa}, 
	{0x7159, 0xb1ec}, 
	{0x715a, 0x8fc9fb}, 
	{0x715c, 0x8fc9fc}, 
	{0x715e, 0x8fc9fd}, 
	{0x7160, 0x8fc9fe}, 
	{0x7162, 0xdfe9}, 
	{0x7164, 0xc7e1}, 
	{0x7165, 0xdfe5}, 
	{0x7166, 0xdfe8}, 
	{0x7167, 0xbec8}, 
	{0x7168, 0x8fcaa1}, 
	{0x7169, 0xc8d1}, 
	{0x716c, 0xdfec}, 
	{0x716e, 0xbcd1}, 
	{0x7179, 0x8fcaa2}, 
	{0x717d, 0xc0fa}, 
	{0x7180, 0x8fcaa3}, 
	{0x7184, 0xdfef}, 
	{0x7185, 0x8fcaa4}, 
	{0x7187, 0x8fcaa5}, 
	{0x7188, 0xdfe7}, 
	{0x718a, 0xb7a7}, 
	{0x718c, 0x8fcaa6}, 
	{0x718f, 0xdfed}, 
	{0x7192, 0x8fcaa7}, 
	{0x7194, 0xcdd0}, 
	{0x7195, 0xdff0}, 
	{0x7199, 0xf4a6}, 
	{0x719a, 0x8fcaa8}, 
	{0x719b, 0x8fcaa9}, 
	{0x719f, 0xbdcf}, 
	{0x71a0, 0x8fcaaa}, 
	{0x71a2, 0x8fcaab}, 
	{0x71a8, 0xdff1}, 
	{0x71ac, 0xdff2}, 
	{0x71af, 0x8fcaac}, 
	{0x71b0, 0x8fcaad}, 
	{0x71b1, 0xc7ae}, 
	{0x71b2, 0x8fcaae}, 
	{0x71b3, 0x8fcaaf}, 
	{0x71b9, 0xdff4}, 
	{0x71ba, 0x8fcab0}, 
	{0x71be, 0xdff5}, 
	{0x71bf, 0x8fcab1}, 
	{0x71c0, 0x8fcab2}, 
	{0x71c1, 0x8fcab3}, 
	{0x71c3, 0xc7b3}, 
	{0x71c4, 0x8fcab4}, 
	{0x71c8, 0xc5f5}, 
	{0x71c9, 0xdff7}, 
	{0x71cb, 0x8fcab5}, 
	{0x71cc, 0x8fcab6}, 
	{0x71ce, 0xdff9}, 
	{0x71d0, 0xced5}, 
	{0x71d2, 0xdff6}, 
	{0x71d3, 0x8fcab7}, 
	{0x71d4, 0xdff8}, 
	{0x71d5, 0xb1ed}, 
	{0x71d6, 0x8fcab8}, 
	{0x71d7, 0xdff3}, 
	{0x71d9, 0x8fcab9}, 
	{0x71da, 0x8fcaba}, 
	{0x71dc, 0x8fcabb}, 
	{0x71df, 0xd3db}, 
	{0x71e0, 0xdffa}, 
	{0x71e5, 0xc1e7}, 
	{0x71e6, 0xbbb8}, 
	{0x71e7, 0xdffc}, 
	{0x71ec, 0xdffb}, 
	{0x71ed, 0xbfa4}, 
	{0x71ee, 0xd2d9}, 
	{0x71f5, 0xdffd}, 
	{0x71f8, 0x8fcabc}, 
	{0x71f9, 0xe0a1}, 
	{0x71fb, 0xdfee}, 
	{0x71fc, 0xdffe}, 
	{0x71fe, 0x8fcabd}, 
	{0x71ff, 0xe0a2}, 
	{0x7200, 0x8fcabe}, 
	{0x7206, 0xc7fa}, 
	{0x7207, 0x8fcabf}, 
	{0x7208, 0x8fcac0}, 
	{0x7209, 0x8fcac1}, 
	{0x720d, 0xe0a3}, 
	{0x7210, 0xe0a4}, 
	{0x7213, 0x8fcac2}, 
	{0x7217, 0x8fcac3}, 
	{0x721a, 0x8fcac4}, 
	{0x721b, 0xe0a5}, 
	{0x721d, 0x8fcac5}, 
	{0x721f, 0x8fcac6}, 
	{0x7224, 0x8fcac7}, 
	{0x7228, 0xe0a6}, 
	{0x722a, 0xc4de}, 
	{0x722b, 0x8fcac8}, 
	{0x722c, 0xe0a8}, 
	{0x722d, 0xe0a7}, 
	{0x722f, 0x8fcac9}, 
	{0x7230, 0xe0a9}, 
	{0x7232, 0xe0aa}, 
	{0x7234, 0x8fcaca}, 
	{0x7235, 0xbcdf}, 
	{0x7236, 0xc9e3}, 
	{0x7238, 0x8fcacb}, 
	{0x7239, 0x8fcacc}, 
	{0x723a, 0xccec}, 
	{0x723b, 0xe0ab}, 
	{0x723c, 0xe0ac}, 
	{0x723d, 0xc1d6}, 
	{0x723e, 0xbca4}, 
	{0x723f, 0xe0ad}, 
	{0x7240, 0xe0ae}, 
	{0x7241, 0x8fcacd}, 
	{0x7242, 0x8fcace}, 
	{0x7243, 0x8fcacf}, 
	{0x7245, 0x8fcad0}, 
	{0x7246, 0xe0af}, 
	{0x7247, 0xcad2}, 
	{0x7248, 0xc8c7}, 
	{0x724b, 0xe0b0}, 
	{0x724c, 0xc7d7}, 
	{0x724e, 0x8fcad1}, 
	{0x724f, 0x8fcad2}, 
	{0x7250, 0x8fcad3}, 
	{0x7252, 0xc4ad}, 
	{0x7253, 0x8fcad4}, 
	{0x7255, 0x8fcad5}, 
	{0x7256, 0x8fcad6}, 
	{0x7258, 0xe0b1}, 
	{0x7259, 0xb2e7}, 
	{0x725a, 0x8fcad7}, 
	{0x725b, 0xb5ed}, 
	{0x725c, 0x8fcad8}, 
	{0x725d, 0xccc6}, 
	{0x725e, 0x8fcad9}, 
	{0x725f, 0xccb6}, 
	{0x7260, 0x8fcada}, 
	{0x7261, 0xb2b4}, 
	{0x7262, 0xcfb4}, 
	{0x7263, 0x8fcadb}, 
	{0x7267, 0xcbd2}, 
	{0x7268, 0x8fcadc}, 
	{0x7269, 0xcaaa}, 
	{0x726b, 0x8fcadd}, 
	{0x726e, 0x8fcade}, 
	{0x726f, 0x8fcadf}, 
	{0x7271, 0x8fcae0}, 
	{0x7272, 0xc0b7}, 
	{0x7274, 0xe0b2}, 
	{0x7277, 0x8fcae1}, 
	{0x7278, 0x8fcae2}, 
	{0x7279, 0xc6c3}, 
	{0x727b, 0x8fcae3}, 
	{0x727c, 0x8fcae4}, 
	{0x727d, 0xb8a3}, 
	{0x727e, 0xe0b3}, 
	{0x727f, 0x8fcae5}, 
	{0x7280, 0xbad4}, 
	{0x7281, 0xe0b5}, 
	{0x7282, 0xe0b4}, 
	{0x7284, 0x8fcae6}, 
	{0x7287, 0xe0b6}, 
	{0x7289, 0x8fcae7}, 
	{0x728d, 0x8fcae8}, 
	{0x728e, 0x8fcae9}, 
	{0x7292, 0xe0b7}, 
	{0x7293, 0x8fcaea}, 
	{0x7296, 0xe0b8}, 
	{0x729b, 0x8fcaeb}, 
	{0x72a0, 0xb5be}, 
	{0x72a2, 0xe0b9}, 
	{0x72a7, 0xe0ba}, 
	{0x72a8, 0x8fcaec}, 
	{0x72ac, 0xb8a4}, 
	{0x72ad, 0x8fcaed}, 
	{0x72ae, 0x8fcaee}, 
	{0x72af, 0xc8c8}, 
	{0x72b1, 0x8fcaef}, 
	{0x72b2, 0xe0bc}, 
	{0x72b4, 0x8fcaf0}, 
	{0x72b6, 0xbef5}, 
	{0x72b9, 0xe0bb}, 
	{0x72be, 0x8fcaf1}, 
	{0x72c1, 0x8fcaf2}, 
	{0x72c2, 0xb6b8}, 
	{0x72c3, 0xe0bd}, 
	{0x72c4, 0xe0bf}, 
	{0x72c6, 0xe0be}, 
	{0x72c7, 0x8fcaf3}, 
	{0x72c9, 0x8fcaf4}, 
	{0x72cc, 0x8fcaf5}, 
	{0x72ce, 0xe0c0}, 
	{0x72d0, 0xb8d1}, 
	{0x72d2, 0xe0c1}, 
	{0x72d5, 0x8fcaf6}, 
	{0x72d6, 0x8fcaf7}, 
	{0x72d7, 0xb6e9}, 
	{0x72d8, 0x8fcaf8}, 
	{0x72d9, 0xc1c0}, 
	{0x72db, 0xb9fd}, 
	{0x72df, 0x8fcaf9}, 
	{0x72e0, 0xe0c3}, 
	{0x72e1, 0xe0c4}, 
	{0x72e2, 0xe0c2}, 
	{0x72e5, 0x8fcafa}, 
	{0x72e9, 0xbced}, 
	{0x72ec, 0xc6c8}, 
	{0x72ed, 0xb6b9}, 
	{0x72f3, 0x8fcafb}, 
	{0x72f4, 0x8fcafc}, 
	{0x72f7, 0xe0c6}, 
	{0x72f8, 0xc3ac}, 
	{0x72f9, 0xe0c5}, 
	{0x72fa, 0x8fcafd}, 
	{0x72fb, 0x8fcafe}, 
	{0x72fc, 0xcfb5}, 
	{0x72fd, 0xc7e2}, 
	{0x72fe, 0x8fcba1}, 
	{0x7302, 0x8fcba2}, 
	{0x7304, 0x8fcba3}, 
	{0x7305, 0x8fcba4}, 
	{0x7307, 0x8fcba5}, 
	{0x730a, 0xe0c9}, 
	{0x730b, 0x8fcba6}, 
	{0x730d, 0x8fcba7}, 
	{0x7312, 0x8fcba8}, 
	{0x7313, 0x8fcba9}, 
	{0x7316, 0xe0cb}, 
	{0x7317, 0xe0c8}, 
	{0x7318, 0x8fcbaa}, 
	{0x7319, 0x8fcbab}, 
	{0x731b, 0xccd4}, 
	{0x731c, 0xe0ca}, 
	{0x731d, 0xe0cc}, 
	{0x731e, 0x8fcbac}, 
	{0x731f, 0xcec4}, 
	{0x7322, 0x8fcbad}, 
	{0x7324, 0x8fcbae}, 
	{0x7325, 0xe0d0}, 
	{0x7327, 0x8fcbaf}, 
	{0x7328, 0x8fcbb0}, 
	{0x7329, 0xe0cf}, 
	{0x732a, 0xc3f6}, 
	{0x732b, 0xc7ad}, 
	{0x732c, 0x8fcbb1}, 
	{0x732e, 0xb8a5}, 
	{0x732f, 0xe0ce}, 
	{0x7331, 0x8fcbb2}, 
	{0x7332, 0x8fcbb3}, 
	{0x7334, 0xe0cd}, 
	{0x7335, 0x8fcbb4}, 
	{0x7336, 0xcdb1}, 
	{0x7337, 0xcdb2}, 
	{0x733a, 0x8fcbb5}, 
	{0x733b, 0x8fcbb6}, 
	{0x733d, 0x8fcbb7}, 
	{0x733e, 0xe0d1}, 
	{0x733f, 0xb1ee}, 
	{0x7343, 0x8fcbb8}, 
	{0x7344, 0xb9f6}, 
	{0x7345, 0xbbe2}, 
	{0x734d, 0x8fcbb9}, 
	{0x734e, 0xe0d2}, 
	{0x734f, 0xe0d3}, 
	{0x7350, 0x8fcbba}, 
	{0x7352, 0x8fcbbb}, 
	{0x7356, 0x8fcbbc}, 
	{0x7357, 0xe0d5}, 
	{0x7358, 0x8fcbbd}, 
	{0x735d, 0x8fcbbe}, 
	{0x735e, 0x8fcbbf}, 
	{0x735f, 0x8fcbc0}, 
	{0x7360, 0x8fcbc1}, 
	{0x7363, 0xbdc3}, 
	{0x7366, 0x8fcbc2}, 
	{0x7367, 0x8fcbc3}, 
	{0x7368, 0xe0d7}, 
	{0x7369, 0x8fcbc4}, 
	{0x736a, 0xe0d6}, 
	{0x736b, 0x8fcbc5}, 
	{0x736c, 0x8fcbc6}, 
	{0x736e, 0x8fcbc7}, 
	{0x736f, 0x8fcbc8}, 
	{0x7370, 0xe0d8}, 
	{0x7371, 0x8fcbc9}, 
	{0x7372, 0xb3cd}, 
	{0x7375, 0xe0da}, 
	{0x7377, 0x8fcbca}, 
	{0x7378, 0xe0d9}, 
	{0x7379, 0x8fcbcb}, 
	{0x737a, 0xe0dc}, 
	{0x737b, 0xe0db}, 
	{0x737c, 0x8fcbcc}, 
	{0x7380, 0x8fcbcd}, 
	{0x7381, 0x8fcbce}, 
	{0x7383, 0x8fcbcf}, 
	{0x7384, 0xb8bc}, 
	{0x7385, 0x8fcbd0}, 
	{0x7386, 0x8fcbd1}, 
	{0x7387, 0xcea8}, 
	{0x7389, 0xb6cc}, 
	{0x738b, 0xb2a6}, 
	{0x738e, 0x8fcbd2}, 
	{0x7390, 0x8fcbd3}, 
	{0x7393, 0x8fcbd4}, 
	{0x7395, 0x8fcbd5}, 
	{0x7396, 0xb6ea}, 
	{0x7397, 0x8fcbd6}, 
	{0x7398, 0x8fcbd7}, 
	{0x739c, 0x8fcbd8}, 
	{0x739e, 0x8fcbd9}, 
	{0x739f, 0x8fcbda}, 
	{0x73a0, 0x8fcbdb}, 
	{0x73a2, 0x8fcbdc}, 
	{0x73a5, 0x8fcbdd}, 
	{0x73a6, 0x8fcbde}, 
	{0x73a9, 0xb4e1}, 
	{0x73aa, 0x8fcbdf}, 
	{0x73ab, 0x8fcbe0}, 
	{0x73ad, 0x8fcbe1}, 
	{0x73b2, 0xcee8}, 
	{0x73b3, 0xe0de}, 
	{0x73b5, 0x8fcbe2}, 
	{0x73b7, 0x8fcbe3}, 
	{0x73b9, 0x8fcbe4}, 
	{0x73bb, 0xe0e0}, 
	{0x73bc, 0x8fcbe5}, 
	{0x73bd, 0x8fcbe6}, 
	{0x73bf, 0x8fcbe7}, 
	{0x73c0, 0xe0e1}, 
	{0x73c2, 0xb2d1}, 
	{0x73c5, 0x8fcbe8}, 
	{0x73c6, 0x8fcbe9}, 
	{0x73c8, 0xe0dd}, 
	{0x73c9, 0x8fcbea}, 
	{0x73ca, 0xbbb9}, 
	{0x73cb, 0x8fcbeb}, 
	{0x73cc, 0x8fcbec}, 
	{0x73cd, 0xc4c1}, 
	{0x73ce, 0xe0df}, 
	{0x73cf, 0x8fcbed}, 
	{0x73d2, 0x8fcbee}, 
	{0x73d3, 0x8fcbef}, 
	{0x73d6, 0x8fcbf0}, 
	{0x73d9, 0x8fcbf1}, 
	{0x73dd, 0x8fcbf2}, 
	{0x73de, 0xe0e4}, 
	{0x73e0, 0xbcee}, 
	{0x73e1, 0x8fcbf3}, 
	{0x73e3, 0x8fcbf4}, 
	{0x73e5, 0xe0e2}, 
	{0x73e6, 0x8fcbf5}, 
	{0x73e7, 0x8fcbf6}, 
	{0x73e9, 0x8fcbf7}, 
	{0x73ea, 0xb7be}, 
	{0x73ed, 0xc8c9}, 
	{0x73ee, 0xe0e3}, 
	{0x73f1, 0xe0fe}, 
	{0x73f4, 0x8fcbf8}, 
	{0x73f5, 0x8fcbf9}, 
	{0x73f7, 0x8fcbfa}, 
	{0x73f8, 0xe0e9}, 
	{0x73f9, 0x8fcbfb}, 
	{0x73fa, 0x8fcbfc}, 
	{0x73fb, 0x8fcbfd}, 
	{0x73fd, 0x8fcbfe}, 
	{0x73fe, 0xb8bd}, 
	{0x73ff, 0x8fcca1}, 
	{0x7400, 0x8fcca2}, 
	{0x7401, 0x8fcca3}, 
	{0x7403, 0xb5e5}, 
	{0x7404, 0x8fcca4}, 
	{0x7405, 0xe0e6}, 
	{0x7406, 0xcdfd}, 
	{0x7407, 0x8fcca5}, 
	{0x7409, 0xceb0}, 
	{0x740a, 0x8fcca6}, 
	{0x7411, 0x8fcca7}, 
	{0x741a, 0x8fcca8}, 
	{0x741b, 0x8fcca9}, 
	{0x7422, 0xc2f6}, 
	{0x7424, 0x8fccaa}, 
	{0x7425, 0xe0e8}, 
	{0x7426, 0x8fccab}, 
	{0x7428, 0x8fccac}, 
	{0x7429, 0x8fccad}, 
	{0x742a, 0x8fccae}, 
	{0x742b, 0x8fccaf}, 
	{0x742c, 0x8fccb0}, 
	{0x742d, 0x8fccb1}, 
	{0x742e, 0x8fccb2}, 
	{0x742f, 0x8fccb3}, 
	{0x7430, 0x8fccb4}, 
	{0x7431, 0x8fccb5}, 
	{0x7432, 0xe0ea}, 
	{0x7433, 0xced6}, 
	{0x7434, 0xb6d7}, 
	{0x7435, 0xc8fc}, 
	{0x7436, 0xc7ca}, 
	{0x7439, 0x8fccb6}, 
	{0x743a, 0xe0eb}, 
	{0x743f, 0xe0ed}, 
	{0x7440, 0x8fccb7}, 
	{0x7441, 0xe0f0}, 
	{0x7443, 0x8fccb8}, 
	{0x7444, 0x8fccb9}, 
	{0x7446, 0x8fccba}, 
	{0x7447, 0x8fccbb}, 
	{0x744b, 0x8fccbc}, 
	{0x744d, 0x8fccbd}, 
	{0x7451, 0x8fccbe}, 
	{0x7452, 0x8fccbf}, 
	{0x7455, 0xe0ec}, 
	{0x7457, 0x8fccc0}, 
	{0x7459, 0xe0ef}, 
	{0x745a, 0xb8ea}, 
	{0x745b, 0xb1cd}, 
	{0x745c, 0xe0f1}, 
	{0x745d, 0x8fccc1}, 
	{0x745e, 0xbff0}, 
	{0x745f, 0xe0ee}, 
	{0x7460, 0xcedc}, 
	{0x7462, 0x8fccc2}, 
	{0x7463, 0xe0f4}, 
	{0x7464, 0xf4a4}, 
	{0x7466, 0x8fccc3}, 
	{0x7467, 0x8fccc4}, 
	{0x7468, 0x8fccc5}, 
	{0x7469, 0xe0f2}, 
	{0x746a, 0xe0f5}, 
	{0x746b, 0x8fccc6}, 
	{0x746d, 0x8fccc7}, 
	{0x746e, 0x8fccc8}, 
	{0x746f, 0xe0e7}, 
	{0x7470, 0xe0f3}, 
	{0x7471, 0x8fccc9}, 
	{0x7472, 0x8fccca}, 
	{0x7473, 0xbabc}, 
	{0x7476, 0xe0f6}, 
	{0x747e, 0xe0f7}, 
	{0x7480, 0x8fcccb}, 
	{0x7481, 0x8fcccc}, 
	{0x7483, 0xcdfe}, 
	{0x7485, 0x8fcccd}, 
	{0x7486, 0x8fccce}, 
	{0x7487, 0x8fcccf}, 
	{0x7489, 0x8fccd0}, 
	{0x748b, 0xe0f8}, 
	{0x748f, 0x8fccd1}, 
	{0x7490, 0x8fccd2}, 
	{0x7491, 0x8fccd3}, 
	{0x7492, 0x8fccd4}, 
	{0x7498, 0x8fccd5}, 
	{0x7499, 0x8fccd6}, 
	{0x749a, 0x8fccd7}, 
	{0x749c, 0x8fccd8}, 
	{0x749e, 0xe0f9}, 
	{0x749f, 0x8fccd9}, 
	{0x74a0, 0x8fccda}, 
	{0x74a1, 0x8fccdb}, 
	{0x74a2, 0xe0e5}, 
	{0x74a3, 0x8fccdc}, 
	{0x74a6, 0x8fccdd}, 
	{0x74a7, 0xe0fa}, 
	{0x74a8, 0x8fccde}, 
	{0x74a9, 0x8fccdf}, 
	{0x74aa, 0x8fcce0}, 
	{0x74ab, 0x8fcce1}, 
	{0x74ae, 0x8fcce2}, 
	{0x74af, 0x8fcce3}, 
	{0x74b0, 0xb4c4}, 
	{0x74b1, 0x8fcce4}, 
	{0x74b2, 0x8fcce5}, 
	{0x74b5, 0x8fcce6}, 
	{0x74b9, 0x8fcce7}, 
	{0x74bb, 0x8fcce8}, 
	{0x74bd, 0xbca5}, 
	{0x74bf, 0x8fcce9}, 
	{0x74c8, 0x8fccea}, 
	{0x74c9, 0x8fcceb}, 
	{0x74ca, 0xe0fb}, 
	{0x74cc, 0x8fccec}, 
	{0x74cf, 0xe0fc}, 
	{0x74d0, 0x8fcced}, 
	{0x74d3, 0x8fccee}, 
	{0x74d4, 0xe0fd}, 
	{0x74d8, 0x8fccef}, 
	{0x74da, 0x8fccf0}, 
	{0x74db, 0x8fccf1}, 
	{0x74dc, 0xb1bb}, 
	{0x74de, 0x8fccf2}, 
	{0x74df, 0x8fccf3}, 
	{0x74e0, 0xe1a1}, 
	{0x74e2, 0xc9bb}, 
	{0x74e3, 0xe1a2}, 
	{0x74e4, 0x8fccf4}, 
	{0x74e6, 0xb4a4}, 
	{0x74e7, 0xe1a3}, 
	{0x74e8, 0x8fccf5}, 
	{0x74e9, 0xe1a4}, 
	{0x74ea, 0x8fccf6}, 
	{0x74eb, 0x8fccf7}, 
	{0x74ee, 0xe1a5}, 
	{0x74ef, 0x8fccf8}, 
	{0x74f0, 0xe1a7}, 
	{0x74f1, 0xe1a8}, 
	{0x74f2, 0xe1a6}, 
	{0x74f4, 0x8fccf9}, 
	{0x74f6, 0xc9d3}, 
	{0x74f7, 0xe1aa}, 
	{0x74f8, 0xe1a9}, 
	{0x74fa, 0x8fccfa}, 
	{0x74fb, 0x8fccfb}, 
	{0x74fc, 0x8fccfc}, 
	{0x74ff, 0x8fccfd}, 
	{0x7503, 0xe1ac}, 
	{0x7504, 0xe1ab}, 
	{0x7505, 0xe1ad}, 
	{0x7506, 0x8fccfe}, 
	{0x750c, 0xe1ae}, 
	{0x750d, 0xe1b0}, 
	{0x750e, 0xe1af}, 
	{0x7511, 0xb9f9}, 
	{0x7512, 0x8fcda1}, 
	{0x7513, 0xe1b2}, 
	{0x7515, 0xe1b1}, 
	{0x7516, 0x8fcda2}, 
	{0x7517, 0x8fcda3}, 
	{0x7518, 0xb4c5}, 
	{0x751a, 0xbfd3}, 
	{0x751c, 0xc5bc}, 
	{0x751e, 0xe1b3}, 
	{0x751f, 0xc0b8}, 
	{0x7520, 0x8fcda4}, 
	{0x7521, 0x8fcda5}, 
	{0x7523, 0xbbba}, 
	{0x7524, 0x8fcda6}, 
	{0x7525, 0xb1f9}, 
	{0x7526, 0xe1b4}, 
	{0x7527, 0x8fcda7}, 
	{0x7528, 0xcdd1}, 
	{0x7529, 0x8fcda8}, 
	{0x752a, 0x8fcda9}, 
	{0x752b, 0xcae3}, 
	{0x752c, 0xe1b5}, 
	{0x752f, 0x8fcdaa}, 
	{0x7530, 0xc5c4}, 
	{0x7531, 0xcdb3}, 
	{0x7532, 0xb9c3}, 
	{0x7533, 0xbfbd}, 
	{0x7536, 0x8fcdab}, 
	{0x7537, 0xc3cb}, 
	{0x7538, 0xd2b4}, 
	{0x7539, 0x8fcdac}, 
	{0x753a, 0xc4ae}, 
	{0x753b, 0xb2e8}, 
	{0x753c, 0xe1b6}, 
	{0x753d, 0x8fcdad}, 
	{0x753e, 0x8fcdae}, 
	{0x753f, 0x8fcdaf}, 
	{0x7540, 0x8fcdb0}, 
	{0x7543, 0x8fcdb1}, 
	{0x7544, 0xe1b7}, 
	{0x7546, 0xe1bc}, 
	{0x7547, 0x8fcdb2}, 
	{0x7548, 0x8fcdb3}, 
	{0x7549, 0xe1ba}, 
	{0x754a, 0xe1b9}, 
	{0x754b, 0xdac2}, 
	{0x754c, 0xb3a6}, 
	{0x754d, 0xe1b8}, 
	{0x754e, 0x8fcdb4}, 
	{0x754f, 0xb0da}, 
	{0x7550, 0x8fcdb5}, 
	{0x7551, 0xc8aa}, 
	{0x7552, 0x8fcdb6}, 
	{0x7554, 0xc8ca}, 
	{0x7557, 0x8fcdb7}, 
	{0x7559, 0xceb1}, 
	{0x755a, 0xe1bd}, 
	{0x755b, 0xe1bb}, 
	{0x755c, 0xc3dc}, 
	{0x755d, 0xc0a6}, 
	{0x755e, 0x8fcdb8}, 
	{0x755f, 0x8fcdb9}, 
	{0x7560, 0xc8ab}, 
	{0x7561, 0x8fcdba}, 
	{0x7562, 0xc9ad}, 
	{0x7564, 0xe1bf}, 
	{0x7565, 0xceac}, 
	{0x7566, 0xb7cd}, 
	{0x7567, 0xe1c0}, 
	{0x7569, 0xe1be}, 
	{0x756a, 0xc8d6}, 
	{0x756b, 0xe1c1}, 
	{0x756d, 0xe1c2}, 
	{0x756f, 0x8fcdbb}, 
	{0x7570, 0xb0db}, 
	{0x7571, 0x8fcdbc}, 
	{0x7573, 0xbef6}, 
	{0x7574, 0xe1c7}, 
	{0x7576, 0xe1c4}, 
	{0x7577, 0xc6ed}, 
	{0x7578, 0xe1c3}, 
	{0x7579, 0x8fcdbd}, 
	{0x757a, 0x8fcdbe}, 
	{0x757b, 0x8fcdbf}, 
	{0x757c, 0x8fcdc0}, 
	{0x757d, 0x8fcdc1}, 
	{0x757e, 0x8fcdc2}, 
	{0x757f, 0xb5a6}, 
	{0x7581, 0x8fcdc3}, 
	{0x7582, 0xe1ca}, 
	{0x7585, 0x8fcdc4}, 
	{0x7586, 0xe1c5}, 
	{0x7587, 0xe1c6}, 
	{0x7589, 0xe1c9}, 
	{0x758a, 0xe1c8}, 
	{0x758b, 0xc9a5}, 
	{0x758e, 0xc1c2}, 
	{0x758f, 0xc1c1}, 
	{0x7590, 0x8fcdc5}, 
	{0x7591, 0xb5bf}, 
	{0x7592, 0x8fcdc6}, 
	{0x7593, 0x8fcdc7}, 
	{0x7594, 0xe1cb}, 
	{0x7595, 0x8fcdc8}, 
	{0x7599, 0x8fcdc9}, 
	{0x759a, 0xe1cc}, 
	{0x759c, 0x8fcdca}, 
	{0x759d, 0xe1cd}, 
	{0x75a2, 0x8fcdcb}, 
	{0x75a3, 0xe1cf}, 
	{0x75a4, 0x8fcdcc}, 
	{0x75a5, 0xe1ce}, 
	{0x75ab, 0xb1d6}, 
	{0x75b1, 0xe1d7}, 
	{0x75b2, 0xc8e8}, 
	{0x75b3, 0xe1d1}, 
	{0x75b4, 0x8fcdcd}, 
	{0x75b5, 0xe1d3}, 
	{0x75b8, 0xe1d5}, 
	{0x75b9, 0xbfbe}, 
	{0x75ba, 0x8fcdce}, 
	{0x75bc, 0xe1d6}, 
	{0x75bd, 0xe1d4}, 
	{0x75be, 0xbcc0}, 
	{0x75bf, 0x8fcdcf}, 
	{0x75c0, 0x8fcdd0}, 
	{0x75c1, 0x8fcdd1}, 
	{0x75c2, 0xe1d0}, 
	{0x75c3, 0xe1d2}, 
	{0x75c4, 0x8fcdd2}, 
	{0x75c5, 0xc9c2}, 
	{0x75c6, 0x8fcdd3}, 
	{0x75c7, 0xbec9}, 
	{0x75ca, 0xe1d9}, 
	{0x75cc, 0x8fcdd4}, 
	{0x75cd, 0xe1d8}, 
	{0x75ce, 0x8fcdd5}, 
	{0x75cf, 0x8fcdd6}, 
	{0x75d2, 0xe1da}, 
	{0x75d4, 0xbca6}, 
	{0x75d5, 0xbaaf}, 
	{0x75d7, 0x8fcdd7}, 
	{0x75d8, 0xc5f7}, 
	{0x75d9, 0xe1db}, 
	{0x75db, 0xc4cb}, 
	{0x75dc, 0x8fcdd8}, 
	{0x75de, 0xe1dd}, 
	{0x75df, 0x8fcdd9}, 
	{0x75e0, 0x8fcdda}, 
	{0x75e1, 0x8fcddb}, 
	{0x75e2, 0xcea1}, 
	{0x75e3, 0xe1dc}, 
	{0x75e4, 0x8fcddc}, 
	{0x75e7, 0x8fcddd}, 
	{0x75e9, 0xc1e9}, 
	{0x75ec, 0x8fcdde}, 
	{0x75ee, 0x8fcddf}, 
	{0x75ef, 0x8fcde0}, 
	{0x75f0, 0xe1e2}, 
	{0x75f1, 0x8fcde1}, 
	{0x75f2, 0xe1e4}, 
	{0x75f3, 0xe1e5}, 
	{0x75f4, 0xc3d4}, 
	{0x75f9, 0x8fcde2}, 
	{0x75fa, 0xe1e3}, 
	{0x75fc, 0xe1e0}, 
	{0x75fe, 0xe1de}, 
	{0x75ff, 0xe1df}, 
	{0x7600, 0x8fcde3}, 
	{0x7601, 0xe1e1}, 
	{0x7602, 0x8fcde4}, 
	{0x7603, 0x8fcde5}, 
	{0x7604, 0x8fcde6}, 
	{0x7607, 0x8fcde7}, 
	{0x7608, 0x8fcde8}, 
	{0x7609, 0xe1e8}, 
	{0x760a, 0x8fcde9}, 
	{0x760b, 0xe1e6}, 
	{0x760c, 0x8fcdea}, 
	{0x760d, 0xe1e7}, 
	{0x760f, 0x8fcdeb}, 
	{0x7612, 0x8fcdec}, 
	{0x7613, 0x8fcded}, 
	{0x7615, 0x8fcdee}, 
	{0x7616, 0x8fcdef}, 
	{0x7619, 0x8fcdf0}, 
	{0x761b, 0x8fcdf1}, 
	{0x761c, 0x8fcdf2}, 
	{0x761d, 0x8fcdf3}, 
	{0x761e, 0x8fcdf4}, 
	{0x761f, 0xe1e9}, 
	{0x7620, 0xe1eb}, 
	{0x7621, 0xe1ec}, 
	{0x7622, 0xe1ed}, 
	{0x7623, 0x8fcdf5}, 
	{0x7624, 0xe1ee}, 
	{0x7625, 0x8fcdf6}, 
	{0x7626, 0x8fcdf7}, 
	{0x7627, 0xe1ea}, 
	{0x7629, 0x8fcdf8}, 
	{0x762d, 0x8fcdf9}, 
	{0x7630, 0xe1f0}, 
	{0x7632, 0x8fcdfa}, 
	{0x7633, 0x8fcdfb}, 
	{0x7634, 0xe1ef}, 
	{0x7635, 0x8fcdfc}, 
	{0x7638, 0x8fcdfd}, 
	{0x7639, 0x8fcdfe}, 
	{0x763a, 0x8fcea1}, 
	{0x763b, 0xe1f1}, 
	{0x763c, 0x8fcea2}, 
	{0x7640, 0x8fcea4}, 
	{0x7641, 0x8fcea5}, 
	{0x7642, 0xcec5}, 
	{0x7643, 0x8fcea6}, 
	{0x7644, 0x8fcea7}, 
	{0x7645, 0x8fcea8}, 
	{0x7646, 0xe1f4}, 
	{0x7647, 0xe1f2}, 
	{0x7648, 0xe1f3}, 
	{0x7649, 0x8fcea9}, 
	{0x764a, 0x8fcea3}, 
	{0x764b, 0x8fceaa}, 
	{0x764c, 0xb4e2}, 
	{0x7652, 0xccfe}, 
	{0x7655, 0x8fceab}, 
	{0x7656, 0xcaca}, 
	{0x7658, 0xe1f6}, 
	{0x7659, 0x8fceac}, 
	{0x765c, 0xe1f5}, 
	{0x765f, 0x8fcead}, 
	{0x7661, 0xe1f7}, 
	{0x7662, 0xe1f8}, 
	{0x7664, 0x8fceae}, 
	{0x7665, 0x8fceaf}, 
	{0x7667, 0xe1fc}, 
	{0x7668, 0xe1f9}, 
	{0x7669, 0xe1fa}, 
	{0x766a, 0xe1fb}, 
	{0x766c, 0xe1fd}, 
	{0x766d, 0x8fceb0}, 
	{0x766e, 0x8fceb1}, 
	{0x766f, 0x8fceb2}, 
	{0x7670, 0xe1fe}, 
	{0x7671, 0x8fceb3}, 
	{0x7672, 0xe2a1}, 
	{0x7674, 0x8fceb4}, 
	{0x7676, 0xe2a2}, 
	{0x7678, 0xe2a3}, 
	{0x767a, 0xc8af}, 
	{0x767b, 0xc5d0}, 
	{0x767c, 0xe2a4}, 
	{0x767d, 0xc7f2}, 
	{0x767e, 0xc9b4}, 
	{0x7680, 0xe2a5}, 
	{0x7681, 0x8fceb5}, 
	{0x7683, 0xe2a6}, 
	{0x7684, 0xc5aa}, 
	{0x7685, 0x8fceb6}, 
	{0x7686, 0xb3a7}, 
	{0x7687, 0xb9c4}, 
	{0x7688, 0xe2a7}, 
	{0x768b, 0xe2a8}, 
	{0x768c, 0x8fceb7}, 
	{0x768d, 0x8fceb8}, 
	{0x768e, 0xe2a9}, 
	{0x7690, 0xbba9}, 
	{0x7693, 0xe2ab}, 
	{0x7695, 0x8fceb9}, 
	{0x7696, 0xe2aa}, 
	{0x7699, 0xe2ac}, 
	{0x769a, 0xe2ad}, 
	{0x769b, 0x8fceba}, 
	{0x769c, 0x8fcebb}, 
	{0x769d, 0x8fcebc}, 
	{0x769f, 0x8fcebd}, 
	{0x76a0, 0x8fcebe}, 
	{0x76a2, 0x8fcebf}, 
	{0x76a3, 0x8fcec0}, 
	{0x76a4, 0x8fcec1}, 
	{0x76a5, 0x8fcec2}, 
	{0x76a6, 0x8fcec3}, 
	{0x76a7, 0x8fcec4}, 
	{0x76a8, 0x8fcec5}, 
	{0x76aa, 0x8fcec6}, 
	{0x76ad, 0x8fcec7}, 
	{0x76ae, 0xc8e9}, 
	{0x76b0, 0xe2ae}, 
	{0x76b4, 0xe2af}, 
	{0x76b7, 0xf3e9}, 
	{0x76b8, 0xe2b0}, 
	{0x76b9, 0xe2b1}, 
	{0x76ba, 0xe2b2}, 
	{0x76bd, 0x8fcec8}, 
	{0x76bf, 0xbbae}, 
	{0x76c1, 0x8fcec9}, 
	{0x76c2, 0xe2b3}, 
	{0x76c3, 0xc7d6}, 
	{0x76c5, 0x8fceca}, 
	{0x76c6, 0xcbdf}, 
	{0x76c8, 0xb1ce}, 
	{0x76c9, 0x8fcecb}, 
	{0x76ca, 0xb1d7}, 
	{0x76cb, 0x8fcecc}, 
	{0x76cc, 0x8fcecd}, 
	{0x76cd, 0xe2b4}, 
	{0x76ce, 0x8fcece}, 
	{0x76d2, 0xe2b6}, 
	{0x76d4, 0x8fcecf}, 
	{0x76d6, 0xe2b5}, 
	{0x76d7, 0xc5f0}, 
	{0x76d9, 0x8fced0}, 
	{0x76db, 0xc0b9}, 
	{0x76dc, 0xddb9}, 
	{0x76de, 0xe2b7}, 
	{0x76df, 0xccc1}, 
	{0x76e0, 0x8fced1}, 
	{0x76e1, 0xe2b8}, 
	{0x76e3, 0xb4c6}, 
	{0x76e4, 0xc8d7}, 
	{0x76e5, 0xe2b9}, 
	{0x76e6, 0x8fced2}, 
	{0x76e7, 0xe2ba}, 
	{0x76e8, 0x8fced3}, 
	{0x76ea, 0xe2bb}, 
	{0x76ec, 0x8fced4}, 
	{0x76ee, 0xccdc}, 
	{0x76f0, 0x8fced5}, 
	{0x76f1, 0x8fced6}, 
	{0x76f2, 0xccd5}, 
	{0x76f4, 0xc4be}, 
	{0x76f6, 0x8fced7}, 
	{0x76f8, 0xc1ea}, 
	{0x76f9, 0x8fced8}, 
	{0x76fb, 0xe2bd}, 
	{0x76fc, 0x8fced9}, 
	{0x76fe, 0xbde2}, 
	{0x7700, 0x8fceda}, 
	{0x7701, 0xbeca}, 
	{0x7704, 0xe2c0}, 
	{0x7706, 0x8fcedb}, 
	{0x7707, 0xe2bf}, 
	{0x7708, 0xe2be}, 
	{0x7709, 0xc8fd}, 
	{0x770a, 0x8fcedc}, 
	{0x770b, 0xb4c7}, 
	{0x770c, 0xb8a9}, 
	{0x770e, 0x8fcedd}, 
	{0x7712, 0x8fcede}, 
	{0x7714, 0x8fcedf}, 
	{0x7715, 0x8fcee0}, 
	{0x7717, 0x8fcee1}, 
	{0x7719, 0x8fcee2}, 
	{0x771a, 0x8fcee3}, 
	{0x771b, 0xe2c6}, 
	{0x771c, 0x8fcee4}, 
	{0x771e, 0xe2c3}, 
	{0x771f, 0xbfbf}, 
	{0x7720, 0xccb2}, 
	{0x7722, 0x8fcee5}, 
	{0x7724, 0xe2c2}, 
	{0x7725, 0xe2c4}, 
	{0x7726, 0xe2c5}, 
	{0x7728, 0x8fcee6}, 
	{0x7729, 0xe2c1}, 
	{0x772d, 0x8fcee7}, 
	{0x772e, 0x8fcee8}, 
	{0x772f, 0x8fcee9}, 
	{0x7734, 0x8fceea}, 
	{0x7735, 0x8fceeb}, 
	{0x7736, 0x8fceec}, 
	{0x7737, 0xe2c7}, 
	{0x7738, 0xe2c8}, 
	{0x7739, 0x8fceed}, 
	{0x773a, 0xc4af}, 
	{0x773c, 0xb4e3}, 
	{0x773d, 0x8fceee}, 
	{0x773e, 0x8fceef}, 
	{0x7740, 0xc3e5}, 
	{0x7742, 0x8fcef0}, 
	{0x7745, 0x8fcef1}, 
	{0x7746, 0x8fcef2}, 
	{0x7747, 0xe2c9}, 
	{0x774a, 0x8fcef3}, 
	{0x774d, 0x8fcef4}, 
	{0x774e, 0x8fcef5}, 
	{0x774f, 0x8fcef6}, 
	{0x7752, 0x8fcef7}, 
	{0x7756, 0x8fcef8}, 
	{0x7757, 0x8fcef9}, 
	{0x775a, 0xe2ca}, 
	{0x775b, 0xe2cd}, 
	{0x775c, 0x8fcefa}, 
	{0x775e, 0x8fcefb}, 
	{0x775f, 0x8fcefc}, 
	{0x7760, 0x8fcefd}, 
	{0x7761, 0xbfe7}, 
	{0x7762, 0x8fcefe}, 
	{0x7763, 0xc6c4}, 
	{0x7764, 0x8fcfa1}, 
	{0x7765, 0xe2ce}, 
	{0x7766, 0xcbd3}, 
	{0x7767, 0x8fcfa2}, 
	{0x7768, 0xe2cb}, 
	{0x776a, 0x8fcfa3}, 
	{0x776b, 0xe2cc}, 
	{0x776c, 0x8fcfa4}, 
	{0x7770, 0x8fcfa5}, 
	{0x7772, 0x8fcfa6}, 
	{0x7773, 0x8fcfa7}, 
	{0x7774, 0x8fcfa8}, 
	{0x7779, 0xe2d1}, 
	{0x777a, 0x8fcfa9}, 
	{0x777d, 0x8fcfaa}, 
	{0x777e, 0xe2d0}, 
	{0x777f, 0xe2cf}, 
	{0x7780, 0x8fcfab}, 
	{0x7784, 0x8fcfac}, 
	{0x778b, 0xe2d3}, 
	{0x778c, 0x8fcfad}, 
	{0x778d, 0x8fcfae}, 
	{0x778e, 0xe2d2}, 
	{0x7791, 0xe2d4}, 
	{0x7794, 0x8fcfaf}, 
	{0x7795, 0x8fcfb0}, 
	{0x7796, 0x8fcfb1}, 
	{0x779a, 0x8fcfb2}, 
	{0x779e, 0xe2d6}, 
	{0x779f, 0x8fcfb3}, 
	{0x77a0, 0xe2d5}, 
	{0x77a2, 0x8fcfb4}, 
	{0x77a5, 0xcacd}, 
	{0x77a7, 0x8fcfb5}, 
	{0x77aa, 0x8fcfb6}, 
	{0x77ac, 0xbdd6}, 
	{0x77ad, 0xcec6}, 
	{0x77ae, 0x8fcfb7}, 
	{0x77af, 0x8fcfb8}, 
	{0x77b0, 0xe2d7}, 
	{0x77b1, 0x8fcfb9}, 
	{0x77b3, 0xc6b7}, 
	{0x77b5, 0x8fcfba}, 
	{0x77b6, 0xe2d8}, 
	{0x77b9, 0xe2d9}, 
	{0x77bb, 0xe2dd}, 
	{0x77bc, 0xe2db}, 
	{0x77bd, 0xe2dc}, 
	{0x77be, 0x8fcfbb}, 
	{0x77bf, 0xe2da}, 
	{0x77c3, 0x8fcfbc}, 
	{0x77c7, 0xe2de}, 
	{0x77c9, 0x8fcfbd}, 
	{0x77cd, 0xe2df}, 
	{0x77d1, 0x8fcfbe}, 
	{0x77d2, 0x8fcfbf}, 
	{0x77d5, 0x8fcfc0}, 
	{0x77d7, 0xe2e0}, 
	{0x77d9, 0x8fcfc1}, 
	{0x77da, 0xe2e1}, 
	{0x77db, 0xccb7}, 
	{0x77dc, 0xe2e2}, 
	{0x77de, 0x8fcfc2}, 
	{0x77df, 0x8fcfc3}, 
	{0x77e0, 0x8fcfc4}, 
	{0x77e2, 0xccf0}, 
	{0x77e3, 0xe2e3}, 
	{0x77e4, 0x8fcfc5}, 
	{0x77e5, 0xc3ce}, 
	{0x77e6, 0x8fcfc6}, 
	{0x77e7, 0xc7ea}, 
	{0x77e9, 0xb6eb}, 
	{0x77ea, 0x8fcfc7}, 
	{0x77ec, 0x8fcfc8}, 
	{0x77ed, 0xc3bb}, 
	{0x77ee, 0xe2e4}, 
	{0x77ef, 0xb6ba}, 
	{0x77f0, 0x8fcfc9}, 
	{0x77f1, 0x8fcfca}, 
	{0x77f3, 0xc0d0}, 
	{0x77f4, 0x8fcfcb}, 
	{0x77f8, 0x8fcfcc}, 
	{0x77fb, 0x8fcfcd}, 
	{0x77fc, 0xe2e5}, 
	{0x7802, 0xbabd}, 
	{0x7805, 0x8fcfce}, 
	{0x7806, 0x8fcfcf}, 
	{0x7809, 0x8fcfd0}, 
	{0x780c, 0xe2e6}, 
	{0x780d, 0x8fcfd1}, 
	{0x780e, 0x8fcfd2}, 
	{0x7811, 0x8fcfd3}, 
	{0x7812, 0xe2e7}, 
	{0x7814, 0xb8a6}, 
	{0x7815, 0xbad5}, 
	{0x781d, 0x8fcfd4}, 
	{0x7820, 0xe2e9}, 
	{0x7821, 0x8fcfd5}, 
	{0x7822, 0x8fcfd6}, 
	{0x7823, 0x8fcfd7}, 
	{0x7825, 0xc5d6}, 
	{0x7826, 0xbad6}, 
	{0x7827, 0xb5ce}, 
	{0x782d, 0x8fcfd8}, 
	{0x782e, 0x8fcfd9}, 
	{0x7830, 0x8fcfda}, 
	{0x7832, 0xcba4}, 
	{0x7834, 0xc7cb}, 
	{0x7835, 0x8fcfdb}, 
	{0x7837, 0x8fcfdc}, 
	{0x783a, 0xc5d7}, 
	{0x783f, 0xb9dc}, 
	{0x7843, 0x8fcfdd}, 
	{0x7844, 0x8fcfde}, 
	{0x7845, 0xe2eb}, 
	{0x7847, 0x8fcfdf}, 
	{0x7848, 0x8fcfe0}, 
	{0x784c, 0x8fcfe1}, 
	{0x784e, 0x8fcfe2}, 
	{0x7852, 0x8fcfe3}, 
	{0x785c, 0x8fcfe4}, 
	{0x785d, 0xbecb}, 
	{0x785e, 0x8fcfe5}, 
	{0x7860, 0x8fcfe6}, 
	{0x7861, 0x8fcfe7}, 
	{0x7863, 0x8fcfe8}, 
	{0x7864, 0x8fcfe9}, 
	{0x7868, 0x8fcfea}, 
	{0x786a, 0x8fcfeb}, 
	{0x786b, 0xceb2}, 
	{0x786c, 0xb9c5}, 
	{0x786e, 0x8fcfec}, 
	{0x786f, 0xb8a7}, 
	{0x7872, 0xc8a3}, 
	{0x7874, 0xe2ed}, 
	{0x787a, 0x8fcfed}, 
	{0x787c, 0xe2ef}, 
	{0x787e, 0x8fcfee}, 
	{0x7881, 0xb8eb}, 
	{0x7886, 0xe2ee}, 
	{0x7887, 0xc4f6}, 
	{0x788a, 0x8fcfef}, 
	{0x788c, 0xe2f1}, 
	{0x788d, 0xb3b7}, 
	{0x788e, 0xe2ec}, 
	{0x788f, 0x8fcff0}, 
	{0x7891, 0xc8ea}, 
	{0x7893, 0xb1b0}, 
	{0x7894, 0x8fcff1}, 
	{0x7895, 0xbaec}, 
	{0x7897, 0xcfd2}, 
	{0x7898, 0x8fcff2}, 
	{0x789a, 0xe2f0}, 
	{0x789d, 0x8fcff4}, 
	{0x789e, 0x8fcff5}, 
	{0x789f, 0x8fcff6}, 
	{0x78a1, 0x8fcff3}, 
	{0x78a3, 0xe2f2}, 
	{0x78a4, 0x8fcff7}, 
	{0x78a7, 0xcacb}, 
	{0x78a8, 0x8fcff8}, 
	{0x78a9, 0xc0d9}, 
	{0x78aa, 0xe2f4}, 
	{0x78ac, 0x8fcff9}, 
	{0x78ad, 0x8fcffa}, 
	{0x78af, 0xe2f5}, 
	{0x78b0, 0x8fcffb}, 
	{0x78b1, 0x8fcffc}, 
	{0x78b2, 0x8fcffd}, 
	{0x78b3, 0x8fcffe}, 
	{0x78b5, 0xe2f3}, 
	{0x78ba, 0xb3ce}, 
	{0x78bb, 0x8fd0a1}, 
	{0x78bc, 0xe2fb}, 
	{0x78bd, 0x8fd0a2}, 
	{0x78be, 0xe2fa}, 
	{0x78bf, 0x8fd0a3}, 
	{0x78c1, 0xbca7}, 
	{0x78c5, 0xe2fc}, 
	{0x78c6, 0xe2f7}, 
	{0x78c7, 0x8fd0a4}, 
	{0x78c8, 0x8fd0a5}, 
	{0x78c9, 0x8fd0a6}, 
	{0x78ca, 0xe2fd}, 
	{0x78cb, 0xe2f8}, 
	{0x78cc, 0x8fd0a7}, 
	{0x78ce, 0x8fd0a8}, 
	{0x78d0, 0xc8d8}, 
	{0x78d1, 0xe2f6}, 
	{0x78d2, 0x8fd0a9}, 
	{0x78d3, 0x8fd0aa}, 
	{0x78d4, 0xe2f9}, 
	{0x78d5, 0x8fd0ab}, 
	{0x78d6, 0x8fd0ac}, 
	{0x78da, 0xe3a2}, 
	{0x78db, 0x8fd0ae}, 
	{0x78df, 0x8fd0af}, 
	{0x78e0, 0x8fd0b0}, 
	{0x78e1, 0x8fd0b1}, 
	{0x78e4, 0x8fd0ad}, 
	{0x78e6, 0x8fd0b2}, 
	{0x78e7, 0xe3a1}, 
	{0x78e8, 0xcbe1}, 
	{0x78ea, 0x8fd0b3}, 
	{0x78ec, 0xe2fe}, 
	{0x78ef, 0xb0eb}, 
	{0x78f2, 0x8fd0b4}, 
	{0x78f3, 0x8fd0b5}, 
	{0x78f4, 0xe3a4}, 
	{0x78f6, 0x8fd0b7}, 
	{0x78f7, 0x8fd0b8}, 
	{0x78fa, 0x8fd0b9}, 
	{0x78fb, 0x8fd0ba}, 
	{0x78fd, 0xe3a3}, 
	{0x78ff, 0x8fd0bb}, 
	{0x7900, 0x8fd0b6}, 
	{0x7901, 0xbecc}, 
	{0x7906, 0x8fd0bc}, 
	{0x7907, 0xe3a5}, 
	{0x790c, 0x8fd0bd}, 
	{0x790e, 0xc1c3}, 
	{0x7910, 0x8fd0be}, 
	{0x7911, 0xe3a7}, 
	{0x7912, 0xe3a6}, 
	{0x7919, 0xe3a8}, 
	{0x791a, 0x8fd0bf}, 
	{0x791c, 0x8fd0c0}, 
	{0x791e, 0x8fd0c1}, 
	{0x791f, 0x8fd0c2}, 
	{0x7920, 0x8fd0c3}, 
	{0x7925, 0x8fd0c4}, 
	{0x7926, 0xe2e8}, 
	{0x7927, 0x8fd0c5}, 
	{0x7929, 0x8fd0c6}, 
	{0x792a, 0xe2ea}, 
	{0x792b, 0xe3aa}, 
	{0x792c, 0xe3a9}, 
	{0x792d, 0x8fd0c7}, 
	{0x7931, 0x8fd0c8}, 
	{0x7934, 0x8fd0c9}, 
	{0x7935, 0x8fd0ca}, 
	{0x793a, 0xbca8}, 
	{0x793b, 0x8fd0cb}, 
	{0x793c, 0xcee9}, 
	{0x793d, 0x8fd0cc}, 
	{0x793e, 0xbcd2}, 
	{0x793f, 0x8fd0cd}, 
	{0x7940, 0xe3ab}, 
	{0x7941, 0xb7b7}, 
	{0x7944, 0x8fd0ce}, 
	{0x7945, 0x8fd0cf}, 
	{0x7946, 0x8fd0d0}, 
	{0x7947, 0xb5c0}, 
	{0x7948, 0xb5a7}, 
	{0x7949, 0xbbe3}, 
	{0x794a, 0x8fd0d1}, 
	{0x794b, 0x8fd0d2}, 
	{0x794f, 0x8fd0d3}, 
	{0x7950, 0xcdb4}, 
	{0x7951, 0x8fd0d4}, 
	{0x7953, 0xe3b1}, 
	{0x7954, 0x8fd0d5}, 
	{0x7955, 0xe3b0}, 
	{0x7956, 0xc1c4}, 
	{0x7957, 0xe3ad}, 
	{0x7958, 0x8fd0d6}, 
	{0x795a, 0xe3af}, 
	{0x795b, 0x8fd0d7}, 
	{0x795c, 0x8fd0d8}, 
	{0x795d, 0xbdcb}, 
	{0x795e, 0xbfc0}, 
	{0x795f, 0xe3ae}, 
	{0x7960, 0xe3ac}, 
	{0x7962, 0xc7aa}, 
	{0x7965, 0xbecd}, 
	{0x7967, 0x8fd0d9}, 
	{0x7968, 0xc9bc}, 
	{0x7969, 0x8fd0da}, 
	{0x796b, 0x8fd0db}, 
	{0x796d, 0xbad7}, 
	{0x7972, 0x8fd0dc}, 
	{0x7977, 0xc5f8}, 
	{0x7979, 0x8fd0dd}, 
	{0x797a, 0xe3b2}, 
	{0x797b, 0x8fd0de}, 
	{0x797c, 0x8fd0df}, 
	{0x797e, 0x8fd0e0}, 
	{0x797f, 0xe3b3}, 
	{0x7980, 0xe3c9}, 
	{0x7981, 0xb6d8}, 
	{0x7984, 0xcfbd}, 
	{0x7985, 0xc1b5}, 
	{0x798a, 0xe3b4}, 
	{0x798b, 0x8fd0e1}, 
	{0x798c, 0x8fd0e2}, 
	{0x798d, 0xb2d2}, 
	{0x798e, 0xc4f7}, 
	{0x798f, 0xcaa1}, 
	{0x7991, 0x8fd0e3}, 
	{0x7993, 0x8fd0e4}, 
	{0x7994, 0x8fd0e5}, 
	{0x7995, 0x8fd0e6}, 
	{0x7996, 0x8fd0e7}, 
	{0x7998, 0x8fd0e8}, 
	{0x799b, 0x8fd0e9}, 
	{0x799c, 0x8fd0ea}, 
	{0x799d, 0xe3b5}, 
	{0x79a1, 0x8fd0eb}, 
	{0x79a6, 0xb5fa}, 
	{0x79a7, 0xe3b6}, 
	{0x79a8, 0x8fd0ec}, 
	{0x79a9, 0x8fd0ed}, 
	{0x79aa, 0xe3b8}, 
	{0x79ab, 0x8fd0ee}, 
	{0x79ae, 0xe3b9}, 
	{0x79af, 0x8fd0ef}, 
	{0x79b0, 0xc7a9}, 
	{0x79b1, 0x8fd0f0}, 
	{0x79b3, 0xe3ba}, 
	{0x79b4, 0x8fd0f1}, 
	{0x79b8, 0x8fd0f2}, 
	{0x79b9, 0xe3bb}, 
	{0x79ba, 0xe3bc}, 
	{0x79bb, 0x8fd0f3}, 
	{0x79bd, 0xb6d9}, 
	{0x79be, 0xb2d3}, 
	{0x79bf, 0xc6c5}, 
	{0x79c0, 0xbda8}, 
	{0x79c1, 0xbbe4}, 
	{0x79c2, 0x8fd0f4}, 
	{0x79c4, 0x8fd0f5}, 
	{0x79c7, 0x8fd0f6}, 
	{0x79c8, 0x8fd0f7}, 
	{0x79c9, 0xe3bd}, 
	{0x79ca, 0x8fd0f8}, 
	{0x79cb, 0xbda9}, 
	{0x79cf, 0x8fd0f9}, 
	{0x79d1, 0xb2ca}, 
	{0x79d2, 0xc9c3}, 
	{0x79d4, 0x8fd0fa}, 
	{0x79d5, 0xe3be}, 
	{0x79d6, 0x8fd0fb}, 
	{0x79d8, 0xc8eb}, 
	{0x79da, 0x8fd0fc}, 
	{0x79dd, 0x8fd0fd}, 
	{0x79de, 0x8fd0fe}, 
	{0x79df, 0xc1c5}, 
	{0x79e0, 0x8fd1a1}, 
	{0x79e1, 0xe3c1}, 
	{0x79e2, 0x8fd1a2}, 
	{0x79e3, 0xe3c2}, 
	{0x79e4, 0xc7e9}, 
	{0x79e5, 0x8fd1a3}, 
	{0x79e6, 0xbfc1}, 
	{0x79e7, 0xe3bf}, 
	{0x79e9, 0xc3e1}, 
	{0x79ea, 0x8fd1a4}, 
	{0x79eb, 0x8fd1a5}, 
	{0x79ec, 0xe3c0}, 
	{0x79ed, 0x8fd1a6}, 
	{0x79f0, 0xbece}, 
	{0x79f1, 0x8fd1a7}, 
	{0x79f8, 0x8fd1a8}, 
	{0x79fb, 0xb0dc}, 
	{0x79fc, 0x8fd1a9}, 
	{0x7a00, 0xb5a9}, 
	{0x7a02, 0x8fd1aa}, 
	{0x7a03, 0x8fd1ab}, 
	{0x7a07, 0x8fd1ac}, 
	{0x7a08, 0xe3c3}, 
	{0x7a09, 0x8fd1ad}, 
	{0x7a0a, 0x8fd1ae}, 
	{0x7a0b, 0xc4f8}, 
	{0x7a0c, 0x8fd1af}, 
	{0x7a0d, 0xe3c4}, 
	{0x7a0e, 0xc0c7}, 
	{0x7a11, 0x8fd1b0}, 
	{0x7a14, 0xccad}, 
	{0x7a15, 0x8fd1b1}, 
	{0x7a17, 0xc9a3}, 
	{0x7a18, 0xe3c5}, 
	{0x7a19, 0xe3c6}, 
	{0x7a1a, 0xc3d5}, 
	{0x7a1b, 0x8fd1b2}, 
	{0x7a1c, 0xcec7}, 
	{0x7a1e, 0x8fd1b3}, 
	{0x7a1f, 0xe3c8}, 
	{0x7a20, 0xe3c7}, 
	{0x7a21, 0x8fd1b4}, 
	{0x7a27, 0x8fd1b5}, 
	{0x7a2b, 0x8fd1b6}, 
	{0x7a2d, 0x8fd1b7}, 
	{0x7a2e, 0xbcef}, 
	{0x7a2f, 0x8fd1b8}, 
	{0x7a30, 0x8fd1b9}, 
	{0x7a31, 0xe3ca}, 
	{0x7a32, 0xb0f0}, 
	{0x7a34, 0x8fd1ba}, 
	{0x7a35, 0x8fd1bb}, 
	{0x7a37, 0xe3cd}, 
	{0x7a38, 0x8fd1bc}, 
	{0x7a39, 0x8fd1bd}, 
	{0x7a3a, 0x8fd1be}, 
	{0x7a3b, 0xe3cb}, 
	{0x7a3c, 0xb2d4}, 
	{0x7a3d, 0xb7ce}, 
	{0x7a3e, 0xe3cc}, 
	{0x7a3f, 0xb9c6}, 
	{0x7a40, 0xb9f2}, 
	{0x7a42, 0xcae6}, 
	{0x7a43, 0xe3ce}, 
	{0x7a44, 0x8fd1bf}, 
	{0x7a45, 0x8fd1c0}, 
	{0x7a46, 0xcbd4}, 
	{0x7a47, 0x8fd1c1}, 
	{0x7a48, 0x8fd1c2}, 
	{0x7a49, 0xe3d0}, 
	{0x7a4c, 0x8fd1c3}, 
	{0x7a4d, 0xc0d1}, 
	{0x7a4e, 0xb1cf}, 
	{0x7a4f, 0xb2ba}, 
	{0x7a50, 0xb0ac}, 
	{0x7a55, 0x8fd1c4}, 
	{0x7a56, 0x8fd1c5}, 
	{0x7a57, 0xe3cf}, 
	{0x7a59, 0x8fd1c6}, 
	{0x7a5c, 0x8fd1c7}, 
	{0x7a5d, 0x8fd1c8}, 
	{0x7a5f, 0x8fd1c9}, 
	{0x7a60, 0x8fd1ca}, 
	{0x7a61, 0xe3d1}, 
	{0x7a62, 0xe3d2}, 
	{0x7a63, 0xbef7}, 
	{0x7a65, 0x8fd1cb}, 
	{0x7a67, 0x8fd1cc}, 
	{0x7a69, 0xe3d3}, 
	{0x7a6a, 0x8fd1cd}, 
	{0x7a6b, 0xb3cf}, 
	{0x7a6d, 0x8fd1ce}, 
	{0x7a70, 0xe3d5}, 
	{0x7a74, 0xb7ea}, 
	{0x7a75, 0x8fd1cf}, 
	{0x7a76, 0xb5e6}, 
	{0x7a78, 0x8fd1d0}, 
	{0x7a79, 0xe3d6}, 
	{0x7a7a, 0xb6f5}, 
	{0x7a7d, 0xe3d7}, 
	{0x7a7e, 0x8fd1d1}, 
	{0x7a7f, 0xc0fc}, 
	{0x7a80, 0x8fd1d2}, 
	{0x7a81, 0xc6cd}, 
	{0x7a82, 0x8fd1d3}, 
	{0x7a83, 0xc0e0}, 
	{0x7a84, 0xbaf5}, 
	{0x7a85, 0x8fd1d4}, 
	{0x7a86, 0x8fd1d5}, 
	{0x7a88, 0xe3d8}, 
	{0x7a8a, 0x8fd1d6}, 
	{0x7a8b, 0x8fd1d7}, 
	{0x7a90, 0x8fd1d8}, 
	{0x7a91, 0x8fd1d9}, 
	{0x7a92, 0xc3e2}, 
	{0x7a93, 0xc1eb}, 
	{0x7a94, 0x8fd1da}, 
	{0x7a95, 0xe3da}, 
	{0x7a96, 0xe3dc}, 
	{0x7a97, 0xe3d9}, 
	{0x7a98, 0xe3db}, 
	{0x7a9e, 0x8fd1db}, 
	{0x7a9f, 0xb7a2}, 
	{0x7aa0, 0x8fd1dc}, 
	{0x7aa3, 0x8fd1dd}, 
	{0x7aa9, 0xe3dd}, 
	{0x7aaa, 0xb7a6}, 
	{0x7aac, 0x8fd1de}, 
	{0x7aae, 0xb5e7}, 
	{0x7aaf, 0xcdd2}, 
	{0x7ab0, 0xe3df}, 
	{0x7ab3, 0x8fd1df}, 
	{0x7ab5, 0x8fd1e0}, 
	{0x7ab6, 0xe3e0}, 
	{0x7ab9, 0x8fd1e1}, 
	{0x7aba, 0xb1ae}, 
	{0x7abb, 0x8fd1e2}, 
	{0x7abc, 0x8fd1e3}, 
	{0x7abf, 0xe3e3}, 
	{0x7ac3, 0xb3f6}, 
	{0x7ac4, 0xe3e2}, 
	{0x7ac5, 0xe3e1}, 
	{0x7ac6, 0x8fd1e4}, 
	{0x7ac7, 0xe3e5}, 
	{0x7ac8, 0xe3de}, 
	{0x7ac9, 0x8fd1e5}, 
	{0x7aca, 0xe3e6}, 
	{0x7acb, 0xcea9}, 
	{0x7acc, 0x8fd1e6}, 
	{0x7acd, 0xe3e7}, 
	{0x7ace, 0x8fd1e7}, 
	{0x7acf, 0xe3e8}, 
	{0x7ad1, 0x8fd1e8}, 
	{0x7ad2, 0xd4f4}, 
	{0x7ad3, 0xe3ea}, 
	{0x7ad5, 0xe3e9}, 
	{0x7ad9, 0xe3eb}, 
	{0x7ada, 0xe3ec}, 
	{0x7adb, 0x8fd1e9}, 
	{0x7adc, 0xceb5}, 
	{0x7add, 0xe3ed}, 
	{0x7adf, 0xf0ef}, 
	{0x7ae0, 0xbecf}, 
	{0x7ae1, 0xe3ee}, 
	{0x7ae2, 0xe3ef}, 
	{0x7ae3, 0xbdd7}, 
	{0x7ae5, 0xc6b8}, 
	{0x7ae6, 0xe3f0}, 
	{0x7ae8, 0x8fd1ea}, 
	{0x7ae9, 0x8fd1eb}, 
	{0x7aea, 0xc3a8}, 
	{0x7aeb, 0x8fd1ec}, 
	{0x7aec, 0x8fd1ed}, 
	{0x7aed, 0xe3f1}, 
	{0x7aef, 0xc3bc}, 
	{0x7af0, 0xe3f2}, 
	{0x7af1, 0x8fd1ee}, 
	{0x7af4, 0x8fd1ef}, 
	{0x7af6, 0xb6a5}, 
	{0x7af8, 0xd1bf}, 
	{0x7af9, 0xc3dd}, 
	{0x7afa, 0xbcb3}, 
	{0x7afb, 0x8fd1f0}, 
	{0x7afd, 0x8fd1f1}, 
	{0x7afe, 0x8fd1f2}, 
	{0x7aff, 0xb4c8}, 
	{0x7b02, 0xe3f3}, 
	{0x7b04, 0xe4a2}, 
	{0x7b06, 0xe3f6}, 
	{0x7b07, 0x8fd1f3}, 
	{0x7b08, 0xb5e8}, 
	{0x7b0a, 0xe3f5}, 
	{0x7b0b, 0xe4a4}, 
	{0x7b0f, 0xe3f4}, 
	{0x7b11, 0xbed0}, 
	{0x7b14, 0x8fd1f4}, 
	{0x7b18, 0xe3f8}, 
	{0x7b19, 0xe3f9}, 
	{0x7b1b, 0xc5ab}, 
	{0x7b1e, 0xe3fa}, 
	{0x7b1f, 0x8fd1f5}, 
	{0x7b20, 0xb3de}, 
	{0x7b23, 0x8fd1f6}, 
	{0x7b25, 0xbfda}, 
	{0x7b26, 0xc9e4}, 
	{0x7b27, 0x8fd1f7}, 
	{0x7b28, 0xe3fc}, 
	{0x7b29, 0x8fd1f8}, 
	{0x7b2a, 0x8fd1f9}, 
	{0x7b2b, 0x8fd1fa}, 
	{0x7b2c, 0xc2e8}, 
	{0x7b2d, 0x8fd1fb}, 
	{0x7b2e, 0x8fd1fc}, 
	{0x7b2f, 0x8fd1fd}, 
	{0x7b30, 0x8fd1fe}, 
	{0x7b31, 0x8fd2a1}, 
	{0x7b33, 0xe3f7}, 
	{0x7b34, 0x8fd2a2}, 
	{0x7b35, 0xe3fb}, 
	{0x7b36, 0xe3fd}, 
	{0x7b39, 0xbafb}, 
	{0x7b3d, 0x8fd2a3}, 
	{0x7b3f, 0x8fd2a4}, 
	{0x7b40, 0x8fd2a5}, 
	{0x7b41, 0x8fd2a6}, 
	{0x7b45, 0xe4a6}, 
	{0x7b46, 0xc9ae}, 
	{0x7b47, 0x8fd2a7}, 
	{0x7b48, 0xc8a6}, 
	{0x7b49, 0xc5f9}, 
	{0x7b4b, 0xb6da}, 
	{0x7b4c, 0xe4a5}, 
	{0x7b4d, 0xe4a3}, 
	{0x7b4e, 0x8fd2a8}, 
	{0x7b4f, 0xc8b5}, 
	{0x7b50, 0xe3fe}, 
	{0x7b51, 0xc3de}, 
	{0x7b52, 0xc5fb}, 
	{0x7b54, 0xc5fa}, 
	{0x7b55, 0x8fd2a9}, 
	{0x7b56, 0xbaf6}, 
	{0x7b5d, 0xe4b8}, 
	{0x7b60, 0x8fd2aa}, 
	{0x7b64, 0x8fd2ab}, 
	{0x7b65, 0xe4a8}, 
	{0x7b66, 0x8fd2ac}, 
	{0x7b67, 0xe4aa}, 
	{0x7b69, 0x8fd2ad}, 
	{0x7b6a, 0x8fd2ae}, 
	{0x7b6c, 0xe4ad}, 
	{0x7b6d, 0x8fd2af}, 
	{0x7b6e, 0xe4ae}, 
	{0x7b6f, 0x8fd2b0}, 
	{0x7b70, 0xe4ab}, 
	{0x7b71, 0xe4ac}, 
	{0x7b72, 0x8fd2b1}, 
	{0x7b73, 0x8fd2b2}, 
	{0x7b74, 0xe4a9}, 
	{0x7b75, 0xe4a7}, 
	{0x7b77, 0x8fd2b3}, 
	{0x7b7a, 0xe4a1}, 
	{0x7b84, 0x8fd2b4}, 
	{0x7b86, 0xcacf}, 
	{0x7b87, 0xb2d5}, 
	{0x7b89, 0x8fd2b5}, 
	{0x7b8b, 0xe4b5}, 
	{0x7b8d, 0xe4b2}, 
	{0x7b8e, 0x8fd2b6}, 
	{0x7b8f, 0xe4b7}, 
	{0x7b90, 0x8fd2b7}, 
	{0x7b91, 0x8fd2b8}, 
	{0x7b92, 0xe4b6}, 
	{0x7b94, 0xc7f3}, 
	{0x7b95, 0xcca7}, 
	{0x7b96, 0x8fd2b9}, 
	{0x7b97, 0xbbbb}, 
	{0x7b98, 0xe4b0}, 
	{0x7b99, 0xe4b9}, 
	{0x7b9a, 0xe4b4}, 
	{0x7b9b, 0x8fd2ba}, 
	{0x7b9c, 0xe4b3}, 
	{0x7b9d, 0xe4af}, 
	{0x7b9e, 0x8fd2bb}, 
	{0x7b9f, 0xe4b1}, 
	{0x7ba0, 0x8fd2bc}, 
	{0x7ba1, 0xb4c9}, 
	{0x7ba5, 0x8fd2bd}, 
	{0x7baa, 0xc3bd}, 
	{0x7bac, 0x8fd2be}, 
	{0x7bad, 0xc0fd}, 
	{0x7baf, 0x8fd2bf}, 
	{0x7bb0, 0x8fd2c0}, 
	{0x7bb1, 0xc8a2}, 
	{0x7bb2, 0x8fd2c1}, 
	{0x7bb4, 0xe4be}, 
	{0x7bb5, 0x8fd2c2}, 
	{0x7bb6, 0x8fd2c3}, 
	{0x7bb8, 0xc8a4}, 
	{0x7bba, 0x8fd2c4}, 
	{0x7bbb, 0x8fd2c5}, 
	{0x7bbc, 0x8fd2c6}, 
	{0x7bbd, 0x8fd2c7}, 
	{0x7bc0, 0xc0e1}, 
	{0x7bc1, 0xe4bb}, 
	{0x7bc2, 0x8fd2c8}, 
	{0x7bc4, 0xc8cf}, 
	{0x7bc5, 0x8fd2c9}, 
	{0x7bc6, 0xe4bf}, 
	{0x7bc7, 0xcad3}, 
	{0x7bc8, 0x8fd2ca}, 
	{0x7bc9, 0xc3db}, 
	{0x7bca, 0x8fd2cb}, 
	{0x7bcb, 0xe4ba}, 
	{0x7bcc, 0xe4bc}, 
	{0x7bcf, 0xe4bd}, 
	{0x7bd4, 0x8fd2cc}, 
	{0x7bd6, 0x8fd2cd}, 
	{0x7bd7, 0x8fd2ce}, 
	{0x7bd9, 0x8fd2cf}, 
	{0x7bda, 0x8fd2d0}, 
	{0x7bdb, 0x8fd2d1}, 
	{0x7bdd, 0xe4c0}, 
	{0x7be0, 0xbcc4}, 
	{0x7be4, 0xc6c6}, 
	{0x7be5, 0xe4c5}, 
	{0x7be6, 0xe4c4}, 
	{0x7be8, 0x8fd2d2}, 
	{0x7be9, 0xe4c1}, 
	{0x7bea, 0x8fd2d3}, 
	{0x7bed, 0xcfb6}, 
	{0x7bf2, 0x8fd2d4}, 
	{0x7bf3, 0xe4ca}, 
	{0x7bf4, 0x8fd2d5}, 
	{0x7bf5, 0x8fd2d6}, 
	{0x7bf6, 0xe4ce}, 
	{0x7bf7, 0xe4cb}, 
	{0x7bf8, 0x8fd2d7}, 
	{0x7bf9, 0x8fd2d8}, 
	{0x7bfa, 0x8fd2d9}, 
	{0x7bfc, 0x8fd2da}, 
	{0x7bfe, 0x8fd2db}, 
	{0x7c00, 0xe4c7}, 
	{0x7c01, 0x8fd2dc}, 
	{0x7c02, 0x8fd2dd}, 
	{0x7c03, 0x8fd2de}, 
	{0x7c04, 0x8fd2df}, 
	{0x7c06, 0x8fd2e0}, 
	{0x7c07, 0xe4c8}, 
	{0x7c09, 0x8fd2e1}, 
	{0x7c0b, 0x8fd2e2}, 
	{0x7c0c, 0x8fd2e3}, 
	{0x7c0d, 0xe4cd}, 
	{0x7c0e, 0x8fd2e4}, 
	{0x7c0f, 0x8fd2e5}, 
	{0x7c11, 0xe4c2}, 
	{0x7c12, 0xd2d5}, 
	{0x7c13, 0xe4c9}, 
	{0x7c14, 0xe4c3}, 
	{0x7c17, 0xe4cc}, 
	{0x7c19, 0x8fd2e6}, 
	{0x7c1b, 0x8fd2e7}, 
	{0x7c1f, 0xe4d2}, 
	{0x7c20, 0x8fd2e8}, 
	{0x7c21, 0xb4ca}, 
	{0x7c23, 0xe4cf}, 
	{0x7c25, 0x8fd2e9}, 
	{0x7c26, 0x8fd2ea}, 
	{0x7c27, 0xe4d0}, 
	{0x7c28, 0x8fd2eb}, 
	{0x7c2a, 0xe4d1}, 
	{0x7c2b, 0xe4d4}, 
	{0x7c2c, 0x8fd2ec}, 
	{0x7c31, 0x8fd2ed}, 
	{0x7c33, 0x8fd2ee}, 
	{0x7c34, 0x8fd2ef}, 
	{0x7c36, 0x8fd2f0}, 
	{0x7c37, 0xe4d3}, 
	{0x7c38, 0xc8f6}, 
	{0x7c39, 0x8fd2f1}, 
	{0x7c3a, 0x8fd2f2}, 
	{0x7c3d, 0xe4d5}, 
	{0x7c3e, 0xcefc}, 
	{0x7c3f, 0xcaed}, 
	{0x7c40, 0xe4da}, 
	{0x7c43, 0xe4d7}, 
	{0x7c46, 0x8fd2f3}, 
	{0x7c4a, 0x8fd2f4}, 
	{0x7c4c, 0xe4d6}, 
	{0x7c4d, 0xc0d2}, 
	{0x7c4f, 0xe4d9}, 
	{0x7c50, 0xe4db}, 
	{0x7c51, 0x8fd2f6}, 
	{0x7c52, 0x8fd2f7}, 
	{0x7c53, 0x8fd2f8}, 
	{0x7c54, 0xe4d8}, 
	{0x7c55, 0x8fd2f5}, 
	{0x7c56, 0xe4df}, 
	{0x7c58, 0xe4dc}, 
	{0x7c59, 0x8fd2f9}, 
	{0x7c5a, 0x8fd2fa}, 
	{0x7c5b, 0x8fd2fb}, 
	{0x7c5c, 0x8fd2fc}, 
	{0x7c5d, 0x8fd2fd}, 
	{0x7c5e, 0x8fd2fe}, 
	{0x7c5f, 0xe4dd}, 
	{0x7c60, 0xe4c6}, 
	{0x7c61, 0x8fd3a1}, 
	{0x7c63, 0x8fd3a2}, 
	{0x7c64, 0xe4de}, 
	{0x7c65, 0xe4e0}, 
	{0x7c67, 0x8fd3a3}, 
	{0x7c69, 0x8fd3a4}, 
	{0x7c6c, 0xe4e1}, 
	{0x7c6d, 0x8fd3a5}, 
	{0x7c6e, 0x8fd3a6}, 
	{0x7c70, 0x8fd3a7}, 
	{0x7c72, 0x8fd3a8}, 
	{0x7c73, 0xcac6}, 
	{0x7c75, 0xe4e2}, 
	{0x7c79, 0x8fd3a9}, 
	{0x7c7c, 0x8fd3aa}, 
	{0x7c7d, 0x8fd3ab}, 
	{0x7c7e, 0xcce2}, 
	{0x7c81, 0xb6ce}, 
	{0x7c82, 0xb7a9}, 
	{0x7c83, 0xe4e3}, 
	{0x7c86, 0x8fd3ac}, 
	{0x7c87, 0x8fd3ad}, 
	{0x7c89, 0xcab4}, 
	{0x7c8b, 0xbfe8}, 
	{0x7c8d, 0xccb0}, 
	{0x7c8f, 0x8fd3ae}, 
	{0x7c90, 0xe4e4}, 
	{0x7c92, 0xceb3}, 
	{0x7c94, 0x8fd3af}, 
	{0x7c95, 0xc7f4}, 
	{0x7c97, 0xc1c6}, 
	{0x7c98, 0xc7b4}, 
	{0x7c9b, 0xbdcd}, 
	{0x7c9e, 0x8fd3b0}, 
	{0x7c9f, 0xb0c0}, 
	{0x7ca0, 0x8fd3b1}, 
	{0x7ca1, 0xe4e9}, 
	{0x7ca2, 0xe4e7}, 
	{0x7ca4, 0xe4e5}, 
	{0x7ca5, 0xb4a1}, 
	{0x7ca6, 0x8fd3b2}, 
	{0x7ca7, 0xbed1}, 
	{0x7ca8, 0xe4ea}, 
	{0x7cab, 0xe4e8}, 
	{0x7cad, 0xe4e6}, 
	{0x7cae, 0xe4ee}, 
	{0x7cb0, 0x8fd3b3}, 
	{0x7cb1, 0xe4ed}, 
	{0x7cb2, 0xe4ec}, 
	{0x7cb3, 0xe4eb}, 
	{0x7cb6, 0x8fd3b4}, 
	{0x7cb7, 0x8fd3b5}, 
	{0x7cb9, 0xe4ef}, 
	{0x7cba, 0x8fd3b6}, 
	{0x7cbb, 0x8fd3b7}, 
	{0x7cbc, 0x8fd3b8}, 
	{0x7cbd, 0xe4f0}, 
	{0x7cbe, 0xc0ba}, 
	{0x7cbf, 0x8fd3b9}, 
	{0x7cc0, 0xe4f1}, 
	{0x7cc2, 0xe4f3}, 
	{0x7cc4, 0x8fd3ba}, 
	{0x7cc5, 0xe4f2}, 
	{0x7cc7, 0x8fd3bb}, 
	{0x7cc8, 0x8fd3bc}, 
	{0x7cc9, 0x8fd3bd}, 
	{0x7cca, 0xb8d2}, 
	{0x7ccd, 0x8fd3be}, 
	{0x7cce, 0xc1b8}, 
	{0x7ccf, 0x8fd3bf}, 
	{0x7cd2, 0xe4f5}, 
	{0x7cd3, 0x8fd3c0}, 
	{0x7cd4, 0x8fd3c1}, 
	{0x7cd5, 0x8fd3c2}, 
	{0x7cd6, 0xc5fc}, 
	{0x7cd7, 0x8fd3c3}, 
	{0x7cd8, 0xe4f4}, 
	{0x7cd9, 0x8fd3c4}, 
	{0x7cda, 0x8fd3c5}, 
	{0x7cdc, 0xe4f6}, 
	{0x7cdd, 0x8fd3c6}, 
	{0x7cde, 0xcab5}, 
	{0x7cdf, 0xc1ec}, 
	{0x7ce0, 0xb9c7}, 
	{0x7ce2, 0xe4f7}, 
	{0x7ce6, 0x8fd3c7}, 
	{0x7ce7, 0xcec8}, 
	{0x7ce9, 0x8fd3c8}, 
	{0x7ceb, 0x8fd3c9}, 
	{0x7cef, 0xe4f9}, 
	{0x7cf2, 0xe4fa}, 
	{0x7cf4, 0xe4fb}, 
	{0x7cf5, 0x8fd3ca}, 
	{0x7cf6, 0xe4fc}, 
	{0x7cf8, 0xbbe5}, 
	{0x7cfa, 0xe4fd}, 
	{0x7cfb, 0xb7cf}, 
	{0x7cfe, 0xb5ea}, 
	{0x7d00, 0xb5aa}, 
	{0x7d02, 0xe5a1}, 
	{0x7d03, 0x8fd3cb}, 
	{0x7d04, 0xccf3}, 
	{0x7d05, 0xb9c8}, 
	{0x7d06, 0xe4fe}, 
	{0x7d07, 0x8fd3cc}, 
	{0x7d08, 0x8fd3cd}, 
	{0x7d09, 0x8fd3ce}, 
	{0x7d0a, 0xe5a4}, 
	{0x7d0b, 0xcce6}, 
	{0x7d0d, 0xc7bc}, 
	{0x7d0f, 0x8fd3cf}, 
	{0x7d10, 0xc9b3}, 
	{0x7d11, 0x8fd3d0}, 
	{0x7d12, 0x8fd3d1}, 
	{0x7d13, 0x8fd3d2}, 
	{0x7d14, 0xbde3}, 
	{0x7d15, 0xe5a3}, 
	{0x7d16, 0x8fd3d3}, 
	{0x7d17, 0xbcd3}, 
	{0x7d18, 0xb9c9}, 
	{0x7d19, 0xbbe6}, 
	{0x7d1a, 0xb5e9}, 
	{0x7d1b, 0xcab6}, 
	{0x7d1c, 0xe5a2}, 
	{0x7d1d, 0x8fd3d4}, 
	{0x7d1e, 0x8fd3d5}, 
	{0x7d20, 0xc1c7}, 
	{0x7d21, 0xcbc2}, 
	{0x7d22, 0xbaf7}, 
	{0x7d23, 0x8fd3d6}, 
	{0x7d26, 0x8fd3d7}, 
	{0x7d2a, 0x8fd3d8}, 
	{0x7d2b, 0xbbe7}, 
	{0x7d2c, 0xc4dd}, 
	{0x7d2d, 0x8fd3d9}, 
	{0x7d2e, 0xe5a7}, 
	{0x7d2f, 0xcedf}, 
	{0x7d30, 0xbad9}, 
	{0x7d31, 0x8fd3da}, 
	{0x7d32, 0xe5a8}, 
	{0x7d33, 0xbfc2}, 
	{0x7d35, 0xe5aa}, 
	{0x7d39, 0xbed2}, 
	{0x7d3a, 0xbab0}, 
	{0x7d3c, 0x8fd3db}, 
	{0x7d3d, 0x8fd3dc}, 
	{0x7d3e, 0x8fd3dd}, 
	{0x7d3f, 0xe5a9}, 
	{0x7d40, 0x8fd3de}, 
	{0x7d41, 0x8fd3df}, 
	{0x7d42, 0xbdaa}, 
	{0x7d43, 0xb8be}, 
	{0x7d44, 0xc1c8}, 
	{0x7d45, 0xe5a5}, 
	{0x7d46, 0xe5ab}, 
	{0x7d47, 0x8fd3e0}, 
	{0x7d48, 0x8fd3e1}, 
	{0x7d4b, 0xe5a6}, 
	{0x7d4c, 0xb7d0}, 
	{0x7d4d, 0x8fd3e2}, 
	{0x7d4e, 0xe5ae}, 
	{0x7d4f, 0xe5b2}, 
	{0x7d50, 0xb7eb}, 
	{0x7d51, 0x8fd3e3}, 
	{0x7d53, 0x8fd3e4}, 
	{0x7d56, 0xe5ad}, 
	{0x7d57, 0x8fd3e5}, 
	{0x7d59, 0x8fd3e6}, 
	{0x7d5a, 0x8fd3e7}, 
	{0x7d5b, 0xe5b6}, 
	{0x7d5c, 0x8fd3e8}, 
	{0x7d5d, 0x8fd3e9}, 
	{0x7d5e, 0xb9ca}, 
	{0x7d61, 0xcded}, 
	{0x7d62, 0xb0bc}, 
	{0x7d63, 0xe5b3}, 
	{0x7d65, 0x8fd3ea}, 
	{0x7d66, 0xb5eb}, 
	{0x7d67, 0x8fd3eb}, 
	{0x7d68, 0xe5b0}, 
	{0x7d6a, 0x8fd3ec}, 
	{0x7d6e, 0xe5b1}, 
	{0x7d70, 0x8fd3ed}, 
	{0x7d71, 0xc5fd}, 
	{0x7d72, 0xe5af}, 
	{0x7d73, 0xe5ac}, 
	{0x7d75, 0xb3a8}, 
	{0x7d76, 0xc0e4}, 
	{0x7d78, 0x8fd3ee}, 
	{0x7d79, 0xb8a8}, 
	{0x7d7a, 0x8fd3ef}, 
	{0x7d7b, 0x8fd3f0}, 
	{0x7d7d, 0xe5b8}, 
	{0x7d7f, 0x8fd3f1}, 
	{0x7d81, 0x8fd3f2}, 
	{0x7d82, 0x8fd3f3}, 
	{0x7d83, 0x8fd3f4}, 
	{0x7d85, 0x8fd3f5}, 
	{0x7d86, 0x8fd3f6}, 
	{0x7d88, 0x8fd3f7}, 
	{0x7d89, 0xe5b5}, 
	{0x7d8b, 0x8fd3f8}, 
	{0x7d8c, 0x8fd3f9}, 
	{0x7d8d, 0x8fd3fa}, 
	{0x7d8f, 0xe5b7}, 
	{0x7d91, 0x8fd3fb}, 
	{0x7d93, 0xe5b4}, 
	{0x7d96, 0x8fd3fc}, 
	{0x7d97, 0x8fd3fd}, 
	{0x7d99, 0xb7d1}, 
	{0x7d9a, 0xc2b3}, 
	{0x7d9b, 0xe5b9}, 
	{0x7d9c, 0xc1ee}, 
	{0x7d9d, 0x8fd3fe}, 
	{0x7d9e, 0x8fd4a1}, 
	{0x7d9f, 0xe5c6}, 
	{0x7da2, 0xe5c2}, 
	{0x7da3, 0xe5bc}, 
	{0x7da6, 0x8fd4a2}, 
	{0x7da7, 0x8fd4a3}, 
	{0x7daa, 0x8fd4a4}, 
	{0x7dab, 0xe5c0}, 
	{0x7dac, 0xbcfa}, 
	{0x7dad, 0xb0dd}, 
	{0x7dae, 0xe5bb}, 
	{0x7daf, 0xe5c3}, 
	{0x7db0, 0xe5c7}, 
	{0x7db1, 0xb9cb}, 
	{0x7db2, 0xccd6}, 
	{0x7db3, 0x8fd4a5}, 
	{0x7db4, 0xc4d6}, 
	{0x7db5, 0xe5bd}, 
	{0x7db6, 0x8fd4a6}, 
	{0x7db7, 0x8fd4a7}, 
	{0x7db8, 0xe5c5}, 
	{0x7db9, 0x8fd4a8}, 
	{0x7dba, 0xe5ba}, 
	{0x7dbb, 0xc3be}, 
	{0x7dbd, 0xe5bf}, 
	{0x7dbe, 0xb0bd}, 
	{0x7dbf, 0xccca}, 
	{0x7dc2, 0x8fd4a9}, 
	{0x7dc3, 0x8fd4aa}, 
	{0x7dc4, 0x8fd4ab}, 
	{0x7dc5, 0x8fd4ac}, 
	{0x7dc6, 0x8fd4ad}, 
	{0x7dc7, 0xe5be}, 
	{0x7dca, 0xb6db}, 
	{0x7dcb, 0xc8ec}, 
	{0x7dcc, 0x8fd4ae}, 
	{0x7dcd, 0x8fd4af}, 
	{0x7dce, 0x8fd4b0}, 
	{0x7dcf, 0xc1ed}, 
	{0x7dd1, 0xced0}, 
	{0x7dd2, 0xbdef}, 
	{0x7dd5, 0xe5ee}, 
	{0x7dd7, 0x8fd4b1}, 
	{0x7dd8, 0xe5c8}, 
	{0x7dd9, 0x8fd4b2}, 
	{0x7dda, 0xc0fe}, 
	{0x7ddc, 0xe5c4}, 
	{0x7ddd, 0xe5c9}, 
	{0x7dde, 0xe5cb}, 
	{0x7de0, 0xc4f9}, 
	{0x7de1, 0xe5ce}, 
	{0x7de2, 0x8fd4b4}, 
	{0x7de4, 0xe5ca}, 
	{0x7de5, 0x8fd4b5}, 
	{0x7de6, 0x8fd4b6}, 
	{0x7de8, 0xcad4}, 
	{0x7de9, 0xb4cb}, 
	{0x7dea, 0x8fd4b7}, 
	{0x7deb, 0x8fd4b8}, 
	{0x7dec, 0xcccb}, 
	{0x7ded, 0x8fd4b9}, 
	{0x7def, 0xb0de}, 
	{0x7df1, 0x8fd4ba}, 
	{0x7df2, 0xe5cd}, 
	{0x7df4, 0xcefd}, 
	{0x7df5, 0x8fd4bb}, 
	{0x7df6, 0x8fd4bc}, 
	{0x7df9, 0x8fd4bd}, 
	{0x7dfa, 0x8fd4be}, 
	{0x7dfb, 0xe5cc}, 
	{0x7e00, 0x8fd4b3}, 
	{0x7e01, 0xb1ef}, 
	{0x7e04, 0xc6ec}, 
	{0x7e05, 0xe5cf}, 
	{0x7e08, 0x8fd4bf}, 
	{0x7e09, 0xe5d6}, 
	{0x7e0a, 0xe5d0}, 
	{0x7e0b, 0xe5d7}, 
	{0x7e10, 0x8fd4c0}, 
	{0x7e11, 0x8fd4c1}, 
	{0x7e12, 0xe5d3}, 
	{0x7e15, 0x8fd4c2}, 
	{0x7e17, 0x8fd4c3}, 
	{0x7e1b, 0xc7fb}, 
	{0x7e1c, 0x8fd4c4}, 
	{0x7e1d, 0x8fd4c5}, 
	{0x7e1e, 0xbcca}, 
	{0x7e1f, 0xe5d5}, 
	{0x7e20, 0x8fd4c6}, 
	{0x7e21, 0xe5d2}, 
	{0x7e22, 0xe5d8}, 
	{0x7e23, 0xe5d1}, 
	{0x7e26, 0xbdc4}, 
	{0x7e27, 0x8fd4c7}, 
	{0x7e28, 0x8fd4c8}, 
	{0x7e2b, 0xcba5}, 
	{0x7e2c, 0x8fd4c9}, 
	{0x7e2d, 0x8fd4ca}, 
	{0x7e2e, 0xbdcc}, 
	{0x7e2f, 0x8fd4cb}, 
	{0x7e31, 0xe5d4}, 
	{0x7e32, 0xe5e0}, 
	{0x7e33, 0x8fd4cc}, 
	{0x7e35, 0xe5dc}, 
	{0x7e36, 0x8fd4cd}, 
	{0x7e37, 0xe5df}, 
	{0x7e39, 0xe5dd}, 
	{0x7e3a, 0xe5e1}, 
	{0x7e3b, 0xe5db}, 
	{0x7e3d, 0xe5c1}, 
	{0x7e3e, 0xc0d3}, 
	{0x7e3f, 0x8fd4ce}, 
	{0x7e41, 0xc8cb}, 
	{0x7e43, 0xe5de}, 
	{0x7e44, 0x8fd4cf}, 
	{0x7e45, 0x8fd4d0}, 
	{0x7e46, 0xe5d9}, 
	{0x7e47, 0x8fd4d1}, 
	{0x7e4a, 0xc1a1}, 
	{0x7e4b, 0xb7d2}, 
	{0x7e4d, 0xbdab}, 
	{0x7e4e, 0x8fd4d2}, 
	{0x7e50, 0x8fd4d3}, 
	{0x7e52, 0x8fd4d4}, 
	{0x7e54, 0xbfa5}, 
	{0x7e55, 0xc1b6}, 
	{0x7e56, 0xe5e4}, 
	{0x7e58, 0x8fd4d5}, 
	{0x7e59, 0xe5e6}, 
	{0x7e5a, 0xe5e7}, 
	{0x7e5d, 0xe5e3}, 
	{0x7e5e, 0xe5e5}, 
	{0x7e5f, 0x8fd4d6}, 
	{0x7e61, 0x8fd4d7}, 
	{0x7e62, 0x8fd4d8}, 
	{0x7e65, 0x8fd4d9}, 
	{0x7e66, 0xe5da}, 
	{0x7e67, 0xe5e2}, 
	{0x7e69, 0xe5ea}, 
	{0x7e6a, 0xe5e9}, 
	{0x7e6b, 0x8fd4da}, 
	{0x7e6d, 0xcbfa}, 
	{0x7e6e, 0x8fd4db}, 
	{0x7e6f, 0x8fd4dc}, 
	{0x7e70, 0xb7ab}, 
	{0x7e73, 0x8fd4dd}, 
	{0x7e78, 0x8fd4de}, 
	{0x7e79, 0xe5e8}, 
	{0x7e7b, 0xe5ec}, 
	{0x7e7c, 0xe5eb}, 
	{0x7e7d, 0xe5ef}, 
	{0x7e7e, 0x8fd4df}, 
	{0x7e7f, 0xe5f1}, 
	{0x7e81, 0x8fd4e0}, 
	{0x7e82, 0xbbbc}, 
	{0x7e83, 0xe5ed}, 
	{0x7e86, 0x8fd4e1}, 
	{0x7e87, 0x8fd4e2}, 
	{0x7e88, 0xe5f2}, 
	{0x7e89, 0xe5f3}, 
	{0x7e8a, 0x8fd4e3}, 
	{0x7e8c, 0xe5f4}, 
	{0x7e8d, 0x8fd4e4}, 
	{0x7e8e, 0xe5fa}, 
	{0x7e8f, 0xc5bb}, 
	{0x7e90, 0xe5f6}, 
	{0x7e91, 0x8fd4e5}, 
	{0x7e92, 0xe5f5}, 
	{0x7e93, 0xe5f7}, 
	{0x7e94, 0xe5f8}, 
	{0x7e95, 0x8fd4e6}, 
	{0x7e96, 0xe5f9}, 
	{0x7e98, 0x8fd4e7}, 
	{0x7e9a, 0x8fd4e8}, 
	{0x7e9b, 0xe5fb}, 
	{0x7e9c, 0xe5fc}, 
	{0x7e9d, 0x8fd4e9}, 
	{0x7e9e, 0x8fd4ea}, 
	{0x7f36, 0xb4cc}, 
	{0x7f38, 0xe5fd}, 
	{0x7f3a, 0xe5fe}, 
	{0x7f3b, 0x8fd4ec}, 
	{0x7f3c, 0x8fd4eb}, 
	{0x7f3d, 0x8fd4ed}, 
	{0x7f3e, 0x8fd4ee}, 
	{0x7f3f, 0x8fd4ef}, 
	{0x7f43, 0x8fd4f0}, 
	{0x7f44, 0x8fd4f1}, 
	{0x7f45, 0xe6a1}, 
	{0x7f47, 0x8fd4f2}, 
	{0x7f4c, 0xe6a2}, 
	{0x7f4d, 0xe6a3}, 
	{0x7f4e, 0xe6a4}, 
	{0x7f4f, 0x8fd4f3}, 
	{0x7f50, 0xe6a5}, 
	{0x7f51, 0xe6a6}, 
	{0x7f52, 0x8fd4f4}, 
	{0x7f53, 0x8fd4f5}, 
	{0x7f54, 0xe6a8}, 
	{0x7f55, 0xe6a7}, 
	{0x7f58, 0xe6a9}, 
	{0x7f5b, 0x8fd4f6}, 
	{0x7f5c, 0x8fd4f7}, 
	{0x7f5d, 0x8fd4f8}, 
	{0x7f5f, 0xe6aa}, 
	{0x7f60, 0xe6ab}, 
	{0x7f61, 0x8fd4f9}, 
	{0x7f63, 0x8fd4fa}, 
	{0x7f64, 0x8fd4fb}, 
	{0x7f65, 0x8fd4fc}, 
	{0x7f66, 0x8fd4fd}, 
	{0x7f67, 0xe6ae}, 
	{0x7f68, 0xe6ac}, 
	{0x7f69, 0xe6ad}, 
	{0x7f6a, 0xbae1}, 
	{0x7f6b, 0xb7d3}, 
	{0x7f6d, 0x8fd4fe}, 
	{0x7f6e, 0xc3d6}, 
	{0x7f70, 0xc8b3}, 
	{0x7f71, 0x8fd5a1}, 
	{0x7f72, 0xbdf0}, 
	{0x7f75, 0xc7cd}, 
	{0x7f77, 0xc8ed}, 
	{0x7f78, 0xe6af}, 
	{0x7f79, 0xd8ed}, 
	{0x7f7d, 0x8fd5a2}, 
	{0x7f7e, 0x8fd5a3}, 
	{0x7f7f, 0x8fd5a4}, 
	{0x7f80, 0x8fd5a5}, 
	{0x7f82, 0xe6b0}, 
	{0x7f83, 0xe6b2}, 
	{0x7f85, 0xcde5}, 
	{0x7f86, 0xe6b1}, 
	{0x7f87, 0xe6b4}, 
	{0x7f88, 0xe6b3}, 
	{0x7f8a, 0xcdd3}, 
	{0x7f8b, 0x8fd5a6}, 
	{0x7f8c, 0xe6b5}, 
	{0x7f8d, 0x8fd5a7}, 
	{0x7f8e, 0xc8fe}, 
	{0x7f8f, 0x8fd5a8}, 
	{0x7f90, 0x8fd5a9}, 
	{0x7f91, 0x8fd5aa}, 
	{0x7f94, 0xe6b6}, 
	{0x7f96, 0x8fd5ab}, 
	{0x7f97, 0x8fd5ac}, 
	{0x7f9a, 0xe6b9}, 
	{0x7f9c, 0x8fd5ad}, 
	{0x7f9d, 0xe6b8}, 
	{0x7f9e, 0xe6b7}, 
	{0x7fa1, 0x8fd5ae}, 
	{0x7fa2, 0x8fd5af}, 
	{0x7fa3, 0xe6ba}, 
	{0x7fa4, 0xb7b2}, 
	{0x7fa6, 0x8fd5b0}, 
	{0x7fa8, 0xc1a2}, 
	{0x7fa9, 0xb5c1}, 
	{0x7faa, 0x8fd5b1}, 
	{0x7fad, 0x8fd5b2}, 
	{0x7fae, 0xe6be}, 
	{0x7faf, 0xe6bb}, 
	{0x7fb2, 0xe6bc}, 
	{0x7fb4, 0x8fd5b3}, 
	{0x7fb6, 0xe6bf}, 
	{0x7fb8, 0xe6c0}, 
	{0x7fb9, 0xe6bd}, 
	{0x7fbc, 0x8fd5b4}, 
	{0x7fbd, 0xb1a9}, 
	{0x7fbf, 0x8fd5b5}, 
	{0x7fc0, 0x8fd5b6}, 
	{0x7fc1, 0xb2a7}, 
	{0x7fc3, 0x8fd5b7}, 
	{0x7fc5, 0xe6c2}, 
	{0x7fc6, 0xe6c3}, 
	{0x7fc8, 0x8fd5b8}, 
	{0x7fca, 0xe6c4}, 
	{0x7fcc, 0xcde2}, 
	{0x7fce, 0x8fd5b9}, 
	{0x7fcf, 0x8fd5ba}, 
	{0x7fd2, 0xbdac}, 
	{0x7fd4, 0xe6c6}, 
	{0x7fd5, 0xe6c5}, 
	{0x7fdb, 0x8fd5bb}, 
	{0x7fdf, 0x8fd5bc}, 
	{0x7fe0, 0xbfe9}, 
	{0x7fe1, 0xe6c7}, 
	{0x7fe3, 0x8fd5bd}, 
	{0x7fe5, 0x8fd5be}, 
	{0x7fe6, 0xe6c8}, 
	{0x7fe8, 0x8fd5bf}, 
	{0x7fe9, 0xe6c9}, 
	{0x7feb, 0xb4e5}, 
	{0x7fec, 0x8fd5c0}, 
	{0x7fee, 0x8fd5c1}, 
	{0x7fef, 0x8fd5c2}, 
	{0x7ff0, 0xb4cd}, 
	{0x7ff2, 0x8fd5c3}, 
	{0x7ff3, 0xe6ca}, 
	{0x7ff9, 0xe6cb}, 
	{0x7ffa, 0x8fd5c4}, 
	{0x7ffb, 0xcbdd}, 
	{0x7ffc, 0xcde3}, 
	{0x7ffd, 0x8fd5c5}, 
	{0x7ffe, 0x8fd5c6}, 
	{0x7fff, 0x8fd5c7}, 
	{0x8000, 0xcdd4}, 
	{0x8001, 0xcfb7}, 
	{0x8003, 0xb9cd}, 
	{0x8004, 0xe6ce}, 
	{0x8005, 0xbcd4}, 
	{0x8006, 0xe6cd}, 
	{0x8007, 0x8fd5c8}, 
	{0x8008, 0x8fd5c9}, 
	{0x800a, 0x8fd5ca}, 
	{0x800b, 0xe6cf}, 
	{0x800c, 0xbca9}, 
	{0x800d, 0x8fd5cb}, 
	{0x800e, 0x8fd5cc}, 
	{0x800f, 0x8fd5cd}, 
	{0x8010, 0xc2d1}, 
	{0x8011, 0x8fd5ce}, 
	{0x8012, 0xe6d0}, 
	{0x8013, 0x8fd5cf}, 
	{0x8014, 0x8fd5d0}, 
	{0x8015, 0xb9cc}, 
	{0x8016, 0x8fd5d1}, 
	{0x8017, 0xccd7}, 
	{0x8018, 0xe6d1}, 
	{0x8019, 0xe6d2}, 
	{0x801c, 0xe6d3}, 
	{0x801d, 0x8fd5d2}, 
	{0x801e, 0x8fd5d3}, 
	{0x801f, 0x8fd5d4}, 
	{0x8020, 0x8fd5d5}, 
	{0x8021, 0xe6d4}, 
	{0x8024, 0x8fd5d6}, 
	{0x8026, 0x8fd5d7}, 
	{0x8028, 0xe6d5}, 
	{0x802c, 0x8fd5d8}, 
	{0x802e, 0x8fd5d9}, 
	{0x8030, 0x8fd5da}, 
	{0x8033, 0xbcaa}, 
	{0x8034, 0x8fd5db}, 
	{0x8035, 0x8fd5dc}, 
	{0x8036, 0xcced}, 
	{0x8037, 0x8fd5dd}, 
	{0x8039, 0x8fd5de}, 
	{0x803a, 0x8fd5df}, 
	{0x803b, 0xe6d7}, 
	{0x803c, 0x8fd5e0}, 
	{0x803d, 0xc3bf}, 
	{0x803e, 0x8fd5e1}, 
	{0x803f, 0xe6d6}, 
	{0x8040, 0x8fd5e2}, 
	{0x8044, 0x8fd5e3}, 
	{0x8046, 0xe6d9}, 
	{0x804a, 0xe6d8}, 
	{0x8052, 0xe6da}, 
	{0x8056, 0xc0bb}, 
	{0x8058, 0xe6db}, 
	{0x805a, 0xe6dc}, 
	{0x805e, 0xcab9}, 
	{0x805f, 0xe6dd}, 
	{0x8060, 0x8fd5e4}, 
	{0x8061, 0xc1ef}, 
	{0x8062, 0xe6de}, 
	{0x8064, 0x8fd5e5}, 
	{0x8066, 0x8fd5e6}, 
	{0x8068, 0xe6df}, 
	{0x806d, 0x8fd5e7}, 
	{0x806f, 0xcefe}, 
	{0x8070, 0xe6e2}, 
	{0x8071, 0x8fd5e8}, 
	{0x8072, 0xe6e1}, 
	{0x8073, 0xe6e0}, 
	{0x8074, 0xc4b0}, 
	{0x8075, 0x8fd5e9}, 
	{0x8076, 0xe6e3}, 
	{0x8077, 0xbfa6}, 
	{0x8079, 0xe6e4}, 
	{0x807d, 0xe6e5}, 
	{0x807e, 0xcfb8}, 
	{0x807f, 0xe6e6}, 
	{0x8081, 0x8fd5ea}, 
	{0x8084, 0xe6e7}, 
	{0x8085, 0xe6e9}, 
	{0x8086, 0xe6e8}, 
	{0x8087, 0xc8a5}, 
	{0x8088, 0x8fd5eb}, 
	{0x8089, 0xc6f9}, 
	{0x808b, 0xcfbe}, 
	{0x808c, 0xc8a9}, 
	{0x808e, 0x8fd5ec}, 
	{0x8093, 0xe6eb}, 
	{0x8096, 0xbed3}, 
	{0x8098, 0xc9aa}, 
	{0x809a, 0xe6ec}, 
	{0x809b, 0xe6ea}, 
	{0x809c, 0x8fd5ed}, 
	{0x809d, 0xb4ce}, 
	{0x809e, 0x8fd5ee}, 
	{0x80a1, 0xb8d4}, 
	{0x80a2, 0xbbe8}, 
	{0x80a5, 0xc8ee}, 
	{0x80a6, 0x8fd5ef}, 
	{0x80a7, 0x8fd5f0}, 
	{0x80a9, 0xb8aa}, 
	{0x80aa, 0xcbc3}, 
	{0x80ab, 0x8fd5f1}, 
	{0x80ac, 0xe6ef}, 
	{0x80ad, 0xe6ed}, 
	{0x80af, 0xb9ce}, 
	{0x80b1, 0xb9cf}, 
	{0x80b2, 0xb0e9}, 
	{0x80b4, 0xbae8}, 
	{0x80b8, 0x8fd5f2}, 
	{0x80b9, 0x8fd5f3}, 
	{0x80ba, 0xc7d9}, 
	{0x80c3, 0xb0df}, 
	{0x80c4, 0xe6f4}, 
	{0x80c6, 0xc3c0}, 
	{0x80c8, 0x8fd5f4}, 
	{0x80cc, 0xc7d8}, 
	{0x80cd, 0x8fd5f5}, 
	{0x80ce, 0xc2db}, 
	{0x80cf, 0x8fd5f6}, 
	{0x80d2, 0x8fd5f7}, 
	{0x80d4, 0x8fd5f8}, 
	{0x80d5, 0x8fd5f9}, 
	{0x80d6, 0xe6f6}, 
	{0x80d7, 0x8fd5fa}, 
	{0x80d8, 0x8fd5fb}, 
	{0x80d9, 0xe6f2}, 
	{0x80da, 0xe6f5}, 
	{0x80db, 0xe6f0}, 
	{0x80dd, 0xe6f3}, 
	{0x80de, 0xcba6}, 
	{0x80e0, 0x8fd5fc}, 
	{0x80e1, 0xb8d5}, 
	{0x80e4, 0xb0fd}, 
	{0x80e5, 0xe6f1}, 
	{0x80ed, 0x8fd5fd}, 
	{0x80ee, 0x8fd5fe}, 
	{0x80ef, 0xe6f8}, 
	{0x80f0, 0x8fd6a1}, 
	{0x80f1, 0xe6f9}, 
	{0x80f2, 0x8fd6a2}, 
	{0x80f3, 0x8fd6a3}, 
	{0x80f4, 0xc6b9}, 
	{0x80f6, 0x8fd6a4}, 
	{0x80f8, 0xb6bb}, 
	{0x80f9, 0x8fd6a5}, 
	{0x80fa, 0x8fd6a6}, 
	{0x80fc, 0xe7a6}, 
	{0x80fd, 0xc7bd}, 
	{0x80fe, 0x8fd6a7}, 
	{0x8102, 0xbbe9}, 
	{0x8103, 0x8fd6a8}, 
	{0x8105, 0xb6bc}, 
	{0x8106, 0xc0c8}, 
	{0x8107, 0xcfc6}, 
	{0x8108, 0xccae}, 
	{0x8109, 0xe6f7}, 
	{0x810a, 0xc0d4}, 
	{0x810b, 0x8fd6a9}, 
	{0x8116, 0x8fd6aa}, 
	{0x8117, 0x8fd6ab}, 
	{0x8118, 0x8fd6ac}, 
	{0x811a, 0xb5d3}, 
	{0x811b, 0xe6fa}, 
	{0x811c, 0x8fd6ad}, 
	{0x811e, 0x8fd6ae}, 
	{0x8120, 0x8fd6af}, 
	{0x8123, 0xe6fc}, 
	{0x8124, 0x8fd6b0}, 
	{0x8127, 0x8fd6b1}, 
	{0x8129, 0xe6fb}, 
	{0x812c, 0x8fd6b2}, 
	{0x812f, 0xe6fd}, 
	{0x8130, 0x8fd6b3}, 
	{0x8131, 0xc3a6}, 
	{0x8133, 0xc7be}, 
	{0x8135, 0x8fd6b4}, 
	{0x8139, 0xc4b1}, 
	{0x813a, 0x8fd6b5}, 
	{0x813c, 0x8fd6b6}, 
	{0x813e, 0xe7a3}, 
	{0x8145, 0x8fd6b7}, 
	{0x8146, 0xe7a2}, 
	{0x8147, 0x8fd6b8}, 
	{0x814a, 0x8fd6b9}, 
	{0x814b, 0xe6fe}, 
	{0x814c, 0x8fd6ba}, 
	{0x814e, 0xbfd5}, 
	{0x8150, 0xc9e5}, 
	{0x8151, 0xe7a5}, 
	{0x8152, 0x8fd6bb}, 
	{0x8153, 0xe7a4}, 
	{0x8154, 0xb9d0}, 
	{0x8155, 0xcfd3}, 
	{0x8157, 0x8fd6bc}, 
	{0x815f, 0xe7b5}, 
	{0x8160, 0x8fd6bd}, 
	{0x8161, 0x8fd6be}, 
	{0x8165, 0xe7a9}, 
	{0x8166, 0xe7aa}, 
	{0x8167, 0x8fd6bf}, 
	{0x8168, 0x8fd6c0}, 
	{0x8169, 0x8fd6c1}, 
	{0x816b, 0xbcf0}, 
	{0x816d, 0x8fd6c2}, 
	{0x816e, 0xe7a8}, 
	{0x816f, 0x8fd6c3}, 
	{0x8170, 0xb9f8}, 
	{0x8171, 0xe7a7}, 
	{0x8174, 0xe7ab}, 
	{0x8177, 0x8fd6c4}, 
	{0x8178, 0xc4b2}, 
	{0x8179, 0xcaa2}, 
	{0x817a, 0xc1a3}, 
	{0x817f, 0xc2dc}, 
	{0x8180, 0xe7af}, 
	{0x8181, 0x8fd6c5}, 
	{0x8182, 0xe7b0}, 
	{0x8183, 0xe7ac}, 
	{0x8184, 0x8fd6c7}, 
	{0x8185, 0x8fd6c8}, 
	{0x8186, 0x8fd6c9}, 
	{0x8188, 0xe7ad}, 
	{0x818a, 0xe7ae}, 
	{0x818b, 0x8fd6ca}, 
	{0x818e, 0x8fd6cb}, 
	{0x818f, 0xb9d1}, 
	{0x8190, 0x8fd6c6}, 
	{0x8193, 0xe7b6}, 
	{0x8195, 0xe7b2}, 
	{0x8196, 0x8fd6cc}, 
	{0x8198, 0x8fd6cd}, 
	{0x819a, 0xc9e6}, 
	{0x819b, 0x8fd6ce}, 
	{0x819c, 0xcbec}, 
	{0x819d, 0xc9a8}, 
	{0x819e, 0x8fd6cf}, 
	{0x81a0, 0xe7b1}, 
	{0x81a2, 0x8fd6d0}, 
	{0x81a3, 0xe7b4}, 
	{0x81a4, 0xe7b3}, 
	{0x81a8, 0xcbc4}, 
	{0x81a9, 0xe7b7}, 
	{0x81ae, 0x8fd6d1}, 
	{0x81b0, 0xe7b8}, 
	{0x81b2, 0x8fd6d2}, 
	{0x81b3, 0xc1b7}, 
	{0x81b4, 0x8fd6d3}, 
	{0x81b5, 0xe7b9}, 
	{0x81b8, 0xe7bb}, 
	{0x81ba, 0xe7bf}, 
	{0x81bb, 0x8fd6d4}, 
	{0x81bd, 0xe7bc}, 
	{0x81be, 0xe7ba}, 
	{0x81bf, 0xc7bf}, 
	{0x81c0, 0xe7bd}, 
	{0x81c2, 0xe7be}, 
	{0x81c3, 0x8fd6d6}, 
	{0x81c5, 0x8fd6d7}, 
	{0x81c6, 0xb2b2}, 
	{0x81c8, 0xe7c5}, 
	{0x81c9, 0xe7c0}, 
	{0x81ca, 0x8fd6d8}, 
	{0x81cb, 0x8fd6d5}, 
	{0x81cd, 0xe7c1}, 
	{0x81ce, 0x8fd6d9}, 
	{0x81cf, 0x8fd6da}, 
	{0x81d1, 0xe7c2}, 
	{0x81d3, 0xc2a1}, 
	{0x81d5, 0x8fd6db}, 
	{0x81d7, 0x8fd6dc}, 
	{0x81d8, 0xe7c4}, 
	{0x81d9, 0xe7c3}, 
	{0x81da, 0xe7c6}, 
	{0x81db, 0x8fd6dd}, 
	{0x81dd, 0x8fd6de}, 
	{0x81de, 0x8fd6df}, 
	{0x81df, 0xe7c7}, 
	{0x81e0, 0xe7c8}, 
	{0x81e1, 0x8fd6e0}, 
	{0x81e3, 0xbfc3}, 
	{0x81e4, 0x8fd6e1}, 
	{0x81e5, 0xb2e9}, 
	{0x81e7, 0xe7c9}, 
	{0x81e8, 0xced7}, 
	{0x81ea, 0xbcab}, 
	{0x81eb, 0x8fd6e2}, 
	{0x81ec, 0x8fd6e3}, 
	{0x81ed, 0xbdad}, 
	{0x81f0, 0x8fd6e4}, 
	{0x81f1, 0x8fd6e5}, 
	{0x81f2, 0x8fd6e6}, 
	{0x81f3, 0xbbea}, 
	{0x81f4, 0xc3d7}, 
	{0x81f5, 0x8fd6e7}, 
	{0x81f6, 0x8fd6e8}, 
	{0x81f8, 0x8fd6e9}, 
	{0x81f9, 0x8fd6ea}, 
	{0x81fa, 0xe7ca}, 
	{0x81fb, 0xe7cb}, 
	{0x81fc, 0xb1b1}, 
	{0x81fd, 0x8fd6eb}, 
	{0x81fe, 0xe7cc}, 
	{0x81ff, 0x8fd6ec}, 
	{0x8200, 0x8fd6ed}, 
	{0x8201, 0xe7cd}, 
	{0x8202, 0xe7ce}, 
	{0x8203, 0x8fd6ee}, 
	{0x8205, 0xe7cf}, 
	{0x8207, 0xe7d0}, 
	{0x8208, 0xb6bd}, 
	{0x8209, 0xdaaa}, 
	{0x820a, 0xe7d1}, 
	{0x820c, 0xc0e5}, 
	{0x820d, 0xe7d2}, 
	{0x820e, 0xbccb}, 
	{0x820f, 0x8fd6ef}, 
	{0x8210, 0xe7d3}, 
	{0x8212, 0xd0b0}, 
	{0x8213, 0x8fd6f0}, 
	{0x8214, 0x8fd6f1}, 
	{0x8216, 0xe7d4}, 
	{0x8217, 0xcade}, 
	{0x8218, 0xb4dc}, 
	{0x8219, 0x8fd6f2}, 
	{0x821a, 0x8fd6f3}, 
	{0x821b, 0xc1a4}, 
	{0x821c, 0xbdd8}, 
	{0x821d, 0x8fd6f4}, 
	{0x821e, 0xc9f1}, 
	{0x821f, 0xbdae}, 
	{0x8221, 0x8fd6f5}, 
	{0x8222, 0x8fd6f6}, 
	{0x8228, 0x8fd6f7}, 
	{0x8229, 0xe7d5}, 
	{0x822a, 0xb9d2}, 
	{0x822b, 0xe7d6}, 
	{0x822c, 0xc8cc}, 
	{0x822e, 0xe7e4}, 
	{0x8232, 0x8fd6f8}, 
	{0x8233, 0xe7d8}, 
	{0x8234, 0x8fd6f9}, 
	{0x8235, 0xc2c9}, 
	{0x8236, 0xc7f5}, 
	{0x8237, 0xb8bf}, 
	{0x8238, 0xe7d7}, 
	{0x8239, 0xc1a5}, 
	{0x823a, 0x8fd6fa}, 
	{0x8240, 0xe7d9}, 
	{0x8243, 0x8fd6fb}, 
	{0x8244, 0x8fd6fc}, 
	{0x8245, 0x8fd6fd}, 
	{0x8246, 0x8fd6fe}, 
	{0x8247, 0xc4fa}, 
	{0x824b, 0x8fd7a1}, 
	{0x824e, 0x8fd7a2}, 
	{0x824f, 0x8fd7a3}, 
	{0x8251, 0x8fd7a4}, 
	{0x8256, 0x8fd7a5}, 
	{0x8258, 0xe7db}, 
	{0x8259, 0xe7da}, 
	{0x825a, 0xe7dd}, 
	{0x825c, 0x8fd7a6}, 
	{0x825d, 0xe7dc}, 
	{0x825f, 0xe7de}, 
	{0x8260, 0x8fd7a7}, 
	{0x8262, 0xe7e0}, 
	{0x8263, 0x8fd7a8}, 
	{0x8264, 0xe7df}, 
	{0x8266, 0xb4cf}, 
	{0x8267, 0x8fd7a9}, 
	{0x8268, 0xe7e1}, 
	{0x826a, 0xe7e2}, 
	{0x826b, 0xe7e3}, 
	{0x826d, 0x8fd7aa}, 
	{0x826e, 0xbab1}, 
	{0x826f, 0xcec9}, 
	{0x8271, 0xe7e5}, 
	{0x8272, 0xbfa7}, 
	{0x8274, 0x8fd7ab}, 
	{0x8276, 0xb1f0}, 
	{0x8277, 0xe7e6}, 
	{0x8278, 0xe7e7}, 
	{0x827b, 0x8fd7ac}, 
	{0x827d, 0x8fd7ad}, 
	{0x827e, 0xe7e8}, 
	{0x827f, 0x8fd7ae}, 
	{0x8280, 0x8fd7af}, 
	{0x8281, 0x8fd7b0}, 
	{0x8283, 0x8fd7b1}, 
	{0x8284, 0x8fd7b2}, 
	{0x8287, 0x8fd7b3}, 
	{0x8289, 0x8fd7b4}, 
	{0x828a, 0x8fd7b5}, 
	{0x828b, 0xb0f2}, 
	{0x828d, 0xe7e9}, 
	{0x828e, 0x8fd7b6}, 
	{0x8291, 0x8fd7b7}, 
	{0x8292, 0xe7ea}, 
	{0x8294, 0x8fd7b8}, 
	{0x8296, 0x8fd7b9}, 
	{0x8298, 0x8fd7ba}, 
	{0x8299, 0xc9e7}, 
	{0x829a, 0x8fd7bb}, 
	{0x829b, 0x8fd7bc}, 
	{0x829d, 0xbcc7}, 
	{0x829f, 0xe7ec}, 
	{0x82a0, 0x8fd7bd}, 
	{0x82a1, 0x8fd7be}, 
	{0x82a3, 0x8fd7bf}, 
	{0x82a4, 0x8fd7c0}, 
	{0x82a5, 0xb3a9}, 
	{0x82a6, 0xb0b2}, 
	{0x82a7, 0x8fd7c1}, 
	{0x82a8, 0x8fd7c2}, 
	{0x82a9, 0x8fd7c3}, 
	{0x82aa, 0x8fd7c4}, 
	{0x82ab, 0xe7eb}, 
	{0x82ac, 0xe7ee}, 
	{0x82ad, 0xc7ce}, 
	{0x82ae, 0x8fd7c5}, 
	{0x82af, 0xbfc4}, 
	{0x82b0, 0x8fd7c6}, 
	{0x82b1, 0xb2d6}, 
	{0x82b2, 0x8fd7c7}, 
	{0x82b3, 0xcba7}, 
	{0x82b4, 0x8fd7c8}, 
	{0x82b7, 0x8fd7c9}, 
	{0x82b8, 0xb7dd}, 
	{0x82b9, 0xb6dc}, 
	{0x82ba, 0x8fd7ca}, 
	{0x82bb, 0xe7ed}, 
	{0x82bc, 0x8fd7cb}, 
	{0x82bd, 0xb2ea}, 
	{0x82be, 0x8fd7cc}, 
	{0x82bf, 0x8fd7cd}, 
	{0x82c5, 0xb4a3}, 
	{0x82c6, 0x8fd7ce}, 
	{0x82d0, 0x8fd7cf}, 
	{0x82d1, 0xb1f1}, 
	{0x82d2, 0xe7f2}, 
	{0x82d3, 0xceea}, 
	{0x82d4, 0xc2dd}, 
	{0x82d5, 0x8fd7d0}, 
	{0x82d7, 0xc9c4}, 
	{0x82d9, 0xe7fe}, 
	{0x82da, 0x8fd7d1}, 
	{0x82db, 0xb2d7}, 
	{0x82dc, 0xe7fc}, 
	{0x82de, 0xe7fa}, 
	{0x82df, 0xe7f1}, 
	{0x82e0, 0x8fd7d2}, 
	{0x82e1, 0xe7ef}, 
	{0x82e2, 0x8fd7d3}, 
	{0x82e3, 0xe7f0}, 
	{0x82e4, 0x8fd7d4}, 
	{0x82e5, 0xbce3}, 
	{0x82e6, 0xb6ec}, 
	{0x82e7, 0xc3f7}, 
	{0x82e8, 0x8fd7d5}, 
	{0x82ea, 0x8fd7d6}, 
	{0x82eb, 0xc6d1}, 
	{0x82ed, 0x8fd7d7}, 
	{0x82ef, 0x8fd7d8}, 
	{0x82f1, 0xb1d1}, 
	{0x82f3, 0xe7f4}, 
	{0x82f4, 0xe7f3}, 
	{0x82f6, 0x8fd7d9}, 
	{0x82f7, 0x8fd7da}, 
	{0x82f9, 0xe7f9}, 
	{0x82fa, 0xe7f5}, 
	{0x82fb, 0xe7f8}, 
	{0x82fd, 0x8fd7db}, 
	{0x82fe, 0x8fd7dc}, 
	{0x8300, 0x8fd7dd}, 
	{0x8301, 0x8fd7de}, 
	{0x8302, 0xccd0}, 
	{0x8303, 0xe7f7}, 
	{0x8304, 0xb2d8}, 
	{0x8305, 0xb3fd}, 
	{0x8306, 0xe7fb}, 
	{0x8307, 0x8fd7df}, 
	{0x8308, 0x8fd7e0}, 
	{0x8309, 0xe7fd}, 
	{0x830a, 0x8fd7e1}, 
	{0x830b, 0x8fd7e2}, 
	{0x830e, 0xb7d4}, 
	{0x8316, 0xe8a3}, 
	{0x8317, 0xe8ac}, 
	{0x8318, 0xe8ad}, 
	{0x831b, 0x8fd7e4}, 
	{0x831c, 0xb0ab}, 
	{0x831d, 0x8fd7e5}, 
	{0x831e, 0x8fd7e6}, 
	{0x831f, 0x8fd7e7}, 
	{0x8321, 0x8fd7e8}, 
	{0x8322, 0x8fd7e9}, 
	{0x8323, 0xe8b4}, 
	{0x8328, 0xb0f1}, 
	{0x832b, 0xe8ab}, 
	{0x832c, 0x8fd7ea}, 
	{0x832d, 0x8fd7eb}, 
	{0x832e, 0x8fd7ec}, 
	{0x832f, 0xe8aa}, 
	{0x8330, 0x8fd7ed}, 
	{0x8331, 0xe8a5}, 
	{0x8332, 0xe8a4}, 
	{0x8333, 0x8fd7ee}, 
	{0x8334, 0xe8a2}, 
	{0x8335, 0xe8a1}, 
	{0x8336, 0xc3e3}, 
	{0x8337, 0x8fd7ef}, 
	{0x8338, 0xc2fb}, 
	{0x8339, 0xe8a7}, 
	{0x833a, 0x8fd7f0}, 
	{0x833c, 0x8fd7f1}, 
	{0x833d, 0x8fd7f2}, 
	{0x8340, 0xe8a6}, 
	{0x8342, 0x8fd7f3}, 
	{0x8343, 0x8fd7f4}, 
	{0x8344, 0x8fd7f5}, 
	{0x8345, 0xe8a9}, 
	{0x8347, 0x8fd7f6}, 
	{0x8349, 0xc1f0}, 
	{0x834a, 0xb7d5}, 
	{0x834d, 0x8fd7f7}, 
	{0x834e, 0x8fd7f8}, 
	{0x834f, 0xb1c1}, 
	{0x8350, 0xe8a8}, 
	{0x8351, 0x8fd7f9}, 
	{0x8352, 0xb9d3}, 
	{0x8353, 0x8fd8be}, 
	{0x8354, 0x8fd7e3}, 
	{0x8355, 0x8fd7fa}, 
	{0x8356, 0x8fd7fb}, 
	{0x8357, 0x8fd7fc}, 
	{0x8358, 0xc1f1}, 
	{0x8370, 0x8fd7fd}, 
	{0x8373, 0xe8ba}, 
	{0x8375, 0xe8bb}, 
	{0x8377, 0xb2d9}, 
	{0x8378, 0x8fd7fe}, 
	{0x837b, 0xb2ae}, 
	{0x837c, 0xe8b8}, 
	{0x837d, 0x8fd8a1}, 
	{0x837f, 0x8fd8a2}, 
	{0x8380, 0x8fd8a3}, 
	{0x8382, 0x8fd8a4}, 
	{0x8384, 0x8fd8a5}, 
	{0x8385, 0xe8ae}, 
	{0x8386, 0x8fd8a6}, 
	{0x8387, 0xe8b6}, 
	{0x8389, 0xe8bd}, 
	{0x838a, 0xe8b7}, 
	{0x838d, 0x8fd8a7}, 
	{0x838e, 0xe8b5}, 
	{0x8392, 0x8fd8a8}, 
	{0x8393, 0xe7f6}, 
	{0x8394, 0x8fd8a9}, 
	{0x8395, 0x8fd8aa}, 
	{0x8396, 0xe8b3}, 
	{0x8398, 0x8fd8ab}, 
	{0x8399, 0x8fd8ac}, 
	{0x839a, 0xe8af}, 
	{0x839b, 0x8fd8ad}, 
	{0x839c, 0x8fd8ae}, 
	{0x839d, 0x8fd8af}, 
	{0x839e, 0xb4d0}, 
	{0x839f, 0xe8b1}, 
	{0x83a0, 0xe8bc}, 
	{0x83a2, 0xe8b2}, 
	{0x83a6, 0x8fd8b0}, 
	{0x83a7, 0x8fd8b1}, 
	{0x83a8, 0xe8be}, 
	{0x83a9, 0x8fd8b2}, 
	{0x83aa, 0xe8b0}, 
	{0x83ab, 0xc7fc}, 
	{0x83ac, 0x8fd8b3}, 
	{0x83ad, 0x8fd8cc}, 
	{0x83b1, 0xcde9}, 
	{0x83b5, 0xe8b9}, 
	{0x83bd, 0xe8cf}, 
	{0x83be, 0x8fd8b4}, 
	{0x83bf, 0x8fd8b5}, 
	{0x83c0, 0x8fd8b6}, 
	{0x83c1, 0xe8c7}, 
	{0x83c5, 0xbffb}, 
	{0x83c7, 0x8fd8b7}, 
	{0x83c9, 0x8fd8b8}, 
	{0x83ca, 0xb5c6}, 
	{0x83cc, 0xb6dd}, 
	{0x83ce, 0xe8c2}, 
	{0x83cf, 0x8fd8b9}, 
	{0x83d0, 0x8fd8ba}, 
	{0x83d1, 0x8fd8bb}, 
	{0x83d3, 0xb2db}, 
	{0x83d4, 0x8fd8bc}, 
	{0x83d6, 0xbed4}, 
	{0x83d8, 0xe8c5}, 
	{0x83dc, 0xbada}, 
	{0x83dd, 0x8fd8bd}, 
	{0x83df, 0xc5d1}, 
	{0x83e0, 0xe8ca}, 
	{0x83e8, 0x8fd8bf}, 
	{0x83e9, 0xcaee}, 
	{0x83ea, 0x8fd8c0}, 
	{0x83eb, 0xe8c1}, 
	{0x83ef, 0xb2da}, 
	{0x83f0, 0xb8d6}, 
	{0x83f1, 0xc9a9}, 
	{0x83f2, 0xe8cb}, 
	{0x83f4, 0xe8bf}, 
	{0x83f6, 0x8fd8c1}, 
	{0x83f7, 0xe8c8}, 
	{0x83f8, 0x8fd8c2}, 
	{0x83f9, 0x8fd8c3}, 
	{0x83fb, 0xe8d2}, 
	{0x83fc, 0x8fd8c4}, 
	{0x83fd, 0xe8c3}, 
	{0x8401, 0x8fd8c5}, 
	{0x8403, 0xe8c4}, 
	{0x8404, 0xc6ba}, 
	{0x8406, 0x8fd8c6}, 
	{0x8407, 0xe8c9}, 
	{0x840a, 0x8fd8c7}, 
	{0x840b, 0xe8c6}, 
	{0x840c, 0xcba8}, 
	{0x840d, 0xe8cc}, 
	{0x840e, 0xb0e0}, 
	{0x840f, 0x8fd8c8}, 
	{0x8411, 0x8fd8c9}, 
	{0x8413, 0xe8c0}, 
	{0x8415, 0x8fd8ca}, 
	{0x8419, 0x8fd8cb}, 
	{0x8420, 0xe8ce}, 
	{0x8422, 0xe8cd}, 
	{0x8429, 0xc7eb}, 
	{0x842a, 0xe8d4}, 
	{0x842c, 0xe8df}, 
	{0x842f, 0x8fd8cd}, 
	{0x8431, 0xb3fe}, 
	{0x8435, 0xe8e2}, 
	{0x8438, 0xe8d0}, 
	{0x8439, 0x8fd8ce}, 
	{0x843c, 0xe8d5}, 
	{0x843d, 0xcdee}, 
	{0x8445, 0x8fd8cf}, 
	{0x8446, 0xe8de}, 
	{0x8447, 0x8fd8d0}, 
	{0x8448, 0x8fd8d1}, 
	{0x8449, 0xcdd5}, 
	{0x844a, 0x8fd8d2}, 
	{0x844d, 0x8fd8d3}, 
	{0x844e, 0xceaa}, 
	{0x844f, 0x8fd8d4}, 
	{0x8451, 0x8fd8d5}, 
	{0x8452, 0x8fd8d6}, 
	{0x8456, 0x8fd8d7}, 
	{0x8457, 0xc3f8}, 
	{0x8458, 0x8fd8d8}, 
	{0x8459, 0x8fd8d9}, 
	{0x845a, 0x8fd8da}, 
	{0x845b, 0xb3eb}, 
	{0x845c, 0x8fd8db}, 
	{0x8460, 0x8fd8dc}, 
	{0x8461, 0xc9f2}, 
	{0x8462, 0xe8e4}, 
	{0x8463, 0xc6a1}, 
	{0x8464, 0x8fd8dd}, 
	{0x8465, 0x8fd8de}, 
	{0x8466, 0xb0b1}, 
	{0x8467, 0x8fd8df}, 
	{0x8469, 0xe8dd}, 
	{0x846a, 0x8fd8e0}, 
	{0x846b, 0xe8d9}, 
	{0x846c, 0xc1f2}, 
	{0x846d, 0xe8d3}, 
	{0x846e, 0xe8db}, 
	{0x846f, 0xe8e0}, 
	{0x8470, 0x8fd8e1}, 
	{0x8471, 0xc7ac}, 
	{0x8473, 0x8fd8e2}, 
	{0x8474, 0x8fd8e3}, 
	{0x8475, 0xb0aa}, 
	{0x8476, 0x8fd8e4}, 
	{0x8477, 0xe8d8}, 
	{0x8478, 0x8fd8e5}, 
	{0x8479, 0xe8e1}, 
	{0x847a, 0xc9f8}, 
	{0x847c, 0x8fd8e6}, 
	{0x847d, 0x8fd8e7}, 
	{0x8481, 0x8fd8e8}, 
	{0x8482, 0xe8dc}, 
	{0x8484, 0xe8d7}, 
	{0x8485, 0x8fd8e9}, 
	{0x848b, 0xbed5}, 
	{0x8490, 0xbdaf}, 
	{0x8492, 0x8fd8ea}, 
	{0x8493, 0x8fd8eb}, 
	{0x8494, 0xbcac}, 
	{0x8495, 0x8fd8ec}, 
	{0x8499, 0xccd8}, 
	{0x849c, 0xc9c7}, 
	{0x849e, 0x8fd8ed}, 
	{0x849f, 0xe8e7}, 
	{0x84a1, 0xe8f0}, 
	{0x84a6, 0x8fd8ee}, 
	{0x84a8, 0x8fd8ef}, 
	{0x84a9, 0x8fd8f0}, 
	{0x84aa, 0x8fd8f1}, 
	{0x84ad, 0xe8da}, 
	{0x84af, 0x8fd8f2}, 
	{0x84b1, 0x8fd8f3}, 
	{0x84b2, 0xb3f7}, 
	{0x84b4, 0x8fd8f4}, 
	{0x84b8, 0xbef8}, 
	{0x84b9, 0xe8e5}, 
	{0x84ba, 0x8fd8f5}, 
	{0x84bb, 0xe8ea}, 
	{0x84bc, 0xc1f3}, 
	{0x84bd, 0x8fd8f6}, 
	{0x84be, 0x8fd8f7}, 
	{0x84bf, 0xe8e6}, 
	{0x84c0, 0x8fd8f8}, 
	{0x84c1, 0xe8ed}, 
	{0x84c2, 0x8fd8f9}, 
	{0x84c4, 0xc3df}, 
	{0x84c6, 0xe8ee}, 
	{0x84c7, 0x8fd8fa}, 
	{0x84c8, 0x8fd8fb}, 
	{0x84c9, 0xcdd6}, 
	{0x84ca, 0xe8e3}, 
	{0x84cb, 0xb3b8}, 
	{0x84cc, 0x8fd8fc}, 
	{0x84cd, 0xe8e9}, 
	{0x84cf, 0x8fd8fd}, 
	{0x84d0, 0xe8ec}, 
	{0x84d1, 0xccac}, 
	{0x84d3, 0x8fd8fe}, 
	{0x84d6, 0xe8ef}, 
	{0x84d9, 0xe8e8}, 
	{0x84da, 0xe8eb}, 
	{0x84dc, 0x8fd9a1}, 
	{0x84e7, 0x8fd9a2}, 
	{0x84ea, 0x8fd9a3}, 
	{0x84ec, 0xcba9}, 
	{0x84ee, 0xcfa1}, 
	{0x84ef, 0x8fd9a4}, 
	{0x84f0, 0x8fd9a5}, 
	{0x84f1, 0x8fd9a6}, 
	{0x84f2, 0x8fd9a7}, 
	{0x84f4, 0xe8f3}, 
	{0x84f7, 0x8fd9a8}, 
	{0x84fa, 0x8fd9aa}, 
	{0x84fb, 0x8fd9ab}, 
	{0x84fc, 0xe8fa}, 
	{0x84fd, 0x8fd9ac}, 
	{0x84ff, 0xe8f2}, 
	{0x8500, 0xbcc3}, 
	{0x8502, 0x8fd9ad}, 
	{0x8503, 0x8fd9ae}, 
	{0x8506, 0xe8d1}, 
	{0x8507, 0x8fd9af}, 
	{0x850c, 0x8fd9b0}, 
	{0x850e, 0x8fd9b1}, 
	{0x8510, 0x8fd9b2}, 
	{0x8511, 0xcace}, 
	{0x8513, 0xcca2}, 
	{0x8514, 0xe8f9}, 
	{0x8515, 0xe8f8}, 
	{0x8517, 0xe8f4}, 
	{0x8518, 0xe8f5}, 
	{0x851a, 0xb1b6}, 
	{0x851c, 0x8fd9b3}, 
	{0x851e, 0x8fd9b4}, 
	{0x851f, 0xe8f7}, 
	{0x8521, 0xe8f1}, 
	{0x8522, 0x8fd9b5}, 
	{0x8523, 0x8fd9b6}, 
	{0x8524, 0x8fd9b7}, 
	{0x8525, 0x8fd9b8}, 
	{0x8526, 0xc4d5}, 
	{0x8527, 0x8fd9b9}, 
	{0x852a, 0x8fd9ba}, 
	{0x852b, 0x8fd9bb}, 
	{0x852c, 0xe8f6}, 
	{0x852d, 0xb0fe}, 
	{0x852f, 0x8fd9bc}, 
	{0x8532, 0x8fd9a9}, 
	{0x8533, 0x8fd9bd}, 
	{0x8534, 0x8fd9be}, 
	{0x8535, 0xc2a2}, 
	{0x8536, 0x8fd9bf}, 
	{0x853d, 0xcac3}, 
	{0x853f, 0x8fd9c0}, 
	{0x8540, 0xe8fb}, 
	{0x8541, 0xe9a1}, 
	{0x8543, 0xc8d9}, 
	{0x8546, 0x8fd9c1}, 
	{0x8548, 0xe8fe}, 
	{0x8549, 0xbed6}, 
	{0x854a, 0xbcc9}, 
	{0x854b, 0xe9a3}, 
	{0x854e, 0xb6be}, 
	{0x854f, 0x8fd9c2}, 
	{0x8550, 0x8fd9c3}, 
	{0x8551, 0x8fd9c4}, 
	{0x8552, 0x8fd9c5}, 
	{0x8553, 0x8fd9c6}, 
	{0x8555, 0xe9a4}, 
	{0x8556, 0x8fd9c7}, 
	{0x8557, 0xc9f9}, 
	{0x8558, 0xe8fd}, 
	{0x8559, 0x8fd9c8}, 
	{0x855a, 0xe8d6}, 
	{0x855c, 0x8fd9c9}, 
	{0x855d, 0x8fd9ca}, 
	{0x855e, 0x8fd9cb}, 
	{0x855f, 0x8fd9cc}, 
	{0x8560, 0x8fd9cd}, 
	{0x8561, 0x8fd9ce}, 
	{0x8562, 0x8fd9cf}, 
	{0x8563, 0xe8fc}, 
	{0x8564, 0x8fd9d0}, 
	{0x8568, 0xcfcf}, 
	{0x8569, 0xc6a2}, 
	{0x856a, 0xc9f3}, 
	{0x856b, 0x8fd9d1}, 
	{0x856d, 0xe9ab}, 
	{0x856f, 0x8fd9d2}, 
	{0x8577, 0xe9b1}, 
	{0x8579, 0x8fd9d3}, 
	{0x857a, 0x8fd9d4}, 
	{0x857b, 0x8fd9d5}, 
	{0x857d, 0x8fd9d6}, 
	{0x857e, 0xe9b2}, 
	{0x857f, 0x8fd9d7}, 
	{0x8580, 0xe9a5}, 
	{0x8581, 0x8fd9d8}, 
	{0x8584, 0xc7f6}, 
	{0x8585, 0x8fd9d9}, 
	{0x8586, 0x8fd9da}, 
	{0x8587, 0xe9af}, 
	{0x8588, 0xe9a7}, 
	{0x8589, 0x8fd9db}, 
	{0x858a, 0xe9a9}, 
	{0x858b, 0x8fd9dc}, 
	{0x858c, 0x8fd9dd}, 
	{0x858f, 0x8fd9de}, 
	{0x8590, 0xe9b3}, 
	{0x8591, 0xe9a8}, 
	{0x8593, 0x8fd9df}, 
	{0x8594, 0xe9ac}, 
	{0x8597, 0xb1f2}, 
	{0x8598, 0x8fd9e0}, 
	{0x8599, 0xc6e5}, 
	{0x859b, 0xe9ad}, 
	{0x859c, 0xe9b0}, 
	{0x859d, 0x8fd9e1}, 
	{0x859f, 0x8fd9e2}, 
	{0x85a0, 0x8fd9e3}, 
	{0x85a2, 0x8fd9e4}, 
	{0x85a4, 0xe9a6}, 
	{0x85a5, 0x8fd9e5}, 
	{0x85a6, 0xc1a6}, 
	{0x85a7, 0x8fd9e6}, 
	{0x85a8, 0xe9aa}, 
	{0x85a9, 0xbba7}, 
	{0x85aa, 0xbfc5}, 
	{0x85ab, 0xb7b0}, 
	{0x85ac, 0xccf4}, 
	{0x85ad, 0x8fd9f4}, 
	{0x85ae, 0xccf9}, 
	{0x85af, 0xbdf2}, 
	{0x85b4, 0x8fd9e7}, 
	{0x85b6, 0x8fd9e8}, 
	{0x85b7, 0x8fd9e9}, 
	{0x85b8, 0x8fd9ea}, 
	{0x85b9, 0xe9b7}, 
	{0x85ba, 0xe9b5}, 
	{0x85bc, 0x8fd9eb}, 
	{0x85bd, 0x8fd9ec}, 
	{0x85be, 0x8fd9ed}, 
	{0x85bf, 0x8fd9ee}, 
	{0x85c1, 0xcfce}, 
	{0x85c2, 0x8fd9ef}, 
	{0x85c7, 0x8fd9f0}, 
	{0x85c9, 0xe9b4}, 
	{0x85ca, 0x8fd9f1}, 
	{0x85cb, 0x8fd9f2}, 
	{0x85cd, 0xcdf5}, 
	{0x85ce, 0x8fd9f3}, 
	{0x85cf, 0xe9b6}, 
	{0x85d0, 0xe9b8}, 
	{0x85d5, 0xe9b9}, 
	{0x85d8, 0x8fd9f5}, 
	{0x85da, 0x8fd9f6}, 
	{0x85dc, 0xe9bc}, 
	{0x85dd, 0xe9ba}, 
	{0x85df, 0x8fd9f7}, 
	{0x85e0, 0x8fd9f8}, 
	{0x85e4, 0xc6a3}, 
	{0x85e5, 0xe9bb}, 
	{0x85e6, 0x8fd9f9}, 
	{0x85e8, 0x8fd9fa}, 
	{0x85e9, 0xc8cd}, 
	{0x85ea, 0xe9ae}, 
	{0x85ed, 0x8fd9fb}, 
	{0x85f3, 0x8fd9fc}, 
	{0x85f6, 0x8fd9fd}, 
	{0x85f7, 0xbdf3}, 
	{0x85f9, 0xe9bd}, 
	{0x85fa, 0xe9c2}, 
	{0x85fb, 0xc1f4}, 
	{0x85fc, 0x8fd9fe}, 
	{0x85fe, 0xe9c1}, 
	{0x85ff, 0x8fdaa1}, 
	{0x8600, 0x8fdaa2}, 
	{0x8602, 0xe9a2}, 
	{0x8604, 0x8fdaa3}, 
	{0x8605, 0x8fdaa4}, 
	{0x8606, 0xe9c3}, 
	{0x8607, 0xc1c9}, 
	{0x860a, 0xe9be}, 
	{0x860b, 0xe9c0}, 
	{0x860d, 0x8fdaa5}, 
	{0x860e, 0x8fdaa6}, 
	{0x8610, 0x8fdaa7}, 
	{0x8611, 0x8fdaa8}, 
	{0x8612, 0x8fdaa9}, 
	{0x8613, 0xe9bf}, 
	{0x8616, 0xddb1}, 
	{0x8617, 0xdda2}, 
	{0x8618, 0x8fdaaa}, 
	{0x8619, 0x8fdaab}, 
	{0x861a, 0xe9c5}, 
	{0x861b, 0x8fdaac}, 
	{0x861e, 0x8fdaad}, 
	{0x8621, 0x8fdaae}, 
	{0x8622, 0xe9c4}, 
	{0x8627, 0x8fdaaf}, 
	{0x8629, 0x8fdab0}, 
	{0x862d, 0xcdf6}, 
	{0x862f, 0xe2bc}, 
	{0x8630, 0xe9c6}, 
	{0x8636, 0x8fdab1}, 
	{0x8638, 0x8fdab2}, 
	{0x863a, 0x8fdab3}, 
	{0x863c, 0x8fdab4}, 
	{0x863d, 0x8fdab5}, 
	{0x863f, 0xe9c7}, 
	{0x8640, 0x8fdab6}, 
	{0x8641, 0x8fb8e6}, 
	{0x8642, 0x8fdab7}, 
	{0x8646, 0x8fdab8}, 
	{0x864d, 0xe9c8}, 
	{0x864e, 0xb8d7}, 
	{0x8650, 0xb5d4}, 
	{0x8652, 0x8fdab9}, 
	{0x8653, 0x8fdaba}, 
	{0x8654, 0xe9ca}, 
	{0x8655, 0xd1dd}, 
	{0x8656, 0x8fdabb}, 
	{0x8657, 0x8fdabc}, 
	{0x8658, 0x8fdabd}, 
	{0x8659, 0x8fdabe}, 
	{0x865a, 0xb5f5}, 
	{0x865c, 0xceba}, 
	{0x865d, 0x8fdabf}, 
	{0x865e, 0xb6f3}, 
	{0x865f, 0xe9cb}, 
	{0x8660, 0x8fdac0}, 
	{0x8661, 0x8fdac1}, 
	{0x8662, 0x8fdac2}, 
	{0x8663, 0x8fdac3}, 
	{0x8664, 0x8fdac4}, 
	{0x8667, 0xe9cc}, 
	{0x8669, 0x8fdac5}, 
	{0x866b, 0xc3ee}, 
	{0x866c, 0x8fdac6}, 
	{0x866f, 0x8fdac7}, 
	{0x8671, 0xe9cd}, 
	{0x8675, 0x8fdac8}, 
	{0x8676, 0x8fdac9}, 
	{0x8677, 0x8fdaca}, 
	{0x8679, 0xc6fa}, 
	{0x867a, 0x8fdacb}, 
	{0x867b, 0xb0ba}, 
	{0x8688, 0x8fdaed}, 
	{0x868a, 0xb2e3}, 
	{0x868b, 0xe9d2}, 
	{0x868c, 0xe9d3}, 
	{0x868d, 0x8fdacc}, 
	{0x8691, 0x8fdacd}, 
	{0x8693, 0xe9ce}, 
	{0x8695, 0xbbbd}, 
	{0x8696, 0x8fdace}, 
	{0x8698, 0x8fdacf}, 
	{0x869a, 0x8fdad0}, 
	{0x869c, 0x8fdad1}, 
	{0x86a1, 0x8fdad2}, 
	{0x86a3, 0xe9cf}, 
	{0x86a4, 0xc7c2}, 
	{0x86a6, 0x8fdad3}, 
	{0x86a7, 0x8fdad4}, 
	{0x86a8, 0x8fdad5}, 
	{0x86a9, 0xe9d0}, 
	{0x86aa, 0xe9d1}, 
	{0x86ab, 0xe9db}, 
	{0x86ad, 0x8fdad6}, 
	{0x86af, 0xe9d5}, 
	{0x86b0, 0xe9d8}, 
	{0x86b1, 0x8fdad7}, 
	{0x86b3, 0x8fdad8}, 
	{0x86b4, 0x8fdad9}, 
	{0x86b5, 0x8fdada}, 
	{0x86b6, 0xe9d4}, 
	{0x86b7, 0x8fdadb}, 
	{0x86b8, 0x8fdadc}, 
	{0x86b9, 0x8fdadd}, 
	{0x86bf, 0x8fdade}, 
	{0x86c0, 0x8fdadf}, 
	{0x86c1, 0x8fdae0}, 
	{0x86c3, 0x8fdae1}, 
	{0x86c4, 0xe9d6}, 
	{0x86c5, 0x8fdae2}, 
	{0x86c6, 0xe9d7}, 
	{0x86c7, 0xbcd8}, 
	{0x86c9, 0xe9d9}, 
	{0x86cb, 0xc3c1}, 
	{0x86cd, 0xb7d6}, 
	{0x86ce, 0xb3c2}, 
	{0x86d1, 0x8fdae3}, 
	{0x86d2, 0x8fdae4}, 
	{0x86d4, 0xe9dc}, 
	{0x86d5, 0x8fdae5}, 
	{0x86d7, 0x8fdae6}, 
	{0x86d9, 0xb3bf}, 
	{0x86da, 0x8fdae7}, 
	{0x86db, 0xe9e1}, 
	{0x86dc, 0x8fdae8}, 
	{0x86de, 0xe9dd}, 
	{0x86df, 0xe9e0}, 
	{0x86e0, 0x8fdae9}, 
	{0x86e3, 0x8fdaea}, 
	{0x86e4, 0xc8ba}, 
	{0x86e5, 0x8fdaeb}, 
	{0x86e7, 0x8fdaec}, 
	{0x86e9, 0xe9de}, 
	{0x86ec, 0xe9df}, 
	{0x86ed, 0xc9c8}, 
	{0x86ee, 0xc8da}, 
	{0x86ef, 0xe9e2}, 
	{0x86f8, 0xc2fd}, 
	{0x86f9, 0xe9ec}, 
	{0x86fa, 0x8fdaee}, 
	{0x86fb, 0xe9e8}, 
	{0x86fc, 0x8fdaef}, 
	{0x86fd, 0x8fdaf0}, 
	{0x86fe, 0xb2eb}, 
	{0x8700, 0xe9e6}, 
	{0x8702, 0xcbaa}, 
	{0x8703, 0xe9e7}, 
	{0x8704, 0x8fdaf1}, 
	{0x8705, 0x8fdaf2}, 
	{0x8706, 0xe9e4}, 
	{0x8707, 0x8fdaf3}, 
	{0x8708, 0xe9e5}, 
	{0x8709, 0xe9ea}, 
	{0x870a, 0xe9ed}, 
	{0x870b, 0x8fdaf4}, 
	{0x870d, 0xe9eb}, 
	{0x870e, 0x8fdaf5}, 
	{0x870f, 0x8fdaf6}, 
	{0x8710, 0x8fdaf7}, 
	{0x8711, 0xe9e9}, 
	{0x8712, 0xe9e3}, 
	{0x8713, 0x8fdaf8}, 
	{0x8714, 0x8fdaf9}, 
	{0x8718, 0xc3d8}, 
	{0x8719, 0x8fdafa}, 
	{0x871a, 0xe9f4}, 
	{0x871c, 0xccaa}, 
	{0x871e, 0x8fdafb}, 
	{0x871f, 0x8fdafc}, 
	{0x8721, 0x8fdafd}, 
	{0x8723, 0x8fdafe}, 
	{0x8725, 0xe9f2}, 
	{0x8728, 0x8fdba1}, 
	{0x8729, 0xe9f3}, 
	{0x872e, 0x8fdba2}, 
	{0x872f, 0x8fdba3}, 
	{0x8731, 0x8fdba4}, 
	{0x8732, 0x8fdba5}, 
	{0x8734, 0xe9ee}, 
	{0x8737, 0xe9f0}, 
	{0x8739, 0x8fdba6}, 
	{0x873a, 0x8fdba7}, 
	{0x873b, 0xe9f1}, 
	{0x873c, 0x8fdba8}, 
	{0x873d, 0x8fdba9}, 
	{0x873e, 0x8fdbaa}, 
	{0x873f, 0xe9ef}, 
	{0x8740, 0x8fdbab}, 
	{0x8743, 0x8fdbac}, 
	{0x8745, 0x8fdbad}, 
	{0x8749, 0xc0e6}, 
	{0x874b, 0xcfb9}, 
	{0x874c, 0xe9f8}, 
	{0x874d, 0x8fdbae}, 
	{0x874e, 0xe9f9}, 
	{0x8753, 0xeaa1}, 
	{0x8755, 0xbfaa}, 
	{0x8757, 0xe9fb}, 
	{0x8758, 0x8fdbaf}, 
	{0x8759, 0xe9fe}, 
	{0x875d, 0x8fdbb0}, 
	{0x875f, 0xe9f6}, 
	{0x8760, 0xe9f5}, 
	{0x8761, 0x8fdbb1}, 
	{0x8763, 0xeaa2}, 
	{0x8764, 0x8fdbb2}, 
	{0x8765, 0x8fdbb3}, 
	{0x8766, 0xb2dc}, 
	{0x8768, 0xe9fc}, 
	{0x876a, 0xeaa3}, 
	{0x876e, 0xe9fd}, 
	{0x876f, 0x8fdbb4}, 
	{0x8771, 0x8fdbb5}, 
	{0x8772, 0x8fdbb6}, 
	{0x8774, 0xe9fa}, 
	{0x8776, 0xc4b3}, 
	{0x8778, 0xe9f7}, 
	{0x877b, 0x8fdbb7}, 
	{0x877f, 0xc7e8}, 
	{0x8782, 0xeaa7}, 
	{0x8783, 0x8fdbb8}, 
	{0x8784, 0x8fdbb9}, 
	{0x8785, 0x8fdbba}, 
	{0x8786, 0x8fdbbb}, 
	{0x8787, 0x8fdbbc}, 
	{0x8788, 0x8fdbbd}, 
	{0x8789, 0x8fdbbe}, 
	{0x878b, 0x8fdbbf}, 
	{0x878c, 0x8fdbc0}, 
	{0x878d, 0xcdbb}, 
	{0x8790, 0x8fdbc1}, 
	{0x8793, 0x8fdbc2}, 
	{0x8795, 0x8fdbc3}, 
	{0x8797, 0x8fdbc4}, 
	{0x8798, 0x8fdbc5}, 
	{0x8799, 0x8fdbc6}, 
	{0x879e, 0x8fdbc7}, 
	{0x879f, 0xeaa6}, 
	{0x87a0, 0x8fdbc8}, 
	{0x87a2, 0xeaa5}, 
	{0x87a3, 0x8fdbc9}, 
	{0x87a7, 0x8fdbca}, 
	{0x87ab, 0xeaae}, 
	{0x87ac, 0x8fdbcb}, 
	{0x87ad, 0x8fdbcc}, 
	{0x87ae, 0x8fdbcd}, 
	{0x87af, 0xeaa8}, 
	{0x87b1, 0x8fdbce}, 
	{0x87b3, 0xeab0}, 
	{0x87b5, 0x8fdbcf}, 
	{0x87ba, 0xcde6}, 
	{0x87bb, 0xeab3}, 
	{0x87bd, 0xeaaa}, 
	{0x87be, 0x8fdbd0}, 
	{0x87bf, 0x8fdbd1}, 
	{0x87c0, 0xeaab}, 
	{0x87c1, 0x8fdbd2}, 
	{0x87c4, 0xeaaf}, 
	{0x87c6, 0xeab2}, 
	{0x87c7, 0xeab1}, 
	{0x87c8, 0x8fdbd3}, 
	{0x87c9, 0x8fdbd4}, 
	{0x87ca, 0x8fdbd5}, 
	{0x87cb, 0xeaa9}, 
	{0x87ce, 0x8fdbd6}, 
	{0x87d0, 0xeaac}, 
	{0x87d2, 0xeabd}, 
	{0x87d5, 0x8fdbd7}, 
	{0x87d6, 0x8fdbd8}, 
	{0x87d9, 0x8fdbd9}, 
	{0x87da, 0x8fdbda}, 
	{0x87dc, 0x8fdbdb}, 
	{0x87df, 0x8fdbdc}, 
	{0x87e0, 0xeab6}, 
	{0x87e2, 0x8fdbdd}, 
	{0x87e3, 0x8fdbde}, 
	{0x87e4, 0x8fdbdf}, 
	{0x87ea, 0x8fdbe0}, 
	{0x87eb, 0x8fdbe1}, 
	{0x87ed, 0x8fdbe2}, 
	{0x87ef, 0xeab4}, 
	{0x87f1, 0x8fdbe3}, 
	{0x87f2, 0xeab5}, 
	{0x87f3, 0x8fdbe4}, 
	{0x87f6, 0xeaba}, 
	{0x87f7, 0xeabb}, 
	{0x87f8, 0x8fdbe5}, 
	{0x87f9, 0xb3aa}, 
	{0x87fa, 0x8fdbe6}, 
	{0x87fb, 0xb5c2}, 
	{0x87fe, 0xeab9}, 
	{0x87ff, 0x8fdbe7}, 
	{0x8801, 0x8fdbe8}, 
	{0x8803, 0x8fdbe9}, 
	{0x8805, 0xeaa4}, 
	{0x8806, 0x8fdbea}, 
	{0x8809, 0x8fdbeb}, 
	{0x880a, 0x8fdbec}, 
	{0x880b, 0x8fdbed}, 
	{0x880d, 0xeab8}, 
	{0x880e, 0xeabc}, 
	{0x880f, 0xeab7}, 
	{0x8810, 0x8fdbee}, 
	{0x8811, 0xeabe}, 
	{0x8812, 0x8fdbf0}, 
	{0x8813, 0x8fdbf1}, 
	{0x8814, 0x8fdbf2}, 
	{0x8815, 0xeac0}, 
	{0x8816, 0xeabf}, 
	{0x8818, 0x8fdbf3}, 
	{0x8819, 0x8fdbef}, 
	{0x881a, 0x8fdbf4}, 
	{0x881b, 0x8fdbf5}, 
	{0x881c, 0x8fdbf6}, 
	{0x881e, 0x8fdbf7}, 
	{0x881f, 0x8fdbf8}, 
	{0x8821, 0xeac2}, 
	{0x8822, 0xeac1}, 
	{0x8823, 0xe9da}, 
	{0x8827, 0xeac6}, 
	{0x8828, 0x8fdbf9}, 
	{0x882d, 0x8fdbfa}, 
	{0x882e, 0x8fdbfb}, 
	{0x8830, 0x8fdbfc}, 
	{0x8831, 0xeac3}, 
	{0x8832, 0x8fdbfd}, 
	{0x8835, 0x8fdbfe}, 
	{0x8836, 0xeac4}, 
	{0x8839, 0xeac5}, 
	{0x883a, 0x8fdca1}, 
	{0x883b, 0xeac7}, 
	{0x883c, 0x8fdca2}, 
	{0x8840, 0xb7ec}, 
	{0x8841, 0x8fdca3}, 
	{0x8842, 0xeac9}, 
	{0x8843, 0x8fdca4}, 
	{0x8844, 0xeac8}, 
	{0x8845, 0x8fdca5}, 
	{0x8846, 0xbdb0}, 
	{0x8848, 0x8fdca6}, 
	{0x8849, 0x8fdca7}, 
	{0x884a, 0x8fdca8}, 
	{0x884b, 0x8fdca9}, 
	{0x884c, 0xb9d4}, 
	{0x884d, 0xdea7}, 
	{0x884e, 0x8fdcaa}, 
	{0x8851, 0x8fdcab}, 
	{0x8852, 0xeaca}, 
	{0x8853, 0xbdd1}, 
	{0x8855, 0x8fdcac}, 
	{0x8856, 0x8fdcad}, 
	{0x8857, 0xb3b9}, 
	{0x8858, 0x8fdcae}, 
	{0x8859, 0xeacb}, 
	{0x885a, 0x8fdcaf}, 
	{0x885b, 0xb1d2}, 
	{0x885c, 0x8fdcb0}, 
	{0x885d, 0xbed7}, 
	{0x885e, 0xeacc}, 
	{0x885f, 0x8fdcb1}, 
	{0x8860, 0x8fdcb2}, 
	{0x8861, 0xb9d5}, 
	{0x8862, 0xeacd}, 
	{0x8863, 0xb0e1}, 
	{0x8864, 0x8fdcb3}, 
	{0x8868, 0xc9bd}, 
	{0x8869, 0x8fdcb4}, 
	{0x886b, 0xeace}, 
	{0x8870, 0xbfea}, 
	{0x8871, 0x8fdcb5}, 
	{0x8872, 0xead5}, 
	{0x8875, 0xead2}, 
	{0x8877, 0xc3ef}, 
	{0x8879, 0x8fdcb6}, 
	{0x887b, 0x8fdcb7}, 
	{0x887d, 0xead3}, 
	{0x887e, 0xead0}, 
	{0x887f, 0xb6de}, 
	{0x8880, 0x8fdcb8}, 
	{0x8881, 0xeacf}, 
	{0x8882, 0xead6}, 
	{0x8888, 0xb7b6}, 
	{0x888b, 0xc2de}, 
	{0x888d, 0xeadc}, 
	{0x8892, 0xead8}, 
	{0x8896, 0xc2b5}, 
	{0x8897, 0xead7}, 
	{0x8898, 0x8fdcb9}, 
	{0x8899, 0xeada}, 
	{0x889a, 0x8fdcba}, 
	{0x889b, 0x8fdcbb}, 
	{0x889c, 0x8fdcbc}, 
	{0x889e, 0xead1}, 
	{0x889f, 0x8fdcbd}, 
	{0x88a0, 0x8fdcbe}, 
	{0x88a2, 0xeadb}, 
	{0x88a4, 0xeadd}, 
	{0x88a8, 0x8fdcbf}, 
	{0x88aa, 0x8fdcc0}, 
	{0x88ab, 0xc8ef}, 
	{0x88ae, 0xead9}, 
	{0x88b0, 0xeade}, 
	{0x88b1, 0xeae0}, 
	{0x88b4, 0xb8d3}, 
	{0x88b5, 0xead4}, 
	{0x88b7, 0xb0c1}, 
	{0x88ba, 0x8fdcc1}, 
	{0x88bd, 0x8fdcc2}, 
	{0x88be, 0x8fdcc3}, 
	{0x88bf, 0xeadf}, 
	{0x88c0, 0x8fdcc4}, 
	{0x88c1, 0xbadb}, 
	{0x88c2, 0xcef6}, 
	{0x88c3, 0xeae1}, 
	{0x88c4, 0xeae2}, 
	{0x88c5, 0xc1f5}, 
	{0x88ca, 0x8fdcc5}, 
	{0x88cb, 0x8fdcc6}, 
	{0x88cc, 0x8fdcc7}, 
	{0x88cd, 0x8fdcc8}, 
	{0x88ce, 0x8fdcc9}, 
	{0x88cf, 0xcea2}, 
	{0x88d1, 0x8fdcca}, 
	{0x88d2, 0x8fdccb}, 
	{0x88d3, 0x8fdccc}, 
	{0x88d4, 0xeae3}, 
	{0x88d5, 0xcdb5}, 
	{0x88d8, 0xeae4}, 
	{0x88d9, 0xeae5}, 
	{0x88db, 0x8fdccd}, 
	{0x88dc, 0xcae4}, 
	{0x88dd, 0xeae6}, 
	{0x88de, 0x8fdcce}, 
	{0x88df, 0xbac0}, 
	{0x88e1, 0xcea3}, 
	{0x88e7, 0x8fdccf}, 
	{0x88e8, 0xeaeb}, 
	{0x88ef, 0x8fdcd0}, 
	{0x88f0, 0x8fdcd1}, 
	{0x88f1, 0x8fdcd2}, 
	{0x88f2, 0xeaec}, 
	{0x88f3, 0xbed8}, 
	{0x88f4, 0xeaea}, 
	{0x88f5, 0x8fdcd3}, 
	{0x88f7, 0x8fdcd4}, 
	{0x88f8, 0xcde7}, 
	{0x88f9, 0xeae7}, 
	{0x88fc, 0xeae9}, 
	{0x88fd, 0xc0bd}, 
	{0x88fe, 0xbffe}, 
	{0x8901, 0x8fdcd5}, 
	{0x8902, 0xeae8}, 
	{0x8904, 0xeaed}, 
	{0x8906, 0x8fdcd6}, 
	{0x8907, 0xcaa3}, 
	{0x890a, 0xeaef}, 
	{0x890c, 0xeaee}, 
	{0x890d, 0x8fdcd7}, 
	{0x890e, 0x8fdcd8}, 
	{0x890f, 0x8fdcd9}, 
	{0x8910, 0xb3ec}, 
	{0x8912, 0xcbab}, 
	{0x8913, 0xeaf0}, 
	{0x8915, 0x8fdcda}, 
	{0x8916, 0x8fdcdb}, 
	{0x8918, 0x8fdcdc}, 
	{0x8919, 0x8fdcdd}, 
	{0x891a, 0x8fdcde}, 
	{0x891c, 0x8fdcdf}, 
	{0x891d, 0xeafc}, 
	{0x891e, 0xeaf2}, 
	{0x8920, 0x8fdce0}, 
	{0x8925, 0xeaf3}, 
	{0x8926, 0x8fdce1}, 
	{0x8927, 0x8fdce2}, 
	{0x8928, 0x8fdce3}, 
	{0x892a, 0xeaf4}, 
	{0x892b, 0xeaf5}, 
	{0x8930, 0x8fdce4}, 
	{0x8931, 0x8fdce5}, 
	{0x8932, 0x8fdce6}, 
	{0x8935, 0x8fdce7}, 
	{0x8936, 0xeaf9}, 
	{0x8938, 0xeafa}, 
	{0x8939, 0x8fdce8}, 
	{0x893a, 0x8fdce9}, 
	{0x893b, 0xeaf8}, 
	{0x893e, 0x8fdcea}, 
	{0x8940, 0x8fdceb}, 
	{0x8941, 0xeaf6}, 
	{0x8942, 0x8fdcec}, 
	{0x8943, 0xeaf1}, 
	{0x8944, 0xeaf7}, 
	{0x8945, 0x8fdced}, 
	{0x8946, 0x8fdcee}, 
	{0x8949, 0x8fdcef}, 
	{0x894c, 0xeafb}, 
	{0x894d, 0xf0b7}, 
	{0x894f, 0x8fdcf0}, 
	{0x8952, 0x8fdcf1}, 
	{0x8956, 0xb2a8}, 
	{0x8957, 0x8fdcf2}, 
	{0x895a, 0x8fdcf3}, 
	{0x895b, 0x8fdcf4}, 
	{0x895c, 0x8fdcf5}, 
	{0x895e, 0xeafe}, 
	{0x895f, 0xb6df}, 
	{0x8960, 0xeafd}, 
	{0x8961, 0x8fdcf6}, 
	{0x8962, 0x8fdcf7}, 
	{0x8963, 0x8fdcf8}, 
	{0x8964, 0xeba2}, 
	{0x8966, 0xeba1}, 
	{0x896a, 0xeba4}, 
	{0x896b, 0x8fdcf9}, 
	{0x896d, 0xeba3}, 
	{0x896e, 0x8fdcfa}, 
	{0x896f, 0xeba5}, 
	{0x8970, 0x8fdcfb}, 
	{0x8972, 0xbdb1}, 
	{0x8973, 0x8fdcfc}, 
	{0x8974, 0xeba6}, 
	{0x8975, 0x8fdcfd}, 
	{0x8977, 0xeba7}, 
	{0x897a, 0x8fdcfe}, 
	{0x897b, 0x8fdda1}, 
	{0x897c, 0x8fdda2}, 
	{0x897d, 0x8fdda3}, 
	{0x897e, 0xeba8}, 
	{0x897f, 0xc0be}, 
	{0x8981, 0xcdd7}, 
	{0x8983, 0xeba9}, 
	{0x8986, 0xcaa4}, 
	{0x8987, 0xc7c6}, 
	{0x8988, 0xebaa}, 
	{0x8989, 0x8fdda4}, 
	{0x898a, 0xebab}, 
	{0x898b, 0xb8ab}, 
	{0x898d, 0x8fdda5}, 
	{0x898f, 0xb5ac}, 
	{0x8990, 0x8fdda6}, 
	{0x8993, 0xebac}, 
	{0x8994, 0x8fdda7}, 
	{0x8995, 0x8fdda8}, 
	{0x8996, 0xbbeb}, 
	{0x8997, 0xc7c1}, 
	{0x8998, 0xebad}, 
	{0x899a, 0xb3d0}, 
	{0x899b, 0x8fdda9}, 
	{0x899c, 0x8fddaa}, 
	{0x899f, 0x8fddab}, 
	{0x89a0, 0x8fddac}, 
	{0x89a1, 0xebae}, 
	{0x89a5, 0x8fddad}, 
	{0x89a6, 0xebb0}, 
	{0x89a7, 0xcdf7}, 
	{0x89a9, 0xebaf}, 
	{0x89aa, 0xbfc6}, 
	{0x89ac, 0xebb1}, 
	{0x89af, 0xebb2}, 
	{0x89b0, 0x8fddae}, 
	{0x89b2, 0xebb3}, 
	{0x89b3, 0xb4d1}, 
	{0x89b4, 0x8fddaf}, 
	{0x89b5, 0x8fddb0}, 
	{0x89b6, 0x8fddb1}, 
	{0x89b7, 0x8fddb2}, 
	{0x89ba, 0xebb4}, 
	{0x89bc, 0x8fddb3}, 
	{0x89bd, 0xebb5}, 
	{0x89bf, 0xebb6}, 
	{0x89c0, 0xebb7}, 
	{0x89d2, 0xb3d1}, 
	{0x89d4, 0x8fddb4}, 
	{0x89d5, 0x8fddb5}, 
	{0x89d6, 0x8fddb6}, 
	{0x89d7, 0x8fddb7}, 
	{0x89d8, 0x8fddb8}, 
	{0x89da, 0xebb8}, 
	{0x89dc, 0xebb9}, 
	{0x89dd, 0xebba}, 
	{0x89e3, 0xb2f2}, 
	{0x89e5, 0x8fddb9}, 
	{0x89e6, 0xbfa8}, 
	{0x89e7, 0xebbb}, 
	{0x89e9, 0x8fddba}, 
	{0x89eb, 0x8fddbb}, 
	{0x89ed, 0x8fddbc}, 
	{0x89f1, 0x8fddbd}, 
	{0x89f3, 0x8fddbe}, 
	{0x89f4, 0xebbc}, 
	{0x89f6, 0x8fddbf}, 
	{0x89f8, 0xebbd}, 
	{0x89f9, 0x8fddc0}, 
	{0x89fd, 0x8fddc1}, 
	{0x89ff, 0x8fddc2}, 
	{0x8a00, 0xb8c0}, 
	{0x8a02, 0xc4fb}, 
	{0x8a03, 0xebbe}, 
	{0x8a04, 0x8fddc3}, 
	{0x8a05, 0x8fddc4}, 
	{0x8a07, 0x8fddc5}, 
	{0x8a08, 0xb7d7}, 
	{0x8a0a, 0xbfd6}, 
	{0x8a0c, 0xebc1}, 
	{0x8a0e, 0xc6a4}, 
	{0x8a0f, 0x8fddc6}, 
	{0x8a10, 0xebc0}, 
	{0x8a11, 0x8fddc7}, 
	{0x8a12, 0x8fddc8}, 
	{0x8a13, 0xb7b1}, 
	{0x8a14, 0x8fddc9}, 
	{0x8a15, 0x8fddca}, 
	{0x8a16, 0xebbf}, 
	{0x8a17, 0xc2f7}, 
	{0x8a18, 0xb5ad}, 
	{0x8a1b, 0xebc2}, 
	{0x8a1d, 0xebc3}, 
	{0x8a1e, 0x8fddcb}, 
	{0x8a1f, 0xbed9}, 
	{0x8a20, 0x8fddcc}, 
	{0x8a22, 0x8fddcd}, 
	{0x8a23, 0xb7ed}, 
	{0x8a24, 0x8fddce}, 
	{0x8a25, 0xebc4}, 
	{0x8a26, 0x8fddcf}, 
	{0x8a2a, 0xcbac}, 
	{0x8a2b, 0x8fddd0}, 
	{0x8a2c, 0x8fddd1}, 
	{0x8a2d, 0xc0df}, 
	{0x8a2f, 0x8fddd2}, 
	{0x8a31, 0xb5f6}, 
	{0x8a33, 0xccf5}, 
	{0x8a34, 0xc1ca}, 
	{0x8a35, 0x8fddd3}, 
	{0x8a36, 0xebc5}, 
	{0x8a37, 0x8fddd4}, 
	{0x8a3a, 0xbfc7}, 
	{0x8a3b, 0xc3f0}, 
	{0x8a3c, 0xbeda}, 
	{0x8a3d, 0x8fddd5}, 
	{0x8a3e, 0x8fddd6}, 
	{0x8a40, 0x8fddd7}, 
	{0x8a41, 0xebc6}, 
	{0x8a43, 0x8fddd8}, 
	{0x8a45, 0x8fddd9}, 
	{0x8a46, 0xebc9}, 
	{0x8a47, 0x8fddda}, 
	{0x8a48, 0xebca}, 
	{0x8a49, 0x8fdddb}, 
	{0x8a4d, 0x8fdddc}, 
	{0x8a4e, 0x8fdddd}, 
	{0x8a50, 0xbabe}, 
	{0x8a51, 0xc2c2}, 
	{0x8a52, 0xebc8}, 
	{0x8a53, 0x8fddde}, 
	{0x8a54, 0xbedb}, 
	{0x8a55, 0xc9be}, 
	{0x8a56, 0x8fdddf}, 
	{0x8a57, 0x8fdde0}, 
	{0x8a58, 0x8fdde1}, 
	{0x8a5b, 0xebc7}, 
	{0x8a5c, 0x8fdde2}, 
	{0x8a5d, 0x8fdde3}, 
	{0x8a5e, 0xbbec}, 
	{0x8a60, 0xb1d3}, 
	{0x8a61, 0x8fdde4}, 
	{0x8a62, 0xebce}, 
	{0x8a63, 0xb7d8}, 
	{0x8a65, 0x8fdde5}, 
	{0x8a66, 0xbbee}, 
	{0x8a67, 0x8fdde6}, 
	{0x8a69, 0xbbed}, 
	{0x8a6b, 0xcfcd}, 
	{0x8a6c, 0xebcd}, 
	{0x8a6d, 0xebcc}, 
	{0x8a6e, 0xc1a7}, 
	{0x8a70, 0xb5cd}, 
	{0x8a71, 0xcfc3}, 
	{0x8a72, 0xb3ba}, 
	{0x8a73, 0xbedc}, 
	{0x8a75, 0x8fdde7}, 
	{0x8a76, 0x8fdde8}, 
	{0x8a77, 0x8fdde9}, 
	{0x8a79, 0x8fddea}, 
	{0x8a7a, 0x8fddeb}, 
	{0x8a7b, 0x8fddec}, 
	{0x8a7c, 0xebcb}, 
	{0x8a7e, 0x8fdded}, 
	{0x8a7f, 0x8fddee}, 
	{0x8a80, 0x8fddef}, 
	{0x8a82, 0xebd0}, 
	{0x8a83, 0x8fddf0}, 
	{0x8a84, 0xebd1}, 
	{0x8a85, 0xebcf}, 
	{0x8a86, 0x8fddf1}, 
	{0x8a87, 0xb8d8}, 
	{0x8a89, 0xcdc0}, 
	{0x8a8b, 0x8fddf2}, 
	{0x8a8c, 0xbbef}, 
	{0x8a8d, 0xc7a7}, 
	{0x8a8f, 0x8fddf3}, 
	{0x8a90, 0x8fddf4}, 
	{0x8a91, 0xebd4}, 
	{0x8a92, 0x8fddf5}, 
	{0x8a93, 0xc0c0}, 
	{0x8a95, 0xc3c2}, 
	{0x8a96, 0x8fddf6}, 
	{0x8a97, 0x8fddf7}, 
	{0x8a98, 0xcdb6}, 
	{0x8a99, 0x8fddf8}, 
	{0x8a9a, 0xebd7}, 
	{0x8a9e, 0xb8ec}, 
	{0x8a9f, 0x8fddf9}, 
	{0x8aa0, 0xc0bf}, 
	{0x8aa1, 0xebd3}, 
	{0x8aa3, 0xebd8}, 
	{0x8aa4, 0xb8ed}, 
	{0x8aa5, 0xebd5}, 
	{0x8aa6, 0xebd6}, 
	{0x8aa7, 0x8fddfa}, 
	{0x8aa8, 0xebd2}, 
	{0x8aa9, 0x8fddfb}, 
	{0x8aac, 0xc0e2}, 
	{0x8aad, 0xc6c9}, 
	{0x8aae, 0x8fddfc}, 
	{0x8aaf, 0x8fddfd}, 
	{0x8ab0, 0xc3af}, 
	{0x8ab2, 0xb2dd}, 
	{0x8ab3, 0x8fddfe}, 
	{0x8ab6, 0x8fdea1}, 
	{0x8ab7, 0x8fdea2}, 
	{0x8ab9, 0xc8f0}, 
	{0x8abb, 0x8fdea3}, 
	{0x8abc, 0xb5c3}, 
	{0x8abe, 0x8fdea4}, 
	{0x8abf, 0xc4b4}, 
	{0x8ac2, 0xebdb}, 
	{0x8ac3, 0x8fdea5}, 
	{0x8ac4, 0xebd9}, 
	{0x8ac6, 0x8fdea6}, 
	{0x8ac7, 0xc3cc}, 
	{0x8ac8, 0x8fdea7}, 
	{0x8ac9, 0x8fdea8}, 
	{0x8aca, 0x8fdea9}, 
	{0x8acb, 0xc0c1}, 
	{0x8acc, 0xb4d2}, 
	{0x8acd, 0xebda}, 
	{0x8acf, 0xbfdb}, 
	{0x8ad1, 0x8fdeaa}, 
	{0x8ad2, 0xceca}, 
	{0x8ad3, 0x8fdeab}, 
	{0x8ad4, 0x8fdeac}, 
	{0x8ad5, 0x8fdead}, 
	{0x8ad6, 0xcfc0}, 
	{0x8ad7, 0x8fdeae}, 
	{0x8ada, 0xebdc}, 
	{0x8adb, 0xebe7}, 
	{0x8adc, 0xc4b5}, 
	{0x8add, 0x8fdeaf}, 
	{0x8ade, 0xebe6}, 
	{0x8adf, 0x8fdeb0}, 
	{0x8ae0, 0xebe3}, 
	{0x8ae1, 0xebeb}, 
	{0x8ae2, 0xebe4}, 
	{0x8ae4, 0xebe0}, 
	{0x8ae6, 0xc4fc}, 
	{0x8ae7, 0xebdf}, 
	{0x8aeb, 0xebdd}, 
	{0x8aec, 0x8fdeb1}, 
	{0x8aed, 0xcda1}, 
	{0x8aee, 0xbbf0}, 
	{0x8af0, 0x8fdeb2}, 
	{0x8af1, 0xebe1}, 
	{0x8af3, 0xebde}, 
	{0x8af4, 0x8fdeb3}, 
	{0x8af5, 0x8fdeb4}, 
	{0x8af6, 0x8fdeb5}, 
	{0x8af7, 0xebe5}, 
	{0x8af8, 0xbdf4}, 
	{0x8afa, 0xb8c1}, 
	{0x8afc, 0x8fdeb6}, 
	{0x8afe, 0xc2fa}, 
	{0x8aff, 0x8fdeb7}, 
	{0x8b00, 0xcbc5}, 
	{0x8b01, 0xb1da}, 
	{0x8b02, 0xb0e2}, 
	{0x8b04, 0xc6a5}, 
	{0x8b05, 0x8fdeb8}, 
	{0x8b06, 0x8fdeb9}, 
	{0x8b07, 0xebe9}, 
	{0x8b0a, 0x8fdebf}, 
	{0x8b0b, 0x8fdeba}, 
	{0x8b0c, 0xebe8}, 
	{0x8b0e, 0xc6e6}, 
	{0x8b10, 0xebed}, 
	{0x8b11, 0x8fdebb}, 
	{0x8b14, 0xebe2}, 
	{0x8b16, 0xebec}, 
	{0x8b17, 0xebee}, 
	{0x8b19, 0xb8ac}, 
	{0x8b1a, 0xebea}, 
	{0x8b1b, 0xb9d6}, 
	{0x8b1c, 0x8fdebc}, 
	{0x8b1d, 0xbcd5}, 
	{0x8b1e, 0x8fdebd}, 
	{0x8b1f, 0x8fdebe}, 
	{0x8b20, 0xebef}, 
	{0x8b21, 0xcdd8}, 
	{0x8b26, 0xebf2}, 
	{0x8b28, 0xebf5}, 
	{0x8b2b, 0xebf3}, 
	{0x8b2c, 0xc9b5}, 
	{0x8b2d, 0x8fdec0}, 
	{0x8b30, 0x8fdec1}, 
	{0x8b33, 0xebf0}, 
	{0x8b37, 0x8fdec2}, 
	{0x8b39, 0xb6e0}, 
	{0x8b3c, 0x8fdec3}, 
	{0x8b3e, 0xebf4}, 
	{0x8b41, 0xebf6}, 
	{0x8b42, 0x8fdec4}, 
	{0x8b43, 0x8fdec5}, 
	{0x8b44, 0x8fdec6}, 
	{0x8b45, 0x8fdec7}, 
	{0x8b46, 0x8fdec8}, 
	{0x8b48, 0x8fdec9}, 
	{0x8b49, 0xebfa}, 
	{0x8b4c, 0xebf7}, 
	{0x8b4d, 0x8fdece}, 
	{0x8b4e, 0xebf9}, 
	{0x8b4f, 0xebf8}, 
	{0x8b52, 0x8fdeca}, 
	{0x8b53, 0x8fdecb}, 
	{0x8b54, 0x8fdecc}, 
	{0x8b56, 0xebfb}, 
	{0x8b58, 0xbcb1}, 
	{0x8b59, 0x8fdecd}, 
	{0x8b5a, 0xebfd}, 
	{0x8b5b, 0xebfc}, 
	{0x8b5c, 0xc9e8}, 
	{0x8b5e, 0x8fdecf}, 
	{0x8b5f, 0xeca1}, 
	{0x8b63, 0x8fded0}, 
	{0x8b66, 0xb7d9}, 
	{0x8b6b, 0xebfe}, 
	{0x8b6c, 0xeca2}, 
	{0x8b6d, 0x8fded1}, 
	{0x8b6f, 0xeca3}, 
	{0x8b70, 0xb5c4}, 
	{0x8b71, 0xe6c1}, 
	{0x8b72, 0xbef9}, 
	{0x8b74, 0xeca4}, 
	{0x8b76, 0x8fded2}, 
	{0x8b77, 0xb8ee}, 
	{0x8b78, 0x8fded3}, 
	{0x8b79, 0x8fded4}, 
	{0x8b7c, 0x8fded5}, 
	{0x8b7d, 0xeca5}, 
	{0x8b7e, 0x8fded6}, 
	{0x8b80, 0xeca6}, 
	{0x8b81, 0x8fded7}, 
	{0x8b83, 0xbbbe}, 
	{0x8b84, 0x8fded8}, 
	{0x8b85, 0x8fded9}, 
	{0x8b8a, 0xdace}, 
	{0x8b8b, 0x8fdeda}, 
	{0x8b8c, 0xeca7}, 
	{0x8b8d, 0x8fdedb}, 
	{0x8b8e, 0xeca8}, 
	{0x8b8f, 0x8fdedc}, 
	{0x8b90, 0xbdb2}, 
	{0x8b92, 0xeca9}, 
	{0x8b93, 0xecaa}, 
	{0x8b94, 0x8fdedd}, 
	{0x8b95, 0x8fdede}, 
	{0x8b96, 0xecab}, 
	{0x8b99, 0xecac}, 
	{0x8b9a, 0xecad}, 
	{0x8b9c, 0x8fdedf}, 
	{0x8b9e, 0x8fdee0}, 
	{0x8b9f, 0x8fdee1}, 
	{0x8c37, 0xc3ab}, 
	{0x8c38, 0x8fdee2}, 
	{0x8c39, 0x8fdee3}, 
	{0x8c3a, 0xecae}, 
	{0x8c3d, 0x8fdee4}, 
	{0x8c3e, 0x8fdee5}, 
	{0x8c3f, 0xecb0}, 
	{0x8c41, 0xecaf}, 
	{0x8c45, 0x8fdee6}, 
	{0x8c46, 0xc6a6}, 
	{0x8c47, 0x8fdee7}, 
	{0x8c48, 0xecb1}, 
	{0x8c49, 0x8fdee8}, 
	{0x8c4a, 0xcbad}, 
	{0x8c4b, 0x8fdee9}, 
	{0x8c4c, 0xecb2}, 
	{0x8c4e, 0xecb3}, 
	{0x8c4f, 0x8fdeea}, 
	{0x8c50, 0xecb4}, 
	{0x8c51, 0x8fdeeb}, 
	{0x8c53, 0x8fdeec}, 
	{0x8c54, 0x8fdeed}, 
	{0x8c55, 0xecb5}, 
	{0x8c57, 0x8fdeee}, 
	{0x8c58, 0x8fdeef}, 
	{0x8c59, 0x8fdef2}, 
	{0x8c5a, 0xc6da}, 
	{0x8c5b, 0x8fdef0}, 
	{0x8c5d, 0x8fdef1}, 
	{0x8c61, 0xbedd}, 
	{0x8c62, 0xecb6}, 
	{0x8c63, 0x8fdef3}, 
	{0x8c64, 0x8fdef4}, 
	{0x8c66, 0x8fdef5}, 
	{0x8c68, 0x8fdef6}, 
	{0x8c69, 0x8fdef7}, 
	{0x8c6a, 0xb9eb}, 
	{0x8c6b, 0xd0ae}, 
	{0x8c6c, 0xecb7}, 
	{0x8c6d, 0x8fdef8}, 
	{0x8c73, 0x8fdef9}, 
	{0x8c75, 0x8fdefa}, 
	{0x8c76, 0x8fdefb}, 
	{0x8c78, 0xecb8}, 
	{0x8c79, 0xc9bf}, 
	{0x8c7a, 0xecb9}, 
	{0x8c7b, 0x8fdefc}, 
	{0x8c7c, 0xecc1}, 
	{0x8c7e, 0x8fdefd}, 
	{0x8c82, 0xecba}, 
	{0x8c85, 0xecbc}, 
	{0x8c86, 0x8fdefe}, 
	{0x8c87, 0x8fdfa1}, 
	{0x8c89, 0xecbb}, 
	{0x8c8a, 0xecbd}, 
	{0x8c8b, 0x8fdfa2}, 
	{0x8c8c, 0xcbc6}, 
	{0x8c8d, 0xecbe}, 
	{0x8c8e, 0xecbf}, 
	{0x8c90, 0x8fdfa3}, 
	{0x8c92, 0x8fdfa4}, 
	{0x8c93, 0x8fdfa5}, 
	{0x8c94, 0xecc0}, 
	{0x8c98, 0xecc2}, 
	{0x8c99, 0x8fdfa6}, 
	{0x8c9b, 0x8fdfa7}, 
	{0x8c9c, 0x8fdfa8}, 
	{0x8c9d, 0xb3ad}, 
	{0x8c9e, 0xc4e7}, 
	{0x8ca0, 0xc9e9}, 
	{0x8ca1, 0xbae2}, 
	{0x8ca2, 0xb9d7}, 
	{0x8ca4, 0x8fdfa9}, 
	{0x8ca7, 0xc9cf}, 
	{0x8ca8, 0xb2df}, 
	{0x8ca9, 0xc8ce}, 
	{0x8caa, 0xecc5}, 
	{0x8cab, 0xb4d3}, 
	{0x8cac, 0xc0d5}, 
	{0x8cad, 0xecc4}, 
	{0x8cae, 0xecc9}, 
	{0x8caf, 0xc3f9}, 
	{0x8cb0, 0xcce3}, 
	{0x8cb2, 0xecc7}, 
	{0x8cb3, 0xecc8}, 
	{0x8cb4, 0xb5ae}, 
	{0x8cb6, 0xecca}, 
	{0x8cb7, 0xc7e3}, 
	{0x8cb8, 0xc2df}, 
	{0x8cb9, 0x8fdfaa}, 
	{0x8cba, 0x8fdfab}, 
	{0x8cbb, 0xc8f1}, 
	{0x8cbc, 0xc5bd}, 
	{0x8cbd, 0xecc6}, 
	{0x8cbf, 0xcbc7}, 
	{0x8cc0, 0xb2ec}, 
	{0x8cc1, 0xeccc}, 
	{0x8cc2, 0xcfa8}, 
	{0x8cc3, 0xc4c2}, 
	{0x8cc4, 0xcfc5}, 
	{0x8cc5, 0x8fdfac}, 
	{0x8cc6, 0x8fdfad}, 
	{0x8cc7, 0xbbf1}, 
	{0x8cc8, 0xeccb}, 
	{0x8cc9, 0x8fdfae}, 
	{0x8cca, 0xc2b1}, 
	{0x8ccb, 0x8fdfaf}, 
	{0x8ccd, 0xecdc}, 
	{0x8cce, 0xc1a8}, 
	{0x8ccf, 0x8fdfb0}, 
	{0x8cd1, 0xc6f8}, 
	{0x8cd3, 0xc9d0}, 
	{0x8cd5, 0x8fdfb2}, 
	{0x8cd6, 0x8fdfb1}, 
	{0x8cd9, 0x8fdfb3}, 
	{0x8cda, 0xeccf}, 
	{0x8cdb, 0xbbbf}, 
	{0x8cdc, 0xbbf2}, 
	{0x8cdd, 0x8fdfb4}, 
	{0x8cde, 0xbede}, 
	{0x8ce0, 0xc7e5}, 
	{0x8ce1, 0x8fdfb5}, 
	{0x8ce2, 0xb8ad}, 
	{0x8ce3, 0xecce}, 
	{0x8ce4, 0xeccd}, 
	{0x8ce6, 0xc9ea}, 
	{0x8ce8, 0x8fdfb6}, 
	{0x8cea, 0xbcc1}, 
	{0x8cec, 0x8fdfb7}, 
	{0x8ced, 0xc5d2}, 
	{0x8cef, 0x8fdfb8}, 
	{0x8cf0, 0x8fdfb9}, 
	{0x8cf2, 0x8fdfba}, 
	{0x8cf5, 0x8fdfbb}, 
	{0x8cf7, 0x8fdfbc}, 
	{0x8cf8, 0x8fdfbd}, 
	{0x8cfa, 0xecd1}, 
	{0x8cfb, 0xecd2}, 
	{0x8cfc, 0xb9d8}, 
	{0x8cfd, 0xecd0}, 
	{0x8cfe, 0x8fdfbe}, 
	{0x8cff, 0x8fdfbf}, 
	{0x8d01, 0x8fdfc0}, 
	{0x8d03, 0x8fdfc1}, 
	{0x8d04, 0xecd3}, 
	{0x8d05, 0xecd4}, 
	{0x8d07, 0xecd6}, 
	{0x8d08, 0xc2a3}, 
	{0x8d09, 0x8fdfc2}, 
	{0x8d0a, 0xecd5}, 
	{0x8d0b, 0xb4e6}, 
	{0x8d0d, 0xecd8}, 
	{0x8d0f, 0xecd7}, 
	{0x8d10, 0xecd9}, 
	{0x8d12, 0x8fdfc3}, 
	{0x8d13, 0xecdb}, 
	{0x8d14, 0xecdd}, 
	{0x8d16, 0xecde}, 
	{0x8d17, 0x8fdfc4}, 
	{0x8d1b, 0x8fdfc5}, 
	{0x8d64, 0xc0d6}, 
	{0x8d65, 0x8fdfc6}, 
	{0x8d66, 0xbccf}, 
	{0x8d67, 0xecdf}, 
	{0x8d69, 0x8fdfc7}, 
	{0x8d6b, 0xb3d2}, 
	{0x8d6c, 0x8fdfc8}, 
	{0x8d6d, 0xece0}, 
	{0x8d6e, 0x8fdfc9}, 
	{0x8d70, 0xc1f6}, 
	{0x8d71, 0xece1}, 
	{0x8d73, 0xece2}, 
	{0x8d74, 0xc9eb}, 
	{0x8d77, 0xb5af}, 
	{0x8d7f, 0x8fdfca}, 
	{0x8d81, 0xece3}, 
	{0x8d82, 0x8fdfcb}, 
	{0x8d84, 0x8fdfcc}, 
	{0x8d85, 0xc4b6}, 
	{0x8d88, 0x8fdfcd}, 
	{0x8d8a, 0xb1db}, 
	{0x8d8d, 0x8fdfce}, 
	{0x8d90, 0x8fdfcf}, 
	{0x8d91, 0x8fdfd0}, 
	{0x8d95, 0x8fdfd1}, 
	{0x8d99, 0xece4}, 
	{0x8d9e, 0x8fdfd2}, 
	{0x8d9f, 0x8fdfd3}, 
	{0x8da0, 0x8fdfd4}, 
	{0x8da3, 0xbcf1}, 
	{0x8da6, 0x8fdfd5}, 
	{0x8da8, 0xbff6}, 
	{0x8dab, 0x8fdfd6}, 
	{0x8dac, 0x8fdfd7}, 
	{0x8daf, 0x8fdfd8}, 
	{0x8db2, 0x8fdfd9}, 
	{0x8db3, 0xc2ad}, 
	{0x8db5, 0x8fdfda}, 
	{0x8db7, 0x8fdfdb}, 
	{0x8db9, 0x8fdfdc}, 
	{0x8dba, 0xece7}, 
	{0x8dbb, 0x8fdfdd}, 
	{0x8dbc, 0x8fdfef}, 
	{0x8dbe, 0xece6}, 
	{0x8dc0, 0x8fdfde}, 
	{0x8dc2, 0xece5}, 
	{0x8dc5, 0x8fdfdf}, 
	{0x8dc6, 0x8fdfe0}, 
	{0x8dc7, 0x8fdfe1}, 
	{0x8dc8, 0x8fdfe2}, 
	{0x8dca, 0x8fdfe3}, 
	{0x8dcb, 0xeced}, 
	{0x8dcc, 0xeceb}, 
	{0x8dce, 0x8fdfe4}, 
	{0x8dcf, 0xece8}, 
	{0x8dd1, 0x8fdfe5}, 
	{0x8dd4, 0x8fdfe6}, 
	{0x8dd5, 0x8fdfe7}, 
	{0x8dd6, 0xecea}, 
	{0x8dd7, 0x8fdfe8}, 
	{0x8dd9, 0x8fdfe9}, 
	{0x8dda, 0xece9}, 
	{0x8ddb, 0xecec}, 
	{0x8ddd, 0xb5f7}, 
	{0x8ddf, 0xecf0}, 
	{0x8de1, 0xc0d7}, 
	{0x8de3, 0xecf1}, 
	{0x8de4, 0x8fdfea}, 
	{0x8de5, 0x8fdfeb}, 
	{0x8de7, 0x8fdfec}, 
	{0x8de8, 0xb8d9}, 
	{0x8dea, 0xecee}, 
	{0x8deb, 0xecef}, 
	{0x8dec, 0x8fdfed}, 
	{0x8def, 0xcfa9}, 
	{0x8df0, 0x8fdfee}, 
	{0x8df1, 0x8fdff0}, 
	{0x8df2, 0x8fdff1}, 
	{0x8df3, 0xc4b7}, 
	{0x8df4, 0x8fdff2}, 
	{0x8df5, 0xc1a9}, 
	{0x8dfc, 0xecf2}, 
	{0x8dfd, 0x8fdff3}, 
	{0x8dff, 0xecf5}, 
	{0x8e01, 0x8fdff4}, 
	{0x8e04, 0x8fdff5}, 
	{0x8e05, 0x8fdff6}, 
	{0x8e06, 0x8fdff7}, 
	{0x8e08, 0xecf3}, 
	{0x8e09, 0xecf4}, 
	{0x8e0a, 0xcdd9}, 
	{0x8e0b, 0x8fdff8}, 
	{0x8e0f, 0xc6a7}, 
	{0x8e10, 0xecf8}, 
	{0x8e11, 0x8fdff9}, 
	{0x8e14, 0x8fdffa}, 
	{0x8e16, 0x8fdffb}, 
	{0x8e1d, 0xecf6}, 
	{0x8e1e, 0xecf7}, 
	{0x8e1f, 0xecf9}, 
	{0x8e20, 0x8fdffc}, 
	{0x8e21, 0x8fdffd}, 
	{0x8e22, 0x8fdffe}, 
	{0x8e23, 0x8fe0a1}, 
	{0x8e26, 0x8fe0a2}, 
	{0x8e27, 0x8fe0a3}, 
	{0x8e2a, 0xeda9}, 
	{0x8e30, 0xecfc}, 
	{0x8e31, 0x8fe0a4}, 
	{0x8e33, 0x8fe0a5}, 
	{0x8e34, 0xecfd}, 
	{0x8e35, 0xecfb}, 
	{0x8e36, 0x8fe0a6}, 
	{0x8e37, 0x8fe0a7}, 
	{0x8e38, 0x8fe0a8}, 
	{0x8e39, 0x8fe0a9}, 
	{0x8e3d, 0x8fe0aa}, 
	{0x8e40, 0x8fe0ab}, 
	{0x8e41, 0x8fe0ac}, 
	{0x8e42, 0xecfa}, 
	{0x8e44, 0xc4fd}, 
	{0x8e47, 0xeda1}, 
	{0x8e48, 0xeda5}, 
	{0x8e49, 0xeda2}, 
	{0x8e4a, 0xecfe}, 
	{0x8e4b, 0x8fe0ad}, 
	{0x8e4c, 0xeda3}, 
	{0x8e4d, 0x8fe0ae}, 
	{0x8e4e, 0x8fe0af}, 
	{0x8e4f, 0x8fe0b0}, 
	{0x8e50, 0xeda4}, 
	{0x8e54, 0x8fe0b1}, 
	{0x8e55, 0xedab}, 
	{0x8e59, 0xeda6}, 
	{0x8e5b, 0x8fe0b2}, 
	{0x8e5c, 0x8fe0b3}, 
	{0x8e5d, 0x8fe0b4}, 
	{0x8e5e, 0x8fe0b5}, 
	{0x8e5f, 0xc0d8}, 
	{0x8e60, 0xeda8}, 
	{0x8e61, 0x8fe0b6}, 
	{0x8e62, 0x8fe0b7}, 
	{0x8e63, 0xedaa}, 
	{0x8e64, 0xeda7}, 
	{0x8e69, 0x8fe0b8}, 
	{0x8e6c, 0x8fe0b9}, 
	{0x8e6d, 0x8fe0ba}, 
	{0x8e6f, 0x8fe0bb}, 
	{0x8e70, 0x8fe0bc}, 
	{0x8e71, 0x8fe0bd}, 
	{0x8e72, 0xedad}, 
	{0x8e74, 0xbdb3}, 
	{0x8e76, 0xedac}, 
	{0x8e79, 0x8fe0be}, 
	{0x8e7a, 0x8fe0bf}, 
	{0x8e7b, 0x8fe0c0}, 
	{0x8e7c, 0xedae}, 
	{0x8e81, 0xedaf}, 
	{0x8e82, 0x8fe0c1}, 
	{0x8e83, 0x8fe0c2}, 
	{0x8e84, 0xedb2}, 
	{0x8e85, 0xedb1}, 
	{0x8e87, 0xedb0}, 
	{0x8e89, 0x8fe0c3}, 
	{0x8e8a, 0xedb4}, 
	{0x8e8b, 0xedb3}, 
	{0x8e8d, 0xccf6}, 
	{0x8e90, 0x8fe0c4}, 
	{0x8e91, 0xedb6}, 
	{0x8e92, 0x8fe0c5}, 
	{0x8e93, 0xedb5}, 
	{0x8e94, 0xedb7}, 
	{0x8e95, 0x8fe0c6}, 
	{0x8e99, 0xedb8}, 
	{0x8e9a, 0x8fe0c7}, 
	{0x8e9b, 0x8fe0c8}, 
	{0x8e9d, 0x8fe0c9}, 
	{0x8e9e, 0x8fe0ca}, 
	{0x8ea1, 0xedba}, 
	{0x8ea2, 0x8fe0cb}, 
	{0x8ea7, 0x8fe0cc}, 
	{0x8ea9, 0x8fe0cd}, 
	{0x8eaa, 0xedb9}, 
	{0x8eab, 0xbfc8}, 
	{0x8eac, 0xedbb}, 
	{0x8ead, 0x8fe0ce}, 
	{0x8eae, 0x8fe0cf}, 
	{0x8eaf, 0xb6ed}, 
	{0x8eb0, 0xedbc}, 
	{0x8eb1, 0xedbe}, 
	{0x8eb3, 0x8fe0d0}, 
	{0x8eb5, 0x8fe0d1}, 
	{0x8eba, 0x8fe0d2}, 
	{0x8ebb, 0x8fe0d3}, 
	{0x8ebe, 0xedbf}, 
	{0x8ec0, 0x8fe0d4}, 
	{0x8ec1, 0x8fe0d5}, 
	{0x8ec3, 0x8fe0d6}, 
	{0x8ec4, 0x8fe0d7}, 
	{0x8ec5, 0xedc0}, 
	{0x8ec6, 0xedbd}, 
	{0x8ec7, 0x8fe0d8}, 
	{0x8ec8, 0xedc1}, 
	{0x8eca, 0xbcd6}, 
	{0x8ecb, 0xedc2}, 
	{0x8ecc, 0xb5b0}, 
	{0x8ecd, 0xb7b3}, 
	{0x8ecf, 0x8fe0d9}, 
	{0x8ed1, 0x8fe0da}, 
	{0x8ed2, 0xb8ae}, 
	{0x8ed4, 0x8fe0db}, 
	{0x8edb, 0xedc3}, 
	{0x8edc, 0x8fe0dc}, 
	{0x8edf, 0xc6f0}, 
	{0x8ee2, 0xc5be}, 
	{0x8ee3, 0xedc4}, 
	{0x8ee8, 0x8fe0dd}, 
	{0x8eeb, 0xedc7}, 
	{0x8eed, 0x8fe0e4}, 
	{0x8eee, 0x8fe0de}, 
	{0x8ef0, 0x8fe0df}, 
	{0x8ef1, 0x8fe0e0}, 
	{0x8ef7, 0x8fe0e1}, 
	{0x8ef8, 0xbcb4}, 
	{0x8ef9, 0x8fe0e2}, 
	{0x8efa, 0x8fe0e3}, 
	{0x8efb, 0xedc6}, 
	{0x8efc, 0xedc5}, 
	{0x8efd, 0xb7da}, 
	{0x8efe, 0xedc8}, 
	{0x8f00, 0x8fe0e5}, 
	{0x8f02, 0x8fe0e6}, 
	{0x8f03, 0xb3d3}, 
	{0x8f05, 0xedca}, 
	{0x8f07, 0x8fe0e7}, 
	{0x8f08, 0x8fe0e8}, 
	{0x8f09, 0xbadc}, 
	{0x8f0a, 0xedc9}, 
	{0x8f0c, 0xedd2}, 
	{0x8f0f, 0x8fe0e9}, 
	{0x8f10, 0x8fe0ea}, 
	{0x8f12, 0xedcc}, 
	{0x8f13, 0xedce}, 
	{0x8f14, 0xcae5}, 
	{0x8f15, 0xedcb}, 
	{0x8f16, 0x8fe0eb}, 
	{0x8f17, 0x8fe0ec}, 
	{0x8f18, 0x8fe0ed}, 
	{0x8f19, 0xedcd}, 
	{0x8f1b, 0xedd1}, 
	{0x8f1c, 0xedcf}, 
	{0x8f1d, 0xb5b1}, 
	{0x8f1e, 0x8fe0ee}, 
	{0x8f1f, 0xedd0}, 
	{0x8f20, 0x8fe0ef}, 
	{0x8f21, 0x8fe0f0}, 
	{0x8f23, 0x8fe0f1}, 
	{0x8f25, 0x8fe0f2}, 
	{0x8f26, 0xedd3}, 
	{0x8f27, 0x8fe0f3}, 
	{0x8f28, 0x8fe0f4}, 
	{0x8f29, 0xc7da}, 
	{0x8f2a, 0xced8}, 
	{0x8f2c, 0x8fe0f5}, 
	{0x8f2d, 0x8fe0f6}, 
	{0x8f2e, 0x8fe0f7}, 
	{0x8f2f, 0xbdb4}, 
	{0x8f33, 0xedd4}, 
	{0x8f34, 0x8fe0f8}, 
	{0x8f35, 0x8fe0f9}, 
	{0x8f36, 0x8fe0fa}, 
	{0x8f37, 0x8fe0fb}, 
	{0x8f38, 0xcda2}, 
	{0x8f39, 0xedd6}, 
	{0x8f3a, 0x8fe0fc}, 
	{0x8f3b, 0xedd5}, 
	{0x8f3e, 0xedd9}, 
	{0x8f3f, 0xcdc1}, 
	{0x8f40, 0x8fe0fd}, 
	{0x8f41, 0x8fe0fe}, 
	{0x8f42, 0xedd8}, 
	{0x8f43, 0x8fe1a1}, 
	{0x8f44, 0xb3ed}, 
	{0x8f45, 0xedd7}, 
	{0x8f46, 0xeddc}, 
	{0x8f47, 0x8fe1a2}, 
	{0x8f49, 0xeddb}, 
	{0x8f4c, 0xedda}, 
	{0x8f4d, 0xc5b2}, 
	{0x8f4e, 0xeddd}, 
	{0x8f4f, 0x8fe1a3}, 
	{0x8f51, 0x8fe1a4}, 
	{0x8f52, 0x8fe1a5}, 
	{0x8f53, 0x8fe1a6}, 
	{0x8f54, 0x8fe1a7}, 
	{0x8f55, 0x8fe1a8}, 
	{0x8f57, 0xedde}, 
	{0x8f58, 0x8fe1a9}, 
	{0x8f5c, 0xeddf}, 
	{0x8f5d, 0x8fe1aa}, 
	{0x8f5e, 0x8fe1ab}, 
	{0x8f5f, 0xb9ec}, 
	{0x8f61, 0xb7a5}, 
	{0x8f62, 0xede0}, 
	{0x8f63, 0xede1}, 
	{0x8f64, 0xede2}, 
	{0x8f65, 0x8fe1ac}, 
	{0x8f9b, 0xbfc9}, 
	{0x8f9c, 0xede3}, 
	{0x8f9d, 0x8fe1ad}, 
	{0x8f9e, 0xbcad}, 
	{0x8f9f, 0xede4}, 
	{0x8fa0, 0x8fe1ae}, 
	{0x8fa1, 0x8fe1af}, 
	{0x8fa3, 0xede5}, 
	{0x8fa4, 0x8fe1b0}, 
	{0x8fa5, 0x8fe1b1}, 
	{0x8fa6, 0x8fe1b2}, 
	{0x8fa7, 0xd2a1}, 
	{0x8fa8, 0xd1fe}, 
	{0x8fad, 0xede6}, 
	{0x8fae, 0xe5f0}, 
	{0x8faf, 0xede7}, 
	{0x8fb0, 0xc3a4}, 
	{0x8fb1, 0xbfab}, 
	{0x8fb2, 0xc7c0}, 
	{0x8fb5, 0x8fe1b3}, 
	{0x8fb6, 0x8fe1b4}, 
	{0x8fb7, 0xede8}, 
	{0x8fb8, 0x8fe1b5}, 
	{0x8fba, 0xcad5}, 
	{0x8fbb, 0xc4d4}, 
	{0x8fbc, 0xb9fe}, 
	{0x8fbe, 0x8fe1b6}, 
	{0x8fbf, 0xc3a9}, 
	{0x8fc0, 0x8fe1b7}, 
	{0x8fc1, 0x8fe1b8}, 
	{0x8fc2, 0xb1aa}, 
	{0x8fc4, 0xcbf8}, 
	{0x8fc5, 0xbfd7}, 
	{0x8fc6, 0x8fe1b9}, 
	{0x8fca, 0x8fe1ba}, 
	{0x8fcb, 0x8fe1bb}, 
	{0x8fcd, 0x8fe1bc}, 
	{0x8fce, 0xb7de}, 
	{0x8fd0, 0x8fe1bd}, 
	{0x8fd1, 0xb6e1}, 
	{0x8fd2, 0x8fe1be}, 
	{0x8fd3, 0x8fe1bf}, 
	{0x8fd4, 0xcad6}, 
	{0x8fd5, 0x8fe1c0}, 
	{0x8fda, 0xede9}, 
	{0x8fe0, 0x8fe1c1}, 
	{0x8fe2, 0xedeb}, 
	{0x8fe3, 0x8fe1c2}, 
	{0x8fe4, 0x8fe1c3}, 
	{0x8fe5, 0xedea}, 
	{0x8fe6, 0xb2e0}, 
	{0x8fe8, 0x8fe1c4}, 
	{0x8fe9, 0xc6f6}, 
	{0x8fea, 0xedec}, 
	{0x8feb, 0xc7f7}, 
	{0x8fed, 0xc5b3}, 
	{0x8fee, 0x8fe1c5}, 
	{0x8fef, 0xeded}, 
	{0x8ff0, 0xbdd2}, 
	{0x8ff1, 0x8fe1c6}, 
	{0x8ff4, 0xedef}, 
	{0x8ff5, 0x8fe1c7}, 
	{0x8ff6, 0x8fe1c8}, 
	{0x8ff7, 0xccc2}, 
	{0x8ff8, 0xedfe}, 
	{0x8ff9, 0xedf1}, 
	{0x8ffa, 0xedf2}, 
	{0x8ffb, 0x8fe1c9}, 
	{0x8ffd, 0xc4c9}, 
	{0x8ffe, 0x8fe1ca}, 
	{0x9000, 0xc2e0}, 
	{0x9001, 0xc1f7}, 
	{0x9002, 0x8fe1cb}, 
	{0x9003, 0xc6a8}, 
	{0x9004, 0x8fe1cc}, 
	{0x9005, 0xedf0}, 
	{0x9006, 0xb5d5}, 
	{0x9008, 0x8fe1cd}, 
	{0x900b, 0xedf9}, 
	{0x900c, 0x8fe1ce}, 
	{0x900d, 0xedf6}, 
	{0x900e, 0xeea5}, 
	{0x900f, 0xc6a9}, 
	{0x9010, 0xc3e0}, 
	{0x9011, 0xedf3}, 
	{0x9013, 0xc4fe}, 
	{0x9014, 0xc5d3}, 
	{0x9015, 0xedf4}, 
	{0x9016, 0xedf8}, 
	{0x9017, 0xbfe0}, 
	{0x9018, 0x8fe1cf}, 
	{0x9019, 0xc7e7}, 
	{0x901a, 0xc4cc}, 
	{0x901b, 0x8fe1d0}, 
	{0x901d, 0xc0c2}, 
	{0x901e, 0xedf7}, 
	{0x901f, 0xc2ae}, 
	{0x9020, 0xc2a4}, 
	{0x9021, 0xedf5}, 
	{0x9022, 0xb0a9}, 
	{0x9023, 0xcfa2}, 
	{0x9027, 0xedfa}, 
	{0x9028, 0x8fe1d1}, 
	{0x9029, 0x8fe1d2}, 
	{0x902a, 0x8fe1d4}, 
	{0x902c, 0x8fe1d5}, 
	{0x902d, 0x8fe1d6}, 
	{0x902e, 0xc2e1}, 
	{0x902f, 0x8fe1d3}, 
	{0x9031, 0xbdb5}, 
	{0x9032, 0xbfca}, 
	{0x9033, 0x8fe1d7}, 
	{0x9034, 0x8fe1d8}, 
	{0x9035, 0xedfc}, 
	{0x9036, 0xedfb}, 
	{0x9037, 0x8fe1d9}, 
	{0x9038, 0xb0ef}, 
	{0x9039, 0xedfd}, 
	{0x903c, 0xc9af}, 
	{0x903e, 0xeea7}, 
	{0x903f, 0x8fe1da}, 
	{0x9041, 0xc6db}, 
	{0x9042, 0xbfeb}, 
	{0x9043, 0x8fe1db}, 
	{0x9044, 0x8fe1dc}, 
	{0x9045, 0xc3d9}, 
	{0x9047, 0xb6f8}, 
	{0x9049, 0xeea6}, 
	{0x904a, 0xcdb7}, 
	{0x904b, 0xb1bf}, 
	{0x904c, 0x8fe1dd}, 
	{0x904d, 0xcad7}, 
	{0x904e, 0xb2e1}, 
	{0x904f, 0xeea1}, 
	{0x9050, 0xeea2}, 
	{0x9051, 0xeea3}, 
	{0x9052, 0xeea4}, 
	{0x9053, 0xc6bb}, 
	{0x9054, 0xc3a3}, 
	{0x9055, 0xb0e3}, 
	{0x9056, 0xeea8}, 
	{0x9058, 0xeea9}, 
	{0x9059, 0xf4a3}, 
	{0x905b, 0x8fe1de}, 
	{0x905c, 0xc2bd}, 
	{0x905d, 0x8fe1df}, 
	{0x905e, 0xeeaa}, 
	{0x9060, 0xb1f3}, 
	{0x9061, 0xc1cc}, 
	{0x9062, 0x8fe1e0}, 
	{0x9063, 0xb8af}, 
	{0x9065, 0xcdda}, 
	{0x9066, 0x8fe1e1}, 
	{0x9067, 0x8fe1e2}, 
	{0x9068, 0xeeab}, 
	{0x9069, 0xc5ac}, 
	{0x906c, 0x8fe1e3}, 
	{0x906d, 0xc1f8}, 
	{0x906e, 0xbcd7}, 
	{0x906f, 0xeeac}, 
	{0x9070, 0x8fe1e4}, 
	{0x9072, 0xeeaf}, 
	{0x9074, 0x8fe1e5}, 
	{0x9075, 0xbde5}, 
	{0x9076, 0xeead}, 
	{0x9077, 0xc1ab}, 
	{0x9078, 0xc1aa}, 
	{0x9079, 0x8fe1e6}, 
	{0x907a, 0xb0e4}, 
	{0x907c, 0xcecb}, 
	{0x907d, 0xeeb1}, 
	{0x907f, 0xc8f2}, 
	{0x9080, 0xeeb3}, 
	{0x9081, 0xeeb2}, 
	{0x9082, 0xeeb0}, 
	{0x9083, 0xe3e4}, 
	{0x9084, 0xb4d4}, 
	{0x9085, 0x8fe1e7}, 
	{0x9087, 0xedee}, 
	{0x9088, 0x8fe1e8}, 
	{0x9089, 0xeeb5}, 
	{0x908a, 0xeeb4}, 
	{0x908b, 0x8fe1e9}, 
	{0x908c, 0x8fe1ea}, 
	{0x908e, 0x8fe1eb}, 
	{0x908f, 0xeeb6}, 
	{0x9090, 0x8fe1ec}, 
	{0x9091, 0xcdb8}, 
	{0x9095, 0x8fe1ed}, 
	{0x9097, 0x8fe1ee}, 
	{0x9098, 0x8fe1ef}, 
	{0x9099, 0x8fe1f0}, 
	{0x909b, 0x8fe1f1}, 
	{0x90a0, 0x8fe1f2}, 
	{0x90a1, 0x8fe1f3}, 
	{0x90a2, 0x8fe1f4}, 
	{0x90a3, 0xc6e1}, 
	{0x90a5, 0x8fe1f5}, 
	{0x90a6, 0xcbae}, 
	{0x90a8, 0xeeb7}, 
	{0x90aa, 0xbcd9}, 
	{0x90af, 0xeeb8}, 
	{0x90b0, 0x8fe1f6}, 
	{0x90b1, 0xeeb9}, 
	{0x90b2, 0x8fe1f7}, 
	{0x90b3, 0x8fe1f8}, 
	{0x90b4, 0x8fe1f9}, 
	{0x90b5, 0xeeba}, 
	{0x90b6, 0x8fe1fa}, 
	{0x90b8, 0xc5a1}, 
	{0x90bd, 0x8fe1fb}, 
	{0x90be, 0x8fe1fd}, 
	{0x90c1, 0xb0ea}, 
	{0x90c3, 0x8fe1fe}, 
	{0x90c4, 0x8fe2a1}, 
	{0x90c5, 0x8fe2a2}, 
	{0x90c7, 0x8fe2a3}, 
	{0x90c8, 0x8fe2a4}, 
	{0x90ca, 0xb9d9}, 
	{0x90cc, 0x8fe1fc}, 
	{0x90ce, 0xcfba}, 
	{0x90d2, 0x8fe2ad}, 
	{0x90d5, 0x8fe2a5}, 
	{0x90d7, 0x8fe2a6}, 
	{0x90d8, 0x8fe2a7}, 
	{0x90d9, 0x8fe2a8}, 
	{0x90db, 0xeebe}, 
	{0x90dc, 0x8fe2a9}, 
	{0x90dd, 0x8fe2aa}, 
	{0x90df, 0x8fe2ab}, 
	{0x90e1, 0xb7b4}, 
	{0x90e2, 0xeebb}, 
	{0x90e4, 0xeebc}, 
	{0x90e5, 0x8fe2ac}, 
	{0x90e8, 0xc9f4}, 
	{0x90eb, 0x8fe2af}, 
	{0x90ed, 0xb3d4}, 
	{0x90ef, 0x8fe2b0}, 
	{0x90f0, 0x8fe2b1}, 
	{0x90f4, 0x8fe2b2}, 
	{0x90f5, 0xcdb9}, 
	{0x90f6, 0x8fe2ae}, 
	{0x90f7, 0xb6bf}, 
	{0x90fd, 0xc5d4}, 
	{0x90fe, 0x8fe2b3}, 
	{0x90ff, 0x8fe2b4}, 
	{0x9100, 0x8fe2b5}, 
	{0x9102, 0xeebf}, 
	{0x9104, 0x8fe2b6}, 
	{0x9105, 0x8fe2b7}, 
	{0x9106, 0x8fe2b8}, 
	{0x9108, 0x8fe2b9}, 
	{0x910d, 0x8fe2ba}, 
	{0x9110, 0x8fe2bb}, 
	{0x9112, 0xeec0}, 
	{0x9114, 0x8fe2bc}, 
	{0x9116, 0x8fe2bd}, 
	{0x9117, 0x8fe2be}, 
	{0x9118, 0x8fe2bf}, 
	{0x9119, 0xeec1}, 
	{0x911a, 0x8fe2c0}, 
	{0x911c, 0x8fe2c1}, 
	{0x911e, 0x8fe2c2}, 
	{0x9120, 0x8fe2c3}, 
	{0x9122, 0x8fe2c5}, 
	{0x9123, 0x8fe2c6}, 
	{0x9125, 0x8fe2c4}, 
	{0x9127, 0x8fe2c7}, 
	{0x9129, 0x8fe2c8}, 
	{0x912d, 0xc5a2}, 
	{0x912e, 0x8fe2c9}, 
	{0x912f, 0x8fe2ca}, 
	{0x9130, 0xeec3}, 
	{0x9131, 0x8fe2cb}, 
	{0x9132, 0xeec2}, 
	{0x9134, 0x8fe2cc}, 
	{0x9136, 0x8fe2cd}, 
	{0x9137, 0x8fe2ce}, 
	{0x9139, 0x8fe2cf}, 
	{0x913a, 0x8fe2d0}, 
	{0x913c, 0x8fe2d1}, 
	{0x913d, 0x8fe2d2}, 
	{0x9143, 0x8fe2d3}, 
	{0x9147, 0x8fe2d4}, 
	{0x9148, 0x8fe2d5}, 
	{0x9149, 0xc6d3}, 
	{0x914a, 0xeec4}, 
	{0x914b, 0xbdb6}, 
	{0x914c, 0xbce0}, 
	{0x914d, 0xc7db}, 
	{0x914e, 0xc3f1}, 
	{0x914f, 0x8fe2d6}, 
	{0x9152, 0xbcf2}, 
	{0x9153, 0x8fe2d7}, 
	{0x9154, 0xbfec}, 
	{0x9156, 0xeec5}, 
	{0x9157, 0x8fe2d8}, 
	{0x9158, 0xeec6}, 
	{0x9159, 0x8fe2d9}, 
	{0x915a, 0x8fe2da}, 
	{0x915b, 0x8fe2db}, 
	{0x9161, 0x8fe2dc}, 
	{0x9162, 0xbfdd}, 
	{0x9163, 0xeec7}, 
	{0x9164, 0x8fe2dd}, 
	{0x9165, 0xeec8}, 
	{0x9167, 0x8fe2de}, 
	{0x9169, 0xeec9}, 
	{0x916a, 0xcdef}, 
	{0x916c, 0xbdb7}, 
	{0x916d, 0x8fe2df}, 
	{0x9172, 0xeecb}, 
	{0x9173, 0xeeca}, 
	{0x9174, 0x8fe2e0}, 
	{0x9175, 0xb9da}, 
	{0x9177, 0xb9f3}, 
	{0x9178, 0xbbc0}, 
	{0x9179, 0x8fe2e1}, 
	{0x917a, 0x8fe2e2}, 
	{0x917b, 0x8fe2e3}, 
	{0x9181, 0x8fe2e4}, 
	{0x9182, 0xeece}, 
	{0x9183, 0x8fe2e5}, 
	{0x9185, 0x8fe2e6}, 
	{0x9186, 0x8fe2e7}, 
	{0x9187, 0xbde6}, 
	{0x9189, 0xeecd}, 
	{0x918a, 0x8fe2e8}, 
	{0x918b, 0xeecc}, 
	{0x918d, 0xc2e9}, 
	{0x918e, 0x8fe2e9}, 
	{0x9190, 0xb8ef}, 
	{0x9191, 0x8fe2ea}, 
	{0x9192, 0xc0c3}, 
	{0x9193, 0x8fe2eb}, 
	{0x9194, 0x8fe2ec}, 
	{0x9195, 0x8fe2ed}, 
	{0x9197, 0xc8b0}, 
	{0x9198, 0x8fe2ee}, 
	{0x919c, 0xbdb9}, 
	{0x919e, 0x8fe2ef}, 
	{0x91a1, 0x8fe2f0}, 
	{0x91a2, 0xeecf}, 
	{0x91a4, 0xbedf}, 
	{0x91a6, 0x8fe2f1}, 
	{0x91a8, 0x8fe2f2}, 
	{0x91aa, 0xeed2}, 
	{0x91ab, 0xeed0}, 
	{0x91ac, 0x8fe2f3}, 
	{0x91ad, 0x8fe2f4}, 
	{0x91ae, 0x8fe2f5}, 
	{0x91af, 0xeed1}, 
	{0x91b0, 0x8fe2f6}, 
	{0x91b1, 0x8fe2f7}, 
	{0x91b2, 0x8fe2f8}, 
	{0x91b3, 0x8fe2f9}, 
	{0x91b4, 0xeed4}, 
	{0x91b5, 0xeed3}, 
	{0x91b6, 0x8fe2fa}, 
	{0x91b8, 0xbefa}, 
	{0x91ba, 0xeed5}, 
	{0x91bb, 0x8fe2fb}, 
	{0x91bc, 0x8fe2fc}, 
	{0x91bd, 0x8fe2fd}, 
	{0x91bf, 0x8fe2fe}, 
	{0x91c0, 0xeed6}, 
	{0x91c1, 0xeed7}, 
	{0x91c2, 0x8fe3a1}, 
	{0x91c3, 0x8fe3a2}, 
	{0x91c5, 0x8fe3a3}, 
	{0x91c6, 0xc8d0}, 
	{0x91c7, 0xbad3}, 
	{0x91c8, 0xbce1}, 
	{0x91c9, 0xeed8}, 
	{0x91cb, 0xeed9}, 
	{0x91cc, 0xcea4}, 
	{0x91cd, 0xbdc5}, 
	{0x91ce, 0xccee}, 
	{0x91cf, 0xcecc}, 
	{0x91d0, 0xeeda}, 
	{0x91d1, 0xb6e2}, 
	{0x91d3, 0x8fe3a4}, 
	{0x91d4, 0x8fe3a5}, 
	{0x91d6, 0xeedb}, 
	{0x91d7, 0x8fe3a6}, 
	{0x91d8, 0xc5a3}, 
	{0x91d9, 0x8fe3a7}, 
	{0x91da, 0x8fe3a8}, 
	{0x91db, 0xeede}, 
	{0x91dc, 0xb3f8}, 
	{0x91dd, 0xbfcb}, 
	{0x91de, 0x8fe3a9}, 
	{0x91df, 0xeedc}, 
	{0x91e1, 0xeedd}, 
	{0x91e3, 0xc4e0}, 
	{0x91e4, 0x8fe3aa}, 
	{0x91e5, 0x8fe3ab}, 
	{0x91e6, 0xcbd5}, 
	{0x91e7, 0xb6fc}, 
	{0x91e9, 0x8fe3ac}, 
	{0x91ea, 0x8fe3ad}, 
	{0x91ec, 0x8fe3ae}, 
	{0x91ed, 0x8fe3af}, 
	{0x91ee, 0x8fe3b0}, 
	{0x91ef, 0x8fe3b1}, 
	{0x91f0, 0x8fe3b2}, 
	{0x91f1, 0x8fe3b3}, 
	{0x91f5, 0xeee0}, 
	{0x91f6, 0xeee1}, 
	{0x91f7, 0x8fe3b4}, 
	{0x91f9, 0x8fe3b5}, 
	{0x91fb, 0x8fe3b6}, 
	{0x91fc, 0xeedf}, 
	{0x91fd, 0x8fe3b7}, 
	{0x91ff, 0xeee3}, 
	{0x9200, 0x8fe3b8}, 
	{0x9201, 0x8fe3b9}, 
	{0x9204, 0x8fe3ba}, 
	{0x9205, 0x8fe3bb}, 
	{0x9206, 0x8fe3bc}, 
	{0x9207, 0x8fe3bd}, 
	{0x9209, 0x8fe3be}, 
	{0x920a, 0x8fe3bf}, 
	{0x920c, 0x8fe3c0}, 
	{0x920d, 0xc6df}, 
	{0x920e, 0xb3c3}, 
	{0x9210, 0x8fe3c1}, 
	{0x9211, 0xeee7}, 
	{0x9212, 0x8fe3c2}, 
	{0x9213, 0x8fe3c3}, 
	{0x9214, 0xeee4}, 
	{0x9215, 0xeee6}, 
	{0x9216, 0x8fe3c4}, 
	{0x9218, 0x8fe3c5}, 
	{0x921c, 0x8fe3c6}, 
	{0x921d, 0x8fe3c7}, 
	{0x921e, 0xeee2}, 
	{0x9223, 0x8fe3c8}, 
	{0x9224, 0x8fe3c9}, 
	{0x9225, 0x8fe3ca}, 
	{0x9226, 0x8fe3cb}, 
	{0x9228, 0x8fe3cc}, 
	{0x9229, 0xefcf}, 
	{0x922c, 0xeee5}, 
	{0x922e, 0x8fe3cd}, 
	{0x922f, 0x8fe3ce}, 
	{0x9230, 0x8fe3cf}, 
	{0x9233, 0x8fe3d0}, 
	{0x9234, 0xceeb}, 
	{0x9235, 0x8fe3d1}, 
	{0x9236, 0x8fe3d2}, 
	{0x9237, 0xb8da}, 
	{0x9238, 0x8fe3d3}, 
	{0x9239, 0x8fe3d4}, 
	{0x923a, 0x8fe3d5}, 
	{0x923c, 0x8fe3d6}, 
	{0x923e, 0x8fe3d7}, 
	{0x923f, 0xeeef}, 
	{0x9240, 0x8fe3d8}, 
	{0x9242, 0x8fe3d9}, 
	{0x9243, 0x8fe3da}, 
	{0x9244, 0xc5b4}, 
	{0x9245, 0xeeea}, 
	{0x9246, 0x8fe3db}, 
	{0x9247, 0x8fe3dc}, 
	{0x9248, 0xeeed}, 
	{0x9249, 0xeeeb}, 
	{0x924a, 0x8fe3dd}, 
	{0x924b, 0xeef0}, 
	{0x924d, 0x8fe3de}, 
	{0x924e, 0x8fe3df}, 
	{0x924f, 0x8fe3e0}, 
	{0x9250, 0xeef1}, 
	{0x9251, 0x8fe3e1}, 
	{0x9257, 0xeee9}, 
	{0x9258, 0x8fe3e2}, 
	{0x9259, 0x8fe3e3}, 
	{0x925a, 0xeef6}, 
	{0x925b, 0xb1f4}, 
	{0x925c, 0x8fe3e4}, 
	{0x925d, 0x8fe3e5}, 
	{0x925e, 0xeee8}, 
	{0x9260, 0x8fe3e6}, 
	{0x9261, 0x8fe3e7}, 
	{0x9262, 0xc8ad}, 
	{0x9264, 0xeeec}, 
	{0x9265, 0x8fe3e8}, 
	{0x9266, 0xbee0}, 
	{0x9267, 0x8fe3e9}, 
	{0x9268, 0x8fe3ea}, 
	{0x9269, 0x8fe3eb}, 
	{0x926e, 0x8fe3ec}, 
	{0x926f, 0x8fe3ed}, 
	{0x9270, 0x8fe3ee}, 
	{0x9271, 0xb9db}, 
	{0x9275, 0x8fe3ef}, 
	{0x9276, 0x8fe3f0}, 
	{0x9277, 0x8fe3f1}, 
	{0x9278, 0x8fe3f2}, 
	{0x9279, 0x8fe3f3}, 
	{0x927b, 0x8fe3f4}, 
	{0x927c, 0x8fe3f5}, 
	{0x927d, 0x8fe3f6}, 
	{0x927e, 0xcbc8}, 
	{0x927f, 0x8fe3f7}, 
	{0x9280, 0xb6e4}, 
	{0x9283, 0xbdc6}, 
	{0x9285, 0xc6bc}, 
	{0x9288, 0x8fe3f8}, 
	{0x9289, 0x8fe3f9}, 
	{0x928a, 0x8fe3fa}, 
	{0x928d, 0x8fe3fb}, 
	{0x928e, 0x8fe3fc}, 
	{0x9291, 0xc1ad}, 
	{0x9292, 0x8fe3fd}, 
	{0x9293, 0xeef4}, 
	{0x9295, 0xeeee}, 
	{0x9296, 0xeef3}, 
	{0x9297, 0x8fe3fe}, 
	{0x9298, 0xccc3}, 
	{0x9299, 0x8fe4a1}, 
	{0x929a, 0xc4b8}, 
	{0x929b, 0xeef5}, 
	{0x929c, 0xeef2}, 
	{0x929f, 0x8fe4a2}, 
	{0x92a0, 0x8fe4a3}, 
	{0x92a4, 0x8fe4a4}, 
	{0x92a5, 0x8fe4a5}, 
	{0x92a7, 0x8fe4a6}, 
	{0x92a8, 0x8fe4a7}, 
	{0x92ab, 0x8fe4a8}, 
	{0x92ad, 0xc1ac}, 
	{0x92af, 0x8fe4a9}, 
	{0x92b2, 0x8fe4aa}, 
	{0x92b6, 0x8fe4ab}, 
	{0x92b7, 0xeef9}, 
	{0x92b8, 0x8fe4ac}, 
	{0x92b9, 0xeef8}, 
	{0x92ba, 0x8fe4ad}, 
	{0x92bb, 0x8fe4ae}, 
	{0x92bc, 0x8fe4af}, 
	{0x92bd, 0x8fe4b0}, 
	{0x92bf, 0x8fe4b1}, 
	{0x92c0, 0x8fe4b2}, 
	{0x92c1, 0x8fe4b3}, 
	{0x92c2, 0x8fe4b4}, 
	{0x92c3, 0x8fe4b5}, 
	{0x92c5, 0x8fe4b6}, 
	{0x92c6, 0x8fe4b7}, 
	{0x92c7, 0x8fe4b8}, 
	{0x92c8, 0x8fe4b9}, 
	{0x92cb, 0x8fe4ba}, 
	{0x92cc, 0x8fe4bb}, 
	{0x92cd, 0x8fe4bc}, 
	{0x92ce, 0x8fe4bd}, 
	{0x92cf, 0xeef7}, 
	{0x92d0, 0x8fe4be}, 
	{0x92d2, 0xcbaf}, 
	{0x92d3, 0x8fe4bf}, 
	{0x92d5, 0x8fe4c0}, 
	{0x92d7, 0x8fe4c1}, 
	{0x92d8, 0x8fe4c2}, 
	{0x92d9, 0x8fe4c3}, 
	{0x92dc, 0x8fe4c4}, 
	{0x92dd, 0x8fe4c5}, 
	{0x92df, 0x8fe4c6}, 
	{0x92e0, 0x8fe4c7}, 
	{0x92e1, 0x8fe4c8}, 
	{0x92e3, 0x8fe4c9}, 
	{0x92e4, 0xbdfb}, 
	{0x92e5, 0x8fe4ca}, 
	{0x92e7, 0x8fe4cb}, 
	{0x92e8, 0x8fe4cc}, 
	{0x92e9, 0xeefa}, 
	{0x92ea, 0xcadf}, 
	{0x92ec, 0x8fe4cd}, 
	{0x92ed, 0xb1d4}, 
	{0x92ee, 0x8fe4ce}, 
	{0x92f0, 0x8fe4cf}, 
	{0x92f2, 0xc9c6}, 
	{0x92f3, 0xc3f2}, 
	{0x92f8, 0xb5f8}, 
	{0x92f9, 0x8fe4d0}, 
	{0x92fa, 0xeefc}, 
	{0x92fb, 0x8fe4d1}, 
	{0x92fc, 0xb9dd}, 
	{0x92ff, 0x8fe4d2}, 
	{0x9300, 0x8fe4d3}, 
	{0x9302, 0x8fe4d4}, 
	{0x9306, 0xbbac}, 
	{0x9308, 0x8fe4d5}, 
	{0x930d, 0x8fe4d6}, 
	{0x930f, 0xeefb}, 
	{0x9310, 0xbfed}, 
	{0x9311, 0x8fe4d7}, 
	{0x9314, 0x8fe4d8}, 
	{0x9315, 0x8fe4d9}, 
	{0x9318, 0xbfee}, 
	{0x9319, 0xefa1}, 
	{0x931a, 0xefa3}, 
	{0x931c, 0x8fe4da}, 
	{0x931d, 0x8fe4db}, 
	{0x931e, 0x8fe4dc}, 
	{0x931f, 0x8fe4dd}, 
	{0x9320, 0xbefb}, 
	{0x9321, 0x8fe4de}, 
	{0x9322, 0xefa2}, 
	{0x9323, 0xefa4}, 
	{0x9324, 0x8fe4df}, 
	{0x9325, 0x8fe4e0}, 
	{0x9326, 0xb6d3}, 
	{0x9327, 0x8fe4e1}, 
	{0x9328, 0xc9c5}, 
	{0x9329, 0x8fe4e2}, 
	{0x932a, 0x8fe4e3}, 
	{0x932b, 0xbce2}, 
	{0x932c, 0xcfa3}, 
	{0x932e, 0xeefe}, 
	{0x932f, 0xbaf8}, 
	{0x9332, 0xcfbf}, 
	{0x9333, 0x8fe4e4}, 
	{0x9334, 0x8fe4e5}, 
	{0x9335, 0xefa6}, 
	{0x9336, 0x8fe4e6}, 
	{0x9337, 0x8fe4e7}, 
	{0x933a, 0xefa5}, 
	{0x933b, 0xefa7}, 
	{0x9344, 0xeefd}, 
	{0x9347, 0x8fe4e8}, 
	{0x9348, 0x8fe4e9}, 
	{0x9349, 0x8fe4ea}, 
	{0x934b, 0xc6e9}, 
	{0x934d, 0xc5d5}, 
	{0x9350, 0x8fe4eb}, 
	{0x9351, 0x8fe4ec}, 
	{0x9352, 0x8fe4ed}, 
	{0x9354, 0xc4d7}, 
	{0x9355, 0x8fe4ee}, 
	{0x9356, 0xefac}, 
	{0x9357, 0x8fe4ef}, 
	{0x9358, 0x8fe4f0}, 
	{0x935a, 0x8fe4f1}, 
	{0x935b, 0xc3c3}, 
	{0x935c, 0xefa8}, 
	{0x935e, 0x8fe4f2}, 
	{0x9360, 0xefa9}, 
	{0x9364, 0x8fe4f3}, 
	{0x9365, 0x8fe4f4}, 
	{0x9367, 0x8fe4f5}, 
	{0x9369, 0x8fe4f6}, 
	{0x936a, 0x8fe4f7}, 
	{0x936c, 0xb7ad}, 
	{0x936d, 0x8fe4f8}, 
	{0x936e, 0xefab}, 
	{0x936f, 0x8fe4f9}, 
	{0x9370, 0x8fe4fa}, 
	{0x9371, 0x8fe4fb}, 
	{0x9373, 0x8fe4fc}, 
	{0x9374, 0x8fe4fd}, 
	{0x9375, 0xb8b0}, 
	{0x9376, 0x8fe4fe}, 
	{0x937a, 0x8fe5a1}, 
	{0x937c, 0xefaa}, 
	{0x937d, 0x8fe5a2}, 
	{0x937e, 0xbee1}, 
	{0x937f, 0x8fe5a3}, 
	{0x9380, 0x8fe5a4}, 
	{0x9381, 0x8fe5a5}, 
	{0x9382, 0x8fe5a6}, 
	{0x9388, 0x8fe5a7}, 
	{0x938a, 0x8fe5a8}, 
	{0x938b, 0x8fe5a9}, 
	{0x938c, 0xb3f9}, 
	{0x938d, 0x8fe5aa}, 
	{0x938f, 0x8fe5ab}, 
	{0x9392, 0x8fe5ac}, 
	{0x9394, 0xefb0}, 
	{0x9395, 0x8fe5ad}, 
	{0x9396, 0xbabf}, 
	{0x9397, 0xc1f9}, 
	{0x9398, 0x8fe5ae}, 
	{0x939a, 0xc4ca}, 
	{0x939b, 0x8fe5af}, 
	{0x939e, 0x8fe5b0}, 
	{0x93a1, 0x8fe5b1}, 
	{0x93a3, 0x8fe5b2}, 
	{0x93a4, 0x8fe5b3}, 
	{0x93a6, 0x8fe5b4}, 
	{0x93a7, 0xb3bb}, 
	{0x93a8, 0x8fe5b5}, 
	{0x93a9, 0x8fe5bb}, 
	{0x93ab, 0x8fe5b6}, 
	{0x93ac, 0xefae}, 
	{0x93ad, 0xefaf}, 
	{0x93ae, 0xc4c3}, 
	{0x93b0, 0xefad}, 
	{0x93b4, 0x8fe5b7}, 
	{0x93b5, 0x8fe5b8}, 
	{0x93b6, 0x8fe5b9}, 
	{0x93b9, 0xefb1}, 
	{0x93ba, 0x8fe5ba}, 
	{0x93c1, 0x8fe5bc}, 
	{0x93c3, 0xefb7}, 
	{0x93c4, 0x8fe5bd}, 
	{0x93c5, 0x8fe5be}, 
	{0x93c6, 0x8fe5bf}, 
	{0x93c7, 0x8fe5c0}, 
	{0x93c8, 0xefba}, 
	{0x93c9, 0x8fe5c1}, 
	{0x93ca, 0x8fe5c2}, 
	{0x93cb, 0x8fe5c3}, 
	{0x93cc, 0x8fe5c4}, 
	{0x93cd, 0x8fe5c5}, 
	{0x93d0, 0xefb9}, 
	{0x93d1, 0xc5ad}, 
	{0x93d3, 0x8fe5c6}, 
	{0x93d6, 0xefb2}, 
	{0x93d7, 0xefb3}, 
	{0x93d8, 0xefb6}, 
	{0x93d9, 0x8fe5c7}, 
	{0x93dc, 0x8fe5c8}, 
	{0x93dd, 0xefb8}, 
	{0x93de, 0x8fe5c9}, 
	{0x93df, 0x8fe5ca}, 
	{0x93e1, 0xb6c0}, 
	{0x93e2, 0x8fe5cb}, 
	{0x93e4, 0xefbb}, 
	{0x93e5, 0xefb5}, 
	{0x93e6, 0x8fe5cc}, 
	{0x93e7, 0x8fe5cd}, 
	{0x93e8, 0xefb4}, 
	{0x93f7, 0x8fe5cf}, 
	{0x93f8, 0x8fe5d0}, 
	{0x93f9, 0x8fe5ce}, 
	{0x93fa, 0x8fe5d1}, 
	{0x93fb, 0x8fe5d2}, 
	{0x93fd, 0x8fe5d3}, 
	{0x9401, 0x8fe5d4}, 
	{0x9402, 0x8fe5d5}, 
	{0x9403, 0xefbf}, 
	{0x9404, 0x8fe5d6}, 
	{0x9407, 0xefc0}, 
	{0x9408, 0x8fe5d7}, 
	{0x9409, 0x8fe5d8}, 
	{0x940d, 0x8fe5d9}, 
	{0x940e, 0x8fe5da}, 
	{0x940f, 0x8fe5db}, 
	{0x9410, 0xefc1}, 
	{0x9413, 0xefbe}, 
	{0x9414, 0xefbd}, 
	{0x9415, 0x8fe5dc}, 
	{0x9416, 0x8fe5dd}, 
	{0x9417, 0x8fe5de}, 
	{0x9418, 0xbee2}, 
	{0x9419, 0xc6aa}, 
	{0x941a, 0xefbc}, 
	{0x941f, 0x8fe5df}, 
	{0x9421, 0xefc5}, 
	{0x942b, 0xefc3}, 
	{0x942e, 0x8fe5e0}, 
	{0x942f, 0x8fe5e1}, 
	{0x9431, 0x8fe5e2}, 
	{0x9432, 0x8fe5e3}, 
	{0x9433, 0x8fe5e4}, 
	{0x9434, 0x8fe5e5}, 
	{0x9435, 0xefc4}, 
	{0x9436, 0xefc2}, 
	{0x9438, 0xc2f8}, 
	{0x943a, 0xefc6}, 
	{0x943b, 0x8fe5e6}, 
	{0x943d, 0x8fe5e8}, 
	{0x943f, 0x8fe5e7}, 
	{0x9441, 0xefc7}, 
	{0x9443, 0x8fe5e9}, 
	{0x9444, 0xefc9}, 
	{0x9445, 0x8fe5ea}, 
	{0x9448, 0x8fe5eb}, 
	{0x944a, 0x8fe5ec}, 
	{0x944c, 0x8fe5ed}, 
	{0x9451, 0xb4d5}, 
	{0x9452, 0xefc8}, 
	{0x9453, 0xccfa}, 
	{0x9455, 0x8fe5ee}, 
	{0x9459, 0x8fe5ef}, 
	{0x945a, 0xefd4}, 
	{0x945b, 0xefca}, 
	{0x945c, 0x8fe5f0}, 
	{0x945e, 0xefcd}, 
	{0x945f, 0x8fe5f1}, 
	{0x9460, 0xefcb}, 
	{0x9461, 0x8fe5f2}, 
	{0x9462, 0xefcc}, 
	{0x9463, 0x8fe5f3}, 
	{0x9468, 0x8fe5f4}, 
	{0x946a, 0xefce}, 
	{0x946b, 0x8fe5f5}, 
	{0x946d, 0x8fe5f6}, 
	{0x946e, 0x8fe5f7}, 
	{0x946f, 0x8fe5f8}, 
	{0x9470, 0xefd0}, 
	{0x9471, 0x8fe5f9}, 
	{0x9472, 0x8fe5fa}, 
	{0x9475, 0xefd1}, 
	{0x9477, 0xefd2}, 
	{0x947c, 0xefd5}, 
	{0x947d, 0xefd3}, 
	{0x947e, 0xefd6}, 
	{0x947f, 0xefd8}, 
	{0x9481, 0xefd7}, 
	{0x9483, 0x8fe5fc}, 
	{0x9484, 0x8fe5fb}, 
	{0x9577, 0xc4b9}, 
	{0x9578, 0x8fe5fd}, 
	{0x9579, 0x8fe5fe}, 
	{0x957e, 0x8fe6a1}, 
	{0x9580, 0xcce7}, 
	{0x9582, 0xefd9}, 
	{0x9583, 0xc1ae}, 
	{0x9584, 0x8fe6a2}, 
	{0x9587, 0xefda}, 
	{0x9588, 0x8fe6a3}, 
	{0x9589, 0xcac4}, 
	{0x958a, 0xefdb}, 
	{0x958b, 0xb3ab}, 
	{0x958c, 0x8fe6a4}, 
	{0x958d, 0x8fe6a5}, 
	{0x958e, 0x8fe6a6}, 
	{0x958f, 0xb1bc}, 
	{0x9591, 0xb4d7}, 
	{0x9593, 0xb4d6}, 
	{0x9594, 0xefdc}, 
	{0x9596, 0xefdd}, 
	{0x9598, 0xefde}, 
	{0x9599, 0xefdf}, 
	{0x959d, 0x8fe6a7}, 
	{0x959e, 0x8fe6a8}, 
	{0x959f, 0x8fe6a9}, 
	{0x95a0, 0xefe0}, 
	{0x95a1, 0x8fe6aa}, 
	{0x95a2, 0xb4d8}, 
	{0x95a3, 0xb3d5}, 
	{0x95a4, 0xb9de}, 
	{0x95a5, 0xc8b6}, 
	{0x95a6, 0x8fe6ab}, 
	{0x95a7, 0xefe2}, 
	{0x95a8, 0xefe1}, 
	{0x95a9, 0x8fe6ac}, 
	{0x95ab, 0x8fe6ad}, 
	{0x95ac, 0x8fe6ae}, 
	{0x95ad, 0xefe3}, 
	{0x95b2, 0xb1dc}, 
	{0x95b4, 0x8fe6af}, 
	{0x95b6, 0x8fe6b0}, 
	{0x95b9, 0xefe6}, 
	{0x95ba, 0x8fe6b1}, 
	{0x95bb, 0xefe5}, 
	{0x95bc, 0xefe4}, 
	{0x95bd, 0x8fe6b2}, 
	{0x95be, 0xefe7}, 
	{0x95bf, 0x8fe6b3}, 
	{0x95c3, 0xefea}, 
	{0x95c6, 0x8fe6b4}, 
	{0x95c7, 0xb0c7}, 
	{0x95c8, 0x8fe6b5}, 
	{0x95c9, 0x8fe6b6}, 
	{0x95ca, 0xefe8}, 
	{0x95cb, 0x8fe6b7}, 
	{0x95cc, 0xefec}, 
	{0x95cd, 0xefeb}, 
	{0x95d0, 0x8fe6b8}, 
	{0x95d1, 0x8fe6b9}, 
	{0x95d2, 0x8fe6ba}, 
	{0x95d3, 0x8fe6bb}, 
	{0x95d4, 0xefee}, 
	{0x95d5, 0xefed}, 
	{0x95d6, 0xefef}, 
	{0x95d8, 0xc6ae}, 
	{0x95d9, 0x8fe6bc}, 
	{0x95da, 0x8fe6bd}, 
	{0x95dc, 0xeff0}, 
	{0x95dd, 0x8fe6be}, 
	{0x95de, 0x8fe6bf}, 
	{0x95df, 0x8fe6c0}, 
	{0x95e0, 0x8fe6c1}, 
	{0x95e1, 0xeff1}, 
	{0x95e2, 0xeff3}, 
	{0x95e4, 0x8fe6c2}, 
	{0x95e5, 0xeff2}, 
	{0x95e6, 0x8fe6c3}, 
	{0x961c, 0xc9ec}, 
	{0x961d, 0x8fe6c4}, 
	{0x961e, 0x8fe6c5}, 
	{0x9621, 0xeff4}, 
	{0x9622, 0x8fe6c6}, 
	{0x9624, 0x8fe6c7}, 
	{0x9625, 0x8fe6c8}, 
	{0x9626, 0x8fe6c9}, 
	{0x9628, 0xeff5}, 
	{0x962a, 0xbae5}, 
	{0x962c, 0x8fe6ca}, 
	{0x962e, 0xeff6}, 
	{0x962f, 0xeff7}, 
	{0x9631, 0x8fe6cb}, 
	{0x9632, 0xcbc9}, 
	{0x9633, 0x8fe6cc}, 
	{0x9637, 0x8fe6cd}, 
	{0x9638, 0x8fe6ce}, 
	{0x9639, 0x8fe6cf}, 
	{0x963a, 0x8fe6d0}, 
	{0x963b, 0xc1cb}, 
	{0x963c, 0x8fe6d1}, 
	{0x963d, 0x8fe6d2}, 
	{0x963f, 0xb0a4}, 
	{0x9640, 0xc2cb}, 
	{0x9641, 0x8fe6d3}, 
	{0x9642, 0xeff8}, 
	{0x9644, 0xc9ed}, 
	{0x964b, 0xeffb}, 
	{0x964c, 0xeff9}, 
	{0x964d, 0xb9df}, 
	{0x964f, 0xeffa}, 
	{0x9650, 0xb8c2}, 
	{0x9652, 0x8fe6d4}, 
	{0x9654, 0x8fe6d5}, 
	{0x9656, 0x8fe6d6}, 
	{0x9657, 0x8fe6d7}, 
	{0x9658, 0x8fe6d8}, 
	{0x965b, 0xcac5}, 
	{0x965c, 0xeffd}, 
	{0x965d, 0xf0a1}, 
	{0x965e, 0xeffe}, 
	{0x965f, 0xf0a2}, 
	{0x9661, 0x8fe6d9}, 
	{0x9662, 0xb1a1}, 
	{0x9663, 0xbfd8}, 
	{0x9664, 0xbdfc}, 
	{0x9665, 0xb4d9}, 
	{0x9666, 0xf0a3}, 
	{0x966a, 0xc7e6}, 
	{0x966c, 0xf0a5}, 
	{0x966e, 0x8fe6da}, 
	{0x9670, 0xb1a2}, 
	{0x9672, 0xf0a4}, 
	{0x9673, 0xc4c4}, 
	{0x9674, 0x8fe6db}, 
	{0x9675, 0xcecd}, 
	{0x9676, 0xc6ab}, 
	{0x9677, 0xeffc}, 
	{0x9678, 0xcea6}, 
	{0x967a, 0xb8b1}, 
	{0x967b, 0x8fe6dc}, 
	{0x967c, 0x8fe6dd}, 
	{0x967d, 0xcddb}, 
	{0x967e, 0x8fe6de}, 
	{0x967f, 0x8fe6df}, 
	{0x9681, 0x8fe6e0}, 
	{0x9682, 0x8fe6e1}, 
	{0x9683, 0x8fe6e2}, 
	{0x9684, 0x8fe6e3}, 
	{0x9685, 0xb6f9}, 
	{0x9686, 0xceb4}, 
	{0x9688, 0xb7a8}, 
	{0x9689, 0x8fe6e4}, 
	{0x968a, 0xc2e2}, 
	{0x968b, 0xe7a1}, 
	{0x968d, 0xf0a6}, 
	{0x968e, 0xb3ac}, 
	{0x968f, 0xbfef}, 
	{0x9691, 0x8fe6e5}, 
	{0x9694, 0xb3d6}, 
	{0x9695, 0xf0a8}, 
	{0x9696, 0x8fe6e6}, 
	{0x9697, 0xf0a9}, 
	{0x9698, 0xf0a7}, 
	{0x9699, 0xb7e4}, 
	{0x969a, 0x8fe6e7}, 
	{0x969b, 0xbadd}, 
	{0x969c, 0xbee3}, 
	{0x969d, 0x8fe6e8}, 
	{0x969f, 0x8fe6e9}, 
	{0x96a0, 0xb1a3}, 
	{0x96a3, 0xced9}, 
	{0x96a4, 0x8fe6ea}, 
	{0x96a5, 0x8fe6eb}, 
	{0x96a6, 0x8fe6ec}, 
	{0x96a7, 0xf0ab}, 
	{0x96a8, 0xeeae}, 
	{0x96a9, 0x8fe6ed}, 
	{0x96aa, 0xf0aa}, 
	{0x96ae, 0x8fe6ee}, 
	{0x96af, 0x8fe6ef}, 
	{0x96b0, 0xf0ae}, 
	{0x96b1, 0xf0ac}, 
	{0x96b2, 0xf0ad}, 
	{0x96b3, 0x8fe6f0}, 
	{0x96b4, 0xf0af}, 
	{0x96b6, 0xf0b0}, 
	{0x96b7, 0xceec}, 
	{0x96b8, 0xf0b1}, 
	{0x96b9, 0xf0b2}, 
	{0x96ba, 0x8fe6f1}, 
	{0x96bb, 0xc0c9}, 
	{0x96bc, 0xc8bb}, 
	{0x96c0, 0xbffd}, 
	{0x96c1, 0xb4e7}, 
	{0x96c4, 0xcdba}, 
	{0x96c5, 0xb2ed}, 
	{0x96c6, 0xbdb8}, 
	{0x96c7, 0xb8db}, 
	{0x96c9, 0xf0b5}, 
	{0x96ca, 0x8fe6f2}, 
	{0x96cb, 0xf0b4}, 
	{0x96cc, 0xbbf3}, 
	{0x96cd, 0xf0b6}, 
	{0x96ce, 0xf0b3}, 
	{0x96d1, 0xbba8}, 
	{0x96d2, 0x8fe6f3}, 
	{0x96d5, 0xf0ba}, 
	{0x96d6, 0xeaad}, 
	{0x96d8, 0x8fe6f5}, 
	{0x96d9, 0xd2d6}, 
	{0x96da, 0x8fe6f6}, 
	{0x96db, 0xbff7}, 
	{0x96dc, 0xf0b8}, 
	{0x96dd, 0x8fe6f7}, 
	{0x96de, 0x8fe6f8}, 
	{0x96df, 0x8fe6f9}, 
	{0x96e2, 0xcea5}, 
	{0x96e3, 0xc6f1}, 
	{0x96e8, 0xb1ab}, 
	{0x96e9, 0x8fe6fa}, 
	{0x96ea, 0xc0e3}, 
	{0x96eb, 0xbcb6}, 
	{0x96ef, 0x8fe6fb}, 
	{0x96f0, 0xcab7}, 
	{0x96f1, 0x8fe6fc}, 
	{0x96f2, 0xb1c0}, 
	{0x96f6, 0xceed}, 
	{0x96f7, 0xcdeb}, 
	{0x96f9, 0xf0bb}, 
	{0x96fa, 0x8fe6fd}, 
	{0x96fb, 0xc5c5}, 
	{0x9700, 0xbcfb}, 
	{0x9702, 0x8fe6fe}, 
	{0x9703, 0x8fe7a1}, 
	{0x9704, 0xf0bc}, 
	{0x9705, 0x8fe7a2}, 
	{0x9706, 0xf0bd}, 
	{0x9707, 0xbfcc}, 
	{0x9708, 0xf0be}, 
	{0x9709, 0x8fe7a3}, 
	{0x970a, 0xceee}, 
	{0x970d, 0xf0b9}, 
	{0x970e, 0xf0c0}, 
	{0x970f, 0xf0c2}, 
	{0x9711, 0xf0c1}, 
	{0x9713, 0xf0bf}, 
	{0x9716, 0xf0c3}, 
	{0x9719, 0xf0c4}, 
	{0x971a, 0x8fe7a4}, 
	{0x971b, 0x8fe7a5}, 
	{0x971c, 0xc1fa}, 
	{0x971d, 0x8fe7a6}, 
	{0x971e, 0xb2e2}, 
	{0x9721, 0x8fe7a7}, 
	{0x9722, 0x8fe7a8}, 
	{0x9723, 0x8fe7a9}, 
	{0x9724, 0xf0c5}, 
	{0x9727, 0xccb8}, 
	{0x9728, 0x8fe7aa}, 
	{0x972a, 0xf0c6}, 
	{0x9730, 0xf0c7}, 
	{0x9731, 0x8fe7ab}, 
	{0x9732, 0xcfaa}, 
	{0x9733, 0x8fe7ac}, 
	{0x9738, 0xdbb1}, 
	{0x9739, 0xf0c8}, 
	{0x973d, 0xf0c9}, 
	{0x973e, 0xf0ca}, 
	{0x9741, 0x8fe7ad}, 
	{0x9742, 0xf0ce}, 
	{0x9743, 0x8fe7ae}, 
	{0x9744, 0xf0cb}, 
	{0x9746, 0xf0cc}, 
	{0x9748, 0xf0cd}, 
	{0x9749, 0xf0cf}, 
	{0x974a, 0x8fe7af}, 
	{0x974e, 0x8fe7b0}, 
	{0x974f, 0x8fe7b1}, 
	{0x9752, 0xc0c4}, 
	{0x9755, 0x8fe7b2}, 
	{0x9756, 0xccf7}, 
	{0x9757, 0x8fe7b3}, 
	{0x9758, 0x8fe7b4}, 
	{0x9759, 0xc0c5}, 
	{0x975a, 0x8fe7b5}, 
	{0x975b, 0x8fe7b6}, 
	{0x975c, 0xf0d0}, 
	{0x975e, 0xc8f3}, 
	{0x9760, 0xf0d1}, 
	{0x9761, 0xf3d3}, 
	{0x9762, 0xcccc}, 
	{0x9763, 0x8fe7b7}, 
	{0x9764, 0xf0d2}, 
	{0x9766, 0xf0d3}, 
	{0x9767, 0x8fe7b8}, 
	{0x9768, 0xf0d4}, 
	{0x9769, 0xb3d7}, 
	{0x976a, 0x8fe7b9}, 
	{0x976b, 0xf0d6}, 
	{0x976d, 0xbfd9}, 
	{0x976e, 0x8fe7ba}, 
	{0x9771, 0xf0d7}, 
	{0x9773, 0x8fe7bb}, 
	{0x9774, 0xb7a4}, 
	{0x9776, 0x8fe7bc}, 
	{0x9777, 0x8fe7bd}, 
	{0x9778, 0x8fe7be}, 
	{0x9779, 0xf0d8}, 
	{0x977a, 0xf0dc}, 
	{0x977b, 0x8fe7bf}, 
	{0x977c, 0xf0da}, 
	{0x977d, 0x8fe7c0}, 
	{0x977f, 0x8fe7c1}, 
	{0x9780, 0x8fe7c2}, 
	{0x9781, 0xf0db}, 
	{0x9784, 0xb3f3}, 
	{0x9785, 0xf0d9}, 
	{0x9786, 0xf0dd}, 
	{0x9789, 0x8fe7c3}, 
	{0x978b, 0xf0de}, 
	{0x978d, 0xb0c8}, 
	{0x978f, 0xf0df}, 
	{0x9790, 0xf0e0}, 
	{0x9795, 0x8fe7c4}, 
	{0x9796, 0x8fe7c5}, 
	{0x9797, 0x8fe7c6}, 
	{0x9798, 0xbee4}, 
	{0x9799, 0x8fe7c7}, 
	{0x979a, 0x8fe7c8}, 
	{0x979c, 0xf0e1}, 
	{0x979e, 0x8fe7c9}, 
	{0x979f, 0x8fe7ca}, 
	{0x97a0, 0xb5c7}, 
	{0x97a2, 0x8fe7cb}, 
	{0x97a3, 0xf0e4}, 
	{0x97a6, 0xf0e3}, 
	{0x97a8, 0xf0e2}, 
	{0x97ab, 0xebf1}, 
	{0x97ac, 0x8fe7cc}, 
	{0x97ad, 0xcadc}, 
	{0x97ae, 0x8fe7cd}, 
	{0x97b1, 0x8fe7ce}, 
	{0x97b2, 0x8fe7cf}, 
	{0x97b3, 0xf0e5}, 
	{0x97b4, 0xf0e6}, 
	{0x97b5, 0x8fe7d0}, 
	{0x97b6, 0x8fe7d1}, 
	{0x97b8, 0x8fe7d2}, 
	{0x97b9, 0x8fe7d3}, 
	{0x97ba, 0x8fe7d4}, 
	{0x97bc, 0x8fe7d5}, 
	{0x97be, 0x8fe7d6}, 
	{0x97bf, 0x8fe7d7}, 
	{0x97c1, 0x8fe7d8}, 
	{0x97c3, 0xf0e7}, 
	{0x97c4, 0x8fe7d9}, 
	{0x97c5, 0x8fe7da}, 
	{0x97c6, 0xf0e8}, 
	{0x97c7, 0x8fe7db}, 
	{0x97c8, 0xf0e9}, 
	{0x97c9, 0x8fe7dc}, 
	{0x97ca, 0x8fe7dd}, 
	{0x97cb, 0xf0ea}, 
	{0x97cc, 0x8fe7de}, 
	{0x97cd, 0x8fe7df}, 
	{0x97ce, 0x8fe7e0}, 
	{0x97d0, 0x8fe7e1}, 
	{0x97d1, 0x8fe7e2}, 
	{0x97d3, 0xb4da}, 
	{0x97d4, 0x8fe7e3}, 
	{0x97d7, 0x8fe7e4}, 
	{0x97d8, 0x8fe7e5}, 
	{0x97d9, 0x8fe7e6}, 
	{0x97db, 0x8fe7ea}, 
	{0x97dc, 0xf0eb}, 
	{0x97dd, 0x8fe7e7}, 
	{0x97de, 0x8fe7e8}, 
	{0x97e0, 0x8fe7e9}, 
	{0x97e1, 0x8fe7eb}, 
	{0x97e4, 0x8fe7ec}, 
	{0x97ed, 0xf0ec}, 
	{0x97ee, 0xc7a3}, 
	{0x97ef, 0x8fe7ed}, 
	{0x97f1, 0x8fe7ee}, 
	{0x97f2, 0xf0ee}, 
	{0x97f3, 0xb2bb}, 
	{0x97f4, 0x8fe7ef}, 
	{0x97f5, 0xf0f1}, 
	{0x97f6, 0xf0f0}, 
	{0x97f7, 0x8fe7f0}, 
	{0x97f8, 0x8fe7f1}, 
	{0x97fa, 0x8fe7f2}, 
	{0x97fb, 0xb1a4}, 
	{0x97ff, 0xb6c1}, 
	{0x9801, 0xcac7}, 
	{0x9802, 0xc4ba}, 
	{0x9803, 0xbaa2}, 
	{0x9805, 0xb9e0}, 
	{0x9806, 0xbde7}, 
	{0x9807, 0x8fe7f3}, 
	{0x9808, 0xbfdc}, 
	{0x980a, 0x8fe7f4}, 
	{0x980c, 0xf0f3}, 
	{0x980d, 0x8fe7f6}, 
	{0x980e, 0x8fe7f7}, 
	{0x980f, 0xf0f2}, 
	{0x9810, 0xcdc2}, 
	{0x9811, 0xb4e8}, 
	{0x9812, 0xc8d2}, 
	{0x9813, 0xc6dc}, 
	{0x9814, 0x8fe7f8}, 
	{0x9816, 0x8fe7f9}, 
	{0x9817, 0xbffc}, 
	{0x9818, 0xcece}, 
	{0x9819, 0x8fe7f5}, 
	{0x981a, 0xb7db}, 
	{0x981c, 0x8fe7fa}, 
	{0x981e, 0x8fe7fb}, 
	{0x9820, 0x8fe7fc}, 
	{0x9821, 0xf0f6}, 
	{0x9823, 0x8fe7fd}, 
	{0x9824, 0xf0f5}, 
	{0x9825, 0x8fe8a8}, 
	{0x9826, 0x8fe7fe}, 
	{0x982b, 0x8fe8a1}, 
	{0x982c, 0xcbcb}, 
	{0x982d, 0xc6ac}, 
	{0x982e, 0x8fe8a2}, 
	{0x982f, 0x8fe8a3}, 
	{0x9830, 0x8fe8a4}, 
	{0x9832, 0x8fe8a5}, 
	{0x9833, 0x8fe8a6}, 
	{0x9834, 0xb1d0}, 
	{0x9835, 0x8fe8a7}, 
	{0x9837, 0xf0f7}, 
	{0x9838, 0xf0f4}, 
	{0x983b, 0xc9d1}, 
	{0x983c, 0xcdea}, 
	{0x983d, 0xf0f8}, 
	{0x983e, 0x8fe8a9}, 
	{0x9844, 0x8fe8aa}, 
	{0x9846, 0xf0f9}, 
	{0x9847, 0x8fe8ab}, 
	{0x984a, 0x8fe8ac}, 
	{0x984b, 0xf0fb}, 
	{0x984c, 0xc2ea}, 
	{0x984d, 0xb3db}, 
	{0x984e, 0xb3dc}, 
	{0x984f, 0xf0fa}, 
	{0x9851, 0x8fe8ad}, 
	{0x9852, 0x8fe8ae}, 
	{0x9853, 0x8fe8af}, 
	{0x9854, 0xb4e9}, 
	{0x9855, 0xb8b2}, 
	{0x9856, 0x8fe8b0}, 
	{0x9857, 0x8fe8b1}, 
	{0x9858, 0xb4ea}, 
	{0x9859, 0x8fe8b2}, 
	{0x985a, 0x8fe8b3}, 
	{0x985b, 0xc5bf}, 
	{0x985e, 0xcee0}, 
	{0x9862, 0x8fe8b4}, 
	{0x9863, 0x8fe8b5}, 
	{0x9865, 0x8fe8b6}, 
	{0x9866, 0x8fe8b7}, 
	{0x9867, 0xb8dc}, 
	{0x986a, 0x8fe8b8}, 
	{0x986b, 0xf0fc}, 
	{0x986c, 0x8fe8b9}, 
	{0x986f, 0xf0fd}, 
	{0x9870, 0xf0fe}, 
	{0x9871, 0xf1a1}, 
	{0x9873, 0xf1a3}, 
	{0x9874, 0xf1a2}, 
	{0x98a8, 0xc9f7}, 
	{0x98aa, 0xf1a4}, 
	{0x98ab, 0x8fe8ba}, 
	{0x98ad, 0x8fe8bb}, 
	{0x98ae, 0x8fe8bc}, 
	{0x98af, 0xf1a5}, 
	{0x98b0, 0x8fe8bd}, 
	{0x98b1, 0xf1a6}, 
	{0x98b4, 0x8fe8be}, 
	{0x98b6, 0xf1a7}, 
	{0x98b7, 0x8fe8bf}, 
	{0x98b8, 0x8fe8c0}, 
	{0x98ba, 0x8fe8c1}, 
	{0x98bb, 0x8fe8c2}, 
	{0x98bf, 0x8fe8c3}, 
	{0x98c2, 0x8fe8c4}, 
	{0x98c3, 0xf1a9}, 
	{0x98c4, 0xf1a8}, 
	{0x98c5, 0x8fe8c5}, 
	{0x98c6, 0xf1aa}, 
	{0x98c8, 0x8fe8c6}, 
	{0x98cc, 0x8fe8c7}, 
	{0x98db, 0xc8f4}, 
	{0x98dc, 0xe6cc}, 
	{0x98df, 0xbfa9}, 
	{0x98e1, 0x8fe8c8}, 
	{0x98e2, 0xb5b2}, 
	{0x98e3, 0x8fe8c9}, 
	{0x98e5, 0x8fe8ca}, 
	{0x98e6, 0x8fe8cb}, 
	{0x98e7, 0x8fe8cc}, 
	{0x98e9, 0xf1ab}, 
	{0x98ea, 0x8fe8cd}, 
	{0x98eb, 0xf1ac}, 
	{0x98ed, 0xd2ac}, 
	{0x98ee, 0xddbb}, 
	{0x98ef, 0xc8d3}, 
	{0x98f2, 0xb0fb}, 
	{0x98f3, 0x8fe8ce}, 
	{0x98f4, 0xb0bb}, 
	{0x98f6, 0x8fe8cf}, 
	{0x98fc, 0xbbf4}, 
	{0x98fd, 0xcbb0}, 
	{0x98fe, 0xbefe}, 
	{0x9902, 0x8fe8d0}, 
	{0x9903, 0xf1ad}, 
	{0x9905, 0xccdf}, 
	{0x9907, 0x8fe8d1}, 
	{0x9908, 0x8fe8d2}, 
	{0x9909, 0xf1ae}, 
	{0x990a, 0xcddc}, 
	{0x990c, 0xb1c2}, 
	{0x9910, 0xbbc1}, 
	{0x9911, 0x8fe8d3}, 
	{0x9912, 0xf1af}, 
	{0x9913, 0xb2ee}, 
	{0x9914, 0xf1b0}, 
	{0x9915, 0x8fe8d4}, 
	{0x9916, 0x8fe8d5}, 
	{0x9917, 0x8fe8d6}, 
	{0x9918, 0xf1b1}, 
	{0x991a, 0x8fe8d7}, 
	{0x991b, 0x8fe8d8}, 
	{0x991c, 0x8fe8d9}, 
	{0x991d, 0xf1b3}, 
	{0x991e, 0xf1b4}, 
	{0x991f, 0x8fe8da}, 
	{0x9920, 0xf1b6}, 
	{0x9921, 0xf1b2}, 
	{0x9922, 0x8fe8db}, 
	{0x9924, 0xf1b5}, 
	{0x9926, 0x8fe8dc}, 
	{0x9927, 0x8fe8dd}, 
	{0x9928, 0xb4db}, 
	{0x992b, 0x8fe8de}, 
	{0x992c, 0xf1b7}, 
	{0x992e, 0xf1b8}, 
	{0x9931, 0x8fe8df}, 
	{0x9932, 0x8fe8e0}, 
	{0x9933, 0x8fe8e1}, 
	{0x9934, 0x8fe8e2}, 
	{0x9935, 0x8fe8e3}, 
	{0x9939, 0x8fe8e4}, 
	{0x993a, 0x8fe8e5}, 
	{0x993b, 0x8fe8e6}, 
	{0x993c, 0x8fe8e7}, 
	{0x993d, 0xf1b9}, 
	{0x993e, 0xf1ba}, 
	{0x9940, 0x8fe8e8}, 
	{0x9941, 0x8fe8e9}, 
	{0x9942, 0xf1bb}, 
	{0x9945, 0xf1bd}, 
	{0x9946, 0x8fe8ea}, 
	{0x9947, 0x8fe8eb}, 
	{0x9948, 0x8fe8ec}, 
	{0x9949, 0xf1bc}, 
	{0x994b, 0xf1bf}, 
	{0x994c, 0xf1c2}, 
	{0x994d, 0x8fe8ed}, 
	{0x994e, 0x8fe8ee}, 
	{0x9950, 0xf1be}, 
	{0x9951, 0xf1c0}, 
	{0x9952, 0xf1c1}, 
	{0x9954, 0x8fe8ef}, 
	{0x9955, 0xf1c3}, 
	{0x9957, 0xb6c2}, 
	{0x9958, 0x8fe8f0}, 
	{0x9959, 0x8fe8f1}, 
	{0x995b, 0x8fe8f2}, 
	{0x995c, 0x8fe8f3}, 
	{0x995e, 0x8fe8f4}, 
	{0x995f, 0x8fe8f5}, 
	{0x9960, 0x8fe8f6}, 
	{0x9996, 0xbcf3}, 
	{0x9997, 0xf1c4}, 
	{0x9998, 0xf1c5}, 
	{0x9999, 0xb9e1}, 
	{0x999b, 0x8fe8f7}, 
	{0x999d, 0x8fe8f8}, 
	{0x999f, 0x8fe8f9}, 
	{0x99a5, 0xf1c6}, 
	{0x99a6, 0x8fe8fa}, 
	{0x99a8, 0xb3be}, 
	{0x99ac, 0xc7cf}, 
	{0x99ad, 0xf1c7}, 
	{0x99ae, 0xf1c8}, 
	{0x99b0, 0x8fe8fb}, 
	{0x99b1, 0x8fe8fc}, 
	{0x99b2, 0x8fe8fd}, 
	{0x99b3, 0xc3da}, 
	{0x99b4, 0xc6eb}, 
	{0x99b5, 0x8fe8fe}, 
	{0x99b9, 0x8fe9a1}, 
	{0x99ba, 0x8fe9a2}, 
	{0x99bc, 0xf1c9}, 
	{0x99bd, 0x8fe9a3}, 
	{0x99bf, 0x8fe9a4}, 
	{0x99c1, 0xc7fd}, 
	{0x99c3, 0x8fe9a5}, 
	{0x99c4, 0xc2cc}, 
	{0x99c5, 0xb1d8}, 
	{0x99c6, 0xb6ee}, 
	{0x99c8, 0xb6ef}, 
	{0x99c9, 0x8fe9a6}, 
	{0x99d0, 0xc3f3}, 
	{0x99d1, 0xf1ce}, 
	{0x99d2, 0xb6f0}, 
	{0x99d3, 0x8fe9a7}, 
	{0x99d4, 0x8fe9a8}, 
	{0x99d5, 0xb2ef}, 
	{0x99d8, 0xf1cd}, 
	{0x99d9, 0x8fe9a9}, 
	{0x99da, 0x8fe9aa}, 
	{0x99db, 0xf1cb}, 
	{0x99dc, 0x8fe9ab}, 
	{0x99dd, 0xf1cc}, 
	{0x99de, 0x8fe9ac}, 
	{0x99df, 0xf1ca}, 
	{0x99e2, 0xf1d8}, 
	{0x99e7, 0x8fe9ad}, 
	{0x99ea, 0x8fe9ae}, 
	{0x99eb, 0x8fe9af}, 
	{0x99ec, 0x8fe9b0}, 
	{0x99ed, 0xf1cf}, 
	{0x99ee, 0xf1d0}, 
	{0x99f0, 0x8fe9b1}, 
	{0x99f1, 0xf1d1}, 
	{0x99f2, 0xf1d2}, 
	{0x99f4, 0x8fe9b2}, 
	{0x99f5, 0x8fe9b3}, 
	{0x99f8, 0xf1d4}, 
	{0x99f9, 0x8fe9b4}, 
	{0x99fb, 0xf1d3}, 
	{0x99fd, 0x8fe9b5}, 
	{0x99fe, 0x8fe9b6}, 
	{0x99ff, 0xbdd9}, 
	{0x9a01, 0xf1d5}, 
	{0x9a02, 0x8fe9b7}, 
	{0x9a03, 0x8fe9b8}, 
	{0x9a04, 0x8fe9b9}, 
	{0x9a05, 0xf1d7}, 
	{0x9a0b, 0x8fe9ba}, 
	{0x9a0c, 0x8fe9bb}, 
	{0x9a0e, 0xb5b3}, 
	{0x9a0f, 0xf1d6}, 
	{0x9a10, 0x8fe9bc}, 
	{0x9a11, 0x8fe9bd}, 
	{0x9a12, 0xc1fb}, 
	{0x9a13, 0xb8b3}, 
	{0x9a16, 0x8fe9be}, 
	{0x9a19, 0xf1d9}, 
	{0x9a1e, 0x8fe9bf}, 
	{0x9a20, 0x8fe9c0}, 
	{0x9a22, 0x8fe9c1}, 
	{0x9a23, 0x8fe9c2}, 
	{0x9a24, 0x8fe9c3}, 
	{0x9a27, 0x8fe9c4}, 
	{0x9a28, 0xc2cd}, 
	{0x9a2b, 0xf1da}, 
	{0x9a2d, 0x8fe9c5}, 
	{0x9a2e, 0x8fe9c6}, 
	{0x9a30, 0xc6ad}, 
	{0x9a33, 0x8fe9c7}, 
	{0x9a35, 0x8fe9c8}, 
	{0x9a36, 0x8fe9c9}, 
	{0x9a37, 0xf1db}, 
	{0x9a38, 0x8fe9ca}, 
	{0x9a3e, 0xf1e0}, 
	{0x9a40, 0xf1de}, 
	{0x9a41, 0x8fe9cc}, 
	{0x9a42, 0xf1dd}, 
	{0x9a43, 0xf1df}, 
	{0x9a44, 0x8fe9cd}, 
	{0x9a45, 0xf1dc}, 
	{0x9a47, 0x8fe9cb}, 
	{0x9a4a, 0x8fe9ce}, 
	{0x9a4b, 0x8fe9cf}, 
	{0x9a4c, 0x8fe9d0}, 
	{0x9a4d, 0xf1e2}, 
	{0x9a4e, 0x8fe9d1}, 
	{0x9a51, 0x8fe9d2}, 
	{0x9a54, 0x8fe9d3}, 
	{0x9a55, 0xf1e1}, 
	{0x9a56, 0x8fe9d4}, 
	{0x9a57, 0xf1e4}, 
	{0x9a5a, 0xb6c3}, 
	{0x9a5b, 0xf1e3}, 
	{0x9a5d, 0x8fe9d5}, 
	{0x9a5f, 0xf1e5}, 
	{0x9a62, 0xf1e6}, 
	{0x9a64, 0xf1e8}, 
	{0x9a65, 0xf1e7}, 
	{0x9a69, 0xf1e9}, 
	{0x9a6a, 0xf1eb}, 
	{0x9a6b, 0xf1ea}, 
	{0x9aa8, 0xb9fc}, 
	{0x9aaa, 0x8fe9d6}, 
	{0x9aac, 0x8fe9d7}, 
	{0x9aad, 0xf1ec}, 
	{0x9aae, 0x8fe9d8}, 
	{0x9aaf, 0x8fe9d9}, 
	{0x9ab0, 0xf1ed}, 
	{0x9ab2, 0x8fe9da}, 
	{0x9ab4, 0x8fe9db}, 
	{0x9ab5, 0x8fe9dc}, 
	{0x9ab6, 0x8fe9dd}, 
	{0x9ab8, 0xb3bc}, 
	{0x9ab9, 0x8fe9de}, 
	{0x9abb, 0x8fe9df}, 
	{0x9abc, 0xf1ee}, 
	{0x9abe, 0x8fe9e0}, 
	{0x9abf, 0x8fe9e1}, 
	{0x9ac0, 0xf1ef}, 
	{0x9ac1, 0x8fe9e2}, 
	{0x9ac3, 0x8fe9e3}, 
	{0x9ac4, 0xbff1}, 
	{0x9ac6, 0x8fe9e4}, 
	{0x9ac8, 0x8fe9e5}, 
	{0x9ace, 0x8fe9e6}, 
	{0x9acf, 0xf1f0}, 
	{0x9ad0, 0x8fe9e7}, 
	{0x9ad1, 0xf1f1}, 
	{0x9ad2, 0x8fe9e8}, 
	{0x9ad3, 0xf1f2}, 
	{0x9ad4, 0xf1f3}, 
	{0x9ad5, 0x8fe9e9}, 
	{0x9ad6, 0x8fe9ea}, 
	{0x9ad7, 0x8fe9eb}, 
	{0x9ad8, 0xb9e2}, 
	{0x9adb, 0x8fe9ec}, 
	{0x9adc, 0x8fe9ed}, 
	{0x9ade, 0xf1f4}, 
	{0x9adf, 0xf1f5}, 
	{0x9ae0, 0x8fe9ee}, 
	{0x9ae2, 0xf1f6}, 
	{0x9ae3, 0xf1f7}, 
	{0x9ae4, 0x8fe9ef}, 
	{0x9ae5, 0x8fe9f0}, 
	{0x9ae6, 0xf1f8}, 
	{0x9ae7, 0x8fe9f1}, 
	{0x9ae9, 0x8fe9f2}, 
	{0x9aea, 0xc8b1}, 
	{0x9aeb, 0xf1fa}, 
	{0x9aec, 0x8fe9f3}, 
	{0x9aed, 0xc9a6}, 
	{0x9aee, 0xf1fb}, 
	{0x9aef, 0xf1f9}, 
	{0x9af1, 0xf1fd}, 
	{0x9af2, 0x8fe9f4}, 
	{0x9af3, 0x8fe9f5}, 
	{0x9af4, 0xf1fc}, 
	{0x9af5, 0x8fe9f6}, 
	{0x9af7, 0xf1fe}, 
	{0x9af9, 0x8fe9f7}, 
	{0x9afa, 0x8fe9f8}, 
	{0x9afb, 0xf2a1}, 
	{0x9afd, 0x8fe9f9}, 
	{0x9aff, 0x8fe9fa}, 
	{0x9b00, 0x8fe9fb}, 
	{0x9b01, 0x8fe9fc}, 
	{0x9b02, 0x8fe9fd}, 
	{0x9b03, 0x8fe9fe}, 
	{0x9b04, 0x8feaa1}, 
	{0x9b05, 0x8feaa2}, 
	{0x9b06, 0xf2a2}, 
	{0x9b08, 0x8feaa3}, 
	{0x9b09, 0x8feaa4}, 
	{0x9b0b, 0x8feaa5}, 
	{0x9b0c, 0x8feaa6}, 
	{0x9b0d, 0x8feaa7}, 
	{0x9b0e, 0x8feaa8}, 
	{0x9b10, 0x8feaa9}, 
	{0x9b12, 0x8feaaa}, 
	{0x9b16, 0x8feaab}, 
	{0x9b18, 0xf2a3}, 
	{0x9b19, 0x8feaac}, 
	{0x9b1a, 0xf2a4}, 
	{0x9b1b, 0x8feaad}, 
	{0x9b1c, 0x8feaae}, 
	{0x9b1f, 0xf2a5}, 
	{0x9b20, 0x8feaaf}, 
	{0x9b22, 0xf2a6}, 
	{0x9b23, 0xf2a7}, 
	{0x9b25, 0xf2a8}, 
	{0x9b26, 0x8feab0}, 
	{0x9b27, 0xf2a9}, 
	{0x9b28, 0xf2aa}, 
	{0x9b29, 0xf2ab}, 
	{0x9b2a, 0xf2ac}, 
	{0x9b2b, 0x8feab1}, 
	{0x9b2d, 0x8feab2}, 
	{0x9b2e, 0xf2ad}, 
	{0x9b2f, 0xf2ae}, 
	{0x9b31, 0xddb5}, 
	{0x9b32, 0xf2af}, 
	{0x9b33, 0x8feab3}, 
	{0x9b34, 0x8feab4}, 
	{0x9b35, 0x8feab5}, 
	{0x9b37, 0x8feab6}, 
	{0x9b39, 0x8feab7}, 
	{0x9b3a, 0x8feab8}, 
	{0x9b3b, 0xe4f8}, 
	{0x9b3c, 0xb5b4}, 
	{0x9b3d, 0x8feab9}, 
	{0x9b41, 0xb3a1}, 
	{0x9b42, 0xbab2}, 
	{0x9b43, 0xf2b1}, 
	{0x9b44, 0xf2b0}, 
	{0x9b45, 0xcca5}, 
	{0x9b48, 0x8feaba}, 
	{0x9b4b, 0x8feabb}, 
	{0x9b4c, 0x8feabc}, 
	{0x9b4d, 0xf2b3}, 
	{0x9b4e, 0xf2b4}, 
	{0x9b4f, 0xf2b2}, 
	{0x9b51, 0xf2b5}, 
	{0x9b54, 0xcbe2}, 
	{0x9b55, 0x8feabd}, 
	{0x9b56, 0x8feabe}, 
	{0x9b57, 0x8feabf}, 
	{0x9b58, 0xf2b6}, 
	{0x9b5a, 0xb5fb}, 
	{0x9b5b, 0x8feac0}, 
	{0x9b5e, 0x8feac1}, 
	{0x9b61, 0x8feac2}, 
	{0x9b63, 0x8feac3}, 
	{0x9b65, 0x8feac4}, 
	{0x9b66, 0x8feac5}, 
	{0x9b68, 0x8feac6}, 
	{0x9b6a, 0x8feac7}, 
	{0x9b6b, 0x8feac8}, 
	{0x9b6c, 0x8feac9}, 
	{0x9b6d, 0x8feaca}, 
	{0x9b6e, 0x8feacb}, 
	{0x9b6f, 0xcfa5}, 
	{0x9b73, 0x8feacc}, 
	{0x9b74, 0xf2b7}, 
	{0x9b75, 0x8feacd}, 
	{0x9b77, 0x8feace}, 
	{0x9b78, 0x8feacf}, 
	{0x9b79, 0x8fead0}, 
	{0x9b7f, 0x8fead1}, 
	{0x9b80, 0x8fead2}, 
	{0x9b83, 0xf2b9}, 
	{0x9b84, 0x8fead3}, 
	{0x9b85, 0x8fead4}, 
	{0x9b86, 0x8fead5}, 
	{0x9b87, 0x8fead6}, 
	{0x9b89, 0x8fead7}, 
	{0x9b8a, 0x8fead8}, 
	{0x9b8b, 0x8fead9}, 
	{0x9b8d, 0x8feada}, 
	{0x9b8e, 0xb0be}, 
	{0x9b8f, 0x8feadb}, 
	{0x9b90, 0x8feadc}, 
	{0x9b91, 0xf2ba}, 
	{0x9b92, 0xcaab}, 
	{0x9b93, 0xf2b8}, 
	{0x9b94, 0x8feadd}, 
	{0x9b96, 0xf2bb}, 
	{0x9b97, 0xf2bc}, 
	{0x9b9a, 0x8feade}, 
	{0x9b9d, 0x8feadf}, 
	{0x9b9e, 0x8feae0}, 
	{0x9b9f, 0xf2bd}, 
	{0x9ba0, 0xf2be}, 
	{0x9ba6, 0x8feae1}, 
	{0x9ba7, 0x8feae2}, 
	{0x9ba8, 0xf2bf}, 
	{0x9ba9, 0x8feae3}, 
	{0x9baa, 0xcbee}, 
	{0x9bab, 0xbbad}, 
	{0x9bac, 0x8feae4}, 
	{0x9bad, 0xbafa}, 
	{0x9bae, 0xc1af}, 
	{0x9bb0, 0x8feae5}, 
	{0x9bb1, 0x8feae6}, 
	{0x9bb2, 0x8feae7}, 
	{0x9bb4, 0xf2c0}, 
	{0x9bb7, 0x8feae8}, 
	{0x9bb8, 0x8feae9}, 
	{0x9bb9, 0xf2c3}, 
	{0x9bbb, 0x8feaea}, 
	{0x9bbc, 0x8feaeb}, 
	{0x9bbe, 0x8feaec}, 
	{0x9bbf, 0x8feaed}, 
	{0x9bc0, 0xf2c1}, 
	{0x9bc1, 0x8feaee}, 
	{0x9bc6, 0xf2c4}, 
	{0x9bc7, 0x8feaef}, 
	{0x9bc8, 0x8feaf0}, 
	{0x9bc9, 0xb8f1}, 
	{0x9bca, 0xf2c2}, 
	{0x9bce, 0x8feaf1}, 
	{0x9bcf, 0xf2c5}, 
	{0x9bd0, 0x8feaf2}, 
	{0x9bd1, 0xf2c6}, 
	{0x9bd2, 0xf2c7}, 
	{0x9bd4, 0xf2cb}, 
	{0x9bd6, 0xbbaa}, 
	{0x9bd7, 0x8feaf3}, 
	{0x9bd8, 0x8feaf4}, 
	{0x9bdb, 0xc2e4}, 
	{0x9bdd, 0x8feaf5}, 
	{0x9bdf, 0x8feaf6}, 
	{0x9be1, 0xf2cc}, 
	{0x9be2, 0xf2c9}, 
	{0x9be3, 0xf2c8}, 
	{0x9be4, 0xf2ca}, 
	{0x9be5, 0x8feaf7}, 
	{0x9be7, 0x8feaf8}, 
	{0x9be8, 0xb7df}, 
	{0x9bea, 0x8feaf9}, 
	{0x9beb, 0x8feafa}, 
	{0x9bef, 0x8feafb}, 
	{0x9bf0, 0xf2d0}, 
	{0x9bf1, 0xf2cf}, 
	{0x9bf2, 0xf2ce}, 
	{0x9bf3, 0x8feafc}, 
	{0x9bf5, 0xb0b3}, 
	{0x9bf7, 0x8feafd}, 
	{0x9bf8, 0x8feafe}, 
	{0x9bf9, 0x8feba1}, 
	{0x9bfa, 0x8feba2}, 
	{0x9bfd, 0x8feba3}, 
	{0x9bff, 0x8feba4}, 
	{0x9c00, 0x8feba5}, 
	{0x9c02, 0x8feba6}, 
	{0x9c04, 0xf2da}, 
	{0x9c06, 0xf2d6}, 
	{0x9c08, 0xf2d7}, 
	{0x9c09, 0xf2d3}, 
	{0x9c0a, 0xf2d9}, 
	{0x9c0b, 0x8feba7}, 
	{0x9c0c, 0xf2d5}, 
	{0x9c0d, 0xb3e2}, 
	{0x9c0f, 0x8feba8}, 
	{0x9c10, 0xcfcc}, 
	{0x9c11, 0x8feba9}, 
	{0x9c12, 0xf2d8}, 
	{0x9c13, 0xf2d4}, 
	{0x9c14, 0xf2d2}, 
	{0x9c15, 0xf2d1}, 
	{0x9c16, 0x8febaa}, 
	{0x9c18, 0x8febab}, 
	{0x9c19, 0x8febac}, 
	{0x9c1a, 0x8febad}, 
	{0x9c1b, 0xf2dc}, 
	{0x9c1c, 0x8febae}, 
	{0x9c1e, 0x8febaf}, 
	{0x9c21, 0xf2df}, 
	{0x9c22, 0x8febb0}, 
	{0x9c23, 0x8febb1}, 
	{0x9c24, 0xf2de}, 
	{0x9c25, 0xf2dd}, 
	{0x9c26, 0x8febb2}, 
	{0x9c27, 0x8febb3}, 
	{0x9c28, 0x8febb4}, 
	{0x9c29, 0x8febb5}, 
	{0x9c2a, 0x8febb6}, 
	{0x9c2d, 0xc9c9}, 
	{0x9c2e, 0xf2db}, 
	{0x9c2f, 0xb0f3}, 
	{0x9c30, 0xf2e0}, 
	{0x9c31, 0x8febb7}, 
	{0x9c32, 0xf2e2}, 
	{0x9c35, 0x8febb8}, 
	{0x9c36, 0x8febb9}, 
	{0x9c37, 0x8febba}, 
	{0x9c39, 0xb3ef}, 
	{0x9c3a, 0xf2cd}, 
	{0x9c3b, 0xb1b7}, 
	{0x9c3d, 0x8febbb}, 
	{0x9c3e, 0xf2e4}, 
	{0x9c41, 0x8febbc}, 
	{0x9c43, 0x8febbd}, 
	{0x9c44, 0x8febbe}, 
	{0x9c45, 0x8febbf}, 
	{0x9c46, 0xf2e3}, 
	{0x9c47, 0xf2e1}, 
	{0x9c48, 0xc3ad}, 
	{0x9c49, 0x8febc0}, 
	{0x9c4a, 0x8febc1}, 
	{0x9c4e, 0x8febc2}, 
	{0x9c4f, 0x8febc3}, 
	{0x9c50, 0x8febc4}, 
	{0x9c52, 0xcbf0}, 
	{0x9c53, 0x8febc5}, 
	{0x9c54, 0x8febc6}, 
	{0x9c56, 0x8febc7}, 
	{0x9c57, 0xceda}, 
	{0x9c58, 0x8febc8}, 
	{0x9c5a, 0xf2e5}, 
	{0x9c5b, 0x8febc9}, 
	{0x9c5c, 0x8febd0}, 
	{0x9c5d, 0x8febca}, 
	{0x9c5e, 0x8febcb}, 
	{0x9c5f, 0x8febcc}, 
	{0x9c60, 0xf2e6}, 
	{0x9c63, 0x8febcd}, 
	{0x9c67, 0xf2e7}, 
	{0x9c68, 0x8febd2}, 
	{0x9c69, 0x8febce}, 
	{0x9c6a, 0x8febcf}, 
	{0x9c6b, 0x8febd1}, 
	{0x9c6e, 0x8febd3}, 
	{0x9c70, 0x8febd4}, 
	{0x9c72, 0x8febd5}, 
	{0x9c75, 0x8febd6}, 
	{0x9c76, 0xf2e8}, 
	{0x9c77, 0x8febd7}, 
	{0x9c78, 0xf2e9}, 
	{0x9c7b, 0x8febd8}, 
	{0x9ce5, 0xc4bb}, 
	{0x9ce6, 0x8febd9}, 
	{0x9ce7, 0xf2ea}, 
	{0x9ce9, 0xc8b7}, 
	{0x9ceb, 0xf2ef}, 
	{0x9cec, 0xf2eb}, 
	{0x9cf0, 0xf2ec}, 
	{0x9cf2, 0x8febda}, 
	{0x9cf3, 0xcbb1}, 
	{0x9cf4, 0xccc4}, 
	{0x9cf6, 0xc6d0}, 
	{0x9cf7, 0x8febdb}, 
	{0x9cf9, 0x8febdc}, 
	{0x9d02, 0x8febde}, 
	{0x9d03, 0xf2f0}, 
	{0x9d06, 0xf2f1}, 
	{0x9d07, 0xc6be}, 
	{0x9d08, 0xf2ee}, 
	{0x9d09, 0xf2ed}, 
	{0x9d0b, 0x8febdd}, 
	{0x9d0e, 0xb2aa}, 
	{0x9d11, 0x8febdf}, 
	{0x9d12, 0xf2f9}, 
	{0x9d15, 0xf2f8}, 
	{0x9d17, 0x8febe0}, 
	{0x9d18, 0x8febe1}, 
	{0x9d1b, 0xb1f5}, 
	{0x9d1c, 0x8febe2}, 
	{0x9d1d, 0x8febe3}, 
	{0x9d1e, 0x8febe4}, 
	{0x9d1f, 0xf2f6}, 
	{0x9d23, 0xf2f5}, 
	{0x9d26, 0xf2f3}, 
	{0x9d28, 0xb3fb}, 
	{0x9d2a, 0xf2f2}, 
	{0x9d2b, 0xbcb2}, 
	{0x9d2c, 0xb2a9}, 
	{0x9d2f, 0x8febe5}, 
	{0x9d30, 0x8febe6}, 
	{0x9d32, 0x8febe7}, 
	{0x9d33, 0x8febe8}, 
	{0x9d34, 0x8febe9}, 
	{0x9d3a, 0x8febea}, 
	{0x9d3b, 0xb9e3}, 
	{0x9d3c, 0x8febeb}, 
	{0x9d3d, 0x8febed}, 
	{0x9d3e, 0xf2fc}, 
	{0x9d3f, 0xf2fb}, 
	{0x9d41, 0xf2fa}, 
	{0x9d42, 0x8febee}, 
	{0x9d43, 0x8febef}, 
	{0x9d44, 0xf2f7}, 
	{0x9d45, 0x8febec}, 
	{0x9d46, 0xf2fd}, 
	{0x9d47, 0x8febf0}, 
	{0x9d48, 0xf2fe}, 
	{0x9d4a, 0x8febf1}, 
	{0x9d50, 0xf3a5}, 
	{0x9d51, 0xf3a4}, 
	{0x9d53, 0x8febf2}, 
	{0x9d54, 0x8febf3}, 
	{0x9d59, 0xf3a6}, 
	{0x9d5c, 0xb1ad}, 
	{0x9d5d, 0xf3a1}, 
	{0x9d5e, 0xf3a2}, 
	{0x9d5f, 0x8febf4}, 
	{0x9d60, 0xb9f4}, 
	{0x9d61, 0xccb9}, 
	{0x9d62, 0x8febf6}, 
	{0x9d63, 0x8febf5}, 
	{0x9d64, 0xf3a3}, 
	{0x9d65, 0x8febf7}, 
	{0x9d69, 0x8febf8}, 
	{0x9d6a, 0x8febf9}, 
	{0x9d6b, 0x8febfa}, 
	{0x9d6c, 0xcbb2}, 
	{0x9d6f, 0xf3ab}, 
	{0x9d70, 0x8febfb}, 
	{0x9d72, 0xf3a7}, 
	{0x9d76, 0x8febfc}, 
	{0x9d77, 0x8febfd}, 
	{0x9d7a, 0xf3ac}, 
	{0x9d7b, 0x8febfe}, 
	{0x9d7c, 0x8feca1}, 
	{0x9d7e, 0x8feca2}, 
	{0x9d83, 0x8feca3}, 
	{0x9d84, 0x8feca4}, 
	{0x9d86, 0x8feca5}, 
	{0x9d87, 0xf3a9}, 
	{0x9d89, 0xf3a8}, 
	{0x9d8a, 0x8feca6}, 
	{0x9d8d, 0x8feca7}, 
	{0x9d8e, 0x8feca8}, 
	{0x9d8f, 0xb7dc}, 
	{0x9d92, 0x8feca9}, 
	{0x9d93, 0x8fecaa}, 
	{0x9d95, 0x8fecab}, 
	{0x9d96, 0x8fecac}, 
	{0x9d97, 0x8fecad}, 
	{0x9d98, 0x8fecae}, 
	{0x9d9a, 0xf3ad}, 
	{0x9da1, 0x8fecaf}, 
	{0x9da4, 0xf3ae}, 
	{0x9da9, 0xf3af}, 
	{0x9daa, 0x8fecb0}, 
	{0x9dab, 0xf3aa}, 
	{0x9dac, 0x8fecb1}, 
	{0x9dae, 0x8fecb2}, 
	{0x9daf, 0xf2f4}, 
	{0x9db1, 0x8fecb3}, 
	{0x9db2, 0xf3b0}, 
	{0x9db4, 0xc4e1}, 
	{0x9db5, 0x8fecb4}, 
	{0x9db8, 0xf3b4}, 
	{0x9db9, 0x8fecb5}, 
	{0x9dba, 0xf3b5}, 
	{0x9dbb, 0xf3b3}, 
	{0x9dbc, 0x8fecb6}, 
	{0x9dbf, 0x8fecb7}, 
	{0x9dc1, 0xf3b2}, 
	{0x9dc2, 0xf3b8}, 
	{0x9dc3, 0x8fecb8}, 
	{0x9dc4, 0xf3b1}, 
	{0x9dc6, 0xf3b6}, 
	{0x9dc7, 0x8fecb9}, 
	{0x9dc9, 0x8fecba}, 
	{0x9dca, 0x8fecbb}, 
	{0x9dcf, 0xf3b7}, 
	{0x9dd3, 0xf3ba}, 
	{0x9dd4, 0x8fecbc}, 
	{0x9dd5, 0x8fecbd}, 
	{0x9dd6, 0x8fecbe}, 
	{0x9dd7, 0x8fecbf}, 
	{0x9dd9, 0xf3b9}, 
	{0x9dda, 0x8fecc0}, 
	{0x9dde, 0x8fecc1}, 
	{0x9ddf, 0x8fecc2}, 
	{0x9de0, 0x8fecc3}, 
	{0x9de5, 0x8fecc4}, 
	{0x9de6, 0xf3bc}, 
	{0x9de7, 0x8fecc5}, 
	{0x9de9, 0x8fecc6}, 
	{0x9deb, 0x8fecc7}, 
	{0x9ded, 0xf3bd}, 
	{0x9dee, 0x8fecc8}, 
	{0x9def, 0xf3be}, 
	{0x9df0, 0x8fecc9}, 
	{0x9df2, 0xcfc9}, 
	{0x9df3, 0x8fecca}, 
	{0x9df4, 0x8feccb}, 
	{0x9df8, 0xf3bb}, 
	{0x9df9, 0xc2eb}, 
	{0x9dfa, 0xbaed}, 
	{0x9dfd, 0xf3bf}, 
	{0x9dfe, 0x8feccc}, 
	{0x9e02, 0x8fecce}, 
	{0x9e07, 0x8feccf}, 
	{0x9e0a, 0x8feccd}, 
	{0x9e0e, 0x8fecd0}, 
	{0x9e10, 0x8fecd1}, 
	{0x9e11, 0x8fecd2}, 
	{0x9e12, 0x8fecd3}, 
	{0x9e15, 0x8fecd4}, 
	{0x9e16, 0x8fecd5}, 
	{0x9e19, 0x8fecd6}, 
	{0x9e1a, 0xf3c0}, 
	{0x9e1b, 0xf3c1}, 
	{0x9e1c, 0x8fecd7}, 
	{0x9e1d, 0x8fecd8}, 
	{0x9e1e, 0xf3c2}, 
	{0x9e75, 0xf3c3}, 
	{0x9e78, 0xb8b4}, 
	{0x9e79, 0xf3c4}, 
	{0x9e7a, 0x8fecd9}, 
	{0x9e7b, 0x8fecda}, 
	{0x9e7c, 0x8fecdb}, 
	{0x9e7d, 0xf3c5}, 
	{0x9e7f, 0xbcaf}, 
	{0x9e80, 0x8fecdc}, 
	{0x9e81, 0xf3c6}, 
	{0x9e82, 0x8fecdd}, 
	{0x9e83, 0x8fecde}, 
	{0x9e84, 0x8fecdf}, 
	{0x9e85, 0x8fece0}, 
	{0x9e87, 0x8fece1}, 
	{0x9e88, 0xf3c7}, 
	{0x9e8b, 0xf3c8}, 
	{0x9e8c, 0xf3c9}, 
	{0x9e8e, 0x8fece2}, 
	{0x9e8f, 0x8fece3}, 
	{0x9e91, 0xf3cc}, 
	{0x9e92, 0xf3ca}, 
	{0x9e93, 0xcfbc}, 
	{0x9e95, 0xf3cb}, 
	{0x9e96, 0x8fece4}, 
	{0x9e97, 0xceef}, 
	{0x9e98, 0x8fece5}, 
	{0x9e9b, 0x8fece6}, 
	{0x9e9d, 0xf3cd}, 
	{0x9e9e, 0x8fece7}, 
	{0x9e9f, 0xcedb}, 
	{0x9ea4, 0x8fece8}, 
	{0x9ea5, 0xf3ce}, 
	{0x9ea6, 0xc7fe}, 
	{0x9ea8, 0x8fece9}, 
	{0x9ea9, 0xf3cf}, 
	{0x9eaa, 0xf3d1}, 
	{0x9eac, 0x8fecea}, 
	{0x9ead, 0xf3d2}, 
	{0x9eae, 0x8feceb}, 
	{0x9eaf, 0x8fecec}, 
	{0x9eb0, 0x8feced}, 
	{0x9eb3, 0x8fecee}, 
	{0x9eb4, 0x8fecef}, 
	{0x9eb5, 0x8fecf0}, 
	{0x9eb8, 0xf3d0}, 
	{0x9eb9, 0xb9ed}, 
	{0x9eba, 0xcccd}, 
	{0x9ebb, 0xcbe3}, 
	{0x9ebc, 0xd6f7}, 
	{0x9ebe, 0xdde0}, 
	{0x9ebf, 0xcbfb}, 
	{0x9ec4, 0xb2ab}, 
	{0x9ec6, 0x8fecf1}, 
	{0x9ec8, 0x8fecf2}, 
	{0x9ecb, 0x8fecf3}, 
	{0x9ecc, 0xf3d4}, 
	{0x9ecd, 0xb5d0}, 
	{0x9ece, 0xf3d5}, 
	{0x9ecf, 0xf3d6}, 
	{0x9ed0, 0xf3d7}, 
	{0x9ed2, 0xb9f5}, 
	{0x9ed4, 0xf3d8}, 
	{0x9ed5, 0x8fecf4}, 
	{0x9ed8, 0xe0d4}, 
	{0x9ed9, 0xccdb}, 
	{0x9edb, 0xc2e3}, 
	{0x9edc, 0xf3d9}, 
	{0x9edd, 0xf3db}, 
	{0x9ede, 0xf3da}, 
	{0x9edf, 0x8fecf5}, 
	{0x9ee0, 0xf3dc}, 
	{0x9ee4, 0x8fecf6}, 
	{0x9ee5, 0xf3dd}, 
	{0x9ee7, 0x8fecf7}, 
	{0x9ee8, 0xf3de}, 
	{0x9eec, 0x8fecf8}, 
	{0x9eed, 0x8fecf9}, 
	{0x9eee, 0x8fecfa}, 
	{0x9eef, 0xf3df}, 
	{0x9ef0, 0x8fecfb}, 
	{0x9ef1, 0x8fecfc}, 
	{0x9ef2, 0x8fecfd}, 
	{0x9ef4, 0xf3e0}, 
	{0x9ef5, 0x8fecfe}, 
	{0x9ef6, 0xf3e1}, 
	{0x9ef7, 0xf3e2}, 
	{0x9ef8, 0x8feda1}, 
	{0x9ef9, 0xf3e3}, 
	{0x9efb, 0xf3e4}, 
	{0x9efc, 0xf3e5}, 
	{0x9efd, 0xf3e6}, 
	{0x9eff, 0x8feda2}, 
	{0x9f02, 0x8feda3}, 
	{0x9f03, 0x8feda4}, 
	{0x9f07, 0xf3e7}, 
	{0x9f08, 0xf3e8}, 
	{0x9f09, 0x8feda5}, 
	{0x9f0e, 0xc5a4}, 
	{0x9f0f, 0x8feda6}, 
	{0x9f10, 0x8feda7}, 
	{0x9f11, 0x8feda8}, 
	{0x9f12, 0x8feda9}, 
	{0x9f13, 0xb8dd}, 
	{0x9f14, 0x8fedaa}, 
	{0x9f15, 0xf3ea}, 
	{0x9f16, 0x8fedab}, 
	{0x9f17, 0x8fedac}, 
	{0x9f19, 0x8fedad}, 
	{0x9f1a, 0x8fedae}, 
	{0x9f1b, 0x8fedaf}, 
	{0x9f1f, 0x8fedb0}, 
	{0x9f20, 0xc1cd}, 
	{0x9f21, 0xf3eb}, 
	{0x9f22, 0x8fedb1}, 
	{0x9f26, 0x8fedb2}, 
	{0x9f2a, 0x8fedb3}, 
	{0x9f2b, 0x8fedb4}, 
	{0x9f2c, 0xf3ec}, 
	{0x9f2f, 0x8fedb5}, 
	{0x9f31, 0x8fedb6}, 
	{0x9f32, 0x8fedb7}, 
	{0x9f34, 0x8fedb8}, 
	{0x9f37, 0x8fedb9}, 
	{0x9f39, 0x8fedba}, 
	{0x9f3a, 0x8fedbb}, 
	{0x9f3b, 0xc9a1}, 
	{0x9f3c, 0x8fedbc}, 
	{0x9f3d, 0x8fedbd}, 
	{0x9f3e, 0xf3ed}, 
	{0x9f3f, 0x8fedbe}, 
	{0x9f41, 0x8fedbf}, 
	{0x9f43, 0x8fedc0}, 
	{0x9f44, 0x8fedc1}, 
	{0x9f45, 0x8fedc2}, 
	{0x9f46, 0x8fedc3}, 
	{0x9f47, 0x8fedc4}, 
	{0x9f4a, 0xf3ee}, 
	{0x9f4b, 0xe3b7}, 
	{0x9f4e, 0xecda}, 
	{0x9f4f, 0xf0ed}, 
	{0x9f52, 0xf3ef}, 
	{0x9f53, 0x8fedc5}, 
	{0x9f54, 0xf3f0}, 
	{0x9f55, 0x8fedc6}, 
	{0x9f56, 0x8fedc7}, 
	{0x9f57, 0x8fedc8}, 
	{0x9f58, 0x8fedc9}, 
	{0x9f5a, 0x8fedca}, 
	{0x9f5d, 0x8fedcb}, 
	{0x9f5e, 0x8fedcc}, 
	{0x9f5f, 0xf3f2}, 
	{0x9f60, 0xf3f3}, 
	{0x9f61, 0xf3f4}, 
	{0x9f62, 0xcef0}, 
	{0x9f63, 0xf3f1}, 
	{0x9f66, 0xf3f5}, 
	{0x9f67, 0xf3f6}, 
	{0x9f68, 0x8fedcd}, 
	{0x9f69, 0x8fedce}, 
	{0x9f6a, 0xf3f8}, 
	{0x9f6c, 0xf3f7}, 
	{0x9f6d, 0x8fedcf}, 
	{0x9f6e, 0x8fedd0}, 
	{0x9f6f, 0x8fedd1}, 
	{0x9f70, 0x8fedd2}, 
	{0x9f71, 0x8fedd3}, 
	{0x9f72, 0xf3fa}, 
	{0x9f73, 0x8fedd4}, 
	{0x9f75, 0x8fedd5}, 
	{0x9f76, 0xf3fb}, 
	{0x9f77, 0xf3f9}, 
	{0x9f7a, 0x8fedd6}, 
	{0x9f7d, 0x8fedd7}, 
	{0x9f8d, 0xceb6}, 
	{0x9f8f, 0x8fedd8}, 
	{0x9f90, 0x8fedd9}, 
	{0x9f91, 0x8fedda}, 
	{0x9f92, 0x8feddb}, 
	{0x9f94, 0x8feddc}, 
	{0x9f95, 0xf3fc}, 
	{0x9f96, 0x8feddd}, 
	{0x9f97, 0x8fedde}, 
	{0x9f9c, 0xf3fd}, 
	{0x9f9d, 0xe3d4}, 
	{0x9f9e, 0x8feddf}, 
	{0x9fa0, 0xf3fe}, 
	{0x9fa1, 0x8fede0}, 
	{0x9fa2, 0x8fede1}, 
	{0x9fa3, 0x8fede2}, 
	{0x9fa5, 0x8fede3}, 
	{0xff01, 0xa1aa}, 
	{0xff03, 0xa1f4}, 
	{0xff04, 0xa1f0}, 
	{0xff05, 0xa1f3}, 
	{0xff06, 0xa1f5}, 
	{0xff08, 0xa1ca}, 
	{0xff09, 0xa1cb}, 
	{0xff0a, 0xa1f6}, 
	{0xff0b, 0xa1dc}, 
	{0xff0c, 0xa1a4}, 
	{0xff0e, 0xa1a5}, 
	{0xff0f, 0xa1bf}, 
	{0xff10, 0xa3b0}, 
	{0xff11, 0xa3b1}, 
	{0xff12, 0xa3b2}, 
	{0xff13, 0xa3b3}, 
	{0xff14, 0xa3b4}, 
	{0xff15, 0xa3b5}, 
	{0xff16, 0xa3b6}, 
	{0xff17, 0xa3b7}, 
	{0xff18, 0xa3b8}, 
	{0xff19, 0xa3b9}, 
	{0xff1a, 0xa1a7}, 
	{0xff1b, 0xa1a8}, 
	{0xff1c, 0xa1e3}, 
	{0xff1d, 0xa1e1}, 
	{0xff1e, 0xa1e4}, 
	{0xff1f, 0xa1a9}, 
	{0xff20, 0xa1f7}, 
	{0xff21, 0xa3c1}, 
	{0xff22, 0xa3c2}, 
	{0xff23, 0xa3c3}, 
	{0xff24, 0xa3c4}, 
	{0xff25, 0xa3c5}, 
	{0xff26, 0xa3c6}, 
	{0xff27, 0xa3c7}, 
	{0xff28, 0xa3c8}, 
	{0xff29, 0xa3c9}, 
	{0xff2a, 0xa3ca}, 
	{0xff2b, 0xa3cb}, 
	{0xff2c, 0xa3cc}, 
	{0xff2d, 0xa3cd}, 
	{0xff2e, 0xa3ce}, 
	{0xff2f, 0xa3cf}, 
	{0xff30, 0xa3d0}, 
	{0xff31, 0xa3d1}, 
	{0xff32, 0xa3d2}, 
	{0xff33, 0xa3d3}, 
	{0xff34, 0xa3d4}, 
	{0xff35, 0xa3d5}, 
	{0xff36, 0xa3d6}, 
	{0xff37, 0xa3d7}, 
	{0xff38, 0xa3d8}, 
	{0xff39, 0xa3d9}, 
	{0xff3a, 0xa3da}, 
	{0xff3b, 0xa1ce}, 
	{0xff3c, 0xa1c0}, /*  */
	{0xff3d, 0xa1cf}, 
	{0xff3e, 0xa1b0}, 
	{0xff3f, 0xa1b2}, 
	{0xff40, 0xa1ae}, 
	{0xff41, 0xa3e1}, 
	{0xff42, 0xa3e2}, 
	{0xff43, 0xa3e3}, 
	{0xff44, 0xa3e4}, 
	{0xff45, 0xa3e5}, 
	{0xff46, 0xa3e6}, 
	{0xff47, 0xa3e7}, 
	{0xff48, 0xa3e8}, 
	{0xff49, 0xa3e9}, 
	{0xff4a, 0xa3ea}, 
	{0xff4b, 0xa3eb}, 
	{0xff4c, 0xa3ec}, 
	{0xff4d, 0xa3ed}, 
	{0xff4e, 0xa3ee}, 
	{0xff4f, 0xa3ef}, 
	{0xff50, 0xa3f0}, 
	{0xff51, 0xa3f1}, 
	{0xff52, 0xa3f2}, 
	{0xff53, 0xa3f3}, 
	{0xff54, 0xa3f4}, 
	{0xff55, 0xa3f5}, 
	{0xff56, 0xa3f6}, 
	{0xff57, 0xa3f7}, 
	{0xff58, 0xa3f8}, 
	{0xff59, 0xa3f9}, 
	{0xff5a, 0xa3fa}, 
	{0xff5b, 0xa1d0}, 
	{0xff5c, 0xa1c3}, 
	{0xff5d, 0xa1d1}, 
	{0xff61, 0x8ea1}, 
	{0xff62, 0x8ea2}, 
	{0xff63, 0x8ea3}, 
	{0xff64, 0x8ea4}, 
	{0xff65, 0x8ea5}, 
	{0xff66, 0x8ea6}, 
	{0xff67, 0x8ea7}, 
	{0xff68, 0x8ea8}, 
	{0xff69, 0x8ea9}, 
	{0xff6a, 0x8eaa}, 
	{0xff6b, 0x8eab}, 
	{0xff6c, 0x8eac}, 
	{0xff6d, 0x8ead}, 
	{0xff6e, 0x8eae}, 
	{0xff6f, 0x8eaf}, 
	{0xff70, 0x8eb0}, 
	{0xff71, 0x8eb1}, 
	{0xff72, 0x8eb2}, 
	{0xff73, 0x8eb3}, 
	{0xff74, 0x8eb4}, 
	{0xff75, 0x8eb5}, 
	{0xff76, 0x8eb6}, 
	{0xff77, 0x8eb7}, 
	{0xff78, 0x8eb8}, 
	{0xff79, 0x8eb9}, 
	{0xff7a, 0x8eba}, 
	{0xff7b, 0x8ebb}, 
	{0xff7c, 0x8ebc}, 
	{0xff7d, 0x8ebd}, 
	{0xff7e, 0x8ebe}, 
	{0xff7f, 0x8ebf}, 
	{0xff80, 0x8ec0}, 
	{0xff81, 0x8ec1}, 
	{0xff82, 0x8ec2}, 
	{0xff83, 0x8ec3}, 
	{0xff84, 0x8ec4}, 
	{0xff85, 0x8ec5}, 
	{0xff86, 0x8ec6}, 
	{0xff87, 0x8ec7}, 
	{0xff88, 0x8ec8}, 
	{0xff89, 0x8ec9}, 
	{0xff8a, 0x8eca}, 
	{0xff8b, 0x8ecb}, 
	{0xff8c, 0x8ecc}, 
	{0xff8d, 0x8ecd}, 
	{0xff8e, 0x8ece}, 
	{0xff8f, 0x8ecf}, 
	{0xff90, 0x8ed0}, 
	{0xff91, 0x8ed1}, 
	{0xff92, 0x8ed2}, 
	{0xff93, 0x8ed3}, 
	{0xff94, 0x8ed4}, 
	{0xff95, 0x8ed5}, 
	{0xff96, 0x8ed6}, 
	{0xff97, 0x8ed7}, 
	{0xff98, 0x8ed8}, 
	{0xff99, 0x8ed9}, 
	{0xff9a, 0x8eda}, 
	{0xff9b, 0x8edb}, 
	{0xff9c, 0x8edc}, 
	{0xff9d, 0x8edd}, 
	{0xff9e, 0x8ede}, 
	{0xff9f, 0x8edf}, 
	{0xffe3, 0xa1b1}, 
	{0xffe5, 0xa1ef}, 

};
