#!/usr/bin/perl -w
# 
# sb::Plugin::sbTextFormat - Module for sb
# == written by T.Otani <ootani@segausers.gr.jp> ===
# == Copyright (C) 2004 SimpleBoxes/SerendipityNZ ==

# ˡΥ롼˴ؤƤϡΡsbtext ˡˤĤơפ

# ץ饰 the Perl Artistic License ˴Ťۤޤ
#  : http://www.perl.com/pub/a/language/misc/Artistic.html

# 0.10 [2006/08/03] changed detail to point new site address
# 0.11 [2007/04/12] changed get_footnote to fix a bug

package sb::Plugin::sbTextFormat;
# ==================================================
# // initialization for plugin
# ==================================================
use sb::Plugin ();
sb::Plugin->register_plugin(
	'lang' => {
		'ja' => 'euc',
		'en' => 'ascii',
	},
	'text' => {
		'type'    => 'text format, cms',
		'name'    => 'sbtext',
		'text'    => 'sbtext',
		'author'  => 'takkyun',
		'detail'  => 'http://serenebach.net/',
		'version' => '0.11',
	},
	'file' => 'sbtext_format.txt',
	'data' => undef,
);
# ƥȥեޥåȥץ饰ȤϿ
sb::Plugin->register_text_filter(
	'name'     => 'sbtext',
	'callback' => \&sb::TextFormat::sbtext::format,
);
# cmsѥץ饰ȤϿ
sb::Plugin->register_content_module(
	'type'     => 'entry',
	'callback' => \&sb::TextFormat::sbtext::content,
	'field'    => 'body_text',
);
package sb::TextFormat::sbtext;
use sb::Config ();
# ==================================================
# // declaration for constant value
# ==================================================
sub LINK_TARGET     (){ ' target="_blank"' };                               # 󥯥å
sub HEADING_MARK    (){ '&#9632;' };                                        # Фѥޡ
sub HEADING_PREFIX  (){ 'eid' };                                            # Ф id
sub LOWEST_HEADING  (){ 2 };                                                # ǾξФإåǥ
sub MAX_BLOCK_LEVEL (){ 3 };                                                # ѥͥȥ٥
sub FOOTNOTE_PREFIX (){ 'note' };                                           #  id
sub NOTE_BEGIN_TAG  (){ '<sup>' };                                          # ʸε(ϥ)
sub NOTE_END_TAG    (){ '</sup>' };                                         # ʸε(λ)
sub LINK_HATENA     (){ 'http://d.hatena.ne.jp/keyword/' };                 # ϤƤʥɥ
sub LINK_GOOGLE     (){ 'http://www.google.com/search?lr=lang_ja&amp;q=' }; # Google 
sub LINK_AMAZON     (){ 'http://www.amazon.co.jp/exec/obidos/ASIN/' };      # ޥʥ
# ==================================================
# // declaration for class member
# ==================================================
my @mFootNote = ();
my $mEntryId  = 0;
my $mAwsId    = '';
# ==================================================
# // functions for content
# ==================================================
sub content { # ʸ³
	my $cms   = shift;
	my $entry = shift;
	my %var   = @_;
	if ($entry->form eq 'sbtext') { # sbtext format
		my ($body,$more);
		@mFootNote = ();
		$mEntryId  = $entry->id;
		$mAwsId    = &_check_awsid($entry->auth) if ($mAwsId eq '');
		if ($entry->body ne '') { # ʸ
			$body = $entry->formated_body;
			$body .= '<a id="sequel"></a>' if ($entry->more ne '' and $var{'mode'} eq 'ent');
		}
		if ($entry->more ne '') { # ³
			my $permalink = &sb::Content::Entry::_permalink($entry,$var{'cat'},'more',$var{'mode'});
			$more = ($var{'mode'} eq 'ent') 
			      ? $entry->formated_more 
			      : '<a href="' . $permalink . '">' . $var{'lang'}->string('parts_sequel') . '</a>';
		}
		my $footnote = &get_footnote($entry->id,\$body,\$more);
		if ($var{'mode'} ne 'ent' and $more eq '') {
			$body .= $footnote;
		} else {
			$more .= $footnote;
		}
		$cms->tag('entry_description'=>$body) if ($body ne '');
		$cms->tag('entry_sequel'=>$more) if ($more ne '');
		$cms->tag('entry_excerpt'=>$entry->sum);
	} else { # other format
		&sb::Content::Entry::_body_text($cms,$entry,%var);
	}
}
sub get_footnote($$$)
{
	my ($id,$body,$more) = @_;
	my $footnote = '';
	if (@mFootNote)
	{ # 
		$footnote .= '<ul class="footnote">';
		my $bgn = NOTE_BEGIN_TAG;
		my $end = NOTE_END_TAG;
		my $symbol = FOOTNOTE_PREFIX . $id . '-';
		my $note_in_body = $$body =~ s!<sbnote />!<sbnote />!g;
		for (my $i=0;$i<@mFootNote;$i++) {
			my $text = &_inline($mFootNote[$i]);
			my $num = $i + 1;
			my $note = $symbol . $i;
			my $mark = $symbol . $i . '-body';
			if ($i < $note_in_body) {
				$$body =~ s!<sbnote />!$bgn<a href="#$note" id="$mark" title="$text">\*$num</a>$end!;
			} else {
				$$more =~ s!<sbnote />!$bgn<a href="#$note" id="$mark" title="$text">\*$num</a>$end!;
			}
			$footnote .= "\n<li id=\"$note\"><a href=\"#$mark\">*$num</a> : $text</li>";
		}
		$footnote .= "\n</ul>";
	}
	return $footnote;
}
# ==================================================
# // private functions - other utilities
# ==================================================
sub _check_awsid { # ޥ󥢥 ID ɤ߹
	my $id = shift;
	my $user = sb::Data->load('User','id'=>$id);
	return ($user and $user->aws ne '') ? $user->aws : 'simpleboxes-22';
}
# ==================================================
# // functions for text format
# ==================================================
sub format { # ƥȥեޥåȥᥤ
	my $text = shift; # ϥѥ᡼
	@mFootNote = (); # reset buffer
	$text = sb::Text->entitize($text);
	$text = &_shelter_letters($text);
	$text = &_shelter_footnote($text);
	$text = &_hatena_block($text);
	$text = &_blocks($text);
	$text = &_return_letters($text);
	$text = &_finishing($text);
	return($text);
}
# ==================================================
# // private functions - text utilities
# ==================================================
sub _finishing { # λ
	my $text = shift;
	$text =~ s!<p(.*?)>\n!<p$1>!g;
	$text =~ s!<pre>\n!<pre>!g;
	$text =~ s!\n</pre>!</pre>!g;
	$text =~ s!<p></p>\n!!g;
	$text =~ s!<br />\n</p>!</p>!g;
	return($text);
}
sub _shelter_letters { # üʸ
	my $text = shift;
	$text =~ s/\\\\/&sb_;/g;
	$text =~ s/\\\^/&sba;/g;
	$text =~ s/\\\*/&sbb;/g;
	$text =~ s/\\\&lt;/&sbc;/g;
	$text =~ s/\\\'/&sbd;/g; # escape '
	$text =~ s/\\\(/&sbe;/g;
	$text =~ s/\\\[/&sbf;/g;
	$text =~ s/\\\|/&sbg;/g;
	$text =~ s/\\\-/&sbh;/g;
	$text =~ s/\\\+/&sbi;/g;
	$text =~ s/\\\:/&sbj;/g;
	$text =~ s/\\\#/&sbk;/g;
	$text =~ s/\\\)/&sbl;/g;
	$text =~ s/\\\]/&sbm;/g;
	$text =~ s/\\\&amp;/&sbn;/g;
	return($text);
}
sub _return_letters { # üʸ
	my $text = shift;
	$text =~ s/\&sbn;/\&amp;/g;
	$text =~ s/\&sbm;/\]/g;
	$text =~ s/\&sbl;/\)/g;
	$text =~ s/\&sbk;/\#/g;
	$text =~ s/\&sbj;/\:/g;
	$text =~ s/\&sbi;/\+/g;
	$text =~ s/\&sbh;/\-/g;
	$text =~ s/\&sbg;/\|/g;
	$text =~ s/\&sbf;/\[/g;
	$text =~ s/\&sbe;/\(/g;
	$text =~ s/\&sbd;/\'/g; # unescape '
	$text =~ s/\&sbc;/\&lt;/g;
	$text =~ s/\&sbb;/\*/g;
	$text =~ s/\&sba;/\^/g;
	$text =~ s/\&sb_;/\\/g;
	return($text);
}
sub _shelter_footnote { # ΥХåե
	my $text = shift;
	push(@mFootNote,$1) while ( $text =~ s/\(\((.*?)\)\)/<sbnote \/>/ );
	return($text);
}
sub _hatena_block { # ϤƤ֥åν
	my $text = shift;
	my @result = ();
	my $quote = -1;
	my $pre   = -1;
	$quote = 0 if ($text =~ /&gt;&gt;.*\n&lt;&lt;/s);
	$pre   = 0 if ($text =~ /&gt;\|\|\n.*\n\|\|&lt;/s);
	return($text) if ($quote == -1 and $pre == -1);
	my @buf = split("\n",$text);
	foreach my $line (@buf) {
		if ($line =~ /^&lt;&lt;$/) {
			$quote--;
			$quote = 0 if ($quote < 0);
			next;
		} elsif ($line =~ /^\|\|&lt;$/) {
			$pre = 0;
			next;
		}
		if ($quote >= 0 and $line =~ /^&gt;&gt;(.*)$/) {
			my $check = $1;
			if ($check =~ /^=/ or $check eq '') {
				$quote++;
				$quote = MAX_BLOCK_LEVEL if ($quote > MAX_BLOCK_LEVEL);
				$line = $check;
				next if ($line eq '');
			}
		} elsif ($pre >= 0 and $line =~ /^&gt;\|\|$/) {
			$pre = 1;
			next;
		}
		my $mark = ($quote > 0) ? '&gt;' x $quote : ($pre > 0) ? ' ' : '';
		push(@result,$mark . $line);
	}
	return join("\n",@result);
}
sub _blocks { # ֥å
	# from YukiWiki http://www.hyuki.com/yukiwiki/
	# Copyright (C) 2000-2004 Hiroshi Yuki <hyuki@hyuki.com>
	my $text = shift;
	my (@result,@saved);
	my $heading = 0;
	my $quote_flag = 0;
	my @buf = split("\n",$text);
	unshift(@saved, '</p>');
	push(@result, '<p>');
	foreach (@buf) {
		if (/^(\*{1,3})(.+)/) { # Ф
			my $number = (length($1) + LOWEST_HEADING - 1);
			$number = 6 if ($number > 6);
			my $hn = 'h' . $number;
			my $id = HEADING_PREFIX . $mEntryId . '-' . $heading;
			my $mark = HEADING_MARK;
			$mark = '<a href="#' . $id . '">' . $mark . '</a>' if ($mark ne '');
			push(@result, splice(@saved), qq(<$hn id="$id">$mark) . &_inline($2) . qq(</$hn>));
			$heading++;
		} elsif (/^----/) { # ʿ
			push(@result, splice(@saved), '<hr />');
		} elsif (/^#(.+)/ or /^\/\/(.+)/) { # ʸ
			&_back_push(
				'tag'       => 'p',
				'level'     => 1,
				'saved'     => \@saved,
				'result'    => \@result,
				'attribute' => ' class="note"',
			);
			push(@result, &_inline($_) . '<br />');
		} elsif (/^(-{1,3})(.+)/) { # վꥹ
			&_back_push(
				'tag'       => 'ul',
				'level'     => length($1),
				'saved'     => \@saved,
				'result'    => \@result,
				'attribute' => '',
			);
			push(@result, '<li>' . &_inline($2) . '</li>');
		} elsif (/^(\+{1,3})(.+)/) { # ꥹ
			&_back_push(
				'tag'       => 'ol',
				'level'     => length($1),
				'saved'     => \@saved,
				'result'    => \@result,
				'attribute' => '',
			);
			push(@result, '<li>' . &_inline($2) . '</li>');
		} elsif (/^:([^:]+):(.+)/) { # ꥹ
			&_back_push(
				'tag'       => 'dl',
				'level'     => 1,
				'saved'     => \@saved,
				'result'    => \@result,
				'attribute' => '',
			);
			push(@result, '<dt>' . &_inline($1) . '</dt>', '<dd>' . &_inline($2) . '</dd>');
		} elsif (/^((&gt;){1,3})(.*)/) { # ѥ֥å
			my $attribute = '';
			my $level = length($1) / 4;
			my $quote = $3;
			if ($quote =~ /^=(.*?):(s?https?:\/\/[-_.!~*\'()a-zA-Z0-9;\/?:\@&=+\$,%#]+)?/) { # '
				$attribute .= ' title="' . $1 . '"' if ($1 ne '');
				$attribute .= ' cite="' . $2 . '"' if ($2 ne '');
			}
			&_back_push(
				'tag'       => 'blockquote',
				'level'     => $level,
				'saved'     => \@saved,
				'result'    => \@result,
				'attribute' => $attribute,
			);
			next if ($attribute ne '');
			push(@result, '<p>' . &_inline($quote) . '</p>'); # [0.09] changed
			# push(@result, ($quote ne '') ? &_inline($quote) . '<br />' : '</p><p>');
		} elsif (/^$/) { # (ѥ饰դνλ)
			push(@result, splice(@saved));
			unshift(@saved, '</p>');
			push(@result, '<p>');
		} elsif (/^(\s)(.*)$/) { # Ѥߥƥ
			&_back_push(
				'tag'       => 'pre',
				'level'     => 1,
				'saved'     => \@saved,
				'result'    => \@result,
				'attribute' => '',
			);
			push(@result, $2);
		} elsif (/^\|(.*?)$/) { # ɽȤ
			my $tmp = $1;
			&_back_push(
				'tag'       => 'table',
				'level'     => 1,
				'saved'     => \@saved,
				'result'    => \@result,
				'attribute' => '',
			);
			my @elems = ($tmp =~ /(.*?)\|/g);
			my $value = '';
			foreach my $elem (@elems) {
				if ($elem =~ /^\*(.*)/) {
					$value .= '<th>' . $1 . '</th>'
				} else {
					$value .= '<td>' . $elem . '</td>';
				}
			}
			push(@result, '<tr>' . $value . '</tr>');
		} else { # ̾
			push(@result, &_inline($_) . '<br />');
		}
	}
	push(@result, splice(@saved));
	return join("\n",@result);
}
sub _back_push { # ֥å
	# from YukiWiki http://www.hyuki.com/yukiwiki/
	# Copyright (C) 2000-2004 Hiroshi Yuki <hyuki@hyuki.com>
	my %param = (
		'tag'       => undef,
		'level'     => undef,
		'saved'     => undef,
		'result'    => undef,
		'attribute' => undef,
		@_
	);
	my $bgn_tag = '<' . $param{'tag'} . $param{'attribute'} . '>';
	my $end_tag = '</' . $param{'tag'} . '>';
	if ($param{'tag'} ne 'blockquote' and $param{'attribute'} ne '') {
		$param{'attribute'} =~ s/\-/_/g;
		$end_tag .= '<!--' . $param{'attribute'} . '-->';
	}
	while (@{$param{'saved'}} > $param{'level'}) {
		push(@{$param{'result'}}, shift(@{$param{'saved'}}));
	}
	if ($param{'saved'}->[0] ne $end_tag) {
		push(@{$param{'result'}}, splice(@{$param{'saved'}}));
	}
	while (@{$param{'saved'}} < $param{'level'}) {
		unshift(@{$param{'saved'}}, $end_tag);
		push(@{$param{'result'}}, $bgn_tag);
	}
}
sub _inline { # 饤
	my $text = shift; # ϥѥ᡼
	$text =~ s/''(.*?)''/<strong>$1<\/strong>/g;     # Ĵ (Wikiɽ)
	$text =~ s/\*\*(.*?)\*\*/<strong>$1<\/strong>/g; # Ĵ
	$text =~ s/\*(.*?)\*/<em>$1<\/em>/g;             # 夤Ĵ
	my $srvbase = sb::Config->get->value('conf_srv_base');
	my $srv_cgi = sb::Config->get->value('conf_srv_cgi');
	while ($text =~ /\^(.*?)\((.*?)\)/) { # Ӥȥ
		my $check = $2;
		if ($check =~ /(s?https?:\/\/[-_.!~*\'()a-zA-Z0-9;\/?:\@&=+\$,%#]+)/) { # '
			my $target = (index($check,$srvbase) > -1 or index($check,$srv_cgi) > -1) ? '' : LINK_TARGET;
			$text =~ s/\^(.*?)\((.*?)\)/<a href=\"$2\"$target>$1<\/a>/;
		} elsif ($check =~ /mailto:([\w=+\$%*-]+\@[^\s()\[\]{}!\"\'<>:,\x7f-\xff]+\.\w+)/) {
			$text =~ s/\^(.*?)\((.*?)\)/<a href=\"$2\">$1<\/a>/;
		} else {
			$text =~ s/\^(.*?)\((.*?)\)/<ruby><rb>$1<\/rb><rp>\(<\/rp><rt>$2<\/rt><rp>\)<\/rp><\/ruby>/;
		}
	}
	while ($text =~ /\[(.*?):(.*?)\]/) { # hatena, google, link
		my ($name,$check) = ($1,$2);
		if ($name ne '' and $check =~ /(s?https?:\/\/[-_.!~*\'()a-zA-Z0-9;\/?:\@&=+\$,%#]+)/) {  # '
			my $target = (index($check,$srvbase) > -1 or index($check,$srv_cgi) > -1) ? '' : LINK_TARGET;
			$text =~ s!\[(.*?):(.*?)\]!<a href="$2"$target>$name</a>!;
		} else {
			my $target = LINK_TARGET;
			my $amazon = LINK_AMAZON;
			my $hatena = LINK_HATENA;
			my $google = LINK_GOOGLE;
			if ($name =~ /ASIN/i and $check =~ /^\w+$/) { # Amazon
				$check = $amazon . $check . '/' . $self->{'amazon_id'};
				$text =~ s/\[(ASIN):(.*?)\]/<a href="$check"$target>$1:$2<\/a>/i;
			} elsif ($name =~ /keyword/i) { # keyword for Hatena
				$check = sb::Language->get->convert($check,'euc') if (sb::Language->get->charcode ne 'euc');
				$check =~ s/(\W)/'%' . unpack('H2', $1)/eg;
				$text =~ s/\[(.*?):(.*?)\]/<a href=\"$hatena$check\"$target>$2<\/a>/;
			} elsif ($name eq '' or $name =~ /google/i) { # word for Google
				$check = sb::Language->get->convert($check,'utf8') if (sb::Language->get->charcode ne 'utf8');
				$check =~ s/(\W)/'%' . unpack('H2', $1)/eg;
				$text =~ s/\[(.*?):(.*?)\]/<a href=\"$google$check\"$target>$2<\/a>/;
			} else { # escape blackets
				$text =~ s/\[(.*?):(.*?)\]/&sbf;$1\:$2\]/;
			}
		}
	}
	foreach my $tag ('img','hr','br') { # ñ
		while ($text =~ /\&lt;$tag (.*?)\&gt;/i) {
			my $attr = sb::Text->detitize($1);
			$text =~ s/\&lt;$tag (.*?)\&gt;/<$tag $attr>/i;
		}
	}
	foreach my $tag ('a','q','strong','em','abbr','code','p','div','del','ins') {
		while ($text =~ /\&lt;$tag(.*?)\&gt;(.+?)\&lt;\/$tag\&gt;/i) {
			my $attr = sb::Text->detitize($1);
			my $elem = $2;
			$text =~ s/\&lt;$tag(.*?)\&gt;(.+?)\&lt;\/$tag\&gt;/<$tag$attr>$elem<\/$tag>/i;
		}
	}
	if ($text =~ /(s?https?:\/\/[-_.!~*\'()a-zA-Z0-9;\/?:\@&=+\$,%#]+)/ and 
	    $text !~ /\"(s?https?:\/\/[-_.!~*\'()a-zA-Z0-9;\/?:\@&=+\$,%#]+)\"/) { # ʸ uri => http
		my $target = (index($1,$srvbase) > -1 or index($1,$srv_cgi) > -1) ? '' : LINK_TARGET;
		$text =~ s/(s?https?:\/\/[-_.!~*\'()a-zA-Z0-9;\/?:\@&=+\$,%#]+)/<a href=\"$1\"$target>$1<\/a>/g;
	}
	if ($text =~ /mailto:([\w=+\$%*-]+\@[^\s()\[\]{}!\"\'<>:,\x7f-\xff]+\.\w+)/ and 
	    $text !~ /\"mailto:([\w=+\$%*-]+\@[^\s()\[\]{}!\"\'<>:,\x7f-\xff]+\.\w+)\"/) { # ʸ uri => mailto
		$text =~ s/mailto:([\w=+\$%*-]+\@[^\s()\[\]{}!\"\'<>:,\x7f-\xff]+\.\w+)/<a href="mailto:$1">mailto:$1<\/a>/g;
	}
	return($text);
}
1;
__END__

==== sbtext ˡˤĤ ============================================
* ֥å
** Ф
*ס**ס***פǻϤޤԤ򸫽ФȤưޤ

ɸǤϡ* => h2ס** => h3ס*** => h4פȰ졢Фѥޡ
Ȥơ֢פѤޤ

** ѥ֥å
>פǻϤޤԤѥ֥åȤưޤ

ޤǽΰѹԤ
 >=title:http://serenebach.net/
Τ褦ˤȡѥ֥å cite °title °򵭽ҤǤޤ

>>פȡ<<פǰϤޤ줿ʸϤѥ֥åȤưޤ

>פƱ͡
 >>=title:http://serenebach.net/
Τ褦ˤȡѥ֥å cite °title °򵭽ҤǤޤ

ѥ֥å3ʤޤǥͥȲǽǤ>>פ2ʡ>>>פ3ʤΰѥ
åȤưޤ

** ʸ
#פʤ//פǻϤޤԤʸȤưޤ(ʸȤǤϤ
ޤΤǡ<p class="note"> Ȥƥޡåפޤ)

** Ѥߥƥ
ڡ(֤ʤȾѥڡ)ǻϤޤԤѤߥƥȤȤư
ޤ

>||פȡ||<פǰϤޤ줿ʸϤѤߥƥȤȤưޤ

** վꥹ
-פǻϤޤԤֹʤꥹ(վꥹ)Ȥưޤ

--ס---פΤ褦˥ϥեο䤹ȡ¿ʥꥹȤɽǤޤ

** ꥹ
+פǻϤޤԤֹդꥹ(ꥹ)Ȥưޤ

++ס+++פΤ褦˥ץ饹ο䤹ȡ¿ʥꥹȤɽǤޤ

** ꥹ
:Ѹ:ʸפΤ褦˵ҤȡιԤꥹȤȤưޤ

** ɽȤ
|פǻϤޤԤɽȤߤȤưޤ

 |*Ф1|*Ф2|
 |1|2|

|*פȵҤ줿ܤϸФȤưޤ

** ʿ
----פǻϤޤԤˤϿʿ(<hr />)ޤ

** Ǥʸ
嵭ʳǤʸ p ǤȤưޤ

Ū˲ԤϤΤޤ޲ԤȤơޤΤǡ֥åʬ
϶Ԥ褦ˤƤ

----

* 饤
** Ĵ
*פǰϤޤ줿ʬĴȤưޤ

**פǰϤޤ줿ʬ궯ĴȤưޤ

''פǰϤޤ줿ʬ궯ĴȤưޤ

** ư
ʸ url ʸ˼ưŪ˥󥯤ĥޤɸǤϳ󥯤ˤ
target °ղä졢Ʊ쥦֥Υ󥯤ˤ°դޤ

** ᡼
᡼̤̾ꡢ<img> 򤽤ΤޤѤǤޤ

** 
^()פΤ褦ˡ^פǻϤޤꡢ(פȡ)פǰϤޤ줿ʬ
Ū˥ӤȤưޤ()⤬겾̾ˤʤޤ

겾̾ʬ url 򵭽ҤƤȡ^פȡ()פǶޤ줿
ʬʸȤ륢󥫡ˤʤޤ

** 
ų̡(())פǰϤȡϤޤ줿ƤȤɲäޤ

ؤΥ󥫡ϼưŪϢ֤ǳ꿶ޤ

** ɥ
[]פѤҤǥɥ󥯤ѤǤޤ

- [keyword:]  : ϤƤʤγɤ˥󥯤ޤ
- [:]     : Google γƤθ̥ڡ˥󥯤ޤ
- [asin:ASINֹ] : Amazon.co.jpγʥڡ˥󥯤ޤ
- [̾:url]  : URL ˥̾ǥ󥯤ޤ

** üʸΥ
\פѤȡüʸ򥨥פǤޤ

\*, \^, \<, \', \(, \[, \| ޤ

㤨Сų̤ȤƤǤϤʤ̾ʸϤѤ硢
 \((ϵǤϤޤ))
Τ褦ų̤Ƭˡ\פ֤̤ʸϤȤѤǤޤ

* ͻ¾

Υץ饰ϰʲΥץȡ򻲹ͤƤޤ

- [YukiWiki:http://www.hyuki.com/yukiwiki/]
-- Copyright (C) 2000-2004 Hiroshi Yuki <hyuki@hyuki.com>
- [ϤƤʥ꡼إ:http://d.hatena.ne.jp/help]
-- Copyright (C) 2002-2005 hatena.

